/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.sonatype.spice.zapper.internal.hawtbuf.FileSegments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SegmentsMessageBase<T>
extends BaseMessage<T> {
    private String f_magic = "zSeg";
    private boolean b_magic;
    private String f_transferId = null;
    private boolean b_transferId;
    private List<FileSegments> f_fileSegments;

    SegmentsMessageBase() {
    }

    public boolean hasMagic() {
        return this.b_magic;
    }

    public String getMagic() {
        return this.f_magic;
    }

    public T setMagic(String magic) {
        this.loadAndClear();
        this.b_magic = true;
        this.f_magic = magic;
        return (T)((Object)this);
    }

    public void clearMagic() {
        this.loadAndClear();
        this.b_magic = false;
        this.f_magic = "zSeg";
    }

    public boolean hasTransferId() {
        return this.b_transferId;
    }

    public String getTransferId() {
        return this.f_transferId;
    }

    public T setTransferId(String transferId) {
        this.loadAndClear();
        this.b_transferId = true;
        this.f_transferId = transferId;
        return (T)((Object)this);
    }

    public void clearTransferId() {
        this.loadAndClear();
        this.b_transferId = false;
        this.f_transferId = null;
    }

    public boolean hasFileSegments() {
        return this.f_fileSegments != null && !this.f_fileSegments.isEmpty();
    }

    public List<FileSegments> getFileSegmentsList() {
        if (this.f_fileSegments == null) {
            this.f_fileSegments = new ArrayList<FileSegments>();
        }
        return this.f_fileSegments;
    }

    public T setFileSegmentsList(List<FileSegments> fileSegments) {
        this.loadAndClear();
        this.f_fileSegments = fileSegments;
        return (T)((Object)this);
    }

    public int getFileSegmentsCount() {
        if (this.f_fileSegments == null) {
            return 0;
        }
        return this.f_fileSegments.size();
    }

    public FileSegments getFileSegments(int index) {
        if (this.f_fileSegments == null) {
            return null;
        }
        return this.f_fileSegments.get(index);
    }

    public T setFileSegments(int index, FileSegments value) {
        this.loadAndClear();
        this.getFileSegmentsList().set(index, value);
        return (T)((Object)this);
    }

    public T addFileSegments(FileSegments value) {
        this.loadAndClear();
        this.getFileSegmentsList().add(value);
        return (T)((Object)this);
    }

    public T addAllFileSegments(Iterable<? extends FileSegments> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getFileSegmentsList());
        return (T)((Object)this);
    }

    public void clearFileSegments() {
        this.loadAndClear();
        this.f_fileSegments = null;
    }
}

