/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.extensions.ForkNodeFactory;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class SurefireMojo
extends AbstractSurefireMojo
implements SurefireReportParameters {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="test")
    private String test;
    @Parameter(property="surefire.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="surefire.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="surefire.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="surefire.failIfNoSpecifiedTests", defaultValue="true")
    private boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.surefire.debug")
    private String debugForkedProcess;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="surefire.exitTimeout", defaultValue="30")
    private int forkedProcessExitTimeoutInSeconds;
    @Parameter(property="surefire.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="surefire.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter(property="surefire.includes")
    private List<String> includes;
    @Parameter(property="surefire.excludes")
    private List<String> excludes;
    @Parameter(property="surefire.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="surefire.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="surefire.encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private int rerunFailingTestsCount;
    @Parameter(property="surefire.failOnFlakeCount", defaultValue="0")
    private int failOnFlakeCount;
    @Parameter(property="surefire.suiteXmlFiles")
    private File[] suiteXmlFiles;
    @Parameter(property="surefire.runOrder", defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="surefire.runOrder.random.seed")
    private Long runOrderRandomSeed;
    @Parameter(property="surefire.includesFile")
    private File includesFile;
    @Parameter(property="surefire.excludesFile")
    private File excludesFile;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private int skipAfterFailureCount;
    @Parameter(property="surefire.shutdown", defaultValue="exit")
    private String shutdown;
    @Parameter(property="surefire.useModulePath", defaultValue="true")
    private boolean useModulePath;
    @Parameter(property="surefire.forkNode")
    private ForkNodeFactory forkNode;
    @Parameter(property="surefire.excludedEnvironmentVariables")
    private String[] excludedEnvironmentVariables;
    @Parameter(property="surefire.enableProcessChecker")
    private String enableProcessChecker;
    @Parameter(property="surefire.systemPropertiesFile")
    private File systemPropertiesFile;
    @Parameter(property="surefire.includeJUnit5Engines")
    private String[] includeJUnit5Engines;
    @Parameter(property="surefire.excludeJUnit5Engines")
    private String[] excludeJUnit5Engines;

    protected int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    public int getFailOnFlakeCount() {
        return this.failOnFlakeCount;
    }

    public void setFailOnFlakeCount(int failOnFlakeCount) {
        this.failOnFlakeCount = failOnFlakeCount;
    }

    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (PluginConsoleLogger)this.getConsoleLogger(), (Exception)firstForkException);
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "surefire";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/Test*.java", "**/*Test.java", "**/*Tests.java", "**/*TestCase.java"};
    }

    protected String getReportSchemaLocation() {
        return "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd";
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    @Deprecated
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Deprecated
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getMainBuildPath() {
        return this.classesDirectory;
    }

    public void setMainBuildPath(File mainBuildPath) {
        this.classesDirectory = mainBuildPath;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        return this.test;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public int getForkedProcessExitTimeoutInSeconds() {
        return this.forkedProcessExitTimeoutInSeconds;
    }

    public void setForkedProcessExitTimeoutInSeconds(int forkedProcessExitTimeoutInSeconds) {
        this.forkedProcessExitTimeoutInSeconds = forkedProcessExitTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public File[] getSuiteXmlFiles() {
        return (File[])this.suiteXmlFiles.clone();
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = (File[])suiteXmlFiles.clone();
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    public Long getRunOrderRandomSeed() {
        return this.runOrderRandomSeed;
    }

    public void setRunOrderRandomSeed(Long runOrderRandomSeed) {
        this.runOrderRandomSeed = runOrderRandomSeed;
    }

    public File getIncludesFile() {
        return this.includesFile;
    }

    public File getExcludesFile() {
        return this.excludesFile;
    }

    protected boolean useModulePath() {
        return this.useModulePath;
    }

    protected void setUseModulePath(boolean useModulePath) {
        this.useModulePath = useModulePath;
    }

    protected final List<File> suiteXmlFiles() {
        return this.hasSuiteXmlFiles() ? Arrays.asList(this.suiteXmlFiles) : Collections.emptyList();
    }

    protected final boolean hasSuiteXmlFiles() {
        return this.suiteXmlFiles != null && this.suiteXmlFiles.length != 0;
    }

    protected final String[] getExcludedEnvironmentVariables() {
        return this.excludedEnvironmentVariables == null ? new String[]{} : this.excludedEnvironmentVariables;
    }

    void setExcludedEnvironmentVariables(String[] excludedEnvironmentVariables) {
        this.excludedEnvironmentVariables = excludedEnvironmentVariables;
    }

    protected final String getEnableProcessChecker() {
        return this.enableProcessChecker;
    }

    protected final ForkNodeFactory getForkNode() {
        return this.forkNode;
    }

    protected void warnIfIllegalFailOnFlakeCount() throws MojoFailureException {
        if (this.failOnFlakeCount < 0) {
            throw new MojoFailureException("Parameter \"failOnFlakeCount\" should not be negative.");
        }
        if (this.failOnFlakeCount > 0 && this.rerunFailingTestsCount < 1) {
            throw new MojoFailureException("\"failOnFlakeCount\" requires rerunFailingTestsCount to be at least 1.");
        }
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.skipAfterFailureCount);
    }

    public String[] getIncludeJUnit5Engines() {
        return this.includeJUnit5Engines;
    }

    public void setIncludeJUnit5Engines(String[] includeJUnit5Engines) {
        this.includeJUnit5Engines = includeJUnit5Engines;
    }

    public String[] getExcludeJUnit5Engines() {
        return this.excludeJUnit5Engines;
    }

    public void setExcludeJUnit5Engines(String[] excludeJUnit5Engines) {
        this.excludeJUnit5Engines = excludeJUnit5Engines;
    }
}

