/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Histogram;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.Metric;
import org.json.simple.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\u0010\u0007\u001a\u00020\b\"\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0002H\u0016J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/metrics/HistogramMetric;", "Lorg/jitsi/metrics/Metric;", "Lorg/json/simple/JSONObject;", "name", "", "help", "namespace", "buckets", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[D)V", "histogram", "Lio/prometheus/client/Histogram;", "getHistogram", "()Lio/prometheus/client/Histogram;", "getName", "()Ljava/lang/String;", "getNamespace", "get", "register", "registry", "Lio/prometheus/client/CollectorRegistry;", "register$jicoco_metrics", "reset", "", "reset$jicoco_metrics", "jicoco-metrics"})
@SourceDebugExtension(value={"SMAP\nHistogramMetric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramMetric.kt\norg/jitsi/metrics/HistogramMetric\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1855#2:52\n1855#2,2:53\n1856#2:55\n1#3:56\n*S KotlinDebug\n*F\n+ 1 HistogramMetric.kt\norg/jitsi/metrics/HistogramMetric\n*L\n33#1:52\n34#1:53,2\n33#1:55\n*E\n"})
public final class HistogramMetric
extends Metric<JSONObject> {
    @NotNull
    private final String name;
    @NotNull
    private final String help;
    @NotNull
    private final String namespace;
    @NotNull
    private final Histogram histogram;

    public HistogramMetric(@NotNull String name, @NotNull String help, @NotNull String namespace, double ... buckets) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        super(null);
        this.name = name;
        this.help = help;
        this.namespace = namespace;
        Histogram histogram = ((Histogram.Builder)Histogram.build((String)this.getName(), (String)this.help).namespace(this.namespace)).buckets(Arrays.copyOf(buckets, buckets.length)).create();
        Intrinsics.checkNotNullExpressionValue((Object)histogram, (String)"create(...)");
        this.histogram = histogram;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final Histogram getHistogram() {
        return this.histogram;
    }

    @Override
    @NotNull
    public JSONObject get() {
        JSONObject jSONObject;
        JSONObject $this$get_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        List list = this.histogram.collect();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collect(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collector.MetricFamilySamples it = (Collector.MetricFamilySamples)element$iv;
            boolean bl2 = false;
            List list2 = it.samples;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"samples");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String shortName;
                String string;
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)element$iv2;
                boolean bl3 = false;
                String string2 = sample.name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                if (!StringsKt.startsWith$default((String)string2, (String)(this.namespace + "_" + this.getName() + "_"), (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)sample.name, (String)"name");
                int n = (this.namespace + "_" + this.getName() + "_").length();
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n), (String)"this as java.lang.String).substring(startIndex)");
                if (Intrinsics.areEqual((Object)shortName, (Object)"bucket") && sample.labelNames.size() == 1) {
                    $this$get_u24lambda_u242.put((Object)(shortName + "_" + sample.labelNames.get(0) + "_" + sample.labelValues.get(0)), (Object)sample.value);
                    continue;
                }
                $this$get_u24lambda_u242.put((Object)shortName, (Object)sample.value);
            }
        }
        return jSONObject;
    }

    @Override
    public void reset$jicoco_metrics() {
        this.histogram.clear();
    }

    @Override
    @NotNull
    public Metric<JSONObject> register$jicoco_metrics(@NotNull CollectorRegistry registry) {
        HistogramMetric histogramMetric;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        HistogramMetric it = histogramMetric = this;
        boolean bl = false;
        registry.register((Collector)this.histogram);
        return histogramMetric;
    }
}

