/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;

public class MojoExecution {
    public static boolean isThisTheExecutionRoot(MavenSession mavenSession, File basedir) {
        return MojoExecution.isThisTheExecutionRoot(mavenSession, basedir.getAbsolutePath());
    }

    public static boolean isThisTheExecutionRoot(MavenSession mavenSession, String basedir) {
        return mavenSession.getExecutionRootDirectory().equalsIgnoreCase(basedir);
    }

    public static boolean isCurrentTheLastProjectInExecution(MavenSession mavenSession) {
        MavenProject lastProject;
        MavenProject currentProject = mavenSession.getCurrentProject();
        return currentProject == (lastProject = (MavenProject)mavenSession.getSortedProjects().get(mavenSession.getSortedProjects().size() - 1));
    }

    public static boolean isCurrentTheFirstProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        return mavenSession.getCurrentProject() == MojoExecution.getFirstProjectWithMojoInExecution(mavenSession, pluginGroupId, pluginArtifactId, goal);
    }

    public static boolean isCurrentTheLastProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        return mavenSession.getCurrentProject() == MojoExecution.getLastProjectWithMojoInExecution(mavenSession, pluginGroupId, pluginArtifactId, goal);
    }

    public static MavenProject getFirstProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        ArrayList projects = new ArrayList(mavenSession.getSortedProjects());
        MavenProject firstWithThisMojo = null;
        for (MavenProject project : projects) {
            if (null == MojoExecution.findPlugin((PluginContainer)project.getBuild(), pluginGroupId, pluginArtifactId, goal)) continue;
            firstWithThisMojo = project;
            break;
        }
        return firstWithThisMojo;
    }

    public static MavenProject getLastProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        ArrayList projects = new ArrayList(mavenSession.getSortedProjects());
        Collections.reverse(projects);
        MavenProject lastWithThisMojo = null;
        for (MavenProject project : projects) {
            if (null == MojoExecution.findPlugin((PluginContainer)project.getBuild(), pluginGroupId, pluginArtifactId, goal)) continue;
            lastWithThisMojo = project;
            break;
        }
        return lastWithThisMojo;
    }

    public static Plugin findPlugin(PluginContainer container, String pluginGroupId, String pluginArtifactId, String goal) {
        if (container != null) {
            for (Plugin plugin : container.getPlugins()) {
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                if (goal != null) {
                    for (PluginExecution execution : plugin.getExecutions()) {
                        if (!execution.getGoals().contains(goal)) continue;
                        return plugin;
                    }
                    continue;
                }
                return plugin;
            }
        }
        return null;
    }
}

