/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.index;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.BufferingSinkProxyFactory;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.sink.impl.SinkWrapper;
import org.apache.maven.doxia.util.DoxiaUtils;

public class IndexingSink
extends SinkWrapper {
    private IndexEntry.Type type;
    private final Stack<IndexEntry> stack;
    private final Map<String, AtomicInteger> usedIds;
    private final IndexEntry rootEntry;
    private boolean isComplete;
    private boolean isTitle;
    private boolean hasOpenEntry;

    @Deprecated
    public IndexingSink(IndexEntry rootEntry) {
        this(rootEntry, new SinkAdapter());
    }

    public IndexingSink(Sink delegate) {
        this(new IndexEntry("index"), delegate);
    }

    private IndexingSink(IndexEntry rootEntry, Sink delegate) {
        super(delegate);
        this.rootEntry = rootEntry;
        this.stack = new Stack();
        this.stack.push(rootEntry);
        this.usedIds = new HashMap<String, AtomicInteger>();
        this.usedIds.put(rootEntry.getId(), new AtomicInteger());
        this.type = IndexEntry.Type.UNKNOWN;
    }

    public IndexEntry getRootEntry() {
        if (!this.isComplete) {
            throw new IllegalStateException("The sink has not been closed yet, i.e. the index tree is not complete yet");
        }
        return this.rootEntry;
    }

    public String getTitle() {
        return this.rootEntry.getTitle();
    }

    @Override
    public void title(SinkEventAttributes attributes) {
        this.isTitle = true;
        super.title(attributes);
    }

    @Override
    public void title_() {
        this.isTitle = false;
        super.title_();
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        super.section(level, attributes);
        this.indexEntryComplete();
        this.type = IndexEntry.Type.fromSectionLevel(level);
        this.pushNewEntry(this.type);
    }

    @Override
    public void section_(int level) {
        this.indexEntryComplete();
        this.pop();
        super.section_(level);
    }

    @Override
    public void sectionTitle_(int level) {
        this.indexEntryComplete();
        super.sectionTitle_(level);
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        if (this.isTitle) {
            this.rootEntry.setTitle(text);
        } else {
            switch (this.type) {
                case SECTION_1: 
                case SECTION_2: 
                case SECTION_3: 
                case SECTION_4: 
                case SECTION_5: 
                case SECTION_6: {
                    IndexEntry entry = (IndexEntry)this.stack.lastElement();
                    String title = entry.getTitle();
                    title = title != null ? title + text : text;
                    title = title.replaceAll("[\\r\\n]+", "");
                    entry.setTitle(title);
                    this.setEntryId(entry, title);
                    break;
                }
            }
        }
        super.text(text, attributes);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        this.parseAnchor(name);
        super.anchor(name, attributes);
    }

    private boolean parseAnchor(String name) {
        switch (this.type) {
            case SECTION_1: 
            case SECTION_2: 
            case SECTION_3: 
            case SECTION_4: 
            case SECTION_5: {
                IndexEntry entry = (IndexEntry)this.stack.lastElement();
                entry.setAnchor(true);
                this.setEntryId(entry, name);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setEntryId(IndexEntry entry, String id) {
        if (entry.getId() != null) {
            this.usedIds.remove(entry.getId());
        }
        entry.setId(this.getUniqueId(DoxiaUtils.encodeId(id)));
    }

    String getUniqueId(String id) {
        String uniqueId;
        if (this.usedIds.containsKey(id)) {
            uniqueId = id + "_" + this.usedIds.get(id).incrementAndGet();
        } else {
            this.usedIds.put(id, new AtomicInteger());
            uniqueId = id;
        }
        return uniqueId;
    }

    void indexEntryComplete() {
        if (!this.hasOpenEntry) {
            return;
        }
        this.type = IndexEntry.Type.UNKNOWN;
        BufferingSinkProxyFactory.BufferingSink bufferingSink = BufferingSinkProxyFactory.castAsBufferingSink(this.getWrappedSink());
        this.setWrappedSink(bufferingSink.getBufferedSink());
        this.onIndexEntry(this.stack.peek());
        bufferingSink.flush();
        this.hasOpenEntry = false;
    }

    protected void onIndexEntry(IndexEntry entry) {
    }

    private void pushNewEntry(IndexEntry.Type type) {
        IndexEntry entry = new IndexEntry(this.peek(), null, type);
        this.stack.push(entry);
        this.setWrappedSink(new BufferingSinkProxyFactory().createWrapper(this.getWrappedSink()));
        this.hasOpenEntry = true;
    }

    public void push(IndexEntry entry) {
        this.stack.push(entry);
    }

    public void pop() {
        this.stack.pop();
    }

    public IndexEntry peek() {
        return this.stack.peek();
    }

    @Override
    public void close() {
        super.close();
        this.isComplete = true;
    }
}

