/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.maven.doxia.parser.Xhtml5BaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class Xhtml1BaseParser
extends Xhtml5BaseParser {
    private static final Map<String, Collection<AttributeMapping>> ATTRIBUTE_MAPPING_TABLE = new HashMap<String, Collection<AttributeMapping>>();
    private static final Map<String, String> ELEMENT_MAPPING_TABLE = new HashMap<String, String>();

    static final String mapAlignToStyle(String alignValue) {
        switch (alignValue) {
            case "center": 
            case "left": 
            case "right": {
                return "text-align: " + alignValue + ";";
            }
        }
        return null;
    }

    @Override
    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        String elementName = parser.getName();
        Collection<AttributeMapping> attributeMappings = ATTRIBUTE_MAPPING_TABLE.get(elementName);
        if (attributeMappings != null) {
            for (AttributeMapping attributeMapping : attributeMappings) {
                String attributeValue = (String)attribs.getAttribute(attributeMapping.getSourceName());
                if (attributeValue == null) continue;
                String newValue = (String)attributeMapping.getValueMapper().apply(attributeValue);
                if (newValue != null) {
                    String oldValue = (String)attribs.getAttribute(attributeMapping.getTargetName());
                    if (oldValue != null) {
                        newValue = attributeMapping.mergeValue(oldValue, newValue);
                    }
                    attribs.addAttribute(attributeMapping.getTargetName(), newValue);
                }
                attribs.removeAttribute(attributeMapping.getSourceName());
            }
        }
        String mappedElementName = ELEMENT_MAPPING_TABLE.getOrDefault(elementName, elementName);
        return super.baseStartTag(mappedElementName, attribs, sink);
    }

    @Override
    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        String elementName = parser.getName();
        String mappedElementName = ELEMENT_MAPPING_TABLE.getOrDefault(elementName, elementName);
        return super.baseEndTag(mappedElementName, attribs, sink);
    }

    static {
        ATTRIBUTE_MAPPING_TABLE.put("a", Collections.singleton(new AttributeMapping("name", "id", AttributeMapping.MergeSemantics.IGNORE)));
        List<AttributeMapping> tableMappings = Arrays.asList(new AttributeMapping("border", "class", v -> v != null && !v.equals("0") ? "bodyTableBorder" : null, AttributeMapping.MergeSemantics.PREPEND), new AttributeMapping("align", "style", Xhtml1BaseParser::mapAlignToStyle, AttributeMapping.MergeSemantics.PREPEND));
        ATTRIBUTE_MAPPING_TABLE.put("table", tableMappings);
        ATTRIBUTE_MAPPING_TABLE.put("td", Collections.singleton(new AttributeMapping("align", "style", Xhtml1BaseParser::mapAlignToStyle, AttributeMapping.MergeSemantics.PREPEND)));
        ATTRIBUTE_MAPPING_TABLE.put("th", Collections.singleton(new AttributeMapping("align", "style", Xhtml1BaseParser::mapAlignToStyle, AttributeMapping.MergeSemantics.PREPEND)));
        ELEMENT_MAPPING_TABLE.put("tt", "code");
        ELEMENT_MAPPING_TABLE.put("strike", "del");
    }

    private static final class AttributeMapping {
        private final String sourceName;
        private final String targetName;
        private final UnaryOperator<String> valueMapper;
        private final MergeSemantics mergeSemantics;

        AttributeMapping(String sourceAttribute, String targetAttribute, MergeSemantics mergeSemantics) {
            this(sourceAttribute, targetAttribute, UnaryOperator.identity(), mergeSemantics);
        }

        AttributeMapping(String sourceName, String targetName, UnaryOperator<String> valueMapper, MergeSemantics mergeSemantics) {
            this.sourceName = sourceName;
            this.targetName = targetName;
            this.valueMapper = valueMapper;
            this.mergeSemantics = mergeSemantics;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public UnaryOperator<String> getValueMapper() {
            return this.valueMapper;
        }

        public String mergeValue(String oldValue, String newValue) {
            String mergedValue;
            switch (this.mergeSemantics) {
                case IGNORE: {
                    mergedValue = oldValue;
                    break;
                }
                case OVERWRITE: {
                    mergedValue = newValue;
                    break;
                }
                default: {
                    mergedValue = newValue + " " + oldValue;
                }
            }
            return mergedValue;
        }

        static enum MergeSemantics {
            OVERWRITE,
            IGNORE,
            PREPEND;

        }
    }
}

