/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.impl.PreConditions;

public final class AddressImpl
implements Address {
    private final Buffer rawAddress;
    private final Buffer displayName;
    private final URI uri;

    public AddressImpl(Buffer original, Buffer displayName, URI uri) {
        this.rawAddress = original;
        this.displayName = PreConditions.ifNull(displayName, Buffers.EMPTY_BUFFER);
        this.uri = uri;
    }

    @Override
    public Address.Builder copy() {
        Address.Builder builder = Address.withURI(this.uri);
        builder.withDisplayName(this.displayName);
        return builder;
    }

    @Override
    public Buffer getDisplayName() {
        return this.displayName;
    }

    @Override
    public URI getURI() throws SipParseException {
        return this.uri;
    }

    @Override
    public Buffer toBuffer() {
        return this.rawAddress.clone();
    }

    public String toString() {
        return this.rawAddress.toString();
    }

    @Override
    public void getBytes(Buffer dst) {
        this.rawAddress.getBytes(0, dst);
    }
}

