/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"klass.declaredAnnotations");
        for (Annotation annotation : annotationArray) {
            Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
            this.processAnnotation(visitor2, annotation);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"klass.declaredMethods");
        Method[] methodArray2 = methodArray;
        int n = 0;
        int n2 = methodArray2.length;
        while (n < n2) {
            Method method = methodArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"identifier(method.name)");
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.methodDesc(method));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray3 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray3, (String)"method.parameterAnnotations");
            annotationArray2 = annotationArray3;
            int n3 = 0;
            int n4 = ((Object[])annotationArray2).length;
            while (n3 < n4) {
                int parameterIndex = n3;
                Annotation annotations2 = annotationArray2[n3];
                ++n3;
                Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                for (Annotation annotation : annotations2) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation));
                    if (annotationArgumentVisitor2 == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
                    boolean bl = false;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"klass.declaredConstructors");
        Constructor<?>[] constructorArray2 = constructorArray;
        int n = 0;
        int n2 = constructorArray2.length;
        while (n < n2) {
            Constructor<?> constructor = constructorArray2[n];
            ++n;
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"constructor");
            Annotation[] annotationArray = memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor));
            if (annotationArray == null) continue;
            Annotation[] visitor2 = annotationArray;
            Annotation[] annotationArray2 = constructor.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"constructor.declaredAnnotations");
            for (Annotation annotation : annotationArray2) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)parameterAnnotations, (String)"parameterAnnotations");
            if (!(((Object[])parameterAnnotations).length == 0)) {
                int shift = constructor.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray3 = parameterAnnotations;
                int n3 = 0;
                int n4 = ((Object[])annotationArray3).length;
                while (n3 < n4) {
                    int parameterIndex = n3;
                    Annotation[] annotations2 = annotationArray3[n3];
                    ++n3;
                    Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                    for (Annotation annotation : annotations2) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor2 == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
                        boolean bl = false;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"klass.declaredFields");
        Field[] fieldArray2 = fieldArray;
        int n = 0;
        int n2 = fieldArray2.length;
        while (n < n2) {
            Field field = fieldArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"identifier(field.name)");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            Annotation[] annotationArray2 = memberVisitor.visitField((Name)annotationArray, SignatureSerializer.INSTANCE.fieldDesc(field), null);
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = field.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"field.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation((KotlinJvmBinaryClass.AnnotationVisitor)visitor2, annotation);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
        if (annotationArgumentVisitor != null) {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2 = annotationArgumentVisitor;
            boolean bl = false;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            try {
                Object object2 = method.invoke((Object)annotation, new Object[0]);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            Object value = object;
            object = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, (Name)object, value);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Object object;
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            int n = dimensions;
            dimensions = n + 1;
            object = currentClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(object, (String)"currentClass.componentType");
            currentClass = object;
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                object = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue((ClassId)object, dimensions);
            }
            Object object2 = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(currentClass.name).primitiveType");
            PrimitiveType primitiveType = object2;
            if (dimensions > 0) {
                object2 = ClassId.topLevel(primitiveType.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue((ClassId)object2, dimensions - 1);
            }
            object2 = ClassId.topLevel(primitiveType.getTypeFqName());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue((ClassId)object2, dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        FqName fqName2 = javaClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        ClassId kotlinClassId = classId == null ? javaClassId : classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            visitor2.visitClassLiteral(name, this.classLiteralValue((Class)value));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Object object = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(object, (String)"if (clazz.isEnum) clazz else clazz.enclosingClass");
            ClassId classId = ReflectClassUtilKt.getClassId(object);
            object = Name.identifier(((Enum)value).name());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, (Name)object);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass, (String)"annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            this.processAnnotationArguments(v, (Annotation)value, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = visitor2.visitArray(name);
            if (v == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v2 = v;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNullExpressionValue(componentType, (String)"componentType");
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                for (Object element : (Object[])value) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name2 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier((element as Enum<*>).name)");
                    v2.visitEnum(enumClassId, name2);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                for (Object element : (Object[])value) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    v2.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                for (Object element : (Object[])value) {
                    Intrinsics.checkNotNullExpressionValue(componentType, (String)"componentType");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = v2.visitAnnotation(ReflectClassUtilKt.getClassId(componentType));
                    if (annotationArgumentVisitor == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv = annotationArgumentVisitor;
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Annotation");
                    }
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                for (Object element : (Object[])value) {
                    v2.visit(element);
                }
            }
            v2.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }
}

