#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/checkpoint.h>
extern int errno;

void my_handler(int sig)
{
 int ret;

 printf("received signal %d\n", sig);
 if (sig == SIGSEGV)
	tlongjmp(1);
 else
   tlongjmp(0);
}

void corrupt()
{
 char* p = (char*) malloc(sizeof(char)*1024);
 char * q;
 unsigned int x = 1234; 

 q = (char*)random();
 printf("q=%#0lx\n", q);
 *q = x;
 /* very little chance we will get here */
 while (1) {
	x = random();
	printf("x=%u\n", x);
	*(p + x)= 'x';
}
}

main()
{
 int ret, stage;

 printf("starting program execution\n");
/*
 sigset_t mask;
 struct sigaction act;
 stack_t st;
 st.ss_sp = malloc(sizeof(SIGSTKSZ));
 if (st.ss_sp == NULL)
  perror("malloc");
 st.ss_size = SIGSTKSZ;
 st.ss_flags = 0;
 if (sigaltstack(&st,0) <0)
	perror("sigaltstack");

 sigfillset(&mask);
 act.sa_handler = my_handler;
 act.sa_mask = mask;
 act.sa_flags = SA_RESETHAND;
 sigaction(SIGSEGV | SIGBUS, &act, NULL);
 signal(SIGSEGV | SIGBUS | SIGINT | SIGFPE | SIGQUIT | SIGILL, my_handler);
*/
 signal(SIGSEGV, my_handler);
 signal(SIGBUS, my_handler);
 errno = 0;
 stage = 0;
 printf("stage %d pid = %d\n", stage, getpid());
 stage = 1;
/* First checkpoint state */
 ret = tsetjmp();
if (ret <0)
{
 printf ("tsetjmp returned %d, errno = %d\n", ret, errno);
 perror("tsetjmp");
}
 else 
	printf("tsetjmp() returned %d\n", ret);
 printf("stage %d pid = %d\n", stage, getpid());
 if (chkpt_currstate() > 0) {
	printf("we have recovered from a sigfault\n");
	printf("from state %d" , chkpt_prevstate());
	printf("to state %d\n", chkpt_currstate());
	printf("the signal that caused the problem was %d\n", chkpt_signal());
 	printf("numchkpts = %d\n", chkpt_count());
 }
 printf("do you want to corrupt the program(y/n):");
 ret = getchar();
 if (ret == 'y')
 {
   printf("sending a signal to %d\n", getpid());
	if (kill(getpid(), SIGBUS) != 0)
		perror("kill");
 }
 stage = 2;
 /* we want to setjmp() in the initial program but not if we reach
  * this place after a recovery.
  */
if (chkpt_count() < 2)
{
 ret = tsetjmp();
 if (ret < 0)
 printf ("tsetjmp returned %d, errno = %d\n", ret, errno);
else
	printf("tsetjmp() returned %d\n", ret);
}
 printf("stage %d pid = %d\n", stage, getpid());
 if (chkpt_currstate()== 1) {
	printf("we have recovered from a sigfault\n");
	printf("from state %d" , chkpt_prevstate());
	printf("to state %d\n", chkpt_currstate());
	printf("the signal that caused the problem was %d\n", chkpt_signal());
 }
 printf("do you want to corrupt the program(y/n):");
 ret = getchar();
 ret = getchar();

 if (ret == 'y')
	corrupt();
 if (ret == 'n')
	if (kill(getpid(), SIGBUS) != 0)
		perror("kill");
 printf("goodbye\n");
}
