# Copyright 2020 Joerg Sonnenberger <joerg@bec.de>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2 or any later version.

"""enforce_topic is a hook to ensure all new changesets have a topic.

Usage:
  [hooks]
  pretxnclose-phase.enforce_topic_commits = \
    python:hgext.hooklib.enforce_topic_commits.hook

"""

from __future__ import annotations

from mercurial.i18n import _
from mercurial import (
    error,
    pycompat,
)


def hook(ui, repo, hooktype, node=None, **kwargs):
    if hooktype != b"pretxnclose-phase":
        raise error.Abort(
            _(b'Unsupported hook type %r') % pycompat.bytestr(hooktype)
        )
    ctx = repo.unfiltered()[node]
    if not ctx.topic():
        raise error.Abort(
            _(b'New changeset %s lacks a topic.')
            % (ctx,)
        )
