/* $NetBSD: $ */

/*-
 * Copyright (c) 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _POWERPC_MPC5200_PSCREG__H_
#define _POWERPC_MPC5200_PSCREG_H_

#define PSC_MR1		0x00	/* Mode Register 1 */
#define PSC_MR2		0x00	/* Mode Register 2 */
#define PSC_SR		0x04	/* Status Register */
#define PSC_CSR		0x04	/* Clock Select Register */
#define PSC_CR		0x08	/* Command Register */
#define PSC_RB		0x0c	/* Rx Buffer Register */
#define PSC_TB		0x0c	/* Tx Buffer Register */
#define PSC_IPCR	0x10	/* Input Port Change Register */
#define PSC_ACR		0x10	/* Auxiliary Control Register */
#define PSC_ISR		0x14	/* Interrupt Status Register */
#define PSC_IMR		0x14	/* Interrupt Mask Register */
#define PSC_CTUR	0x18	/* Counter Timer Upper Register */
#define PSC_CTLR	0x1c	/* Counter Timer Lower Register */
#define PSC_CCR		0x20	/* Codec Clock Register */
#define PSC_AC97SLOTS	0x24	/* AC97 Slots Register */
#define PSC_AC97CMD	0x28	/* AC97 Command Register */
#define PSC_AC97DATA	0x2c	/* AC97 Status Data Register */
#define PSC_IVR		0x30	/* Interrupt Vector Register */
#define PSC_IP		0x34	/* Input Port Register */
#define PSC_OP1		0x38	/* Output Port 1 Bit Set */
#define PSC_OP0		0x3c	/* Output Port 0 Bit Set */
#define PSC_SICR	0x40	/* Serial Interface Control Register */
#define PSC_IRCR1	0x44	/* Infrared Control 1 */
#define PSC_IRCR2	0x48	/* Infrared Control 2 */
#define PSC_IRSDR	0x4c	/* Infrared SIR Divide Register */
#define PSC_IRMDR	0x50	/* Infrared MIR Divide Register */
#define PSC_IRFDR	0x54	/* Infrared FIR Divice Register */
#define PSC_RFNUM	0x58	/* Rx FIFO Number of Data */
#define PSC_TFNUM	0x5c	/* Tx FIFO Number of Data */
#define PSC_RFDATA	0x60	/* Rx FIFO Data */
#define PSC_RFSTAT	0x64	/* Rx FIFO Status */
#define PSC_RFCNTL	0x68	/* Rx FIFO Control */
#define PSC_RFALARM	0x6e	/* Rx FIFO Alarm */
#define PSC_RFRPTR	0x72	/* Rx FIFO Read Pointer */
#define PSC_RFWPTR	0x76	/* Rx FIFO Write Pointer */
#define PSC_RFLRFPTR	0x7a	/* Rx FIFO Last Read Frame */
#define PSC_RFLWFPTR	0x7c	/* Rx FIFO Last Write Frame */
#define PSC_TFDATA	0x80	/* Tx FIFO Data */
#define PSC_TFSTAT	0x84	/* Tx FIFO Status */
#define PSC_TFCNTL	0x86	/* Tx FIFO Control */
#define PSC_TFALARM	0x8e	/* Tx FIFO Alarm */
#define PSC_TFRPTR	0x92	/* Tx FIFO Read Pointer */
#define PSC_TFWPTR	0x96	/* Tx FIFO Write Pointer */
#define PSC_TFLRFPTR	0x9a	/* Tx FIFO Last Read Frame */
#define PSC_TFLWFPTR	0x9c	/* Tx FIFO Last Write Frame */

#define PSC_NPORTS	0xa0
#define PSC_FIFOLEN	512

/* Status Register */

#define SR_RB			(1 << 15)
#define SR_FE			(1 << 14)
#define SR_PE			(1 << 13)
#define SR_ORERR		(1 << 12)
#define SR_TXEMP		(1 << 11)
#define SR_TXRDY		(1 << 10)
#define SR_FFULL		(1 << 9)
#define SR_RXRDY		(1 << 8)

#define SR_RCV_MASK		(SR_RB | SR_FE | SR_PE | SR_ORERR | SR_RXRDY)

/* Command Register */

#define CMD_RESET_MR		(1 << 4)
#define CMD_RESET_RX		(2 << 4)
#define CMD_RESET_TX		(3 << 4)
#define CMD_RESET_ERR		(4 << 4)
#define CMD_RESET_BRK		(5 << 4)
#define CMD_START_BRK		(6 << 4)
#define CMD_STOP_BRK		(7 << 4)

#define CMD_TX_ENABLE		(1 << 2)
#define CMD_TX_DISABLE		(2 << 2)

#define CMD_RX_ENABLE		(1 << 0)
#define CMD_RX_DISABLE		(2 << 0)

/* Input Port Change Register */

#define IPCR_DELTA_DCD		(1 << 5)
#define IPCR_DELTA_CTS		(1 << 4)
#define IPCR_DCD		(1 << 1)
#define IPCR_CTS		(1 << 0)

/* Interrupt Status/Mask Register */

#define INT_IPC			(1 << 15)
#define INT_ORERR		(1 << 12)
#define INT_TXEMP		(1 << 11)
#define INT_DB			(1 << 10)
#define INT_RXRDY		(1 << 9)
#define INT_TXRDY		(1 << 8)
#define INT_ERROR		(1 << 6)

#define	PSC_TOLERANCE	30	/* baud rate tolerance, in 0.1% units */

#endif /* _POWERPC_MPC5200_PSCREG_H_ */
