/* $NetBSD: $ */

/*-
 * Copyright (c) 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _POWERPC_MPC5200_MPC5200REG_H_
#define _POWERPC_MPC5200_MPC5200REG_H_

/*
 * Interrupt Controller
 */

#define ICTL_PIM	0x00
#define ICTL_PP1	0x04
#define ICTL_PP2	0x08
#define ICTL_PP3	0x0c
#define ICTL_EEET	0x10
#define ICTL_CPMIM	0x14
#define ICTL_MIP1	0x18
#define ICTL_MIP2	0x1c

#define ICTL_CISA	0x28
#define ICTL_MISA	0x2c
#define ICTL_PISA	0x30

/*
 * USB Host Controller
 */

#define USBHC_RR	0x00
#define USBHC_CR	0x04
#define USBHC_CSR	0x08
#define USBHC_ISR	0x0c
#define USBHC_IER	0x10
#define USBHC_IDR	0x14

/*
 * Clock Distribution Module
 */

#define CDM_JTAG_ID	0x00
#define CDM_RESET_CFG	0x04
#define CDM_BREADCRUMB	0x08
#define CDM_CONFIG	0x0c
#define CDM_FRAC_DIV	0x10
#define CDM_CLK_ENABLE	0x14

/*
 * ATA Controller
 */

#define ATA_CONFIG		0x00
#define ATA_STATUS		0x04
#define ATA_PIO1		0x08
#define ATA_PIO2		0x0c
#define ATA_DMA1		0x10
#define ATA_DMA2		0x14
#define ATA_UDMA1		0x18
#define ATA_UDMA2		0x1c
#define ATA_UDMA3		0x20
#define ATA_UDMA4		0x24
#define ATA_UDMA5		0x28
#define ATA_FIFO_DATA		0x3c
#define ATA_FIFO_STATUS		0x40
#define ATA_FIFO_CONTROL	0x44
#define ATA_FIFO_ALARM		0x48
#define ATA_FIFO_READPTR	0x4c
#define ATA_FIFO_WRITEPTR	0x50

#define ATA_CONFIG_SMR		(1 << 31)
#define ATA_CONFIG_FR		(1 << 30)
#define ATA_CONFIG_IE		(1 << 25)
#define ATA_CONFIG_IORDY	(1 << 24)

#endif /* _POWERPC_MPC5200_MPC5200REG_H_ */
