#	$Id: lib.mk,v 1.27 2005/07/11 18:01:05 sjg Exp $
# skip the :Q for now as we don't support it (yet) on non-BSD systems
#	$NetBSD: bsd.lib.mk,v 1.83 1997/02/17 19:24:47 cgd Exp $
#	@(#)bsd.lib.mk	5.26 (Berkeley) 5/2/91

.include <init.mk>

.MAIN: all

.if ${OBJECT_FMT} == "ELF"
NEED_SOLINKS?= yes
.endif

.if exists(${.CURDIR}/shlib_version)
SHLIB_MAJOR != . ${.CURDIR}/shlib_version ; echo $$major
SHLIB_MINOR != . ${.CURDIR}/shlib_version ; echo $$minor
.endif

print-shlib-major:
.if defined(SHLIB_MAJOR) && ${MKPIC} != "no"
	@echo ${SHLIB_MAJOR}
.else
	@false
.endif

print-shlib-minor:
.if defined(SHLIB_MINOR) && ${MKPIC} != "no"
	@echo ${SHLIB_MINOR}
.else
	@false
.endif

print-shlib-teeny:
.if defined(SHLIB_TEENY) && ${MKPIC} != "no"
	@echo ${SHLIB_TEENY}
.else
	@false
.endif

.if defined(SHLIB_MAJOR) && !empty(SHLIB_MAJOR)
.if defined(SHLIB_MINOR) && !empty(SHLIB_MINOR)
.if defined(SHLIB_TEENY) && !empty(SHLIB_TEENY)
SHLIB_FULLVERSION=${SHLIB_MAJOR}.${SHLIB_MINOR}.${SHLIB_TEENY}
.else
SHLIB_FULLVERSION=${SHLIB_MAJOR}.${SHLIB_MINOR}
.endif
.else
SHLIB_FULLVERSION=${SHLIB_MAJOR}
.endif
.endif

# add additional suffixes not exported.
# .po is used for profiling object files.
# .so is used for PIC object files.
.SUFFIXES: .out .a .ln .so .po .o .s .S .c .cc .C .m .F .f .r .y .l .cl .p .h
.SUFFIXES: .sh .m4 .m

CFLAGS+=	${COPTS}

# we only use this if they ask for it
USE_LIBTOOL?=no

# Derrived from NetBSD-1.6

# Set PICFLAGS to cc flags for producing position-independent code,
# if not already set.  Includes -DPIC, if required.

# Data-driven table using make variables to control how shared libraries
# are built for different platforms and object formats.
# OBJECT_FMT:		currently either "ELF" or "a.out", from <bsd.own.mk>
# SHLIB_SOVERSION:	version number to be compiled into a shared library
#			via -soname. Usualy ${SHLIB_MAJOR} on ELF.
#			NetBSD/pmax used to use ${SHLIB_MAJOR}[.${SHLIB_MINOR}
#			[.${SHLIB_TEENY}]]
# SHLIB_SHFLAGS:	Flags to tell ${LD} to emit shared library.
#			with ELF, also set shared-lib version for ld.so.
# SHLIB_LDSTARTFILE:	support .o file, call C++ file-level constructors
# SHLIB_LDENDFILE:	support .o file, call C++ file-level destructors
# FPICFLAGS:		flags for ${FC} to compile .[fF] files to .so objects.
# CPPICFLAGS:		flags for ${CPP} to preprocess .[sS] files for ${AS}
# CPICFLAGS:		flags for ${CC} to compile .[cC] files to .so objects.
# CAPICFLAGS		flags for {$CC} to compiling .[Ss] files
#		 	(usually just ${CPPPICFLAGS} ${CPICFLAGS})
# APICFLAGS:		flags for ${AS} to assemble .[sS] to .so objects.

.if ${TARGET_OSNAME} == "NetBSD"
.if ${MACHINE_ARCH} == "alpha"
		# Alpha-specific shared library flags
FPICFLAGS ?= -fPIC
CPICFLAGS ?= -fPIC -DPIC
CPPPICFLAGS?= -DPIC 
CAPICFLAGS?= ${CPPPICFLAGS} ${CPICFLAGS}
APICFLAGS ?=
.elif ${MACHINE_ARCH} == "mipsel" || ${MACHINE_ARCH} == "mipseb"
		# mips-specific shared library flags

# On mips, all libs are compiled with ABIcalls, not just sharedlibs.
MKPICLIB= no

# so turn shlib PIC flags on for ${AS}.
AINC+=-DABICALLS
AFLAGS+= -fPIC
AS+=	-KPIC

.elif ${MACHINE_ARCH} == "vax" && ${OBJECT_FMT} == "ELF"
# On the VAX, all object are PIC by default, not just sharedlibs.
MKPICLIB= no

.elif (${MACHINE_ARCH} == "sparc" || ${MACHINE_ARCH} == "sparc64") && \
       ${OBJECT_FMT} == "ELF"
# If you use -fPIC you need to define BIGPIC to turn on 32-bit 
# relocations in asm code
FPICFLAGS ?= -fPIC
CPICFLAGS ?= -fPIC -DPIC
CPPPICFLAGS?= -DPIC -DBIGPIC
CAPICFLAGS?= ${CPPPICFLAGS} ${CPICFLAGS}
APICFLAGS ?= -KPIC

.else

# Platform-independent flags for NetBSD a.out shared libraries
SHLIB_SOVERSION=${SHLIB_FULLVERSION}
SHLIB_SHFLAGS=
FPICFLAGS ?= -fPIC
CPICFLAGS?= -fPIC -DPIC
CPPPICFLAGS?= -DPIC 
CAPICFLAGS?= ${CPPPICFLAGS} ${CPICFLAGS}
APICFLAGS?= -k

.endif

# Platform-independent linker flags for ELF shared libraries
.if ${OBJECT_FMT} == "ELF"
SHLIB_SOVERSION=	${SHLIB_MAJOR}
SHLIB_SHFLAGS=		-soname lib${LIB}.so.${SHLIB_SOVERSION}
SHLIB_LDSTARTFILE?=	/usr/lib/crtbeginS.o
SHLIB_LDENDFILE?=	/usr/lib/crtendS.o
.endif

# for compatability with the following
CC_PIC?= ${CPICFLAGS}
LD_shared=${SHLIB_SHFLAGS}

.endif # NetBSD

.if ${TARGET_OSNAME} == "FreeBSD"
.if ${OBJECT_FMT} == "ELF"
SHLIB_SOVERSION=	${SHLIB_MAJOR}
SHLIB_SHFLAGS=		-soname lib${LIB}.so.${SHLIB_SOVERSION}
.else
SHLIB_SHFLAGS=		-assert pure-text
.endif
SHLIB_LDSTARTFILE=
SHLIB_LDENDFILE=
CC_PIC?= -fpic
LD_shared=${SHLIB_SHFLAGS}

.endif # FreeBSD

MKPICLIB?= yes

# sys.mk can override these
CC_PG?=-pg
CC_PIC?=-DPIC

LD_X?=-X
LD_x?=-x
LD_r?=-r

# Non BSD machines will be using bmake.
.if ${TARGET_OSNAME} == "SunOS"
LD_shared=-assert pure-text
.if ${OBJECT_FMT} == "ELF" || ${MACHINE} == "solaris"
# Solaris
LD_shared=-h lib${LIB}.so.${SHLIB_MAJOR} -G
.endif
.elif ${TARGET_OSNAME} == "HP-UX"
LD_shared=-b
LD_so=sl
DLLIB=
# HPsUX lorder does not grok anything but .o
LD_sobjs=`${LORDER} ${OBJS} | ${TSORT} | sed 's,\.o,.so,'`
LD_pobjs=`${LORDER} ${OBJS} | ${TSORT} | sed 's,\.o,.po,'`
.elif ${TARGET_OSNAME} == "OSF1"
LD_shared= -msym -shared -expect_unresolved '*'
LD_solib= -all lib${LIB}_pic.a
DLLIB=
# lorder does not grok anything but .o
LD_sobjs=`${LORDER} ${OBJS} | ${TSORT} | sed 's,\.o,.so,'`
LD_pobjs=`${LORDER} ${OBJS} | ${TSORT} | sed 's,\.o,.po,'`
AR_cq= -cqs
.elif ${TARGET_OSNAME} == "FreeBSD"
LD_solib= lib${LIB}_pic.a
.elif ${TARGET_OSNAME} == "Linux"
# but which one? does it matter?
# Red-hat has tsort but not lorder?
# but we can use lorder from NetBSD :-)
LD_shared=-shared -h lib${LIB}.so.${SHLIB_MAJOR}
LD_solib= --whole-archive lib${LIB}_pic.a
.endif
LORDER?=lorder
TSORT?=tsort
LIBTOOL?=libtool
LD_shared?=-Bshareable -Bforcearchive
LD_so?=so.${SHLIB_FULLVERSION}
LD_sobjs?=`${LORDER} ${SOBJS} | ${TSORT}`
LD_pobjs?=`${LORDER} ${POBJS} | ${TSORT}`
LD_solib?=${LD_sobjs}
AR_cq?=cq
.if exists(/netbsd) && exists(${DESTDIR}/usr/lib/libdl.so)
DLLIB?=-ldl
.endif

.if defined(USE_LIBTOOL) && (${USE_LIBTOOL} == "yes")
# because libtool is so facist about naming the object files,
# we cannot (yet) build profiled libs
MKPROFILE=no
_LIBS=lib${LIB}.a
.if exists(${.CURDIR}/shlib_version)
SHLIB_AGE != . ${.CURDIR}/shlib_version ; echo $$age
.endif
.else
# for the normal .a we do not want to strip symbols
.c.o:
	${COMPILE.c} ${.IMPSRC}

# for the normal .a we do not want to strip symbols
.cc.o .C.o:
	${COMPILE.cc} ${.IMPSRC}

.S.o .s.o:
	@echo ${COMPILE.S} ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC}
	@${COMPILE.S} ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} 

.if (${LD_X} == "")
.c.po:
	${COMPILE.c} ${CC_PG} ${.IMPSRC} -o ${.TARGET}

.cc.po .C.po:
	${COMPILE.cc} -pg ${.IMPSRC} -o ${.TARGET}

.S.so .s.so:
	${COMPILE.S} ${PICFLAG} ${CC_PIC} ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}
.else
.c.po:
	@echo ${COMPILE.c} ${CC_PG} ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.c} ${CC_PG} ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_X} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o

.cc.po .C.po:
	@echo ${COMPILE.cc} -pg ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.cc} -pg ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_X} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o

.S.so .s.so:
	@echo ${COMPILE.S} ${PICFLAG} ${CC_PIC} ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.S} ${PICFLAG} ${CC_PIC} ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_x} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o
.endif

.if (${LD_x} == "")
.c.so:
	${COMPILE.c} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}

.cc.so .C.so:
	${COMPILE.cc} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}

.S.po .s.po:
	${COMPILE.S} -DGPROF -DPROF ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}
.else

.c.so:
	@echo ${COMPILE.c} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.c} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_x} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o

.cc.so .C.so:
	@echo ${COMPILE.cc} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.cc} ${PICFLAG} ${CC_PIC} ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_x} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o

.S.po .s.po:
	@echo ${COMPILE.S} -DGPROF -DPROF ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}
	@${COMPILE.S} -DGPROF -DPROF ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} -o ${.TARGET}.o
	@${LD} ${LD_X} ${LD_r} ${.TARGET}.o -o ${.TARGET}
	@rm -f ${.TARGET}.o

.endif
.endif

.c.ln:
	${LINT} ${LINTFLAGS} ${CFLAGS:M-[IDU]*} -i ${.IMPSRC}

.if defined(USE_LIBTOOL) && (${USE_LIBTOOL} != "yes")

.if !defined(PICFLAG)
PICFLAG=-fpic
.endif

.if ${MKPIC} == "no" || (defined(LDSTATIC) && ${LDSTATIC} != "") \
	|| ${MKLINKLIB} != "no"
_LIBS=lib${LIB}.a
.else
_LIBS=
.endif

.if ${MKPROFILE} != "no"
_LIBS+=lib${LIB}_p.a
POBJS+=${OBJS:.o=.po}
.endif

.if ${MKPIC} != "no"
.if ${MKPICLIB} == "no"
SOLIB=lib${LIB}.a
.else
SOLIB=lib${LIB}_pic.a
_LIBS+=${SOLIB}
SOBJS+=${OBJS:.o=.so}
.endif
.if defined(SHLIB_FULLVERSION)
_LIBS+=lib${LIB}.${LD_so}
.endif
.endif

.if ${MKLINT} != "no"
_LIBS+=llib-l${LIB}.ln
.endif

all: ${_LIBS} _SUBDIRUSE

OBJS+=	${SRCS:N*.h:R:S/$/.o/g}
.NOPATH:	${OBJS}

.if defined(USE_LIBTOOL) && (${USE_LIBTOOL} == "yes")
.if ${MKPIC} == "no"
LT_STATIC=-static
.else
LT_STATIC=
.endif
SHLIB_AGE?=0

# .lo's are created as a side effect
.s.o .S.o .c.o:
	${LIBTOOL} --mode=compile ${CC} ${LT_STATIC} ${CFLAGS} ${CPPFLAGS} ${IMPFLAGS} -c ${.IMPSRC}

# can't really do profiled libs with libtool - its too facist about
# naming the output...
lib${LIB}.a:: ${OBJS}
	@rm -f ${.TARGET}
	${LIBTOOL} --mode=link ${CC} ${LT_STATIC} -o ${.TARGET:.a=.la} ${OBJS:.o=.lo} -rpath ${SHLIBDIR}:/usr/lib -version-info ${SHLIB_MAJOR}:${SHLIB_MINOR}:${SHLIB_AGE}
	@ln .libs/${.TARGET} .

lib${LIB}.${LD_so}:: lib${LIB}.a
	@[ -s ${.TARGET}.${SHLIB_AGE} ] || { ln -s .libs/lib${LIB}.${LD_so}* . 2>/dev/null; : }
	@[ -s ${.TARGET} ] || ln -s ${.TARGET}.${SHLIB_AGE} ${.TARGET}

.else  # USE_LIBTOOL

lib${LIB}.a:: ${OBJS}
	@echo building standard ${LIB} library
	@rm -f ${.TARGET}
	@${AR} ${AR_cq} ${.TARGET} `${LORDER} ${OBJS} | ${TSORT}`
	${RANLIB} ${.TARGET}

POBJS+=	${OBJS:.o=.po}
.NOPATH:	${POBJS}
lib${LIB}_p.a:: ${POBJS}
	@echo building profiled ${LIB} library
	@rm -f ${.TARGET}
	@${AR} ${AR_cq} ${.TARGET} ${LD_pobjs}
	${RANLIB} ${.TARGET}

SOBJS+=	${OBJS:.o=.so}
.NOPATH:	${SOBJS}
lib${LIB}_pic.a:: ${SOBJS}
	@echo building shared object ${LIB} library
	@rm -f ${.TARGET}
	@${AR} ${AR_cq} ${.TARGET} ${LD_sobjs}
	${RANLIB} ${.TARGET}

#SHLIB_LDADD?= ${LDADD}

# bound to be non-portable...
# this is known to work for NetBSD 1.6 and FreeBSD 4.2
lib${LIB}.${LD_so}: ${SOLIB} ${DPADD}
	@echo building shared ${LIB} library \(version ${SHLIB_FULLVERSION}\)
	@rm -f ${.TARGET}
.if ${TARGET_OSNAME} == "NetBSD" || ${TARGET_OSNAME} == "FreeBSD"
.if ${OBJECT_FMT} == "ELF"
	$(LD) -x -shared ${SHLIB_SHFLAGS} -o ${.TARGET} \
	    ${SHLIB_LDSTARTFILE} \
	    --whole-archive ${SOLIB} --no-whole-archive ${SHLIB_LDADD} \
	    ${SHLIB_LDENDFILE}
.else
	$(LD) ${LD_x} ${LD_shared} \
	    -o ${.TARGET} ${SOLIB} ${SHLIB_LDADD}
.endif
.else
	$(LD) -o ${.TARGET} ${LD_shared} ${LD_solib} ${DLLIB} ${SHLIB_LDADD}
.endif
.endif
.if defined(NEED_SOLINKS)
	rm -f lib${LIB}.so; ln -s ${.TARGET} lib${LIB}.so
.endif

LOBJS+=	${LSRCS:.c=.ln} ${SRCS:M*.c:.c=.ln}
.NOPATH:	${LOBJS}
LLIBS?=	-lc
llib-l${LIB}.ln: ${LOBJS}
	@echo building llib-l${LIB}.ln
	@rm -f llib-l${LIB}.ln
	@${LINT} -C${LIB} ${LOBJS} ${LLIBS}

.if !target(clean)
cleanlib:
	rm -f a.out [Ee]rrs mklog core *.core ${CLEANFILES}
	rm -f lib${LIB}.a ${OBJS}
	rm -f lib${LIB}_p.a ${POBJS}
	rm -f lib${LIB}_pic.a lib${LIB}.so.*.* ${SOBJS}
	rm -f llib-l${LIB}.ln ${LOBJS}
.if defined(NEED_SOLINKS)
	rm -f lib${LIB}.so*
.endif

clean: _SUBDIRUSE cleanlib
cleandir: _SUBDIRUSE cleanlib
.else
cleandir: _SUBDIRUSE clean
.endif

.if defined(SRCS) && (!defined(MKDEP) || ${MKDEP} != autodep)
afterdepend: .depend
	@(TMP=/tmp/_depend$$$$; \
	    sed -e 's/^\([^\.]*\).o[ ]*:/\1.o \1.po \1.so \1.ln:/' \
	      < .depend > $$TMP; \
	    mv $$TMP .depend)
.endif

.if !target(install)
.if !target(beforeinstall)
beforeinstall:
.endif

LIB_INSTALL_OWN?= -o ${LIBOWN} -g ${LIBGRP}

.include <links.mk>

realinstall:
.if ${MKARCHIVE} != "no"
#	ranlib lib${LIB}.a
	${INSTALL} ${COPY} ${LIB_INSTALL_OWN} -m 600 lib${LIB}.a \
	    ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/lib${LIB}.a
	chmod ${LIBMODE} ${DESTDIR}${LIBDIR}/lib${LIB}.a
.endif
.if ${MKPROFILE} != "no"
#	ranlib lib${LIB}_p.a
	${INSTALL} ${COPY} ${LIB_INSTALL_OWN} -m 600 \
	    lib${LIB}_p.a ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/lib${LIB}_p.a
	chmod ${LIBMODE} ${DESTDIR}${LIBDIR}/lib${LIB}_p.a
.endif
.if ${MKPIC} != "no"
#	ranlib lib${LIB}_pic.a
	${INSTALL} ${COPY} ${LIB_INSTALL_OWN} -m 600 \
	    lib${LIB}_pic.a ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/lib${LIB}_pic.a
	chmod ${LIBMODE} ${DESTDIR}${LIBDIR}/lib${LIB}_pic.a
.if defined(SHLIB_MAJOR)
	${INSTALL} ${COPY} ${LIB_INSTALL_OWN} -m ${LIBMODE} \
	    lib${LIB}.${LD_so} ${DESTDIR}${LIBDIR}
.if defined(NEED_SOLINKS)
	rm -f ${DESTDIR}${LIBDIR}/lib${LIB}.so.${SHLIB_MAJOR}
	ln -s lib${LIB}.${LD_so} \
	    ${DESTDIR}${LIBDIR}/lib${LIB}.so.${SHLIB_MAJOR}
.if ${MKLINKLIB} != "no"
	rm -f ${DESTDIR}${LIBDIR}/lib${LIB}.so
	ln -s lib${LIB}.${LD_so} \
	    ${DESTDIR}${LIBDIR}/lib${LIB}.so
.endif
.endif
.endif
.endif
.if ${MKLINT} != "no" && ${MKLINKLIB} != "no" && !empty(LOBJS)
	${INSTALL} ${COPY} ${LIB_INSTALL_OWN} -m ${LIBMODE} \
	    llib-l${LIB}.ln ${DESTDIR}${LINTLIBDIR}
.endif
.if defined(LINKS) && !empty(LINKS)
	@set ${LINKS}; ${_LINKS_SCRIPT}
.endif

install: maninstall _SUBDIRUSE
maninstall: afterinstall
afterinstall: realinstall
realinstall: beforeinstall
.endif

.if ${MKMAN} != "no"
.include <man.mk>
.endif

.if ${MKNLS} != "no"
.include <nls.mk>
.endif

.include <obj.mk>
.include <dep.mk>
.include <subdir.mk>
.endif

# during building we usually need/want to install libs somewhere central
# note that we do NOT ch{own,grp} as that would likely fail at this point.
# otherwise it is the same as realinstall
# Note that we don't need this when using dpadd.mk
.libinstall:	${_LIBS}
	test -d ${DESTDIR}${LIBDIR} || ${INSTALL} -d -m775 ${DESTDIR}${LIBDIR}
.for _lib in ${_LIBS:M*.a}
	${INSTALL} ${COPY} -m 644 ${_lib} ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/${_lib}
.endfor
.for _lib in ${_LIBS:M*.so*}
	${INSTALL} ${COPY} -m ${LIBMODE} ${_lib} ${DESTDIR}${LIBDIR}
.if defined(NEED_SOLINKS)
	[ ${_lib} = lib${LIB}.so.${SHLIB_MAJOR} ] || ln -sf ${_lib} ${DESTDIR}${LIBDIR}/lib${LIB}.so.${SHLIB_MAJOR}
	ln -sf ${_lib} ${DESTDIR}${LIBDIR}/lib${LIB}.so
.endif
.endfor
	@touch ${.TARGET}
