/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.WindowPeer;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.FullScreenCapable;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.java2d.InvalidPipeException;
import sun.java2d.NullSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.util.logging.PlatformLogger;

public class LWWindowPeer
extends LWContainerPeer<Window, JComponent>
implements WindowPeer,
FramePeer,
DialogPeer,
FullScreenCapable {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.lwawt.focus.LWWindowPeer");
    private PlatformWindow platformWindow;
    private int sysX;
    private int sysY;
    private int sysW;
    private int sysH;
    private static final int MINIMUM_WIDTH = 1;
    private static final int MINIMUM_HEIGHT = 1;
    private Insets insets = new Insets(0, 0, 0, 0);
    private GraphicsDevice graphicsDevice;
    private GraphicsConfiguration graphicsConfig;
    private SurfaceData surfaceData;
    private final Object surfaceDataLock = new Object();
    private int backBufferCount;
    private BufferCapabilities backBufferCaps;
    private volatile BufferedImage backBuffer;
    private volatile int windowState = 0;
    private static volatile LWComponentPeer lastMouseEventPeer = null;
    private static LWComponentPeer[] mouseDownTarget = new LWComponentPeer[3];
    private static int mouseClickButtons = 0;
    private volatile boolean isOpaque = true;
    private static final Font DEFAULT_FONT = new Font("Lucida Grande", 0, 13);
    private static LWWindowPeer grabbingWindow;
    private volatile boolean skipNextFocusChange;
    private LWWindowPeer blocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer(Window window, PlatformComponent platformComponent, PlatformWindow platformWindow) {
        super(window, platformComponent);
        this.platformWindow = platformWindow;
        Window window2 = window.getOwner();
        LWWindowPeer lWWindowPeer = window2 != null ? (LWWindowPeer)window2.getPeer() : null;
        PlatformWindow platformWindow2 = lWWindowPeer != null ? lWWindowPeer.getPlatformWindow() : null;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.getTarget()).getGraphicsConfiguration();
        Object object = this.getStateLock();
        synchronized (object) {
            this.graphicsConfig = graphicsConfiguration;
        }
        if (!window.isFontSet()) {
            window.setFont(DEFAULT_FONT);
        }
        if (!window.isBackgroundSet()) {
            window.setBackground(SystemColor.window);
        }
        if (!window.isForegroundSet()) {
            window.setForeground(SystemColor.windowText);
        }
        platformWindow.initialize(window, this, platformWindow2);
    }

    @Override
    void initializeImpl() {
        super.initializeImpl();
        if (this.getTarget() instanceof Frame) {
            this.setTitle(((Frame)this.getTarget()).getTitle());
            this.setState(((Frame)this.getTarget()).getExtendedState());
        } else if (this.getTarget() instanceof Dialog) {
            this.setTitle(((Dialog)this.getTarget()).getTitle());
        }
        this.setAlwaysOnTop(((Window)this.getTarget()).isAlwaysOnTop());
        this.updateMinimumSize();
        float f = ((Window)this.getTarget()).getOpacity();
        if (f < 1.0f) {
            this.setOpacity(f);
        }
        this.setOpaque(((Window)this.getTarget()).isOpaque());
        this.updateInsets(this.platformWindow.getInsets());
        if (this.getSurfaceData() == null) {
            this.replaceSurfaceData();
        }
    }

    @Override
    public PlatformWindow getPlatformWindow() {
        return this.platformWindow;
    }

    @Override
    protected LWWindowPeer getWindowPeerOrSelf() {
        return this;
    }

    @Override
    protected void initializeContainerPeer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeImpl() {
        SurfaceData surfaceData = this.getSurfaceData();
        Object object = this.surfaceDataLock;
        synchronized (object) {
            this.surfaceData = null;
        }
        if (surfaceData != null) {
            surfaceData.invalidate();
        }
        if (this.isGrabbing()) {
            this.ungrab();
        }
        this.destroyBuffers();
        this.platformWindow.dispose();
        super.disposeImpl();
    }

    @Override
    protected void setVisibleImpl(boolean bl) {
        super.setVisibleImpl(bl);
        this.platformWindow.setVisible(bl);
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer;
            LWKeyboardFocusManagerPeer lWKeyboardFocusManagerPeer = LWKeyboardFocusManagerPeer.getInstance(this.getAppContext());
            if (bl) {
                if (!((Window)this.getTarget()).isAutoRequestFocus()) {
                    return;
                }
                this.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            } else if (lWKeyboardFocusManagerPeer.getCurrentFocusedWindow() == this.getTarget() && (lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this)) != null) {
                lWWindowPeer.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            }
        }
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.graphicsConfig;
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        this.setGraphicsConfig(graphicsConfiguration);
        return false;
    }

    protected final Graphics getOnscreenGraphics(Color color, Color color2, Font font) {
        if (this.getSurfaceData() == null) {
            return null;
        }
        if (color == null) {
            color = SystemColor.windowText;
        }
        if (color2 == null) {
            color2 = SystemColor.window;
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        return this.platformWindow.transformGraphics(new SunGraphics2D(this.getSurfaceData(), color, color2, font));
    }

    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        try {
            assert (n > 1);
            this.replaceSurfaceData(n - 1, bufferCapabilities);
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Image getBackBuffer() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.backBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        BufferedImage bufferedImage = (BufferedImage)this.getBackBuffer();
        if (bufferedImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        Graphics graphics = this.getGraphics();
        try {
            graphics.drawImage(bufferedImage, n, n2, n3, n4, n, n2, n3, n4, null);
        }
        finally {
            graphics.dispose();
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroyBuffers() {
        Image image = this.getBackBuffer();
        Object object = this.getStateLock();
        synchronized (object) {
            this.backBuffer = null;
        }
        if (image != null) {
            image.flush();
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        if ((n5 & 4) != 0) {
            n5 &= 0xFFFFFFFB;
            n5 |= 2;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        this.setBounds(n, n2, n3, n4, n5, false, false);
        Rectangle rectangle = this.getBounds();
        this.platformWindow.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Point getLocationOnScreen() {
        return this.platformWindow.getLocationOnScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Insets getInsets() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.insets;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.platformWindow.getFontMetrics(font);
    }

    @Override
    public void toFront() {
        this.platformWindow.toFront();
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.platformWindow.setAlwaysOnTop(bl);
    }

    @Override
    public void updateFocusableWindowState() {
        this.platformWindow.updateFocusableWindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            this.blocker = bl && dialog.getPeer() instanceof LWWindowPeer ? (LWWindowPeer)dialog.getPeer() : null;
        }
        this.platformWindow.setModalBlocked(bl);
    }

    @Override
    public void updateMinimumSize() {
        Dimension dimension = null;
        if (((Window)this.getTarget()).isMinimumSizeSet()) {
            dimension = ((Window)this.getTarget()).getMinimumSize();
        }
        if (dimension == null) {
            dimension = new Dimension(1, 1);
        }
        this.platformWindow.setMinimumSize(dimension.width, dimension.height);
    }

    @Override
    public void updateIconImages() {
        this.getPlatformWindow().updateIconImages();
    }

    @Override
    public void setOpacity(float f) {
        this.getPlatformWindow().setOpacity(f);
        this.repaintPeer();
    }

    @Override
    public final void setOpaque(boolean bl) {
        if (this.isOpaque != bl) {
            this.isOpaque = bl;
            this.getPlatformWindow().setOpaque(bl);
            this.replaceSurfaceData();
            this.repaintPeer();
        }
    }

    public final boolean isOpaque() {
        return this.isOpaque;
    }

    @Override
    public void updateWindow() {
        this.flushOffscreenGraphics();
    }

    @Override
    public void repositionSecurityWarning() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setTitle(String string) {
        this.platformWindow.setTitle(string == null ? "" : string);
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        this.platformWindow.setMenuBar(menuBar);
    }

    @Override
    public void setResizable(boolean bl) {
        this.platformWindow.setResizable(bl);
    }

    @Override
    public void setState(int n) {
        this.platformWindow.setWindowState(n);
    }

    @Override
    public int getState() {
        return this.windowState;
    }

    @Override
    public void setMaximizedBounds(Rectangle rectangle) {
    }

    @Override
    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 16387);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void blockWindows(List<Window> list) {
        for (Window window : list) {
            WindowPeer windowPeer = (WindowPeer)window.getPeer();
            if (windowPeer == null) continue;
            windowPeer.setModalBlocked((Dialog)this.getTarget(), true);
        }
    }

    public void notifyIconify(boolean bl) {
        WindowEvent windowEvent = new WindowEvent((Window)this.getTarget(), bl ? 203 : 204);
        this.postEvent(windowEvent);
        int n = bl ? 1 : 0;
        this.postWindowStateChangedEvent(n);
        if (!bl) {
            this.repaintPeer();
        }
    }

    public void notifyZoom(boolean bl) {
        int n = bl ? 6 : 0;
        this.postWindowStateChangedEvent(n);
    }

    public void notifyExpose(int n, int n2, int n3, int n4) {
        LWWindowPeer.flushOnscreenGraphics();
        this.repaintPeer(new Rectangle(n, n2, n3, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyReshape(int n, int n2, int n3, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.getStateLock();
        synchronized (object) {
            bl = n != this.sysX || n2 != this.sysY;
            bl2 = n3 != this.sysW || n4 != this.sysH;
            this.sysX = n;
            this.sysY = n2;
            this.sysW = n3;
            this.sysH = n4;
        }
        if (!bl && !bl2) {
            return;
        }
        this.setBounds(n, n2, n3, n4, 3, false, false);
        this.checkIfOnNewScreen();
        if (bl2) {
            this.replaceSurfaceData();
            LWWindowPeer.flushOnscreenGraphics();
        }
        if (bl) {
            this.handleMove(n, n2, true);
        }
        if (bl2) {
            this.handleResize(n3, n4, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBackground(int n, int n2) {
        Graphics graphics = this.getOnscreenGraphics(this.getForeground(), this.getBackground(), this.getFont());
        if (graphics != null) {
            try {
                graphics.clearRect(0, 0, n, n2);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public void notifyUpdateCursor() {
        this.getLWToolkit().getCursorManager().updateCursorLater(this);
    }

    public void notifyActivation(boolean bl) {
        this.changeFocusedWindow(bl);
    }

    public void notifyNCMouseDown() {
        if (grabbingWindow != null && grabbingWindow != LWWindowPeer.getOwnerFrameDialog(this)) {
            grabbingWindow.ungrab();
        }
    }

    public void dispatchMouseEvent(int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, byte[] byArray) {
        LWWindowPeer lWWindowPeer;
        Rectangle rectangle = this.getBounds();
        LWComponentPeer lWComponentPeer = this.findPeerAt(rectangle.x + n3, rectangle.y + n4);
        LWWindowPeer lWWindowPeer2 = lastMouseEventPeer != null ? lastMouseEventPeer.getWindowPeerOrSelf() : null;
        LWWindowPeer lWWindowPeer3 = lWWindowPeer = lWComponentPeer != null ? lWComponentPeer.getWindowPeerOrSelf() : null;
        if (n == 505) {
            if (lWWindowPeer2 == this) {
                if (this.isEnabled()) {
                    Point point = lastMouseEventPeer.windowToLocal(n3, n4, lWWindowPeer2);
                    this.postEvent(new MouseEvent((Component)lastMouseEventPeer.getTarget(), 505, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                }
                lastMouseEventPeer = null;
            }
        } else {
            int n9;
            if (lWComponentPeer != lastMouseEventPeer) {
                if (n != 506 || lastMouseEventPeer == null) {
                    Point point;
                    if (lastMouseEventPeer != null && lastMouseEventPeer.isEnabled()) {
                        if (lWWindowPeer2 != this) {
                            point = lastMouseEventPeer.windowToLocal(n3, n4, lWWindowPeer2);
                            Rectangle rectangle2 = lWWindowPeer2.getBounds();
                            point.x += rectangle.x - rectangle2.x;
                            point.y += rectangle.y - rectangle2.y;
                            this.postEvent(new MouseEvent((Component)lastMouseEventPeer.getTarget(), 505, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                        } else {
                            point = lastMouseEventPeer.windowToLocal(n3, n4, this);
                            this.postEvent(new MouseEvent((Component)lastMouseEventPeer.getTarget(), 505, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                        }
                    }
                    if (lWComponentPeer != null && lWComponentPeer.isEnabled() && n != 504) {
                        point = lWComponentPeer.windowToLocal(n3, n4, lWWindowPeer);
                        this.postEvent(new MouseEvent((Component)lWComponentPeer.getTarget(), 504, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                    }
                }
                lastMouseEventPeer = lWComponentPeer;
            }
            int n10 = n2 > 0 ? MouseEvent.getMaskForButton(n2) : 0;
            int n11 = n7 & ~n10;
            int n12 = n9 = n2 > 3 ? 1 : n2 - 1;
            if (n == 501) {
                if (!this.isGrabbing() && grabbingWindow != null && grabbingWindow != LWWindowPeer.getOwnerFrameDialog(this)) {
                    grabbingWindow.ungrab();
                }
                mouseClickButtons = n11 == 0 ? n10 : (mouseClickButtons |= n10);
                LWWindowPeer.mouseDownTarget[n9] = lWComponentPeer;
            } else if (n == 506) {
                lWComponentPeer = mouseDownTarget[n9];
                mouseClickButtons &= ~n7;
            } else if (n == 502) {
                lWComponentPeer = mouseDownTarget[n9];
                if ((n7 & n10) == 0) {
                    LWWindowPeer.mouseDownTarget[n9] = null;
                }
            }
            if (lWWindowPeer == null) {
                lWWindowPeer = this;
            }
            if (lWComponentPeer == null) {
                lWComponentPeer = this;
            }
            Point point = lWComponentPeer.windowToLocal(n3, n4, lWWindowPeer);
            if (lWComponentPeer.isEnabled()) {
                MouseEvent mouseEvent = new MouseEvent((Component)lWComponentPeer.getTarget(), n, l, n7, point.x, point.y, n5, n6, n8, bl, n2);
                this.postEvent(mouseEvent);
            }
            if (n == 502) {
                if ((mouseClickButtons & n10) != 0 && lWComponentPeer.isEnabled()) {
                    this.postEvent(new MouseEvent((Component)lWComponentPeer.getTarget(), 500, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                }
                mouseClickButtons &= ~n10;
            }
        }
        this.notifyUpdateCursor();
    }

    public void dispatchMouseWheelEvent(long l, int n, int n2, int n3, int n4, int n5, int n6, double d, byte[] byArray) {
        Rectangle rectangle = this.getBounds();
        LWComponentPeer lWComponentPeer = this.findPeerAt(rectangle.x + n, rectangle.y + n2);
        if (lWComponentPeer == null || !lWComponentPeer.isEnabled()) {
            return;
        }
        Point point = lWComponentPeer.windowToLocal(n, n2, this);
        this.postEvent(new MouseWheelEvent((Component)lWComponentPeer.getTarget(), 507, l, n3, point.x, point.y, 0, 0, 0, false, n4, n5, n6, d));
    }

    public void dispatchKeyEvent(int n, long l, int n2, int n3, char c, int n4) {
        LWComponentPeer lWComponentPeer = LWKeyboardFocusManagerPeer.getInstance(this.getAppContext()).getFocusOwner();
        if (lWComponentPeer != null) {
            KeyEvent keyEvent = new KeyEvent((Component)lWComponentPeer.getTarget(), n, l, n2, n3, c, n4);
            lWComponentPeer.postEvent(keyEvent);
        }
    }

    private void postWindowStateChangedEvent(int n) {
        if (this.getTarget() instanceof Frame) {
            AWTAccessor.getFrameAccessor().setExtendedState((Frame)this.getTarget(), n);
        }
        WindowEvent windowEvent = new WindowEvent((Window)this.getTarget(), 209, this.windowState, n);
        this.postEvent(windowEvent);
        this.windowState = n;
    }

    private static int getGraphicsConfigScreen(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i] != graphicsDevice) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsConfig == graphicsConfiguration) {
                return false;
            }
            this.graphicsConfig = graphicsConfiguration;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfOnNewScreen() {
        GraphicsDevice graphicsDevice = this.platformWindow.getGraphicsDevice();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsDevice == graphicsDevice) {
                return;
            }
            this.graphicsDevice = graphicsDevice;
        }
        object = graphicsDevice.getDefaultConfiguration();
        if (!this.setGraphicsConfig((GraphicsConfiguration)object)) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable((GraphicsConfiguration)object){
            final /* synthetic */ GraphicsConfiguration val$newGC;
            {
                this.val$newGC = graphicsConfiguration;
            }

            @Override
            public void run() {
                AWTAccessor.getComponentAccessor().setGraphicsConfiguration((Component)LWWindowPeer.this.getTarget(), this.val$newGC);
            }
        });
    }

    protected final Graphics getOffscreenGraphics(Color color, Color color2, Font font) {
        Graphics2D graphics2D;
        Image image = this.getBackBuffer();
        if (image == null) {
            return null;
        }
        if (color == null) {
            color = SystemColor.windowText;
        }
        if (color2 == null) {
            color2 = SystemColor.window;
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        if ((graphics2D = (Graphics2D)image.getGraphics()) != null) {
            graphics2D.setColor(color);
            graphics2D.setBackground(color2);
            graphics2D.setFont(font);
        }
        return graphics2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData getSurfaceData() {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            return this.surfaceData;
        }
    }

    private void replaceSurfaceData() {
        this.replaceSurfaceData(this.backBufferCount, this.backBufferCaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSurfaceData(int n, BufferCapabilities bufferCapabilities) {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            SurfaceData surfaceData = this.getSurfaceData();
            this.surfaceData = this.platformWindow.replaceSurfaceData();
            BufferedImage bufferedImage = this.backBuffer;
            this.backBufferCount = n;
            this.backBufferCaps = bufferCapabilities;
            Rectangle rectangle = this.getSize();
            if (this.getSurfaceData() != null && surfaceData != this.getSurfaceData()) {
                this.clearBackground(rectangle.width, rectangle.height);
            }
            this.blitSurfaceData(surfaceData, this.getSurfaceData());
            if (surfaceData != null && surfaceData != this.getSurfaceData()) {
                surfaceData.flush();
            }
            this.backBuffer = (BufferedImage)this.platformWindow.createBackBuffer();
            if (this.backBuffer != null) {
                Graphics graphics = this.backBuffer.getGraphics();
                try {
                    Rectangle rectangle2 = this.getBounds();
                    graphics.setColor(this.getBackground());
                    if (graphics instanceof Graphics2D) {
                        ((Graphics2D)graphics).setComposite(AlphaComposite.Src);
                    }
                    graphics.fillRect(0, 0, rectangle2.width, rectangle2.height);
                    if (bufferedImage != null) {
                        graphics.drawImage(bufferedImage, 0, 0, null);
                        bufferedImage.flush();
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    private void blitSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2) {
        if (surfaceData != surfaceData2 && surfaceData != null && surfaceData2 != null && !(surfaceData2 instanceof NullSurfaceData) && !(surfaceData instanceof NullSurfaceData) && surfaceData.getSurfaceType().equals(surfaceData2.getSurfaceType())) {
            Rectangle rectangle = this.getSize();
            Blit blit = Blit.locate(surfaceData.getSurfaceType(), CompositeType.Src, surfaceData2.getSurfaceType());
            if (blit != null) {
                blit.Blit(surfaceData, surfaceData2, ((Graphics2D)this.getGraphics()).getComposite(), this.getRegion(), 0, 0, 0, 0, rectangle.width, rectangle.height);
            }
        }
    }

    public int getBackBufferCount() {
        return this.backBufferCount;
    }

    public BufferCapabilities getBackBufferCaps() {
        return this.backBufferCaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateInsets(Insets insets) {
        boolean bl = false;
        Object object = this.getStateLock();
        synchronized (object) {
            bl = this.insets.equals(insets);
            this.insets = insets;
        }
        if (bl) {
            this.replaceSurfaceData();
            this.repaintPeer();
        }
        return bl;
    }

    public static LWWindowPeer getWindowUnderCursor() {
        return lastMouseEventPeer != null ? lastMouseEventPeer.getWindowPeerOrSelf() : null;
    }

    public static LWComponentPeer<?, ?> getPeerUnderCursor() {
        return lastMouseEventPeer;
    }

    public boolean requestWindowFocus(CausedFocusEvent.Cause cause) {
        if (focusLog.isLoggable(500)) {
            focusLog.fine("requesting native focus to " + this);
        }
        if (!this.focusAllowedFor()) {
            focusLog.fine("focus is not allowed");
            return false;
        }
        if (this.platformWindow.rejectFocusRequest(cause)) {
            return false;
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this);
            if (lWWindowPeer != null && !lWWindowPeer.platformWindow.isActive()) {
                LWWindowPeer lWWindowPeer2;
                if (focusLog.isLoggable(500)) {
                    focusLog.fine("requesting native focus to the owner " + lWWindowPeer);
                }
                LWWindowPeer lWWindowPeer3 = lWWindowPeer2 = window != null ? (LWWindowPeer)window.getPeer() : null;
                if (lWWindowPeer2 != null && lWWindowPeer2.platformWindow.isActive()) {
                    if (focusLog.isLoggable(500)) {
                        focusLog.fine("the opposite is " + lWWindowPeer2);
                    }
                    lWWindowPeer2.skipNextFocusChange = true;
                }
                lWWindowPeer.skipNextFocusChange = true;
                lWWindowPeer.platformWindow.requestWindowFocus();
            }
            this.changeFocusedWindow(true);
            return true;
        }
        if (this.getTarget() == window && !((Window)this.getTarget()).hasFocus()) {
            this.changeFocusedWindow(true);
            return true;
        }
        return this.platformWindow.requestWindowFocus();
    }

    private boolean focusAllowedFor() {
        Window window = (Window)this.getTarget();
        return window.isVisible() && window.isEnabled() && this.isFocusableWindow();
    }

    private boolean isFocusableWindow() {
        boolean bl = ((Window)this.getTarget()).isFocusableWindow();
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this);
            if (lWWindowPeer == null) {
                return false;
            }
            return bl && ((Window)lWWindowPeer.getTarget()).isFocusableWindow();
        }
        return bl;
    }

    public boolean isSimpleWindow() {
        Window window = (Window)this.getTarget();
        return !(window instanceof Dialog) && !(window instanceof Frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFocusedWindow(boolean bl) {
        Window window;
        Object object;
        if (focusLog.isLoggable(500)) {
            focusLog.fine((bl ? "gaining" : "loosing") + " focus window: " + this);
        }
        if (this.skipNextFocusChange) {
            focusLog.fine("skipping focus change");
            this.skipNextFocusChange = false;
            return;
        }
        if (!this.isFocusableWindow() && bl) {
            focusLog.fine("the window is not focusable");
            return;
        }
        if (bl) {
            object = LWWindowPeer.getPeerTreeLock();
            synchronized (object) {
                if (this.blocker != null) {
                    if (focusLog.isLoggable(300)) {
                        focusLog.finest("the window is blocked by " + this.blocker);
                    }
                    return;
                }
            }
        }
        object = LWKeyboardFocusManagerPeer.getInstance(this.getAppContext());
        Window window2 = window = bl ? ((LWKeyboardFocusManagerPeer)object).getCurrentFocusedWindow() : null;
        if (!bl && (this.isGrabbing() || LWWindowPeer.getOwnerFrameDialog(grabbingWindow) == this)) {
            focusLog.fine("ungrabbing on " + grabbingWindow);
            grabbingWindow.ungrab();
        }
        ((LWKeyboardFocusManagerPeer)object).setFocusedWindow(bl ? this : null);
        int n = bl ? 207 : 208;
        WindowEvent windowEvent = new WindowEvent((Window)this.getTarget(), n, window);
        this.postEvent(windowEvent);
    }

    static LWWindowPeer getOwnerFrameDialog(LWWindowPeer lWWindowPeer) {
        Window window;
        Window window2 = window = lWWindowPeer != null ? ((Window)lWWindowPeer.getTarget()).getOwner() : null;
        while (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = window.getOwner();
        }
        return window != null ? (LWWindowPeer)window.getPeer() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer getBlocker() {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            LWWindowPeer lWWindowPeer = this.blocker;
            if (lWWindowPeer == null) {
                return null;
            }
            while (lWWindowPeer.blocker != null) {
                lWWindowPeer = lWWindowPeer.blocker;
            }
            return lWWindowPeer;
        }
    }

    @Override
    public void enterFullScreenMode() {
        this.platformWindow.enterFullScreenMode();
    }

    @Override
    public void exitFullScreenMode() {
        this.platformWindow.exitFullScreenMode();
    }

    public long getLayerPtr() {
        return this.getPlatformWindow().getLayerPtr();
    }

    void grab() {
        if (grabbingWindow != null && !this.isGrabbing()) {
            grabbingWindow.ungrab();
        }
        grabbingWindow = this;
    }

    void ungrab() {
        if (this.isGrabbing()) {
            grabbingWindow = null;
            this.postEvent(new UngrabEvent((Component)this.getTarget()));
        }
    }

    private boolean isGrabbing() {
        return this == grabbingWindow;
    }

    public String toString() {
        return super.toString() + " [target is " + this.getTarget() + "]";
    }

    public static enum PeerType {
        SIMPLEWINDOW,
        FRAME,
        DIALOG,
        EMBEDDEDFRAME;

    }
}

