/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.security.AccessController;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CPlatformWindow;
import sun.security.action.GetPropertyAction;

public final class CDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final CDragSourceContextPeer fInstance = new CDragSourceContextPeer(null);
    private Image fDragImage;
    private CImage fDragCImage;
    private Point fDragImageOffset;
    private static Component hoveringComponent = null;
    private static double fMaxImageSize = 128.0;

    private CDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    public static CDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        fInstance.setTrigger(dragGestureEvent);
        return fInstance;
    }

    @Override
    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.fDragImage = image;
        this.fDragImageOffset = point;
        super.startDrag(dragSourceContext, cursor, image, point);
    }

    @Override
    protected void startDrag(Transferable transferable, long[] lArray, Map map) {
        Point point;
        Object object;
        Object object2;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        Point point2 = dragGestureEvent.getDragOrigin();
        int n = inputEvent.getModifiers() | inputEvent.getModifiersEx();
        long l = inputEvent.getWhen();
        int n2 = inputEvent instanceof MouseEvent ? ((MouseEvent)inputEvent).getClickCount() : 1;
        Component component = dragGestureEvent.getComponent();
        Point point3 = new Point();
        ComponentPeer componentPeer = component.getPeer();
        if (component.isLightweight()) {
            object2 = component.getLocation();
            point3.translate(((Point)object2).x, ((Point)object2).y);
            for (object = component.getParent(); object != null; object = ((Component)object).getParent()) {
                if (!((Component)object).isLightweight()) {
                    componentPeer = ((Component)object).getPeer();
                    break;
                }
                object2 = ((Component)object).getLocation();
                point3.translate(((Point)object2).x, ((Point)object2).y);
            }
        }
        if (!(componentPeer instanceof LWComponentPeer)) {
            throw new IllegalArgumentException("DragSource's peer must be a ComponentModel.");
        }
        object2 = (LWComponentPeer)componentPeer;
        object = (CPlatformWindow)((LWComponentPeer)object2).getPlatformWindow();
        long l2 = ((CPlatformWindow)object).getNSWindowPtr();
        Cursor cursor = this.getCursor();
        if (this.fDragImage == null) {
            this.setDefaultDragImage(component);
        }
        if (this.fDragImage != null) {
            try {
                this.fDragCImage = CImage.getCreator().createFromImageImmediately(this.fDragImage);
            }
            catch (Exception exception) {
                throw new InvalidDnDOperationException("Drag image can not be created.");
            }
            if (this.fDragCImage == null) {
                throw new InvalidDnDOperationException("Drag image is not ready.");
            }
            point = this.fDragImageOffset;
        } else {
            this.fDragCImage = null;
            point = new Point(0, 0);
        }
        try {
            long l3 = this.createNativeDragSource(component, componentPeer, l2, transferable, inputEvent, (int)(point2.getX() + (double)point3.x), (int)(point2.getY() + (double)point3.y), n, n2, l, cursor, this.fDragCImage, point.x, point.y, this.getDragSourceContext().getSourceActions(), lArray, map);
            if (l3 == 0L) {
                throw new InvalidDnDOperationException("");
            }
            this.setNativeContext(l3);
            CCursorManager.getInstance().startDrag((int)(point2.getX() + (double)point3.x), (int)(point2.getY() + (double)point3.y));
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("failed to create native peer: " + exception);
        }
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
        try {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long l = CDragSourceContextPeer.this.getNativeContext();
                    try {
                        CDragSourceContextPeer.this.doDragging(l);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        CCursorManager.getInstance().stopDrag();
                        CDragSourceContextPeer.this.releaseNativeDragSource(l);
                        CDragSourceContextPeer.this.fDragImage = null;
                        if (CDragSourceContextPeer.this.fDragCImage != null) {
                            CDragSourceContextPeer.this.fDragCImage.dispose();
                            CDragSourceContextPeer.this.fDragCImage = null;
                        }
                    }
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            CCursorManager.getInstance().stopDrag();
            long l4 = this.getNativeContext();
            this.setNativeContext(0L);
            this.releaseNativeDragSource(l4);
            SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            throw new InvalidDnDOperationException("failed to start dragging thread: " + exception);
        }
    }

    private void setDefaultDragImage(Component component) {
        boolean bl = false;
        if (component.isLightweight()) {
            if (component instanceof JTextComponent) {
                this.setDefaultDragImage((JTextComponent)component);
                bl = true;
            } else if (component instanceof JTree) {
                this.setDefaultDragImage((JTree)component);
                bl = true;
            } else if (component instanceof JTable) {
                this.setDefaultDragImage((JTable)component);
                bl = true;
            } else if (component instanceof JList) {
                this.setDefaultDragImage((JList)component);
                bl = true;
            }
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTextComponent jTextComponent) {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = false;
        int n3 = jTextComponent.viewToModel(dragGestureEvent.getDragOrigin());
        if (n < n2 && n3 >= n && n3 <= n2) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                Rectangle rectangle3 = null;
                if (rectangle.y == rectangle2.y) {
                    rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x + rectangle2.width, rectangle2.y - rectangle.y + rectangle2.height);
                } else {
                    AccessibleContext accessibleContext = jTextComponent.getAccessibleContext();
                    AccessibleText accessibleText = (AccessibleText)((Object)accessibleContext);
                    rectangle3 = jTextComponent.modelToView(n);
                    for (int i = n + 1; i <= n2; ++i) {
                        Rectangle rectangle4 = accessibleText.getCharacterBounds(i);
                        if (rectangle4 == null) continue;
                        rectangle3.add(rectangle4);
                    }
                }
                this.setOutlineDragImage(rectangle3);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTree jTree) {
        Rectangle rectangle = null;
        int[] nArray = jTree.getSelectionRows();
        for (int i = 0; i < nArray.length; ++i) {
            Rectangle rectangle2 = jTree.getRowBounds(nArray[i]);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTable jTable) {
        Rectangle rectangle = null;
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                Rectangle rectangle2 = jTable.getCellRect(nArray[i], nArray2[j], true);
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                rectangle.add(rectangle2);
            }
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JList jList) {
        Rectangle rectangle = null;
        int[] nArray = jList.getSelectedIndices();
        if (nArray.length > 0) {
            rectangle = jList.getCellBounds(nArray[0], nArray[nArray.length - 1]);
        }
        if (rectangle != null) {
            this.setOutlineDragImage(rectangle);
        } else {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        this.setOutlineDragImage(new Rectangle(0, 0, component.getWidth(), component.getHeight()), true);
    }

    private void setOutlineDragImage(Rectangle rectangle) {
        this.setOutlineDragImage(rectangle, false);
    }

    private void setOutlineDragImage(Rectangle object, Boolean bl) {
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3 = (int)((Rectangle)object).getWidth();
        int n4 = (int)((Rectangle)object).getHeight();
        double d = 1.0;
        if (bl.booleanValue() && (n2 = n3 * n4) > (n = (int)(fMaxImageSize * fMaxImageSize))) {
            d = (double)n2 / (double)n;
            n3 = (int)((double)n3 / d);
            n4 = (int)((double)n4 / d);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = component.getLocation();
        if (component instanceof JComponent) {
            object3 = ((JComponent)component).getVisibleRect();
            object2 = ((Rectangle)object).intersection((Rectangle)object3);
            if (!((Rectangle)object2).isEmpty()) {
                object = object2;
            }
            ((Rectangle)object).translate(point.x, point.y);
        }
        object3 = component.getGraphicsConfiguration();
        object2 = ((GraphicsConfiguration)object3).createCompatibleImage(n3, n4, 3);
        Color color = Color.gray;
        BasicStroke basicStroke = new BasicStroke(2.0f);
        int n5 = (int)(basicStroke.getLineWidth() + 1.0f) / 2;
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object2).getGraphics();
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawRect(n5, n5, n3 - 2 * n5 - 1, n4 - 2 * n5 - 1);
        graphics2D.dispose();
        this.fDragImage = object2;
        Point point2 = dragGestureEvent.getDragOrigin();
        Point point3 = new Point(((Rectangle)object).x - point2.x, ((Rectangle)object).y - point2.y);
        if (component instanceof JComponent) {
            point3.translate(-point.x, -point.y);
        }
        if (bl.booleanValue()) {
            point3.x = (int)((double)point3.x / d);
            point3.y = (int)((double)point3.y / d);
        }
        this.fDragImageOffset = point3;
    }

    private void dragMouseMoved(int n, int n2, int n3, int n4) {
        CCursorManager.getInstance().updateDragPosition(n3, n4);
        Component component = SwingUtilities.getRoot(this.getComponent());
        if (component != null) {
            Point point = new Point(n3, n4);
            SwingUtilities.convertPointFromScreen(point, component);
            Component component2 = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
            if (component2 != hoveringComponent) {
                if (hoveringComponent != null) {
                    this.dragExit(n3, n4);
                }
                if (component2 != null) {
                    this.dragEnter(n, n2, n3, n4);
                }
                hoveringComponent = component2;
            }
        }
        this.postDragSourceDragEvent(n, n2, n3, n4, 6);
    }

    private void dragEnter(int n, int n2, int n3, int n4) {
        CCursorManager.getInstance().updateDragPosition(n3, n4);
        this.postDragSourceDragEvent(n, n2, n3, n4, 1);
    }

    private void resetHovering() {
        hoveringComponent = null;
    }

    @Override
    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        super.setCursor(cursor);
    }

    @Override
    protected native void setNativeCursor(long var1, Cursor var3, int var4);

    private native long createNativeDragSource(Component var1, ComponentPeer var2, long var3, Transferable var5, InputEvent var6, int var7, int var8, int var9, int var10, long var11, Cursor var13, CImage var14, int var15, int var16, int var17, long[] var18, Map var19);

    private native void doDragging(long var1);

    private native void releaseNativeDragSource(long var1);

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("apple.awt.dnd.defaultDragImageSize"));
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                if (d > 0.0) {
                    fMaxImageSize = d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

