#include "config.h"
/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(__NeXT__)
#define getenv Getenv	/* our getenv conflicts at load-time with NeXT
			   library libsys_s.a version */
#endif

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)getenv.c	5.5 (Berkeley) 6/27/88";
#endif /* LIBC_SCCS and not lint */

#include "args.h"
#include <stdio.h>

#if HAVE_STDC
#include <string.h>
#include <stdlib.h>
#else
#define const
#endif

#if defined(__sgi)
#define environ _environ /* environ unavailable in SGI Std C: environ_ is  */
#endif

char *getenv ARGS((const char *));
char *_findenv ARGS((const char *name, int *offset));

extern char **environ;

/*
 * getenv --
 *	Returns ptr to value associated with name, if any, else NULL.
 */
char *
#if HAVE_STDC
getenv(const char *name)
#else /* K&R style */
getenv(name)
	const char *name;
#endif /* HAVE_STDC */
{
	int offset;

	return(_findenv(name, &offset));
}

/*
 * _findenv --
 *	Returns pointer to value associated with name, if any, else NULL.
 *	Sets offset to be the offset of the name/value combination in the
 *	environmental array, for use by setenv(3) and unsetenv(3).
 *	Explicitly removes '=' in argument name.
 *
 *	This routine *should* be a static; don't use it.
 */
char *
#if HAVE_STDC
_findenv(register const char *name, int *offset)
#else /* K&R style */
_findenv(name, offset)
	register const char *name;
	int *offset;
#endif /* HAVE_STDC */
{
	register int len;
	register const char *C;
	register char **P;

	for (C = name, len = 0; *C && *C != '='; ++C, ++len);
	for (P = environ; *P; ++P)
		if (!strncmp(*P, name, len))
			if (*(C = *P + len) == '=') {
				*offset = P - environ;
				return((char*)(++C));
			}
	return(NULL);
}
