#ifndef ADDRESS_H_
#define ADDRESS_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *addr_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/address.h,v 1.1 2005/05/28 22:27:50 beebe Exp $";
#endif
#endif /* RCSID */

/*
 * parse for RFC822 mail addresses.
 */

/*
 * an entry in an address list can be a comment, a phrase: to start a
 * list, a group end, or an actual address.  Keep these all chained in a list.
 * one of these is an address unit.
 */
typedef struct addr_unit {
    int type;
    char *data;
    struct addr_unit *next, *prev;
} addr_unit;

typedef struct addresslist {
    addr_unit *first;
    addr_unit *last;
} addresslist;

#define ADR_ADDRESS 1
#define ADR_GROUP 2
#define ADR_GROUPEND 3
#define ADR_FILE 4
#define ADR_ALIAS 5
#define ADR_AL_EXPAND 6
#define ADR_LISTFILE 7
#define ADR_MLIST 8


/* types of mail aliases */
#define MA_USER		0		/* user set alias, needs to be saved */
#define MA_SYSTEM	1		/* aliases from system init file */
#define MA_MAILRC	2		/* Mail alias from .mailrc */

typedef struct mail_alias {
    const char *name;
    addresslist alias;
    int type;				/* type of alias */
} mail_alias;


typedef struct mail_aliases {
    mail_alias *aliases;
    int count;
} Mail_aliases;

#endif /* ADDRESS_H_ */
