/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vmx86.h,v 1.2 2003/02/16 01:29:50 bad Exp $
 * **********************************************************/

/*
 *  vmx86.h - Platform independent data and interface for supporting 
 *            the vmx86 device driver. 
 */

#ifndef VMX86_H
#define VMX86_H

#include "x86.h"
#include "modulecall.h"
#include "vm_types.h"
#include "vm_time.h"
#include "initblock.h"
#include "memmgmt.h"

/*
 * VMDriver - the main data structure for the driver side of a 
 *            virtual machine.
 */ 


/* support 4GB tracing */

typedef struct VMDriver {
  struct VMCrossPage  *crosspage;    /* Pointer to the cross over page 
				      * shared with the monitor.  */
  void                *processID;    /* User level process handle. */
  void                *uniqHandle;   /* Unique handle of driver */
  struct VMDriver      *nextDriver;  /* Used to link drivers together on an list */
  int                  logFD;        /* File descriptor for log messages */
  void                 *gdtPtr;      /* Address of the GDT in the user
					program address space */
  Bool                 running;      /* True if the monitor has been started */
  void                 *memtracker;  /* Memory tracker pointer */
  /* The following data structures are used for verification 
   * of the monitor task to avoid horrible deaths when something
   * is wrong. 
   */
  int                  numChecks;
  ContextInfo          prevMonContext;
  uint32               jumpLocation[8];
  Descriptor           prevTRDesc;
   
#ifdef WINNT_DDK
  void *crossPageMDL;
#endif
#ifdef __FreeBSD__
  struct KernelAddr *driverPtrs;
#endif
#ifdef __NetBSD__
  void *		crossvaddr;
  void *		crossuaddr;
#endif
   VmTimeStart startTime; /* Used to compute Mhz estimate */
   struct PhysTracker  *physTracker;
   int                 releaseCount;
   struct  PerfCounter *perfCounter;

   Bool                checkFuncFailed;

   Bool                smpMachine;
   VMX86Stats	        stats;
   
   VMMemMgmtInfo       memMgmtInfo;

   uint32              vmUID;
   int32               port;
   char                name[VM_NAME_LENGTH];
   char                userName[VM_USER_NAME_LENGTH];
   VMInfoState         state;

   volatile uint32     (*hostAPIC)[4];    /* kseg pointer to host APIC */
#ifdef KERNEL_2_3_25
   struct page*        crosspagePage;
#endif
} VMDriver;


extern VMDriver *Vmx86_Init(void *uniqHandle, void *processId);
extern void Vmx86_LateInit(VMDriver *vm);
extern int Vmx86_CreateVM(VMDriver *vm, InitBlock *initParams);
extern int Vmx86_RunVM(VMDriver *vm);
extern int Vmx86_DestroyVM(VMDriver *vm);
extern VMDriver *Vmx86_GetVMforProcess(void *processId);
extern int Vmx86_LockPage(VMDriver *vm, void *addr, Bool userPage);
extern int Vmx86_UnlockPage(VMDriver *vm, void *addr, Bool userPage);
extern int32 Vmx86_GetNumVMs(void);
extern int32 Vmx86_GetLockedPagesLimit(void);
extern Bool Vmx86_SetLockedPagesLimit(int32 limit);
extern int32 Vmx86_ReduceLockedPagesLimit(int32 limit);
extern Bool Vmx86_GetMemInfo(VMDriver *curVM,
                             int32 curVMOnly,
                             VMGetSetMemInfoOutArgs *outArgs,
                             int outArgsLength);
extern Bool Vmx86_GetMemInfoCopy(VMDriver *curVM, VMGetSetMemInfoOutArgs *outArgs);
extern void Vmx86_SetMemInfo(VMDriver *curVM, VMGetSetMemInfoInArgs *inArgs);
extern Bool Vmx86_GetVMList(VMGetVMListResult *list, uint32 length);
extern Bool Vmx86_GetVMListCopy(VMGetVMListResult *list);
extern void Vmx86_SetVMInfo(VMDriver *curVM, VMSetVMInfoArgs *info);
extern Bool Vmx86_GetVMInfo(uint32 vmUID, VMGetVMInfoResult *info);
extern void Vmx86_Add2MonPageTable(VMDriver *vm, VPN vpn, MPN mpn, Bool readOnly);
extern VMDriver * Vmx86_CurrentVM(void *uniqHandle);


#endif 
