/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: linux-version.h,v 1.2 2003/02/16 01:29:50 bad Exp $
 * **********************************************************/

#ifndef ___LINUX_VERSION_H__
#define ___LINUX_VERSION_H__

#include <linux/version.h>

#ifndef linux
#error "linux-version.h"
#endif

/*
 * Distinguish relevant classes of Linux kernels.
 *
 * The convention is that version X defines all
 * the KERNEL_Y symbols where Y <= X.
 */

#ifdef KERNEL_VERSION
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 1, 0)
#    define KERNEL_2_1
#  endif
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 2, 0)
#    define KERNEL_2_2
#  endif
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 1)
#    define KERNEL_2_3_1
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 15)
/*     new networking */
#      define KERNEL_2_3_15
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 25)
/*     4GB & 64GB support */
#      define KERNEL_2_3_25
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 25)
/*     new procfs */
#      define KERNEL_2_3_25
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 29)
/*     even newer procfs */
#      define KERNEL_2_3_29
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 43)
/*     softnet changes */
#      define KERNEL_2_3_43
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 47)
/*     more softnet changes */
#      define KERNEL_2_3_47
#    endif
#    if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 99)
/*     name in netdevice struct is array and not pointer */
#      define KERNEL_2_3_99
#    endif
#  endif
#endif


#endif
