/*
 * Copyright 2001 Wasabi Systems, Inc.
 * All rights reserved.
 *
 * Written by Frank van der Linden for Wasabi Systems, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed for the NetBSD Project by
 *      Wasabi Systems, Inc.
 * 4. The name of Wasabi Systems, Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY WASABI SYSTEMS, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL WASABI SYSTEMS, INC
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct hubport_softc {
	struct ethercom	ethercom;
	dev_t port_dev;
	u_short port_flags;
	u_int8_t port_addr[ETHER_ADDR_LEN];
	u_int16_t port_ladrf[4];		/* lance multicast filter */
	int port_sigio;
	struct selinfo port_rsel;
	struct ifqueue port_rcvq;
	struct hubdev_softc *port_hub;
};

#define port_if ethercom.ec_if

#define MAXHUBDEVS	 4	/* No more than 4 devices XXX */
#define MAXHUBPORTS	15	/* Maximum number of ports per hubdevice */
#define MINORSPERDEV	(MAXHUBPORTS + 1)

#define	PORT_RWAIT	0x01	/* Someone is reading on this port */
#define	PORT_ASYNC	0x02	/* Port is in async read mode */
#define PORT_HOSTIF	0x04	/* Port is connected to the real interface */
#define PORT_NBIO	0x08	/* Port in non-blocking mode */

struct hubdev_softc {
	struct hubport_softc *sc_ports[MAXHUBPORTS];
	dev_t sc_dev;
	int sc_maxport;
	int sc_flags;
};

/*
 * The devices are numbered as follows:
 * minor             0: device with name in /dev, opened to create clones.
 * minor 1-MAXHUBPORTS: created clones.
 */

#define HUBUNIT(dev)	(minor(dev) / MINORSPERDEV)
#define HUBPORT(dev)	((minor(dev) % MINORSPERDEV) - 1)

#define MAKEPORTDEV(d,u,p) makedev(major(d),(((u) * MINORSPERDEV) + (p) + 1))
#define MAKEHUBDEV(d,u)  MAKEPORTDEV(d,0,-1)

#define HUBMINPKT	ETHER_HDR_LEN
#if __NetBSD_Version__ >= 105230000 || (__NetBSD_Version__ >= 105000100 && __NetBSD_Version__ < 105010000)
# define HUBMAXPKT(ifp)	(ETHER_MAX_FRAME(ifp, ETHERTYPE_VLAN, 1))
#else
# define HUBMAXPKT	(ETHER_MAX_FRAME(ETHERTYPE_VLAN, 1))
#endif
