/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: memtrack.h,v 1.3 2003/02/16 15:32:33 bad Exp $
 * **********************************************************/

/************************************************************
 *
 * memtrack.h  - Utility module for tracking memory allocated 
 *               and/or locked by the driver. 
 *
 ************************************************************/


#ifndef MEMTRACK_H
#define MEMTRACK_H

#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "vm_types.h"

typedef struct MemTrackEntry {
  VPN vpn;
  MPN mpn;
  struct MemTrackEntry *hashChain;
#ifdef _WIN32
  PMDL mdl;
#endif
} MemTrackEntry;

extern void *MemTrack_Init(void);
extern MemTrackEntry *MemTrack_Add(void *s, VPN vpn, MPN mpn);
extern MemTrackEntry *MemTrack_LookupVPN(void *s, VPN vpn);
extern int MemTrack_Cleanup(void *s,
                            void (*cleanProc)(void *, MemTrackEntry *),
                            void *clientData);
extern void *MemTrack_Scan(void *s, void *arg,
            void *(*searchFunc)(void *arg, MemTrackEntry *entryPtr)); 

#endif 
