/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vm_types.h,v 1.4 2003/02/16 17:42:22 bad Exp $
 * **********************************************************/

/*
 *
 * vm_types.h -- 
 *
 *    basic data types.-- part of driver-only distribution.
 */

#ifndef _VM_TYPES_H_
#define _VM_TYPES_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MONITOR
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMKERNEL
#include "includeCheck.h"

#include "vm_basic_types.h"

#ifndef PAGE_SHIFT
#define PAGE_SHIFT    12
#endif

#ifndef PAGE_SIZE
#define PAGE_SIZE     (1<<PAGE_SHIFT)
#endif

#ifndef PAGE_MASK
#define PAGE_MASK     (PAGE_SIZE - 1)
#endif

#ifndef NULL
#define NULL          ((void*)0)
#endif

#define VA_2_VPN(_va)  ((_va) >> PAGE_SHIFT)
#define PTR_2_VPN(_ptr) VA_2_VPN((uint32)(_ptr))
#define VPN_2_VA(_vpn) ((_vpn) << PAGE_SHIFT)

/* 
 * Notice that we don't cast PA_2_PPN's argument to an unsigned type, because
 * we would lose compile-time checks for pointer operands and byte-sized
 * operands. If you use a signed quantity for _pa, ones may be shifted into the
 * high bits of your ppn.
 */
#define PA_2_PPN(_pa)  ((_pa) >> PAGE_SHIFT)
#define PPN_2_PA(_ppn) ((_ppn) << PAGE_SHIFT)

#define MPN_2_KSEG(_mpn)  ((_mpn) << PAGE_SHIFT)
#define MPN_2_MA(_mpn)    ((_mpn) << PAGE_SHIFT)
#define MA_2_KSEG(_ma)    (_ma)
#define MA_2_MPN(_ma)     ((_ma) >> PAGE_SHIFT)

typedef uint32 LA;
typedef uint32 LPN;
#define LA_2_LPN(_la)     ((_la)>>PAGE_SHIFT)
#define LPN_2_LA(_lpn)    ((_lpn) << PAGE_SHIFT)

#ifndef PAGE_OFFSET
#define PAGE_OFFSET(_addr)  ((_addr)&(PAGE_SIZE-1))
#endif

/* 4 Mb pages. */
#define LARGE_PAGE_SHIFT  22
#define LARGE_PAGE_SIZE   (1 << LARGE_PAGE_SHIFT)
#define LARGE_PAGE_MASK   (LARGE_PAGE_SIZE - 1)

typedef uint32 PDE;
typedef uint32 PTE;
typedef uint64 PAE_PDE; 
typedef uint64 PAE_PTE; 
typedef uint64 PDPTE;

typedef int32  Reg;
typedef uint8 *TCA;
typedef int32  IRQ;

#ifndef _SIZE_T
#define _SIZE_T
typedef uint32 size_t;
#endif

typedef int64 VmTimeType;          /* Time in microseconds */
typedef int64 VmTimeRealClock;     /* Real clock kept in microseconds */
typedef int64 VmTimeVirtualClock;  /* Virtual Clock kept in CPU cycles */

typedef struct VmTimeStart {
   VmTimeVirtualClock   count;
   VmTimeRealClock      time;
} VmTimeStart;

/*
 * IRQ
 */

#define NOIRQ -1
#define LEGAL_IRQ(_irq) ( ((_irq)==NOIRQ) || ((_irq)>=0 && (_irq)<16))

#ifndef _WIN32
#define LOWORD(_dw)   ((_dw) & 0xffff)
#endif

#ifdef MONITOR
#ifdef _WIN32
#  define LOWORD(_dw)   ((_dw) & 0xffff)
#endif
#define HIWORD(_dw)   (((_dw) >> 16) & 0xffff)

#define LOBYTE(_w)    ((_w) & 0xff)
#define HIBYTE(_w)    (((_w) >> 8) & 0xff)

#define LODWORD(_dw)   ((uint32)((_dw) & 0xffffffff))

#ifdef __GNUC__
#  define HIDWORD(_dw)  ((uint32)(((_dw) >> 32) & 0xffffffff))
#elif _WIN32
static INLINE uint32 HIDWORD(uint64 y) 
{ 
   uint32 *ptr = (uint32 *)&y;
   return ptr[1];
}
#else
#  error Unknown platform
#endif

#define MERGE_LOBYTE(_w, _b)    (((_w) & ~0x00ff) | ((_b) & 0x00ff))
#define MERGE_HIBYTE(_w, _b)    (((_w) & ~0xff00) | (((_b) << 8) & 0xff00))

#define DWORD(_hi, _lo)         ((((uint64)(_hi))<<32) | (((uint64)(_lo)) & 0xffffffff))

#endif /* ifdef MONITOR */

/* XXX move to where genexc is defined */
#define EXC_SRC_INTERNAL  1
#define EXC_SRC_IRQ       2
#define EXC_SRC_INT       3

#ifndef offsetof
#define offsetof(type, member) ( (int) & ((type*)0) -> member )
#endif

#ifndef __NetBSD__
#ifndef MIN
#define MIN(_a, _b)   (((_a) < (_b)) ? (_a) : (_b))
#endif

#ifndef MAX
#define MAX(_a, _b)   (((_a) > (_b)) ? (_a) : (_b))
#endif
#endif /* __NetBSD__ */

#define ROUNDUP(x,y)		(((x) + (y) - 1) / (y) * (y))
#define ROUNDDOWN(x,y)		((x) / (y) * (y))
#define ROUNDUPBITS(x, bits)	(((uint32) (x) + MASK(bits)) & ~MASK(bits))
#define ROUNDDOWNBITS(x, bits)	((uint32) (x) & ~MASK(bits))
#define CEILING(x, y)		(((x) + (y) - 1) / (y))
#define MASK(n)			((1 << (n)) - 1)	/* make an n-bit mask */

/* Deposit a field _src at _pos bits from the right, with a length of _len, */
/* into the integer _target. */

#define DEPOSIT_BITS(_src,_pos,_len,_target) { \
	unsigned mask = ((1 << _len) - 1); \
	unsigned shiftedmask = ((1 << _len) - 1) << _pos; \
	_target = (_target & ~shiftedmask) | ((_src & mask) << _pos); \
}


#ifdef MONITOR

/*
 * Include stdarg.h so that we can define sprintf and vsprintf to actually
 * match the implementation.  This also matches the linux kernel header file
 * definition making life easier for the vmklinux module.
 */
#include <stdarg.h>

extern int sprintf(char * buf, const char * fmt, ...);
extern int vsprintf(char *buf, const char *, va_list);
extern int snprintf(char *str, size_t size, const char *format, ...);
extern int vsnprintf(char *str, size_t size, const char *format, va_list ap);

#endif /* MONITOR */

/*
 * Standardize some posix names on Windows.
 */
#ifdef _WIN32

#define snprintf _snprintf
#define	vsnprintf	_vsnprintf

#define strcasecmp(_s1,_s2)   _stricmp((_s1),(_s2))
#define strncasecmp(_s1,_s2,_n)   _strnicmp((_s1),(_s2),(_n))
#define sleep(sec)   Sleep((sec) * 1000)
#define usleep(usec) Sleep(CEILING(usec, 1000))

typedef int pid_t;
#define	getpid		_getpid

#define open _open

#define	access        _access
#define       F_OK          0
#define       X_OK          1
#define       W_OK          2
#define       R_OK          4

#define PATH_MAX 256

#endif /* _WIN32 */

#endif //_VM_TYPES_H_
