#ifndef _NFS_NFS_LOCK_H_
#define _NFS_NFS_LOCK_H_

#define _PATH_NFS_LOCKDEV "/dev/nfs_lock"

#define NFSLOCK_MAGIC 0xef01 /* should be odd */

#include <sys/types.h>
#include <sys/socket.h>

struct nfslock_req {
	int magic; /* NFSLOCK_MAGIC */
	int serial;
	int op; /* NULL/TEST/LOCK/CANCEL/UNLOCK */
	int exclusive, posix, wait;
	off_t offset, len;
	pid_t owner;
	int handle_len;
	u_int8_t handle[64];
	int mount_version, mount_soft;
	int mount_timeo, mount_retry;
	struct sockaddr_storage mount_nam;
};

struct nfslock_rep {
	int magic; /* NFSLOCK_MAGIC + 1 */
	int serial;
	int errnum;
	int conflict;
	off_t offset, len;
	pid_t owner;
};

#endif /* _NFS_NFS_LOCK_H_ */
