#!/usr/bin/env python
#
#      Restriction Analysis Libraries.
#      Copyright (C) 2004. Frederic Sohm.
#
# This code is part of the Biopython distribution and governed by its
# license.  Please see the LICENSE file that should have been included
# as part of this package.
#
#
rest_dict = \
{'AarI': {'charac': (11, 8, None, None, 'CACCTGC'),
          'compsite': '(?P<AarI>CACCTGC)|(?P<AarI_as>GCAGGTG)',
          'dna': None,
          'freq': 16384,
          'fst3': 8,
          'fst5': 11,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACCTGC',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'AasI': {'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
          'compsite': '(?P<AasI>GAC......GTC)|(?P<AasI_as>GAC......GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -7,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNNNNGTC',
          'size': 12,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'AatI': {'charac': (3, -3, None, None, 'AGGCCT'),
          'compsite': '(?P<AatI>AGGCCT)|(?P<AatI_as>AGGCCT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGGCCT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('O',)},
 'AatII': {'charac': (5, -5, None, None, 'GACGTC'),
           'compsite': '(?P<AatII>GACGTC)|(?P<AatII_as>GACGTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'ACGT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GACGTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'F', 'G', 'I', 'K', 'M', 'N', 'O', 'R')},
 'Acc16I': {'charac': (3, -3, None, None, 'TGCGCA'),
            'compsite': '(?P<Acc16I>TGCGCA)|(?P<Acc16I_as>TGCGCA)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TGCGCA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Acc36I': {'charac': (10, 8, None, None, 'ACCTGC'),
            'compsite': '(?P<Acc36I>ACCTGC)|(?P<Acc36I_as>GCAGGT)',
            'dna': None,
            'freq': 4096,
            'fst3': 8,
            'fst5': 10,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACCTGC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Acc65I': {'charac': (1, -1, None, None, 'GGTACC'),
            'compsite': '(?P<Acc65I>GGTACC)|(?P<Acc65I_as>GGTACC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GTAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTACC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F', 'G', 'I', 'N', 'R')},
 'AccB1I': {'charac': (1, -1, None, None, 'GGYRCC'),
            'compsite': '(?P<AccB1I>GG[CT][AG]CC)|(?P<AccB1I_as>GG[CT][AG]CC)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GYRC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGYRCC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AccB7I': {'charac': (7, -7, None, None, 'CCANNNNNTGG'),
            'compsite': '(?P<AccB7I>CCA.....TGG)|(?P<AccB7I_as>CCA.....TGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -7,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'NNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCANNNNNTGG',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('I', 'R')},
 'AccBSI': {'charac': (3, -3, None, None, 'CCGCTC'),
            'compsite': '(?P<AccBSI>CCGCTC)|(?P<AccBSI_as>GAGCGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCGCTC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AccI': {'charac': (2, -2, None, None, 'GTMKAC'),
          'compsite': '(?P<AccI>GT[AC][GT]AC)|(?P<AccI_as>GT[AC][GT]AC)',
          'dna': None,
          'freq': 1024,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'MK',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTMKAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'E', 'G', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U')},
 'AccII': {'charac': (2, -2, None, None, 'CGCG'),
           'compsite': '(?P<AccII>CGCG)|(?P<AccII_as>CGCG)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGCG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('A', 'J', 'K')},
 'AccIII': {'charac': (1, -1, None, None, 'TCCGGA'),
            'compsite': '(?P<AccIII>TCCGGA)|(?P<AccIII_as>TCCGGA)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CCGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TCCGGA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('E', 'G', 'J', 'K', 'R')},
 'AceIII': {'charac': (13, 11, None, None, 'CAGCTC'),
            'compsite': '(?P<AceIII>CAGCTC)|(?P<AceIII_as>GAGCTG)',
            'dna': None,
            'freq': 4096,
            'fst3': 11,
            'fst5': 13,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CAGCTC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'AciI': {'charac': (1, -1, None, None, 'CCGC'),
          'compsite': '(?P<AciI>CCGC)|(?P<AciI_as>GCGG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCGC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'AclI': {'charac': (2, -2, None, None, 'AACGTT'),
          'compsite': '(?P<AclI>AACGTT)|(?P<AclI_as>AACGTT)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AACGTT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'AclWI': {'charac': (9, 5, None, None, 'GGATC'),
           'compsite': '(?P<AclWI>GGATC)|(?P<AclWI_as>GATCC)',
           'dna': None,
           'freq': 1024,
           'fst3': 5,
           'fst5': 9,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGATC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'AcsI': {'charac': (1, -1, None, None, 'RAATTY'),
          'compsite': '(?P<AcsI>[AG]AATT[CT])|(?P<AcsI_as>[AG]AATT[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'AATT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RAATTY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'M')},
 'AcuI': {'charac': (22, 14, None, None, 'CTGAAG'),
          'compsite': '(?P<AcuI>CTGAAG)|(?P<AcuI_as>CTTCAG)',
          'dna': None,
          'freq': 4096,
          'fst3': 14,
          'fst5': 22,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTGAAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'AcvI': {'charac': (3, -3, None, None, 'CACGTG'),
          'compsite': '(?P<AcvI>CACGTG)|(?P<AcvI_as>CACGTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACGTG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('Q', 'X')},
 'AcyI': {'charac': (2, -2, None, None, 'GRCGYC'),
          'compsite': '(?P<AcyI>G[AG]CG[CT]C)|(?P<AcyI_as>G[AG]CG[CT]C)',
          'dna': None,
          'freq': 1024,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GRCGYC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('J', 'M')},
 'AdeI': {'charac': (6, -6, None, None, 'CACNNNGTG'),
          'compsite': '(?P<AdeI>CAC...GTG)|(?P<AdeI_as>CAC...GTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACNNNGTG',
          'size': 9,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'AfaI': {'charac': (2, -2, None, None, 'GTAC'),
          'compsite': '(?P<AfaI>GTAC)|(?P<AfaI_as>GTAC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTAC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A', 'K')},
 'AfeI': {'charac': (3, -3, None, None, 'AGCGCT'),
          'compsite': '(?P<AfeI>AGCGCT)|(?P<AfeI_as>AGCGCT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGCGCT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'AflII': {'charac': (1, -1, None, None, 'CTTAAG'),
           'compsite': '(?P<AflII>CTTAAG)|(?P<AflII_as>CTTAAG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TTAA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTTAAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'J', 'K', 'N', 'O')},
 'AflIII': {'charac': (1, -1, None, None, 'ACRYGT'),
            'compsite': '(?P<AflIII>AC[AG][CT]GT)|(?P<AflIII_as>AC[AG][CT]GT)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CRYG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACRYGT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('G', 'M', 'N', 'S')},
 'AgeI': {'charac': (1, -1, None, None, 'ACCGGT'),
          'compsite': '(?P<AgeI>ACCGGT)|(?P<AgeI_as>ACCGGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACCGGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('G', 'J', 'N', 'R')},
 'AhaIII': {'charac': (3, -3, None, None, 'TTTAAA'),
            'compsite': '(?P<AhaIII>TTTAAA)|(?P<AhaIII_as>TTTAAA)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TTTAAA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'AhdI': {'charac': (6, -6, None, None, 'GACNNNNNGTC'),
          'compsite': '(?P<AhdI>GAC.....GTC)|(?P<AhdI_as>GAC.....GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNNNGTC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('G', 'N')},
 'AhlI': {'charac': (1, -1, None, None, 'ACTAGT'),
          'compsite': '(?P<AhlI>ACTAGT)|(?P<AhlI_as>ACTAGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTAGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'AjnI': {'charac': (0, 0, None, None, 'CCWGG'),
          'compsite': '(?P<AjnI>CC[AT]GG)|(?P<AjnI_as>CC[AT]GG)',
          'dna': None,
          'freq': 512,
          'fst3': 0,
          'fst5': 0,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -5,
          'ovhgseq': 'CCWGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCWGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'AleI': {'charac': (5, -5, None, None, 'CACNNNNGTG'),
          'compsite': '(?P<AleI>CAC....GTG)|(?P<AleI_as>CAC....GTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACNNNNGTG',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'AlfI': {'charac': (-10, -24, 24, 10, 'GCANNNNNNTGC'),
          'compsite': '(?P<AlfI>GCA......TGC)|(?P<AlfI_as>GCA......TGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -24,
          'fst5': -10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': 10,
          'scd5': 24,
          'site': 'GCANNNNNNTGC',
          'size': 12,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'AloI': {'charac': (-7, -25, 25, 7, 'GAACNNNNNNTCC'),
          'compsite': '(?P<AloI>GAAC......TCC)|(?P<AloI_as>GGA......GTTC)',
          'dna': None,
          'freq': 16384,
          'fst3': -25,
          'fst5': -7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 7,
          'scd5': 25,
          'site': 'GAACNNNNNNTCC',
          'size': 13,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'AluI': {'charac': (2, -2, None, None, 'AGCT'),
          'compsite': '(?P<AluI>AGCT)|(?P<AluI_as>AGCT)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGCT',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'Alw21I': {'charac': (5, -5, None, None, 'GWGCWC'),
            'compsite': '(?P<Alw21I>G[AT]GC[AT]C)|(?P<Alw21I_as>G[AT]GC[AT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'WGCW',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GWGCWC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Alw26I': {'charac': (6, 5, None, None, 'GTCTC'),
            'compsite': '(?P<Alw26I>GTCTC)|(?P<Alw26I_as>GAGAC)',
            'dna': None,
            'freq': 1024,
            'fst3': 5,
            'fst5': 6,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTCTC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('F', 'R')},
 'Alw44I': {'charac': (1, -1, None, None, 'GTGCAC'),
            'compsite': '(?P<Alw44I>GTGCAC)|(?P<Alw44I_as>GTGCAC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'TGCA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTGCAC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F', 'J', 'M', 'O', 'R', 'S')},
 'AlwI': {'charac': (9, 5, None, None, 'GGATC'),
          'compsite': '(?P<AlwI>GGATC)|(?P<AlwI_as>GATCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGATC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'AlwNI': {'charac': (6, -6, None, None, 'CAGNNNCTG'),
           'compsite': '(?P<AlwNI>CAG...CTG)|(?P<AlwNI_as>CAG...CTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -6,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CAGNNNCTG',
           'size': 9,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'Ama87I': {'charac': (1, -1, None, None, 'CYCGRG'),
            'compsite': '(?P<Ama87I>C[CT]CG[AG]G)|(?P<Ama87I_as>C[CT]CG[AG]G)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'YCGR',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CYCGRG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Aor51HI': {'charac': (3, -3, None, None, 'AGCGCT'),
             'compsite': '(?P<Aor51HI>AGCGCT)|(?P<Aor51HI_as>AGCGCT)',
             'dna': None,
             'freq': 4096,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'AGCGCT',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('A', 'K')},
 'ApaBI': {'charac': (8, -8, None, None, 'GCANNNNNTGC'),
           'compsite': '(?P<ApaBI>GCA.....TGC)|(?P<ApaBI_as>GCA.....TGC)',
           'dna': None,
           'freq': 4096,
           'fst3': -8,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 5,
           'ovhgseq': 'NNNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCANNNNNTGC',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ()},
 'ApaI': {'charac': (5, -5, None, None, 'GGGCCC'),
          'compsite': '(?P<ApaI>GGGCCC)|(?P<ApaI_as>GGGCCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'GGCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGGCCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'ApaLI': {'charac': (1, -1, None, None, 'GTGCAC'),
           'compsite': '(?P<ApaLI>GTGCAC)|(?P<ApaLI_as>GTGCAC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TGCA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTGCAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'K', 'N', 'U')},
 'ApeKI': {'charac': (1, -1, None, None, 'GCWGC'),
           'compsite': '(?P<ApeKI>GC[AT]GC)|(?P<ApeKI_as>GC[AT]GC)',
           'dna': None,
           'freq': 512,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'CWG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCWGC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'ApoI': {'charac': (1, -1, None, None, 'RAATTY'),
          'compsite': '(?P<ApoI>[AG]AATT[CT])|(?P<ApoI_as>[AG]AATT[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'AATT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RAATTY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'AscI': {'charac': (2, -2, None, None, 'GGCGCGCC'),
          'compsite': '(?P<AscI>GGCGCGCC)|(?P<AscI_as>GGCGCGCC)',
          'dna': None,
          'freq': 65536,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CGCG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCGCC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('G', 'N')},
 'AseI': {'charac': (2, -2, None, None, 'ATTAAT'),
          'compsite': '(?P<AseI>ATTAAT)|(?P<AseI_as>ATTAAT)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATTAAT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('J', 'N', 'O')},
 'AsiAI': {'charac': (1, -1, None, None, 'ACCGGT'),
           'compsite': '(?P<AsiAI>ACCGGT)|(?P<AsiAI_as>ACCGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCGGT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'AsiSI': {'charac': (5, -5, None, None, 'GCGATCGC'),
           'compsite': '(?P<AsiSI>GCGATCGC)|(?P<AsiSI_as>GCGATCGC)',
           'dna': None,
           'freq': 65536,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'AT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGATCGC',
           'size': 8,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'Asp700I': {'charac': (5, -5, None, None, 'GAANNNNTTC'),
             'compsite': '(?P<Asp700I>GAA....TTC)|(?P<Asp700I_as>GAA....TTC)',
             'dna': None,
             'freq': 4096,
             'fst3': -5,
             'fst5': 5,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GAANNNNTTC',
             'size': 10,
             'substrat': 'DNA',
             'suppl': ('M',)},
 'Asp718I': {'charac': (1, -1, None, None, 'GGTACC'),
             'compsite': '(?P<Asp718I>GGTACC)|(?P<Asp718I_as>GGTACC)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'GTAC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GGTACC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('M',)},
 'AspA2I': {'charac': (1, -1, None, None, 'CCTAGG'),
            'compsite': '(?P<AspA2I>CCTAGG)|(?P<AspA2I_as>CCTAGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CTAG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTAGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AspCNI': {'charac': (None, None, None, None, 'GCCGC'),
            'compsite': '(?P<AspCNI>GCCGC)|(?P<AspCNI_as>GCGGC)',
            'dna': None,
            'freq': 1024,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCCGC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'AspEI': {'charac': (6, -6, None, None, 'GACNNNNNGTC'),
           'compsite': '(?P<AspEI>GAC.....GTC)|(?P<AspEI_as>GAC.....GTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -6,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GACNNNNNGTC',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'AspHI': {'charac': (5, -5, None, None, 'GWGCWC'),
           'compsite': '(?P<AspHI>G[AT]GC[AT]C)|(?P<AspHI_as>G[AT]GC[AT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'WGCW',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GWGCWC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'AspI': {'charac': (4, -4, None, None, 'GACNNNGTC'),
          'compsite': '(?P<AspI>GAC...GTC)|(?P<AspI_as>GAC...GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNGTC',
          'size': 9,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'AspLEI': {'charac': (3, -3, None, None, 'GCGC'),
            'compsite': '(?P<AspLEI>GCGC)|(?P<AspLEI_as>GCGC)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCGC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AspS9I': {'charac': (1, -1, None, None, 'GGNCC'),
            'compsite': '(?P<AspS9I>GG.CC)|(?P<AspS9I_as>GG.CC)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GNC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGNCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AssI': {'charac': (3, -3, None, None, 'AGTACT'),
          'compsite': '(?P<AssI>AGTACT)|(?P<AssI_as>AGTACT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGTACT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'AsuC2I': {'charac': (2, -2, None, None, 'CCSGG'),
            'compsite': '(?P<AsuC2I>CC[CG]GG)|(?P<AsuC2I_as>CC[CG]GG)',
            'dna': None,
            'freq': 512,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'S',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCSGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AsuHPI': {'charac': (13, 7, None, None, 'GGTGA'),
            'compsite': '(?P<AsuHPI>GGTGA)|(?P<AsuHPI_as>TCACC)',
            'dna': None,
            'freq': 1024,
            'fst3': 7,
            'fst5': 13,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTGA',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AsuI': {'charac': (1, -1, None, None, 'GGNCC'),
          'compsite': '(?P<AsuI>GG.CC)|(?P<AsuI_as>GG.CC)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'GNC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGNCC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'AsuII': {'charac': (2, -2, None, None, 'TTCGAA'),
           'compsite': '(?P<AsuII>TTCGAA)|(?P<AsuII_as>TTCGAA)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TTCGAA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'AsuNHI': {'charac': (1, -1, None, None, 'GCTAGC'),
            'compsite': '(?P<AsuNHI>GCTAGC)|(?P<AsuNHI_as>GCTAGC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CTAG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCTAGC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'AvaI': {'charac': (1, -1, None, None, 'CYCGRG'),
          'compsite': '(?P<AvaI>C[CT]CG[AG]G)|(?P<AvaI_as>C[CT]CG[AG]G)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'YCGR',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CYCGRG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'E', 'G', 'J', 'K', 'M', 'N', 'O', 'R', 'S', 'U')},
 'AvaII': {'charac': (1, -1, None, None, 'GGWCC'),
           'compsite': '(?P<AvaII>GG[AT]CC)|(?P<AvaII_as>GG[AT]CC)',
           'dna': None,
           'freq': 512,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGWCC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('A', 'G', 'J', 'K', 'M', 'N', 'R', 'S')},
 'AvaIII': {'charac': (None, None, None, None, 'ATGCAT'),
            'compsite': '(?P<AvaIII>ATGCAT)|(?P<AvaIII_as>ATGCAT)',
            'dna': None,
            'freq': 4096,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATGCAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'AviII': {'charac': (3, -3, None, None, 'TGCGCA'),
           'compsite': '(?P<AviII>TGCGCA)|(?P<AviII_as>TGCGCA)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGCGCA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'V')},
 'AvrII': {'charac': (1, -1, None, None, 'CCTAGG'),
           'compsite': '(?P<AvrII>CCTAGG)|(?P<AvrII_as>CCTAGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CTAG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCTAGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'AxyI': {'charac': (2, -2, None, None, 'CCTNAGG'),
          'compsite': '(?P<AxyI>CCT.AGG)|(?P<AxyI_as>CCT.AGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'TNA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTNAGG',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('J',)},
 'BaeI': {'charac': (-10, -26, 23, 7, 'ACNNNNGTAYC'),
          'compsite': '(?P<BaeI>AC....GTA[CT]C)|(?P<BaeI_as>G[AG]TAC....GT)',
          'dna': None,
          'freq': 8192,
          'fst3': -26,
          'fst5': -10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 7,
          'scd5': 23,
          'site': 'ACNNNNGTAYC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BalI': {'charac': (3, -3, None, None, 'TGGCCA'),
          'compsite': '(?P<BalI>TGGCCA)|(?P<BalI_as>TGGCCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGGCCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'J', 'K', 'R')},
 'BamHI': {'charac': (1, -1, None, None, 'GGATCC'),
           'compsite': '(?P<BamHI>GGATCC)|(?P<BamHI_as>GGATCC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGATCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'E',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'S',
                     'U',
                     'V',
                     'X')},
 'BanI': {'charac': (1, -1, None, None, 'GGYRCC'),
          'compsite': '(?P<BanI>GG[CT][AG]CC)|(?P<BanI_as>GG[CT][AG]CC)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GYRC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGYRCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('E', 'N', 'O', 'R', 'U', 'V')},
 'BanII': {'charac': (5, -5, None, None, 'GRGCYC'),
           'compsite': '(?P<BanII>G[AG]GC[CT]C)|(?P<BanII_as>G[AG]GC[CT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'RGCY',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GRGCYC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'G', 'K', 'M', 'N', 'O', 'Q', 'R', 'S', 'V', 'X')},
 'BanIII': {'charac': (2, -2, None, None, 'ATCGAT'),
            'compsite': '(?P<BanIII>ATCGAT)|(?P<BanIII_as>ATCGAT)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATCGAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('O',)},
 'BauI': {'charac': (1, -1, None, None, 'CACGAG'),
          'compsite': '(?P<BauI>CACGAG)|(?P<BauI_as>CTCGTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'ACGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BbeI': {'charac': (5, -5, None, None, 'GGCGCC'),
          'compsite': '(?P<BbeI>GGCGCC)|(?P<BbeI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'GCGC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'K')},
 'Bbr7I': {'charac': (13, 11, None, None, 'GAAGAC'),
           'compsite': '(?P<Bbr7I>GAAGAC)|(?P<Bbr7I_as>GTCTTC)',
           'dna': None,
           'freq': 4096,
           'fst3': 11,
           'fst5': 13,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAAGAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'BbrPI': {'charac': (3, -3, None, None, 'CACGTG'),
           'compsite': '(?P<BbrPI>CACGTG)|(?P<BbrPI_as>CACGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACGTG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'O')},
 'BbsI': {'charac': (8, 6, None, None, 'GAAGAC'),
          'compsite': '(?P<BbsI>GAAGAC)|(?P<BbsI_as>GTCTTC)',
          'dna': None,
          'freq': 4096,
          'fst3': 6,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAAGAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BbuI': {'charac': (5, -5, None, None, 'GCATGC'),
          'compsite': '(?P<BbuI>GCATGC)|(?P<BbuI_as>GCATGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCATGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('R',)},
 'Bbv12I': {'charac': (5, -5, None, None, 'GWGCWC'),
            'compsite': '(?P<Bbv12I>G[AT]GC[AT]C)|(?P<Bbv12I_as>G[AT]GC[AT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'WGCW',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GWGCWC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BbvCI': {'charac': (2, -2, None, None, 'CCTCAGC'),
           'compsite': '(?P<BbvCI>CCTCAGC)|(?P<BbvCI_as>GCTGAGG)',
           'dna': None,
           'freq': 16384,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'TCA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCTCAGC',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BbvI': {'charac': (13, 12, None, None, 'GCAGC'),
          'compsite': '(?P<BbvI>GCAGC)|(?P<BbvI_as>GCTGC)',
          'dna': None,
          'freq': 1024,
          'fst3': 12,
          'fst5': 13,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCAGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BbvII': {'charac': (8, 6, None, None, 'GAAGAC'),
           'compsite': '(?P<BbvII>GAAGAC)|(?P<BbvII_as>GTCTTC)',
           'dna': None,
           'freq': 4096,
           'fst3': 6,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAAGAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'BccI': {'charac': (9, 5, None, None, 'CCATC'),
          'compsite': '(?P<BccI>CCATC)|(?P<BccI_as>GATGG)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCATC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Bce83I': {'charac': (22, 14, None, None, 'CTTGAG'),
            'compsite': '(?P<Bce83I>CTTGAG)|(?P<Bce83I_as>CTCAAG)',
            'dna': None,
            'freq': 4096,
            'fst3': 14,
            'fst5': 22,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTTGAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'BceAI': {'charac': (17, 14, None, None, 'ACGGC'),
           'compsite': '(?P<BceAI>ACGGC)|(?P<BceAI_as>GCCGT)',
           'dna': None,
           'freq': 1024,
           'fst3': 14,
           'fst5': 17,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACGGC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BcefI': {'charac': (17, 13, None, None, 'ACGGC'),
           'compsite': '(?P<BcefI>ACGGC)|(?P<BcefI_as>GCCGT)',
           'dna': None,
           'freq': 1024,
           'fst3': 13,
           'fst5': 17,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACGGC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'BcgI': {'charac': (-10, -24, 24, 10, 'CGANNNNNNTGC'),
          'compsite': '(?P<BcgI>CGA......TGC)|(?P<BcgI_as>GCA......TCG)',
          'dna': None,
          'freq': 4096,
          'fst3': -24,
          'fst5': -10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': 10,
          'scd5': 24,
          'site': 'CGANNNNNNTGC',
          'size': 12,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BciVI': {'charac': (12, 5, None, None, 'GTATCC'),
           'compsite': '(?P<BciVI>GTATCC)|(?P<BciVI_as>GGATAC)',
           'dna': None,
           'freq': 4096,
           'fst3': 5,
           'fst5': 12,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTATCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BclI': {'charac': (1, -1, None, None, 'TGATCA'),
          'compsite': '(?P<BclI>TGATCA)|(?P<BclI_as>TGATCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGATCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('C',
                    'E',
                    'F',
                    'G',
                    'J',
                    'M',
                    'N',
                    'O',
                    'R',
                    'S',
                    'U',
                    'V')},
 'BcnI': {'charac': (2, -2, None, None, 'CCSGG'),
          'compsite': '(?P<BcnI>CC[CG]GG)|(?P<BcnI_as>CC[CG]GG)',
          'dna': None,
          'freq': 512,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'S',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCSGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F', 'K')},
 'BcuI': {'charac': (1, -1, None, None, 'ACTAGT'),
          'compsite': '(?P<BcuI>ACTAGT)|(?P<BcuI_as>ACTAGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTAGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BetI': {'charac': (1, -1, None, None, 'WCCGGW'),
          'compsite': '(?P<BetI>[AT]CCGG[AT])|(?P<BetI_as>[AT]CCGG[AT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'WCCGGW',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'BfaI': {'charac': (1, -1, None, None, 'CTAG'),
          'compsite': '(?P<BfaI>CTAG)|(?P<BfaI_as>CTAG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTAG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BfiI': {'charac': (11, 4, None, None, 'ACTGGG'),
          'compsite': '(?P<BfiI>ACTGGG)|(?P<BfiI_as>CCCAGT)',
          'dna': None,
          'freq': 4096,
          'fst3': 4,
          'fst5': 11,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTGGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BfmI': {'charac': (1, -1, None, None, 'CTRYAG'),
          'compsite': '(?P<BfmI>CT[AG][CT]AG)|(?P<BfmI_as>CT[AG][CT]AG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TRYA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTRYAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BfrBI': {'charac': (3, -3, None, None, 'ATGCAT'),
           'compsite': '(?P<BfrBI>ATGCAT)|(?P<BfrBI_as>ATGCAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATGCAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BfrI': {'charac': (1, -1, None, None, 'CTTAAG'),
          'compsite': '(?P<BfrI>CTTAAG)|(?P<BfrI_as>CTTAAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TTAA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTTAAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M', 'O')},
 'BfuAI': {'charac': (10, 8, None, None, 'ACCTGC'),
           'compsite': '(?P<BfuAI>ACCTGC)|(?P<BfuAI_as>GCAGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': 8,
           'fst5': 10,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCTGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BfuCI': {'charac': (0, 0, None, None, 'GATC'),
           'compsite': '(?P<BfuCI>GATC)|(?P<BfuCI_as>GATC)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BfuI': {'charac': (12, 5, None, None, 'GTATCC'),
          'compsite': '(?P<BfuI>GTATCC)|(?P<BfuI_as>GGATAC)',
          'dna': None,
          'freq': 4096,
          'fst3': 5,
          'fst5': 12,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTATCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BglI': {'charac': (7, -7, None, None, 'GCCNNNNNGGC'),
          'compsite': '(?P<BglI>GCC.....GGC)|(?P<BglI_as>GCC.....GGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -7,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCCNNNNNGGC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'BglII': {'charac': (1, -1, None, None, 'AGATCT'),
           'compsite': '(?P<BglII>AGATCT)|(?P<BglII_as>AGATCT)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'AGATCT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'E',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'S',
                     'U',
                     'X')},
 'BinI': {'charac': (9, 5, None, None, 'GGATC'),
          'compsite': '(?P<BinI>GGATC)|(?P<BinI_as>GATCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGATC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'BlfI': {'charac': (1, -1, None, None, 'TCCGGA'),
          'compsite': '(?P<BlfI>TCCGGA)|(?P<BlfI_as>TCCGGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCCGGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'BlnI': {'charac': (1, -1, None, None, 'CCTAGG'),
          'compsite': '(?P<BlnI>CCTAGG)|(?P<BlnI_as>CCTAGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTAGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'K', 'M', 'S')},
 'BlpI': {'charac': (2, -2, None, None, 'GCTNAGC'),
          'compsite': '(?P<BlpI>GCT.AGC)|(?P<BlpI_as>GCT.AGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'TNA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCTNAGC',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Bme1390I': {'charac': (2, -2, None, None, 'CCNGG'),
              'compsite': '(?P<Bme1390I>CC.GG)|(?P<Bme1390I_as>CC.GG)',
              'dna': None,
              'freq': 256,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -1,
              'ovhgseq': 'N',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CCNGG',
              'size': 5,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'Bme1580I': {'charac': (5, -5, None, None, 'GKGCMC'),
              'compsite': '(?P<Bme1580I>G[GT]GC[AC]C)|(?P<Bme1580I_as>G[GT]GC[AC]C)',
              'dna': None,
              'freq': 1024,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'KGCM',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GKGCMC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('N',)},
 'Bme18I': {'charac': (1, -1, None, None, 'GGWCC'),
            'compsite': '(?P<Bme18I>GG[AT]CC)|(?P<Bme18I_as>GG[AT]CC)',
            'dna': None,
            'freq': 512,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GWC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGWCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BmgBI': {'charac': (3, -3, None, None, 'CACGTC'),
           'compsite': '(?P<BmgBI>CACGTC)|(?P<BmgBI_as>GACGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACGTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BmgI': {'charac': (None, None, None, None, 'GKGCCC'),
          'compsite': '(?P<BmgI>G[GT]GCCC)|(?P<BmgI_as>GGGC[AC]C)',
          'dna': None,
          'freq': 2048,
          'fst3': None,
          'fst5': None,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': None,
          'ovhgseq': None,
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GKGCCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'BmrI': {'charac': (11, 4, None, None, 'ACTGGG'),
          'compsite': '(?P<BmrI>ACTGGG)|(?P<BmrI_as>CCCAGT)',
          'dna': None,
          'freq': 4096,
          'fst3': 4,
          'fst5': 11,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTGGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BmtI': {'charac': (5, -5, None, None, 'GCTAGC'),
          'compsite': '(?P<BmtI>GCTAGC)|(?P<BmtI_as>GCTAGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCTAGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'BmyI': {'charac': (5, -5, None, None, 'GDGCHC'),
          'compsite': '(?P<BmyI>G[AGT]GC[ACT]C)|(?P<BmyI_as>G[AGT]GC[ACT]C)',
          'dna': None,
          'freq': 256,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'DGCH',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GDGCHC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'BoxI': {'charac': (5, -5, None, None, 'GACNNNNGTC'),
          'compsite': '(?P<BoxI>GAC....GTC)|(?P<BoxI_as>GAC....GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNNGTC',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BpcI': {'charac': (1, -1, None, None, 'CTRYAG'),
          'compsite': '(?P<BpcI>CT[AG][CT]AG)|(?P<BpcI_as>CT[AG][CT]AG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TRYA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTRYAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'BpiI': {'charac': (8, 6, None, None, 'GAAGAC'),
          'compsite': '(?P<BpiI>GAAGAC)|(?P<BpiI_as>GTCTTC)',
          'dna': None,
          'freq': 4096,
          'fst3': 6,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAAGAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BplI': {'charac': (-8, -24, 24, 8, 'GAGNNNNNCTC'),
          'compsite': '(?P<BplI>GAG.....CTC)|(?P<BplI_as>GAG.....CTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -24,
          'fst5': -8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 8,
          'scd5': 24,
          'site': 'GAGNNNNNCTC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'BpmI': {'charac': (22, 14, None, None, 'CTGGAG'),
          'compsite': '(?P<BpmI>CTGGAG)|(?P<BpmI_as>CTCCAG)',
          'dna': None,
          'freq': 4096,
          'fst3': 14,
          'fst5': 22,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTGGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'BptI': {'charac': (2, -2, None, None, 'CCWGG'),
          'compsite': '(?P<BptI>CC[AT]GG)|(?P<BptI_as>CC[AT]GG)',
          'dna': None,
          'freq': 512,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'W',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCWGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'Bpu10I': {'charac': (2, -2, None, None, 'CCTNAGC'),
            'compsite': '(?P<Bpu10I>CCT.AGC)|(?P<Bpu10I_as>GCT.AGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'TNA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTNAGC',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('F', 'I', 'N')},
 'Bpu1102I': {'charac': (2, -2, None, None, 'GCTNAGC'),
              'compsite': '(?P<Bpu1102I>GCT.AGC)|(?P<Bpu1102I_as>GCT.AGC)',
              'dna': None,
              'freq': 4096,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'TNA',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GCTNAGC',
              'size': 7,
              'substrat': 'DNA',
              'suppl': ('A', 'E', 'F', 'K')},
 'Bpu14I': {'charac': (2, -2, None, None, 'TTCGAA'),
            'compsite': '(?P<Bpu14I>TTCGAA)|(?P<Bpu14I_as>TTCGAA)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TTCGAA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BpuAI': {'charac': (8, 6, None, None, 'GAAGAC'),
           'compsite': '(?P<BpuAI>GAAGAC)|(?P<BpuAI_as>GTCTTC)',
           'dna': None,
           'freq': 4096,
           'fst3': 6,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAAGAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'BpuEI': {'charac': (22, 14, None, None, 'CTTGAG'),
           'compsite': '(?P<BpuEI>CTTGAG)|(?P<BpuEI_as>CTCAAG)',
           'dna': None,
           'freq': 4096,
           'fst3': 14,
           'fst5': 22,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTTGAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'Bsa29I': {'charac': (2, -2, None, None, 'ATCGAT'),
            'compsite': '(?P<Bsa29I>ATCGAT)|(?P<Bsa29I_as>ATCGAT)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATCGAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BsaAI': {'charac': (3, -3, None, None, 'YACGTR'),
           'compsite': '(?P<BsaAI>[CT]ACGT[AG])|(?P<BsaAI_as>[CT]ACGT[AG])',
           'dna': None,
           'freq': 1024,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'YACGTR',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsaBI': {'charac': (5, -5, None, None, 'GATNNNNATC'),
           'compsite': '(?P<BsaBI>GAT....ATC)|(?P<BsaBI_as>GAT....ATC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATNNNNATC',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsaHI': {'charac': (2, -2, None, None, 'GRCGYC'),
           'compsite': '(?P<BsaHI>G[AG]CG[CT]C)|(?P<BsaHI_as>G[AG]CG[CT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GRCGYC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsaI': {'charac': (7, 5, None, None, 'GGTCTC'),
          'compsite': '(?P<BsaI>GGTCTC)|(?P<BsaI_as>GAGACC)',
          'dna': None,
          'freq': 4096,
          'fst3': 5,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGTCTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BsaJI': {'charac': (1, -1, None, None, 'CCNNGG'),
           'compsite': '(?P<BsaJI>CC..GG)|(?P<BsaJI_as>CC..GG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CNNG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNNGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsaMI': {'charac': (7, -1, None, None, 'GAATGC'),
           'compsite': '(?P<BsaMI>GAATGC)|(?P<BsaMI_as>GCATTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'CN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAATGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('G', 'R')},
 'BsaWI': {'charac': (1, -1, None, None, 'WCCGGW'),
           'compsite': '(?P<BsaWI>[AT]CCGG[AT])|(?P<BsaWI_as>[AT]CCGG[AT])',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'WCCGGW',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsaXI': {'charac': (-9, -23, 21, 7, 'ACNNNNNCTCC'),
           'compsite': '(?P<BsaXI>AC.....CTCC)|(?P<BsaXI_as>GGAG.....GT)',
           'dna': None,
           'freq': 4096,
           'fst3': -23,
           'fst5': -9,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': 7,
           'scd5': 21,
           'site': 'ACNNNNNCTCC',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsbI': {'charac': (None, None, None, None, 'CAACAC'),
          'compsite': '(?P<BsbI>CAACAC)|(?P<BsbI_as>GTGTTG)',
          'dna': None,
          'freq': 4096,
          'fst3': None,
          'fst5': None,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': None,
          'ovhgseq': None,
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CAACAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'Bsc4I': {'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
           'compsite': '(?P<Bsc4I>CC.......GG)|(?P<Bsc4I_as>CC.......GG)',
           'dna': None,
           'freq': 256,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNNNNNNNGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'BscAI': {'charac': (9, 6, None, None, 'GCATC'),
           'compsite': '(?P<BscAI>GCATC)|(?P<BscAI_as>GATGC)',
           'dna': None,
           'freq': 1024,
           'fst3': 6,
           'fst5': 9,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCATC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'BscGI': {'charac': (None, None, None, None, 'CCCGT'),
           'compsite': '(?P<BscGI>CCCGT)|(?P<BscGI_as>ACGGG)',
           'dna': None,
           'freq': 1024,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCGT',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'Bse118I': {'charac': (1, -1, None, None, 'RCCGGY'),
             'compsite': '(?P<Bse118I>[AG]CCGG[CT])|(?P<Bse118I_as>[AG]CCGG[CT])',
             'dna': None,
             'freq': 1024,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'CCGG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'RCCGGY',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I',)},
 'Bse1I': {'charac': (6, -1, None, None, 'ACTGG'),
           'compsite': '(?P<Bse1I>ACTGG)|(?P<Bse1I_as>CCAGT)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'GN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACTGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'Bse21I': {'charac': (2, -2, None, None, 'CCTNAGG'),
            'compsite': '(?P<Bse21I>CCT.AGG)|(?P<Bse21I_as>CCT.AGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'TNA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTNAGG',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bse3DI': {'charac': (8, 0, None, None, 'GCAATG'),
            'compsite': '(?P<Bse3DI>GCAATG)|(?P<Bse3DI_as>CATTGC)',
            'dna': None,
            'freq': 4096,
            'fst3': 0,
            'fst5': 8,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCAATG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bse8I': {'charac': (5, -5, None, None, 'GATNNNNATC'),
           'compsite': '(?P<Bse8I>GAT....ATC)|(?P<Bse8I_as>GAT....ATC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATNNNNATC',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'BseAI': {'charac': (1, -1, None, None, 'TCCGGA'),
           'compsite': '(?P<BseAI>TCCGGA)|(?P<BseAI_as>TCCGGA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TCCGGA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C', 'M')},
 'BseBI': {'charac': (2, -2, None, None, 'CCWGG'),
           'compsite': '(?P<BseBI>CC[AT]GG)|(?P<BseBI_as>CC[AT]GG)',
           'dna': None,
           'freq': 512,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'W',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCWGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'BseCI': {'charac': (2, -2, None, None, 'ATCGAT'),
           'compsite': '(?P<BseCI>ATCGAT)|(?P<BseCI_as>ATCGAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATCGAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'BseDI': {'charac': (1, -1, None, None, 'CCNNGG'),
           'compsite': '(?P<BseDI>CC..GG)|(?P<BseDI_as>CC..GG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CNNG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNNGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseGI': {'charac': (7, 0, None, None, 'GGATG'),
           'compsite': '(?P<BseGI>GGATG)|(?P<BseGI_as>CATCC)',
           'dna': None,
           'freq': 1024,
           'fst3': 0,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGATG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseJI': {'charac': (5, -5, None, None, 'GATNNNNATC'),
           'compsite': '(?P<BseJI>GAT....ATC)|(?P<BseJI_as>GAT....ATC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATNNNNATC',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseLI': {'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
           'compsite': '(?P<BseLI>CC.......GG)|(?P<BseLI_as>CC.......GG)',
           'dna': None,
           'freq': 256,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNNNNNNNGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseMI': {'charac': (8, 0, None, None, 'GCAATG'),
           'compsite': '(?P<BseMI>GCAATG)|(?P<BseMI_as>CATTGC)',
           'dna': None,
           'freq': 4096,
           'fst3': 0,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCAATG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseMII': {'charac': (15, 8, None, None, 'CTCAG'),
            'compsite': '(?P<BseMII>CTCAG)|(?P<BseMII_as>CTGAG)',
            'dna': None,
            'freq': 1024,
            'fst3': 8,
            'fst5': 15,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTCAG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'BseNI': {'charac': (6, -1, None, None, 'ACTGG'),
           'compsite': '(?P<BseNI>ACTGG)|(?P<BseNI_as>CCAGT)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'GN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACTGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('F', 'G')},
 'BsePI': {'charac': (1, -1, None, None, 'GCGCGC'),
           'compsite': '(?P<BsePI>GCGCGC)|(?P<BsePI_as>GCGCGC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CGCG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGCGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'BseRI': {'charac': (16, 8, None, None, 'GAGGAG'),
           'compsite': '(?P<BseRI>GAGGAG)|(?P<BseRI_as>CTCCTC)',
           'dna': None,
           'freq': 4096,
           'fst3': 8,
           'fst5': 16,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAGGAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BseSI': {'charac': (5, -5, None, None, 'GKGCMC'),
           'compsite': '(?P<BseSI>G[GT]GC[AC]C)|(?P<BseSI_as>G[GT]GC[AC]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'KGCM',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GKGCMC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseX3I': {'charac': (1, -1, None, None, 'CGGCCG'),
            'compsite': '(?P<BseX3I>CGGCCG)|(?P<BseX3I_as>CGGCCG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GGCC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGGCCG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BseXI': {'charac': (13, 12, None, None, 'GCAGC'),
           'compsite': '(?P<BseXI>GCAGC)|(?P<BseXI_as>GCTGC)',
           'dna': None,
           'freq': 1024,
           'fst3': 12,
           'fst5': 13,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCAGC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BseYI': {'charac': (1, -1, None, None, 'CCCAGC'),
           'compsite': '(?P<BseYI>CCCAGC)|(?P<BseYI_as>GCTGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCAG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCAGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsgI': {'charac': (22, 14, None, None, 'GTGCAG'),
          'compsite': '(?P<BsgI>GTGCAG)|(?P<BsgI_as>CTGCAC)',
          'dna': None,
          'freq': 4096,
          'fst3': 14,
          'fst5': 22,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTGCAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Bsh1236I': {'charac': (2, -2, None, None, 'CGCG'),
              'compsite': '(?P<Bsh1236I>CGCG)|(?P<Bsh1236I_as>CGCG)',
              'dna': None,
              'freq': 256,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 0,
              'ovhgseq': '',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CGCG',
              'size': 4,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'Bsh1285I': {'charac': (4, -4, None, None, 'CGRYCG'),
              'compsite': '(?P<Bsh1285I>CG[AG][CT]CG)|(?P<Bsh1285I_as>CG[AG][CT]CG)',
              'dna': None,
              'freq': 1024,
              'fst3': -4,
              'fst5': 4,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 2,
              'ovhgseq': 'RY',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CGRYCG',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'BshFI': {'charac': (2, -2, None, None, 'GGCC'),
           'compsite': '(?P<BshFI>GGCC)|(?P<BshFI_as>GGCC)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGCC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'BshNI': {'charac': (1, -1, None, None, 'GGYRCC'),
           'compsite': '(?P<BshNI>GG[CT][AG]CC)|(?P<BshNI_as>GG[CT][AG]CC)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GYRC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGYRCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BshTI': {'charac': (1, -1, None, None, 'ACCGGT'),
           'compsite': '(?P<BshTI>ACCGGT)|(?P<BshTI_as>ACCGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCGGT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BsiEI': {'charac': (4, -4, None, None, 'CGRYCG'),
           'compsite': '(?P<BsiEI>CG[AG][CT]CG)|(?P<BsiEI_as>CG[AG][CT]CG)',
           'dna': None,
           'freq': 1024,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'RY',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGRYCG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsiHKAI': {'charac': (5, -5, None, None, 'GWGCWC'),
             'compsite': '(?P<BsiHKAI>G[AT]GC[AT]C)|(?P<BsiHKAI_as>G[AT]GC[AT]C)',
             'dna': None,
             'freq': 1024,
             'fst3': -5,
             'fst5': 5,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 4,
             'ovhgseq': 'WGCW',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GWGCWC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('N',)},
 'BsiHKCI': {'charac': (1, -1, None, None, 'CYCGRG'),
             'compsite': '(?P<BsiHKCI>C[CT]CG[AG]G)|(?P<BsiHKCI_as>C[CT]CG[AG]G)',
             'dna': None,
             'freq': 1024,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'YCGR',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CYCGRG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('Q', 'X')},
 'BsiI': {'charac': (1, -1, None, None, 'CACGAG'),
          'compsite': '(?P<BsiI>CACGAG)|(?P<BsiI_as>CTCGTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'ACGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'BsiSI': {'charac': (1, -1, None, None, 'CCGG'),
           'compsite': '(?P<BsiSI>CCGG)|(?P<BsiSI_as>CCGG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'BsiWI': {'charac': (1, -1, None, None, 'CGTACG'),
           'compsite': '(?P<BsiWI>CGTACG)|(?P<BsiWI_as>CGTACG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GTAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGTACG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'N', 'O')},
 'BsiYI': {'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
           'compsite': '(?P<BsiYI>CC.......GG)|(?P<BsiYI_as>CC.......GG)',
           'dna': None,
           'freq': 256,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNNNNNNNGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'BslFI': {'charac': (15, 14, 15, 14, 'GGGAC'),
           'compsite': '(?P<BslFI>GGGAC)|(?P<BslFI_as>GTCCC)',
           'dna': None,
           'freq': 1024,
           'fst3': 14,
           'fst5': 15,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': 14,
           'scd5': 15,
           'site': 'GGGAC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'BslI': {'charac': (7, -7, None, None, 'CCNNNNNNNGG'),
          'compsite': '(?P<BslI>CC.......GG)|(?P<BslI_as>CC.......GG)',
          'dna': None,
          'freq': 256,
          'fst3': -7,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCNNNNNNNGG',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('G', 'N')},
 'BsmAI': {'charac': (6, 5, None, None, 'GTCTC'),
           'compsite': '(?P<BsmAI>GTCTC)|(?P<BsmAI_as>GAGAC)',
           'dna': None,
           'freq': 1024,
           'fst3': 5,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTCTC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsmBI': {'charac': (7, 5, None, None, 'CGTCTC'),
           'compsite': '(?P<BsmBI>CGTCTC)|(?P<BsmBI_as>GAGACG)',
           'dna': None,
           'freq': 4096,
           'fst3': 5,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGTCTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsmFI': {'charac': (15, 14, None, None, 'GGGAC'),
           'compsite': '(?P<BsmFI>GGGAC)|(?P<BsmFI_as>GTCCC)',
           'dna': None,
           'freq': 1024,
           'fst3': 14,
           'fst5': 15,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGGAC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsmI': {'charac': (7, -1, None, None, 'GAATGC'),
          'compsite': '(?P<BsmI>GAATGC)|(?P<BsmI_as>GCATTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'CN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAATGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('J', 'M', 'N', 'O', 'S', 'V')},
 'Bso31I': {'charac': (7, 5, None, None, 'GGTCTC'),
            'compsite': '(?P<Bso31I>GGTCTC)|(?P<Bso31I_as>GAGACC)',
            'dna': None,
            'freq': 4096,
            'fst3': 5,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTCTC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BsoBI': {'charac': (1, -1, None, None, 'CYCGRG'),
           'compsite': '(?P<BsoBI>C[CT]CG[AG]G)|(?P<BsoBI_as>C[CT]CG[AG]G)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'YCGR',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CYCGRG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsoMAI': {'charac': (6, 5, None, None, 'GTCTC'),
            'compsite': '(?P<BsoMAI>GTCTC)|(?P<BsoMAI_as>GAGAC)',
            'dna': None,
            'freq': 1024,
            'fst3': 5,
            'fst5': 6,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTCTC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bsp106I': {'charac': (2, -2, None, None, 'ATCGAT'),
             'compsite': '(?P<Bsp106I>ATCGAT)|(?P<Bsp106I_as>ATCGAT)',
             'dna': None,
             'freq': 4096,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -2,
             'ovhgseq': 'CG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'ATCGAT',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('E',)},
 'Bsp119I': {'charac': (2, -2, None, None, 'TTCGAA'),
             'compsite': '(?P<Bsp119I>TTCGAA)|(?P<Bsp119I_as>TTCGAA)',
             'dna': None,
             'freq': 4096,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -2,
             'ovhgseq': 'CG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'TTCGAA',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'Bsp120I': {'charac': (1, -1, None, None, 'GGGCCC'),
             'compsite': '(?P<Bsp120I>GGGCCC)|(?P<Bsp120I_as>GGGCCC)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'GGCC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GGGCCC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F', 'G')},
 'Bsp1286I': {'charac': (5, -5, None, None, 'GDGCHC'),
              'compsite': '(?P<Bsp1286I>G[AGT]GC[ACT]C)|(?P<Bsp1286I_as>G[AGT]GC[ACT]C)',
              'dna': None,
              'freq': 256,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'DGCH',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GDGCHC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('A', 'J', 'K', 'N', 'R')},
 'Bsp13I': {'charac': (1, -1, None, None, 'TCCGGA'),
            'compsite': '(?P<Bsp13I>TCCGGA)|(?P<Bsp13I_as>TCCGGA)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CCGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TCCGGA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bsp1407I': {'charac': (1, -1, None, None, 'TGTACA'),
              'compsite': '(?P<Bsp1407I>TGTACA)|(?P<Bsp1407I_as>TGTACA)',
              'dna': None,
              'freq': 4096,
              'fst3': -1,
              'fst5': 1,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -4,
              'ovhgseq': 'GTAC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'TGTACA',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F', 'K')},
 'Bsp143I': {'charac': (0, 0, None, None, 'GATC'),
             'compsite': '(?P<Bsp143I>GATC)|(?P<Bsp143I_as>GATC)',
             'dna': None,
             'freq': 256,
             'fst3': 0,
             'fst5': 0,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'GATC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GATC',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'Bsp143II': {'charac': (5, -5, None, None, 'RGCGCY'),
              'compsite': '(?P<Bsp143II>[AG]GCGC[CT])|(?P<Bsp143II_as>[AG]GCGC[CT])',
              'dna': None,
              'freq': 1024,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'GCGC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'RGCGCY',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'Bsp1720I': {'charac': (2, -2, None, None, 'GCTNAGC'),
              'compsite': '(?P<Bsp1720I>GCT.AGC)|(?P<Bsp1720I_as>GCT.AGC)',
              'dna': None,
              'freq': 4096,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'TNA',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GCTNAGC',
              'size': 7,
              'substrat': 'DNA',
              'suppl': ('I',)},
 'Bsp19I': {'charac': (1, -1, None, None, 'CCATGG'),
            'compsite': '(?P<Bsp19I>CCATGG)|(?P<Bsp19I_as>CCATGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CATG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCATGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bsp24I': {'charac': (-8, -25, 24, 7, 'GACNNNNNNTGG'),
            'compsite': '(?P<Bsp24I>GAC......TGG)|(?P<Bsp24I_as>CCA......GTC)',
            'dna': None,
            'freq': 4096,
            'fst3': -25,
            'fst5': -8,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 5,
            'ovhgseq': 'NNNNN',
            'results': None,
            'scd3': 7,
            'scd5': 24,
            'site': 'GACNNNNNNTGG',
            'size': 12,
            'substrat': 'DNA',
            'suppl': ()},
 'Bsp68I': {'charac': (3, -3, None, None, 'TCGCGA'),
            'compsite': '(?P<Bsp68I>TCGCGA)|(?P<Bsp68I_as>TCGCGA)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TCGCGA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'BspANI': {'charac': (2, -2, None, None, 'GGCC'),
            'compsite': '(?P<BspANI>GGCC)|(?P<BspANI_as>GGCC)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGCC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'BspCI': {'charac': (4, -4, None, None, 'CGATCG'),
           'compsite': '(?P<BspCI>CGATCG)|(?P<BspCI_as>CGATCG)',
           'dna': None,
           'freq': 4096,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'AT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGATCG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('E',)},
 'BspCNI': {'charac': (14, 7, None, None, 'CTCAG'),
            'compsite': '(?P<BspCNI>CTCAG)|(?P<BspCNI_as>CTGAG)',
            'dna': None,
            'freq': 1024,
            'fst3': 7,
            'fst5': 14,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTCAG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'BspDI': {'charac': (2, -2, None, None, 'ATCGAT'),
           'compsite': '(?P<BspDI>ATCGAT)|(?P<BspDI_as>ATCGAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATCGAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BspEI': {'charac': (1, -1, None, None, 'TCCGGA'),
           'compsite': '(?P<BspEI>TCCGGA)|(?P<BspEI_as>TCCGGA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TCCGGA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BspGI': {'charac': (None, None, None, None, 'CTGGAC'),
           'compsite': '(?P<BspGI>CTGGAC)|(?P<BspGI_as>GTCCAG)',
           'dna': None,
           'freq': 4096,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTGGAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'BspHI': {'charac': (1, -1, None, None, 'TCATGA'),
           'compsite': '(?P<BspHI>TCATGA)|(?P<BspHI_as>TCATGA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CATG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TCATGA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BspLI': {'charac': (3, -3, None, None, 'GGNNCC'),
           'compsite': '(?P<BspLI>GG..CC)|(?P<BspLI_as>GG..CC)',
           'dna': None,
           'freq': 256,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGNNCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BspLU11I': {'charac': (1, -1, None, None, 'ACATGT'),
              'compsite': '(?P<BspLU11I>ACATGT)|(?P<BspLU11I_as>ACATGT)',
              'dna': None,
              'freq': 4096,
              'fst3': -1,
              'fst5': 1,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -4,
              'ovhgseq': 'CATG',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'ACATGT',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('M',)},
 'BspMAI': {'charac': (5, -5, None, None, 'CTGCAG'),
            'compsite': '(?P<BspMAI>CTGCAG)|(?P<BspMAI_as>CTGCAG)',
            'dna': None,
            'freq': 4096,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'TGCA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTGCAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'BspMI': {'charac': (10, 8, None, None, 'ACCTGC'),
           'compsite': '(?P<BspMI>ACCTGC)|(?P<BspMI_as>GCAGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': 8,
           'fst5': 10,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCTGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BspMII': {'charac': (1, -1, None, None, 'TCCGGA'),
            'compsite': '(?P<BspMII>TCCGGA)|(?P<BspMII_as>TCCGGA)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CCGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TCCGGA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'BspNCI': {'charac': (None, None, None, None, 'CCAGA'),
            'compsite': '(?P<BspNCI>CCAGA)|(?P<BspNCI_as>TCTGG)',
            'dna': None,
            'freq': 1024,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCAGA',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'BspPI': {'charac': (9, 5, None, None, 'GGATC'),
           'compsite': '(?P<BspPI>GGATC)|(?P<BspPI_as>GATCC)',
           'dna': None,
           'freq': 1024,
           'fst3': 5,
           'fst5': 9,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGATC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BspT104I': {'charac': (2, -2, None, None, 'TTCGAA'),
              'compsite': '(?P<BspT104I>TTCGAA)|(?P<BspT104I_as>TTCGAA)',
              'dna': None,
              'freq': 4096,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -2,
              'ovhgseq': 'CG',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'TTCGAA',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('K',)},
 'BspT107I': {'charac': (1, -1, None, None, 'GGYRCC'),
              'compsite': '(?P<BspT107I>GG[CT][AG]CC)|(?P<BspT107I_as>GG[CT][AG]CC)',
              'dna': None,
              'freq': 1024,
              'fst3': -1,
              'fst5': 1,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -4,
              'ovhgseq': 'GYRC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GGYRCC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('K',)},
 'BspTI': {'charac': (1, -1, None, None, 'CTTAAG'),
           'compsite': '(?P<BspTI>CTTAAG)|(?P<BspTI_as>CTTAAG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TTAA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTTAAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'BspTNI': {'charac': (7, 5, None, None, 'GGTCTC'),
            'compsite': '(?P<BspTNI>GGTCTC)|(?P<BspTNI_as>GAGACC)',
            'dna': None,
            'freq': 4096,
            'fst3': 5,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTCTC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'BspXI': {'charac': (2, -2, None, None, 'ATCGAT'),
           'compsite': '(?P<BspXI>ATCGAT)|(?P<BspXI_as>ATCGAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATCGAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('G',)},
 'BsrBI': {'charac': (3, -3, None, None, 'CCGCTC'),
           'compsite': '(?P<BsrBI>CCGCTC)|(?P<BsrBI_as>GAGCGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGCTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsrDI': {'charac': (8, 0, None, None, 'GCAATG'),
           'compsite': '(?P<BsrDI>GCAATG)|(?P<BsrDI_as>CATTGC)',
           'dna': None,
           'freq': 4096,
           'fst3': 0,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCAATG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsrFI': {'charac': (1, -1, None, None, 'RCCGGY'),
           'compsite': '(?P<BsrFI>[AG]CCGG[CT])|(?P<BsrFI_as>[AG]CCGG[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RCCGGY',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsrGI': {'charac': (1, -1, None, None, 'TGTACA'),
           'compsite': '(?P<BsrGI>TGTACA)|(?P<BsrGI_as>TGTACA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GTAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGTACA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BsrI': {'charac': (6, -1, None, None, 'ACTGG'),
          'compsite': '(?P<BsrI>ACTGG)|(?P<BsrI_as>CCAGT)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'GN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BsrSI': {'charac': (6, -1, None, None, 'ACTGG'),
           'compsite': '(?P<BsrSI>ACTGG)|(?P<BsrSI_as>CCAGT)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 6,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'GN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACTGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('R',)},
 'BssAI': {'charac': (1, -1, None, None, 'RCCGGY'),
           'compsite': '(?P<BssAI>[AG]CCGG[CT])|(?P<BssAI_as>[AG]CCGG[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RCCGGY',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'BssECI': {'charac': (1, -1, None, None, 'CCNNGG'),
            'compsite': '(?P<BssECI>CC..GG)|(?P<BssECI_as>CC..GG)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CNNG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCNNGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BssHI': {'charac': (1, -1, None, None, 'CTCGAG'),
           'compsite': '(?P<BssHI>CTCGAG)|(?P<BssHI_as>CTCGAG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TCGA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTCGAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('V',)},
 'BssHII': {'charac': (1, -1, None, None, 'GCGCGC'),
            'compsite': '(?P<BssHII>GCGCGC)|(?P<BssHII_as>GCGCGC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CGCG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCGCGC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('A',
                      'E',
                      'J',
                      'K',
                      'M',
                      'N',
                      'O',
                      'Q',
                      'R',
                      'S',
                      'V',
                      'X')},
 'BssKI': {'charac': (0, 0, None, None, 'CCNGG'),
           'compsite': '(?P<BssKI>CC.GG)|(?P<BssKI_as>CC.GG)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'CCNGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BssNAI': {'charac': (3, -3, None, None, 'GTATAC'),
            'compsite': '(?P<BssNAI>GTATAC)|(?P<BssNAI_as>GTATAC)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTATAC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BssSI': {'charac': (1, -1, None, None, 'CACGAG'),
           'compsite': '(?P<BssSI>CACGAG)|(?P<BssSI_as>CTCGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'ACGA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACGAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BssT1I': {'charac': (1, -1, None, None, 'CCWWGG'),
            'compsite': '(?P<BssT1I>CC[AT][AT]GG)|(?P<BssT1I_as>CC[AT][AT]GG)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CWWG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCWWGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bst1107I': {'charac': (3, -3, None, None, 'GTATAC'),
              'compsite': '(?P<Bst1107I>GTATAC)|(?P<Bst1107I_as>GTATAC)',
              'dna': None,
              'freq': 4096,
              'fst3': -3,
              'fst5': 3,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 0,
              'ovhgseq': '',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GTATAC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F', 'K', 'M')},
 'Bst2BI': {'charac': (1, -1, None, None, 'CACGAG'),
            'compsite': '(?P<Bst2BI>CACGAG)|(?P<Bst2BI_as>CTCGTG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'ACGA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CACGAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bst2UI': {'charac': (2, -2, None, None, 'CCWGG'),
            'compsite': '(?P<Bst2UI>CC[AT]GG)|(?P<Bst2UI_as>CC[AT]GG)',
            'dna': None,
            'freq': 512,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'W',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCWGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bst4CI': {'charac': (3, -3, None, None, 'ACNGT'),
            'compsite': '(?P<Bst4CI>AC.GT)|(?P<Bst4CI_as>AC.GT)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACNGT',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Bst6I': {'charac': (7, 4, None, None, 'CTCTTC'),
           'compsite': '(?P<Bst6I>CTCTTC)|(?P<Bst6I_as>GAAGAG)',
           'dna': None,
           'freq': 4096,
           'fst3': 4,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTCTTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'Bst98I': {'charac': (1, -1, None, None, 'CTTAAG'),
            'compsite': '(?P<Bst98I>CTTAAG)|(?P<Bst98I_as>CTTAAG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'TTAA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTTAAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('R',)},
 'BstACI': {'charac': (2, -2, None, None, 'GRCGYC'),
            'compsite': '(?P<BstACI>G[AG]CG[CT]C)|(?P<BstACI_as>G[AG]CG[CT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GRCGYC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstAPI': {'charac': (7, -7, None, None, 'GCANNNNNTGC'),
            'compsite': '(?P<BstAPI>GCA.....TGC)|(?P<BstAPI_as>GCA.....TGC)',
            'dna': None,
            'freq': 4096,
            'fst3': -7,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'NNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCANNNNNTGC',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('I', 'N')},
 'BstAUI': {'charac': (1, -1, None, None, 'TGTACA'),
            'compsite': '(?P<BstAUI>TGTACA)|(?P<BstAUI_as>TGTACA)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GTAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TGTACA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstBAI': {'charac': (3, -3, None, None, 'YACGTR'),
            'compsite': '(?P<BstBAI>[CT]ACGT[AG])|(?P<BstBAI_as>[CT]ACGT[AG])',
            'dna': None,
            'freq': 1024,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'YACGTR',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstBI': {'charac': (2, -2, None, None, 'TTCGAA'),
           'compsite': '(?P<BstBI>TTCGAA)|(?P<BstBI_as>TTCGAA)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TTCGAA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BstC8I': {'charac': (3, -3, None, None, 'GCNNGC'),
            'compsite': '(?P<BstC8I>GC..GC)|(?P<BstC8I_as>GC..GC)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCNNGC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstDEI': {'charac': (1, -1, None, None, 'CTNAG'),
            'compsite': '(?P<BstDEI>CT.AG)|(?P<BstDEI_as>CT.AG)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'TNA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTNAG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstDSI': {'charac': (1, -1, None, None, 'CCRYGG'),
            'compsite': '(?P<BstDSI>CC[AG][CT]GG)|(?P<BstDSI_as>CC[AG][CT]GG)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CRYG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCRYGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstEII': {'charac': (1, -1, None, None, 'GGTNACC'),
            'compsite': '(?P<BstEII>GGT.ACC)|(?P<BstEII_as>GGT.ACC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'GTNAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTNACC',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('G', 'H', 'J', 'M', 'N', 'O', 'R', 'S', 'U', 'V')},
 'BstENI': {'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
            'compsite': '(?P<BstENI>CCT.....AGG)|(?P<BstENI_as>CCT.....AGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTNNNNNAGG',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstF5I': {'charac': (7, 0, None, None, 'GGATG'),
            'compsite': '(?P<BstF5I>GGATG)|(?P<BstF5I_as>CATCC)',
            'dna': None,
            'freq': 1024,
            'fst3': 0,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGATG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I', 'N')},
 'BstFNI': {'charac': (2, -2, None, None, 'CGCG'),
            'compsite': '(?P<BstFNI>CGCG)|(?P<BstFNI_as>CGCG)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGCG',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstH2I': {'charac': (5, -5, None, None, 'RGCGCY'),
            'compsite': '(?P<BstH2I>[AG]GCGC[CT])|(?P<BstH2I_as>[AG]GCGC[CT])',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'GCGC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RGCGCY',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstHHI': {'charac': (3, -3, None, None, 'GCGC'),
            'compsite': '(?P<BstHHI>GCGC)|(?P<BstHHI_as>GCGC)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCGC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstKTI': {'charac': (3, -3, None, None, 'GATC'),
            'compsite': '(?P<BstKTI>GATC)|(?P<BstKTI_as>GATC)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'AT',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GATC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstMBI': {'charac': (0, 0, None, None, 'GATC'),
            'compsite': '(?P<BstMBI>GATC)|(?P<BstMBI_as>GATC)',
            'dna': None,
            'freq': 256,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GATC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GATC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstMCI': {'charac': (4, -4, None, None, 'CGRYCG'),
            'compsite': '(?P<BstMCI>CG[AG][CT]CG)|(?P<BstMCI_as>CG[AG][CT]CG)',
            'dna': None,
            'freq': 1024,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'RY',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGRYCG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstMWI': {'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
            'compsite': '(?P<BstMWI>GC.......GC)|(?P<BstMWI_as>GC.......GC)',
            'dna': None,
            'freq': 256,
            'fst3': -7,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'NNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCNNNNNNNGC',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstNI': {'charac': (2, -2, None, None, 'CCWGG'),
           'compsite': '(?P<BstNI>CC[AT]GG)|(?P<BstNI_as>CC[AT]GG)',
           'dna': None,
           'freq': 512,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'W',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCWGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('E', 'N')},
 'BstNSI': {'charac': (5, -5, None, None, 'RCATGY'),
            'compsite': '(?P<BstNSI>[AG]CATG[CT])|(?P<BstNSI_as>[AG]CATG[CT])',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'CATG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RCATGY',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstOI': {'charac': (2, -2, None, None, 'CCWGG'),
           'compsite': '(?P<BstOI>CC[AT]GG)|(?P<BstOI_as>CC[AT]GG)',
           'dna': None,
           'freq': 512,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'W',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCWGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('R',)},
 'BstPAI': {'charac': (5, -5, None, None, 'GACNNNNGTC'),
            'compsite': '(?P<BstPAI>GAC....GTC)|(?P<BstPAI_as>GAC....GTC)',
            'dna': None,
            'freq': 4096,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GACNNNNGTC',
            'size': 10,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstPI': {'charac': (1, -1, None, None, 'GGTNACC'),
           'compsite': '(?P<BstPI>GGT.ACC)|(?P<BstPI_as>GGT.ACC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'GTNAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGTNACC',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('K',)},
 'BstSCI': {'charac': (0, 0, None, None, 'CCNGG'),
            'compsite': '(?P<BstSCI>CC.GG)|(?P<BstSCI_as>CC.GG)',
            'dna': None,
            'freq': 256,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'CCNGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCNGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstSFI': {'charac': (1, -1, None, None, 'CTRYAG'),
            'compsite': '(?P<BstSFI>CT[AG][CT]AG)|(?P<BstSFI_as>CT[AG][CT]AG)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'TRYA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTRYAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstSNI': {'charac': (3, -3, None, None, 'TACGTA'),
            'compsite': '(?P<BstSNI>TACGTA)|(?P<BstSNI_as>TACGTA)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TACGTA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstUI': {'charac': (2, -2, None, None, 'CGCG'),
           'compsite': '(?P<BstUI>CGCG)|(?P<BstUI_as>CGCG)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGCG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BstV1I': {'charac': (13, 12, None, None, 'GCAGC'),
            'compsite': '(?P<BstV1I>GCAGC)|(?P<BstV1I_as>GCTGC)',
            'dna': None,
            'freq': 1024,
            'fst3': 12,
            'fst5': 13,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCAGC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstV2I': {'charac': (8, 6, None, None, 'GAAGAC'),
            'compsite': '(?P<BstV2I>GAAGAC)|(?P<BstV2I_as>GTCTTC)',
            'dna': None,
            'freq': 4096,
            'fst3': 6,
            'fst5': 8,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GAAGAC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstX2I': {'charac': (1, -1, None, None, 'RGATCY'),
            'compsite': '(?P<BstX2I>[AG]GATC[CT])|(?P<BstX2I_as>[AG]GATC[CT])',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GATC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RGATCY',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'BstXI': {'charac': (8, -8, None, None, 'CCANNNNNNTGG'),
           'compsite': '(?P<BstXI>CCA......TGG)|(?P<BstXI_as>CCA......TGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -8,
           'fst5': 8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCANNNNNNTGG',
           'size': 12,
           'substrat': 'DNA',
           'suppl': ('A',
                     'E',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'V',
                     'X')},
 'BstYI': {'charac': (1, -1, None, None, 'RGATCY'),
           'compsite': '(?P<BstYI>[AG]GATC[CT])|(?P<BstYI_as>[AG]GATC[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGATCY',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BstZ17I': {'charac': (3, -3, None, None, 'GTATAC'),
             'compsite': '(?P<BstZ17I>GTATAC)|(?P<BstZ17I_as>GTATAC)',
             'dna': None,
             'freq': 4096,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GTATAC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('N',)},
 'BstZI': {'charac': (1, -1, None, None, 'CGGCCG'),
           'compsite': '(?P<BstZI>CGGCCG)|(?P<BstZI_as>CGGCCG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GGCC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGGCCG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('R',)},
 'Bsu15I': {'charac': (2, -2, None, None, 'ATCGAT'),
            'compsite': '(?P<Bsu15I>ATCGAT)|(?P<Bsu15I_as>ATCGAT)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATCGAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Bsu36I': {'charac': (2, -2, None, None, 'CCTNAGG'),
            'compsite': '(?P<Bsu36I>CCT.AGG)|(?P<Bsu36I_as>CCT.AGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'TNA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTNAGG',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('E', 'N', 'R')},
 'BsuRI': {'charac': (2, -2, None, None, 'GGCC'),
           'compsite': '(?P<BsuRI>GGCC)|(?P<BsuRI_as>GGCC)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGCC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F', 'I')},
 'BsuTUI': {'charac': (2, -2, None, None, 'ATCGAT'),
            'compsite': '(?P<BsuTUI>ATCGAT)|(?P<BsuTUI_as>ATCGAT)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATCGAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'BtgI': {'charac': (1, -1, None, None, 'CCRYGG'),
          'compsite': '(?P<BtgI>CC[AG][CT]GG)|(?P<BtgI_as>CC[AG][CT]GG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CRYG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCRYGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BtgZI': {'charac': (16, 14, None, None, 'GCGATG'),
           'compsite': '(?P<BtgZI>GCGATG)|(?P<BtgZI_as>CATCGC)',
           'dna': None,
           'freq': 4096,
           'fst3': 14,
           'fst5': 16,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGATG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'BthCI': {'charac': (4, -4, None, None, 'GCNGC'),
           'compsite': '(?P<BthCI>GC.GC)|(?P<BthCI_as>GC.GC)',
           'dna': None,
           'freq': 256,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'CNG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCNGC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'BtrI': {'charac': (3, -3, None, None, 'CACGTC'),
          'compsite': '(?P<BtrI>CACGTC)|(?P<BtrI_as>GACGTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACGTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'BtsI': {'charac': (8, 0, None, None, 'GCAGTG'),
          'compsite': '(?P<BtsI>GCAGTG)|(?P<BtsI_as>CACTGC)',
          'dna': None,
          'freq': 4096,
          'fst3': 0,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCAGTG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'BveI': {'charac': (10, 8, None, None, 'ACCTGC'),
          'compsite': '(?P<BveI>ACCTGC)|(?P<BveI_as>GCAGGT)',
          'dna': None,
          'freq': 4096,
          'fst3': 8,
          'fst5': 10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACCTGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'Cac8I': {'charac': (3, -3, None, None, 'GCNNGC'),
           'compsite': '(?P<Cac8I>GC..GC)|(?P<Cac8I_as>GC..GC)',
           'dna': None,
           'freq': 256,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCNNGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'CaiI': {'charac': (6, -6, None, None, 'CAGNNNCTG'),
          'compsite': '(?P<CaiI>CAG...CTG)|(?P<CaiI_as>CAG...CTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CAGNNNCTG',
          'size': 9,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'CauII': {'charac': (2, -2, None, None, 'CCSGG'),
           'compsite': '(?P<CauII>CC[CG]GG)|(?P<CauII_as>CC[CG]GG)',
           'dna': None,
           'freq': 512,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'S',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCSGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'CciNI': {'charac': (2, -2, None, None, 'GCGGCCGC'),
           'compsite': '(?P<CciNI>GCGGCCGC)|(?P<CciNI_as>GCGGCCGC)',
           'dna': None,
           'freq': 65536,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GGCC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGGCCGC',
           'size': 8,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'CdiI': {'charac': (4, -1, None, None, 'CATCG'),
          'compsite': '(?P<CdiI>CATCG)|(?P<CdiI_as>CGATG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CATCG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'CelII': {'charac': (2, -2, None, None, 'GCTNAGC'),
           'compsite': '(?P<CelII>GCT.AGC)|(?P<CelII_as>GCT.AGC)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'TNA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCTNAGC',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'CfoI': {'charac': (3, -3, None, None, 'GCGC'),
          'compsite': '(?P<CfoI>GCGC)|(?P<CfoI_as>GCGC)',
          'dna': None,
          'freq': 256,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCGC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('G', 'M', 'R', 'S')},
 'Cfr10I': {'charac': (1, -1, None, None, 'RCCGGY'),
            'compsite': '(?P<Cfr10I>[AG]CCGG[CT])|(?P<Cfr10I_as>[AG]CCGG[CT])',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CCGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RCCGGY',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F', 'G', 'K', 'M', 'O')},
 'Cfr13I': {'charac': (1, -1, None, None, 'GGNCC'),
            'compsite': '(?P<Cfr13I>GG.CC)|(?P<Cfr13I_as>GG.CC)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GNC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGNCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('A', 'F', 'K', 'O')},
 'Cfr42I': {'charac': (4, -4, None, None, 'CCGCGG'),
            'compsite': '(?P<Cfr42I>CCGCGG)|(?P<Cfr42I_as>CCGCGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'GC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCGCGG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Cfr9I': {'charac': (1, -1, None, None, 'CCCGGG'),
           'compsite': '(?P<Cfr9I>CCCGGG)|(?P<Cfr9I_as>CCCGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCGGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F', 'O')},
 'CfrI': {'charac': (1, -1, None, None, 'YGGCCR'),
          'compsite': '(?P<CfrI>[CT]GGCC[AG])|(?P<CfrI_as>[CT]GGCC[AG])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GGCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'YGGCCR',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'ChaI': {'charac': (4, -4, None, None, 'GATC'),
          'compsite': '(?P<ChaI>GATC)|(?P<ChaI_as>GATC)',
          'dna': None,
          'freq': 256,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GATC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ()},
 'CjeI': {'charac': (-8, -25, 26, 9, 'CCANNNNNNGT'),
          'compsite': '(?P<CjeI>CCA......GT)|(?P<CjeI_as>AC......TGG)',
          'dna': None,
          'freq': 1024,
          'fst3': -25,
          'fst5': -8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 6,
          'ovhgseq': 'NNNNNN',
          'results': None,
          'scd3': 9,
          'scd5': 26,
          'site': 'CCANNNNNNGT',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ()},
 'CjePI': {'charac': (-7, -25, 26, 8, 'CCANNNNNNNTC'),
           'compsite': '(?P<CjePI>CCA.......TC)|(?P<CjePI_as>GA.......TGG)',
           'dna': None,
           'freq': 1024,
           'fst3': -25,
           'fst5': -7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 6,
           'ovhgseq': 'NNNNNN',
           'results': None,
           'scd3': 8,
           'scd5': 26,
           'site': 'CCANNNNNNNTC',
           'size': 12,
           'substrat': 'DNA',
           'suppl': ()},
 'ClaI': {'charac': (2, -2, None, None, 'ATCGAT'),
          'compsite': '(?P<ClaI>ATCGAT)|(?P<ClaI_as>ATCGAT)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATCGAT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'H', 'K', 'M', 'N', 'R', 'S', 'U')},
 'CpoI': {'charac': (2, -2, None, None, 'CGGWCCG'),
          'compsite': '(?P<CpoI>CGG[AT]CCG)|(?P<CpoI_as>CGG[AT]CCG)',
          'dna': None,
          'freq': 8192,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'GWC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGGWCCG',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('A', 'F', 'K')},
 'Csp45I': {'charac': (2, -2, None, None, 'TTCGAA'),
            'compsite': '(?P<Csp45I>TTCGAA)|(?P<Csp45I_as>TTCGAA)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TTCGAA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('O', 'R')},
 'Csp6I': {'charac': (1, -1, None, None, 'GTAC'),
           'compsite': '(?P<Csp6I>GTAC)|(?P<Csp6I_as>GTAC)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'TA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTAC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'CspAI': {'charac': (1, -1, None, None, 'ACCGGT'),
           'compsite': '(?P<CspAI>ACCGGT)|(?P<CspAI_as>ACCGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCGGT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'CspCI': {'charac': (-11, -25, 24, 10, 'CAANNNNNGTGG'),
           'compsite': '(?P<CspCI>CAA.....GTGG)|(?P<CspCI_as>CCAC.....TTG)',
           'dna': None,
           'freq': 16384,
           'fst3': -25,
           'fst5': -11,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': 10,
           'scd5': 24,
           'site': 'CAANNNNNGTGG',
           'size': 12,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'CspI': {'charac': (2, -2, None, None, 'CGGWCCG'),
          'compsite': '(?P<CspI>CGG[AT]CCG)|(?P<CspI_as>CGG[AT]CCG)',
          'dna': None,
          'freq': 8192,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'GWC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGGWCCG',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('E', 'O', 'R')},
 'CstMI': {'charac': (26, 18, None, None, 'AAGGAG'),
           'compsite': '(?P<CstMI>AAGGAG)|(?P<CstMI_as>CTCCTT)',
           'dna': None,
           'freq': 4096,
           'fst3': 18,
           'fst5': 26,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'AAGGAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'CviAII': {'charac': (1, -1, None, None, 'CATG'),
            'compsite': '(?P<CviAII>CATG)|(?P<CviAII_as>CATG)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'AT',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CATG',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'CviJI': {'charac': (2, -2, None, None, 'RGCY'),
           'compsite': '(?P<CviJI>[AG]GC[CT])|(?P<CviJI_as>[AG]GC[CT])',
           'dna': None,
           'freq': 64,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGCY',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('Q', 'X')},
 'CviRI': {'charac': (2, -2, None, None, 'TGCA'),
           'compsite': '(?P<CviRI>TGCA)|(?P<CviRI_as>TGCA)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGCA',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('P',)},
 'CviTI': {'charac': (2, -2, None, None, 'RGCY'),
           'compsite': '(?P<CviTI>[AG]GC[CT])|(?P<CviTI_as>[AG]GC[CT])',
           'dna': None,
           'freq': 64,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGCY',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('P',)},
 'DdeI': {'charac': (1, -1, None, None, 'CTNAG'),
          'compsite': '(?P<DdeI>CT.AG)|(?P<DdeI_as>CT.AG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'TNA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTNAG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('E', 'G', 'M', 'N', 'O', 'R', 'S', 'V')},
 'DpnI': {'charac': (2, -2, None, None, 'GATC'),
          'compsite': '(?P<DpnI>GATC)|(?P<DpnI_as>GATC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GATC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('E', 'F', 'G', 'M', 'N', 'R', 'S')},
 'DpnII': {'charac': (0, 0, None, None, 'GATC'),
           'compsite': '(?P<DpnII>GATC)|(?P<DpnII_as>GATC)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'DraI': {'charac': (3, -3, None, None, 'TTTAAA'),
          'compsite': '(?P<DraI>TTTAAA)|(?P<DraI_as>TTTAAA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTTAAA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'F',
                    'G',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'DraII': {'charac': (2, -2, None, None, 'RGGNCCY'),
           'compsite': '(?P<DraII>[AG]GG.CC[CT])|(?P<DraII_as>[AG]GG.CC[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GNC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGGNCCY',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('G', 'M')},
 'DraIII': {'charac': (6, -6, None, None, 'CACNNNGTG'),
            'compsite': '(?P<DraIII>CAC...GTG)|(?P<DraIII_as>CAC...GTG)',
            'dna': None,
            'freq': 4096,
            'fst3': -6,
            'fst5': 6,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'NNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CACNNNGTG',
            'size': 9,
            'substrat': 'DNA',
            'suppl': ('E', 'G', 'I', 'M', 'N', 'V')},
 'DrdI': {'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
          'compsite': '(?P<DrdI>GAC......GTC)|(?P<DrdI_as>GAC......GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -7,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNNNNGTC',
          'size': 12,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'DrdII': {'charac': (None, None, None, None, 'GAACCA'),
           'compsite': '(?P<DrdII>GAACCA)|(?P<DrdII_as>TGGTTC)',
           'dna': None,
           'freq': 4096,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAACCA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'DriI': {'charac': (6, -6, None, None, 'GACNNNNNGTC'),
          'compsite': '(?P<DriI>GAC.....GTC)|(?P<DriI_as>GAC.....GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNNNGTC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'DsaI': {'charac': (1, -1, None, None, 'CCRYGG'),
          'compsite': '(?P<DsaI>CC[AG][CT]GG)|(?P<DsaI_as>CC[AG][CT]GG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CRYG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCRYGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'DseDI': {'charac': (7, -7, None, None, 'GACNNNNNNGTC'),
           'compsite': '(?P<DseDI>GAC......GTC)|(?P<DseDI_as>GAC......GTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'NN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GACNNNNNNGTC',
           'size': 12,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'EaeI': {'charac': (1, -1, None, None, 'YGGCCR'),
          'compsite': '(?P<EaeI>[CT]GGCC[AG])|(?P<EaeI_as>[CT]GGCC[AG])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GGCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'YGGCCR',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'K', 'M', 'N', 'V')},
 'EagI': {'charac': (1, -1, None, None, 'CGGCCG'),
          'compsite': '(?P<EagI>CGGCCG)|(?P<EagI_as>CGGCCG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GGCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGGCCG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('G', 'N')},
 'Eam1104I': {'charac': (7, 4, None, None, 'CTCTTC'),
              'compsite': '(?P<Eam1104I>CTCTTC)|(?P<Eam1104I_as>GAAGAG)',
              'dna': None,
              'freq': 4096,
              'fst3': 4,
              'fst5': 7,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'NNN',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CTCTTC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('E', 'F')},
 'Eam1105I': {'charac': (6, -6, None, None, 'GACNNNNNGTC'),
              'compsite': '(?P<Eam1105I>GAC.....GTC)|(?P<Eam1105I_as>GAC.....GTC)',
              'dna': None,
              'freq': 4096,
              'fst3': -6,
              'fst5': 6,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 1,
              'ovhgseq': 'N',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GACNNNNNGTC',
              'size': 11,
              'substrat': 'DNA',
              'suppl': ('F', 'K')},
 'EarI': {'charac': (7, 4, None, None, 'CTCTTC'),
          'compsite': '(?P<EarI>CTCTTC)|(?P<EarI_as>GAAGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': 4,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCTTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'EciI': {'charac': (17, 9, None, None, 'GGCGGA'),
          'compsite': '(?P<EciI>GGCGGA)|(?P<EciI_as>TCCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': 9,
          'fst5': 17,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Ecl136II': {'charac': (3, -3, None, None, 'GAGCTC'),
              'compsite': '(?P<Ecl136II>GAGCTC)|(?P<Ecl136II_as>GAGCTC)',
              'dna': None,
              'freq': 4096,
              'fst3': -3,
              'fst5': 3,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 0,
              'ovhgseq': '',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GAGCTC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'EclHKI': {'charac': (6, -6, None, None, 'GACNNNNNGTC'),
            'compsite': '(?P<EclHKI>GAC.....GTC)|(?P<EclHKI_as>GAC.....GTC)',
            'dna': None,
            'freq': 4096,
            'fst3': -6,
            'fst5': 6,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GACNNNNNGTC',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('R',)},
 'EclXI': {'charac': (1, -1, None, None, 'CGGCCG'),
           'compsite': '(?P<EclXI>CGGCCG)|(?P<EclXI_as>CGGCCG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GGCC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGGCCG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'S')},
 'Eco105I': {'charac': (3, -3, None, None, 'TACGTA'),
             'compsite': '(?P<Eco105I>TACGTA)|(?P<Eco105I_as>TACGTA)',
             'dna': None,
             'freq': 4096,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'TACGTA',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F', 'O')},
 'Eco130I': {'charac': (1, -1, None, None, 'CCWWGG'),
             'compsite': '(?P<Eco130I>CC[AT][AT]GG)|(?P<Eco130I_as>CC[AT][AT]GG)',
             'dna': None,
             'freq': 1024,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'CWWG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CCWWGG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'Eco147I': {'charac': (3, -3, None, None, 'AGGCCT'),
             'compsite': '(?P<Eco147I>AGGCCT)|(?P<Eco147I_as>AGGCCT)',
             'dna': None,
             'freq': 4096,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'AGGCCT',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'Eco24I': {'charac': (5, -5, None, None, 'GRGCYC'),
            'compsite': '(?P<Eco24I>G[AG]GC[CT]C)|(?P<Eco24I_as>G[AG]GC[CT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'RGCY',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GRGCYC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco31I': {'charac': (7, 5, None, None, 'GGTCTC'),
            'compsite': '(?P<Eco31I>GGTCTC)|(?P<Eco31I_as>GAGACC)',
            'dna': None,
            'freq': 4096,
            'fst3': 5,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'NNNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTCTC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco32I': {'charac': (3, -3, None, None, 'GATATC'),
            'compsite': '(?P<Eco32I>GATATC)|(?P<Eco32I_as>GATATC)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GATATC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco47I': {'charac': (1, -1, None, None, 'GGWCC'),
            'compsite': '(?P<Eco47I>GG[AT]CC)|(?P<Eco47I_as>GG[AT]CC)',
            'dna': None,
            'freq': 512,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GWC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGWCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('F', 'O')},
 'Eco47III': {'charac': (3, -3, None, None, 'AGCGCT'),
              'compsite': '(?P<Eco47III>AGCGCT)|(?P<Eco47III_as>AGCGCT)',
              'dna': None,
              'freq': 4096,
              'fst3': -3,
              'fst5': 3,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 0,
              'ovhgseq': '',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'AGCGCT',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('E', 'F', 'G', 'M', 'O', 'R')},
 'Eco52I': {'charac': (1, -1, None, None, 'CGGCCG'),
            'compsite': '(?P<Eco52I>CGGCCG)|(?P<Eco52I_as>CGGCCG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GGCC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGGCCG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F', 'K', 'O', 'R')},
 'Eco57I': {'charac': (22, 14, None, None, 'CTGAAG'),
            'compsite': '(?P<Eco57I>CTGAAG)|(?P<Eco57I_as>CTTCAG)',
            'dna': None,
            'freq': 4096,
            'fst3': 14,
            'fst5': 22,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTGAAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco57MI': {'charac': (22, 14, None, None, 'CTGRAG'),
             'compsite': '(?P<Eco57MI>CTG[AG]AG)|(?P<Eco57MI_as>CT[CT]CAG)',
             'dna': None,
             'freq': 2048,
             'fst3': 14,
             'fst5': 22,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 2,
             'ovhgseq': 'NN',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CTGRAG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'Eco72I': {'charac': (3, -3, None, None, 'CACGTG'),
            'compsite': '(?P<Eco72I>CACGTG)|(?P<Eco72I_as>CACGTG)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CACGTG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco81I': {'charac': (2, -2, None, None, 'CCTNAGG'),
            'compsite': '(?P<Eco81I>CCT.AGG)|(?P<Eco81I_as>CCT.AGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'TNA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTNAGG',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('A', 'F', 'K', 'O')},
 'Eco88I': {'charac': (1, -1, None, None, 'CYCGRG'),
            'compsite': '(?P<Eco88I>C[CT]CG[AG]G)|(?P<Eco88I_as>C[CT]CG[AG]G)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'YCGR',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CYCGRG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Eco91I': {'charac': (1, -1, None, None, 'GGTNACC'),
            'compsite': '(?P<Eco91I>GGT.ACC)|(?P<Eco91I_as>GGT.ACC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'GTNAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTNACC',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'EcoHI': {'charac': (0, 0, None, None, 'CCSGG'),
           'compsite': '(?P<EcoHI>CC[CG]GG)|(?P<EcoHI_as>CC[CG]GG)',
           'dna': None,
           'freq': 512,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'CCSGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCSGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'EcoICRI': {'charac': (3, -3, None, None, 'GAGCTC'),
             'compsite': '(?P<EcoICRI>GAGCTC)|(?P<EcoICRI_as>GAGCTC)',
             'dna': None,
             'freq': 4096,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GAGCTC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I', 'R')},
 'EcoNI': {'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
           'compsite': '(?P<EcoNI>CCT.....AGG)|(?P<EcoNI_as>CCT.....AGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCTNNNNNAGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'EcoO109I': {'charac': (2, -2, None, None, 'RGGNCCY'),
              'compsite': '(?P<EcoO109I>[AG]GG.CC[CT])|(?P<EcoO109I_as>[AG]GG.CC[CT])',
              'dna': None,
              'freq': 1024,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'GNC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'RGGNCCY',
              'size': 7,
              'substrat': 'DNA',
              'suppl': ('A', 'E', 'F', 'J', 'K', 'N', 'V')},
 'EcoO65I': {'charac': (1, -1, None, None, 'GGTNACC'),
             'compsite': '(?P<EcoO65I>GGT.ACC)|(?P<EcoO65I_as>GGT.ACC)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -5,
             'ovhgseq': 'GTNAC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GGTNACC',
             'size': 7,
             'substrat': 'DNA',
             'suppl': ('K',)},
 'EcoRI': {'charac': (1, -1, None, None, 'GAATTC'),
           'compsite': '(?P<EcoRI>GAATTC)|(?P<EcoRI_as>GAATTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'AATT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAATTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'E',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'S',
                     'U',
                     'V',
                     'X')},
 'EcoRII': {'charac': (0, 0, None, None, 'CCWGG'),
            'compsite': '(?P<EcoRII>CC[AT]GG)|(?P<EcoRII_as>CC[AT]GG)',
            'dna': None,
            'freq': 512,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'CCWGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCWGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('E', 'J', 'M', 'O', 'S')},
 'EcoRV': {'charac': (3, -3, None, None, 'GATATC'),
           'compsite': '(?P<EcoRV>GATATC)|(?P<EcoRV_as>GATATC)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATATC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'E',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'S',
                     'U',
                     'V',
                     'X')},
 'EcoT14I': {'charac': (1, -1, None, None, 'CCWWGG'),
             'compsite': '(?P<EcoT14I>CC[AT][AT]GG)|(?P<EcoT14I_as>CC[AT][AT]GG)',
             'dna': None,
             'freq': 1024,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'CWWG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CCWWGG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('A', 'K')},
 'EcoT22I': {'charac': (5, -5, None, None, 'ATGCAT'),
             'compsite': '(?P<EcoT22I>ATGCAT)|(?P<EcoT22I_as>ATGCAT)',
             'dna': None,
             'freq': 4096,
             'fst3': -5,
             'fst5': 5,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 4,
             'ovhgseq': 'TGCA',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'ATGCAT',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('A', 'K', 'O')},
 'EcoT38I': {'charac': (5, -5, None, None, 'GRGCYC'),
             'compsite': '(?P<EcoT38I>G[AG]GC[CT]C)|(?P<EcoT38I_as>G[AG]GC[CT]C)',
             'dna': None,
             'freq': 1024,
             'fst3': -5,
             'fst5': 5,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 4,
             'ovhgseq': 'RGCY',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GRGCYC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('J',)},
 'EgeI': {'charac': (3, -3, None, None, 'GGCGCC'),
          'compsite': '(?P<EgeI>GGCGCC)|(?P<EgeI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'EheI': {'charac': (3, -3, None, None, 'GGCGCC'),
          'compsite': '(?P<EheI>GGCGCC)|(?P<EheI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F', 'O')},
 'ErhI': {'charac': (1, -1, None, None, 'CCWWGG'),
          'compsite': '(?P<ErhI>CC[AT][AT]GG)|(?P<ErhI_as>CC[AT][AT]GG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CWWG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCWWGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'EsaBC3I': {'charac': (2, -2, None, None, 'TCGA'),
             'compsite': '(?P<EsaBC3I>TCGA)|(?P<EsaBC3I_as>TCGA)',
             'dna': None,
             'freq': 256,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'TCGA',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ()},
 'Esp3I': {'charac': (7, 5, None, None, 'CGTCTC'),
           'compsite': '(?P<Esp3I>CGTCTC)|(?P<Esp3I_as>GAGACG)',
           'dna': None,
           'freq': 4096,
           'fst3': 5,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGTCTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'EspI': {'charac': (2, -2, None, None, 'GCTNAGC'),
          'compsite': '(?P<EspI>GCT.AGC)|(?P<EspI_as>GCT.AGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'TNA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCTNAGC',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ()},
 'FalI': {'charac': (-8, -24, 24, 8, 'AAGNNNNNCTT'),
          'compsite': '(?P<FalI>AAG.....CTT)|(?P<FalI_as>AAG.....CTT)',
          'dna': None,
          'freq': 4096,
          'fst3': -24,
          'fst5': -8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 8,
          'scd5': 24,
          'site': 'AAGNNNNNCTT',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'FaqI': {'charac': (15, 14, None, None, 'GGGAC'),
          'compsite': '(?P<FaqI>GGGAC)|(?P<FaqI_as>GTCCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 14,
          'fst5': 15,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGGAC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'FatI': {'charac': (0, 0, None, None, 'CATG'),
          'compsite': '(?P<FatI>CATG)|(?P<FatI_as>CATG)',
          'dna': None,
          'freq': 256,
          'fst3': 0,
          'fst5': 0,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CATG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'FauI': {'charac': (9, 6, None, None, 'CCCGC'),
          'compsite': '(?P<FauI>CCCGC)|(?P<FauI_as>GCGGG)',
          'dna': None,
          'freq': 1024,
          'fst3': 6,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCCGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'FauNDI': {'charac': (2, -2, None, None, 'CATATG'),
            'compsite': '(?P<FauNDI>CATATG)|(?P<FauNDI_as>CATATG)',
            'dna': None,
            'freq': 4096,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'TA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CATATG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'FbaI': {'charac': (1, -1, None, None, 'TGATCA'),
          'compsite': '(?P<FbaI>TGATCA)|(?P<FbaI_as>TGATCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGATCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'K')},
 'FblI': {'charac': (2, -2, None, None, 'GTMKAC'),
          'compsite': '(?P<FblI>GT[AC][GT]AC)|(?P<FblI_as>GT[AC][GT]AC)',
          'dna': None,
          'freq': 1024,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'MK',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTMKAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'FinI': {'charac': (None, None, None, None, 'GGGAC'),
          'compsite': '(?P<FinI>GGGAC)|(?P<FinI_as>GTCCC)',
          'dna': None,
          'freq': 1024,
          'fst3': None,
          'fst5': None,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': None,
          'ovhgseq': None,
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGGAC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'FmuI': {'charac': (4, -4, None, None, 'GGNCC'),
          'compsite': '(?P<FmuI>GG.CC)|(?P<FmuI_as>GG.CC)',
          'dna': None,
          'freq': 256,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'GNC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGNCC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'Fnu4HI': {'charac': (2, -2, None, None, 'GCNGC'),
            'compsite': '(?P<Fnu4HI>GC.GC)|(?P<Fnu4HI_as>GC.GC)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCNGC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'FnuDII': {'charac': (2, -2, None, None, 'CGCG'),
            'compsite': '(?P<FnuDII>CGCG)|(?P<FnuDII_as>CGCG)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGCG',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ()},
 'FokI': {'charac': (14, 13, None, None, 'GGATG'),
          'compsite': '(?P<FokI>GGATG)|(?P<FokI_as>CATCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 13,
          'fst5': 14,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGATG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('A', 'G', 'I', 'J', 'K', 'M', 'N', 'R')},
 'FriOI': {'charac': (5, -5, None, None, 'GRGCYC'),
           'compsite': '(?P<FriOI>G[AG]GC[CT]C)|(?P<FriOI_as>G[AG]GC[CT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'RGCY',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GRGCYC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'FseI': {'charac': (6, -6, None, None, 'GGCCGGCC'),
          'compsite': '(?P<FseI>GGCCGGCC)|(?P<FseI_as>GGCCGGCC)',
          'dna': None,
          'freq': 65536,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCCGGCC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('A', 'K', 'N')},
 'Fsp4HI': {'charac': (2, -2, None, None, 'GCNGC'),
            'compsite': '(?P<Fsp4HI>GC.GC)|(?P<Fsp4HI_as>GC.GC)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCNGC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'FspAI': {'charac': (4, -4, None, None, 'RTGCGCAY'),
           'compsite': '(?P<FspAI>[AG]TGCGCA[CT])|(?P<FspAI_as>[AG]TGCGCA[CT])',
           'dna': None,
           'freq': 16384,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RTGCGCAY',
           'size': 8,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'FspBI': {'charac': (1, -1, None, None, 'CTAG'),
           'compsite': '(?P<FspBI>CTAG)|(?P<FspBI_as>CTAG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'TA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTAG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'FspI': {'charac': (3, -3, None, None, 'TGCGCA'),
          'compsite': '(?P<FspI>TGCGCA)|(?P<FspI_as>TGCGCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGCGCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('J', 'N', 'O')},
 'FunI': {'charac': (3, -3, None, None, 'AGCGCT'),
          'compsite': '(?P<FunI>AGCGCT)|(?P<FunI_as>AGCGCT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGCGCT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('V',)},
 'FunII': {'charac': (1, -1, None, None, 'GAATTC'),
           'compsite': '(?P<FunII>GAATTC)|(?P<FunII_as>GAATTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'AATT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAATTC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('V',)},
 'GdiII': {'charac': (1, -1, None, None, 'CGGCCR'),
           'compsite': '(?P<GdiII>CGGCC[AG])|(?P<GdiII_as>[CT]GGCCG)',
           'dna': None,
           'freq': 2048,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GGCC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGGCCR',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'GsuI': {'charac': (22, 14, None, None, 'CTGGAG'),
          'compsite': '(?P<GsuI>CTGGAG)|(?P<GsuI_as>CTCCAG)',
          'dna': None,
          'freq': 4096,
          'fst3': 14,
          'fst5': 22,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTGGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'HaeI': {'charac': (3, -3, None, None, 'WGGCCW'),
          'compsite': '(?P<HaeI>[AT]GGCC[AT])|(?P<HaeI_as>[AT]GGCC[AT])',
          'dna': None,
          'freq': 1024,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'WGGCCW',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'HaeII': {'charac': (5, -5, None, None, 'RGCGCY'),
           'compsite': '(?P<HaeII>[AG]GCGC[CT])|(?P<HaeII_as>[AG]GCGC[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'GCGC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGCGCY',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('G', 'J', 'K', 'M', 'N', 'O', 'R', 'S')},
 'HaeIII': {'charac': (2, -2, None, None, 'GGCC'),
            'compsite': '(?P<HaeIII>GGCC)|(?P<HaeIII_as>GGCC)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGCC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('A',
                      'G',
                      'H',
                      'I',
                      'J',
                      'K',
                      'M',
                      'N',
                      'O',
                      'Q',
                      'R',
                      'S',
                      'U',
                      'X')},
 'HapII': {'charac': (1, -1, None, None, 'CCGG'),
           'compsite': '(?P<HapII>CCGG)|(?P<HapII_as>CCGG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('A', 'K')},
 'HgaI': {'charac': (10, 10, None, None, 'GACGC'),
          'compsite': '(?P<HgaI>GACGC)|(?P<HgaI_as>GCGTC)',
          'dna': None,
          'freq': 1024,
          'fst3': 10,
          'fst5': 10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'HgiAI': {'charac': (5, -5, None, None, 'GWGCWC'),
           'compsite': '(?P<HgiAI>G[AT]GC[AT]C)|(?P<HgiAI_as>G[AT]GC[AT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'WGCW',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GWGCWC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'HgiCI': {'charac': (1, -1, None, None, 'GGYRCC'),
           'compsite': '(?P<HgiCI>GG[CT][AG]CC)|(?P<HgiCI_as>GG[CT][AG]CC)',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GYRC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGYRCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'HgiEII': {'charac': (None, None, None, None, 'ACCNNNNNNGGT'),
            'compsite': '(?P<HgiEII>ACC......GGT)|(?P<HgiEII_as>ACC......GGT)',
            'dna': None,
            'freq': 4096,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACCNNNNNNGGT',
            'size': 12,
            'substrat': 'DNA',
            'suppl': ()},
 'HgiJII': {'charac': (5, -5, None, None, 'GRGCYC'),
            'compsite': '(?P<HgiJII>G[AG]GC[CT]C)|(?P<HgiJII_as>G[AG]GC[CT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'RGCY',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GRGCYC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'HhaI': {'charac': (3, -3, None, None, 'GCGC'),
          'compsite': '(?P<HhaI>GCGC)|(?P<HhaI_as>GCGC)',
          'dna': None,
          'freq': 256,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCGC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A', 'F', 'G', 'J', 'K', 'N', 'O', 'R', 'U')},
 'Hin1I': {'charac': (2, -2, None, None, 'GRCGYC'),
           'compsite': '(?P<Hin1I>G[AG]CG[CT]C)|(?P<Hin1I_as>G[AG]CG[CT]C)',
           'dna': None,
           'freq': 1024,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GRCGYC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F', 'K', 'O')},
 'Hin1II': {'charac': (4, -4, None, None, 'CATG'),
            'compsite': '(?P<Hin1II>CATG)|(?P<Hin1II_as>CATG)',
            'dna': None,
            'freq': 256,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'CATG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CATG',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Hin4I': {'charac': (-8, -24, 24, 8, 'GAYNNNNNVTC'),
           'compsite': '(?P<Hin4I>GA[CT].....[ACG]TC)|(?P<Hin4I_as>GA[CGT].....[AG]TC)',
           'dna': None,
           'freq': 512,
           'fst3': -24,
           'fst5': -8,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 5,
           'ovhgseq': 'NNNNN',
           'results': None,
           'scd3': 8,
           'scd5': 24,
           'site': 'GAYNNNNNVTC',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'Hin4II': {'charac': (None, None, None, None, 'CCTTC'),
            'compsite': '(?P<Hin4II>CCTTC)|(?P<Hin4II_as>GAAGG)',
            'dna': None,
            'freq': 1024,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCTTC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'Hin6I': {'charac': (1, -1, None, None, 'GCGC'),
           'compsite': '(?P<Hin6I>GCGC)|(?P<Hin6I_as>GCGC)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'HinP1I': {'charac': (1, -1, None, None, 'GCGC'),
            'compsite': '(?P<HinP1I>GCGC)|(?P<HinP1I_as>GCGC)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCGC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'HincII': {'charac': (3, -3, None, None, 'GTYRAC'),
            'compsite': '(?P<HincII>GT[CT][AG]AC)|(?P<HincII_as>GT[CT][AG]AC)',
            'dna': None,
            'freq': 1024,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTYRAC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('A',
                      'E',
                      'F',
                      'G',
                      'H',
                      'J',
                      'K',
                      'N',
                      'O',
                      'Q',
                      'R',
                      'U',
                      'X')},
 'HindII': {'charac': (3, -3, None, None, 'GTYRAC'),
            'compsite': '(?P<HindII>GT[CT][AG]AC)|(?P<HindII_as>GT[CT][AG]AC)',
            'dna': None,
            'freq': 1024,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTYRAC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I', 'M', 'S')},
 'HindIII': {'charac': (1, -1, None, None, 'AAGCTT'),
             'compsite': '(?P<HindIII>AAGCTT)|(?P<HindIII_as>AAGCTT)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'AGCT',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'AAGCTT',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('A',
                       'C',
                       'E',
                       'F',
                       'G',
                       'H',
                       'I',
                       'J',
                       'K',
                       'M',
                       'N',
                       'O',
                       'Q',
                       'R',
                       'S',
                       'U',
                       'X')},
 'HinfI': {'charac': (1, -1, None, None, 'GANTC'),
           'compsite': '(?P<HinfI>GA.TC)|(?P<HinfI_as>GA.TC)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'ANT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GANTC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'U',
                     'X')},
 'HpaI': {'charac': (3, -3, None, None, 'GTTAAC'),
          'compsite': '(?P<HpaI>GTTAAC)|(?P<HpaI_as>GTTAAC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTTAAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'HpaII': {'charac': (1, -1, None, None, 'CCGG'),
           'compsite': '(?P<HpaII>CCGG)|(?P<HpaII_as>CCGG)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGG',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F', 'G', 'I', 'M', 'N', 'O', 'Q', 'R', 'S', 'U', 'X')},
 'HphI': {'charac': (13, 7, None, None, 'GGTGA'),
          'compsite': '(?P<HphI>GGTGA)|(?P<HphI_as>TCACC)',
          'dna': None,
          'freq': 1024,
          'fst3': 7,
          'fst5': 13,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGTGA',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F', 'N')},
 'Hpy178III': {'charac': (2, -2, None, None, 'TCNNGA'),
               'compsite': '(?P<Hpy178III>TC..GA)|(?P<Hpy178III_as>TC..GA)',
               'dna': None,
               'freq': 256,
               'fst3': -2,
               'fst5': 2,
               'inact_temp': 65,
               'opt_temp': 37,
               'ovhg': -2,
               'ovhgseq': 'NN',
               'results': None,
               'scd3': None,
               'scd5': None,
               'site': 'TCNNGA',
               'size': 6,
               'substrat': 'DNA',
               'suppl': ()},
 'Hpy188I': {'charac': (3, -3, None, None, 'TCNGA'),
             'compsite': '(?P<Hpy188I>TC.GA)|(?P<Hpy188I_as>TC.GA)',
             'dna': None,
             'freq': 256,
             'fst3': -3,
             'fst5': 3,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 1,
             'ovhgseq': 'N',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'TCNGA',
             'size': 5,
             'substrat': 'DNA',
             'suppl': ('N',)},
 'Hpy188III': {'charac': (2, -2, None, None, 'TCNNGA'),
               'compsite': '(?P<Hpy188III>TC..GA)|(?P<Hpy188III_as>TC..GA)',
               'dna': None,
               'freq': 256,
               'fst3': -2,
               'fst5': 2,
               'inact_temp': 65,
               'opt_temp': 37,
               'ovhg': -2,
               'ovhgseq': 'NN',
               'results': None,
               'scd3': None,
               'scd5': None,
               'site': 'TCNNGA',
               'size': 6,
               'substrat': 'DNA',
               'suppl': ('N',)},
 'Hpy8I': {'charac': (3, -3, None, None, 'GTNNAC'),
           'compsite': '(?P<Hpy8I>GT..AC)|(?P<Hpy8I_as>GT..AC)',
           'dna': None,
           'freq': 256,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTNNAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'Hpy99I': {'charac': (5, -5, None, None, 'CGWCG'),
            'compsite': '(?P<Hpy99I>CG[AT]CG)|(?P<Hpy99I_as>CG[AT]CG)',
            'dna': None,
            'freq': 512,
            'fst3': -5,
            'fst5': 5,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 5,
            'ovhgseq': 'CGWCG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGWCG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'HpyAV': {'charac': (11, 5, None, None, 'CCTTC'),
           'compsite': '(?P<HpyAV>CCTTC)|(?P<HpyAV_as>GAAGG)',
           'dna': None,
           'freq': 1024,
           'fst3': 5,
           'fst5': 11,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCTTC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ()},
 'HpyCH4III': {'charac': (3, -3, None, None, 'ACNGT'),
               'compsite': '(?P<HpyCH4III>AC.GT)|(?P<HpyCH4III_as>AC.GT)',
               'dna': None,
               'freq': 256,
               'fst3': -3,
               'fst5': 3,
               'inact_temp': 65,
               'opt_temp': 37,
               'ovhg': 1,
               'ovhgseq': 'N',
               'results': None,
               'scd3': None,
               'scd5': None,
               'site': 'ACNGT',
               'size': 5,
               'substrat': 'DNA',
               'suppl': ('N',)},
 'HpyCH4IV': {'charac': (1, -1, None, None, 'ACGT'),
              'compsite': '(?P<HpyCH4IV>ACGT)|(?P<HpyCH4IV_as>ACGT)',
              'dna': None,
              'freq': 256,
              'fst3': -1,
              'fst5': 1,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -2,
              'ovhgseq': 'CG',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'ACGT',
              'size': 4,
              'substrat': 'DNA',
              'suppl': ('N',)},
 'HpyCH4V': {'charac': (2, -2, None, None, 'TGCA'),
             'compsite': '(?P<HpyCH4V>TGCA)|(?P<HpyCH4V_as>TGCA)',
             'dna': None,
             'freq': 256,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 0,
             'ovhgseq': '',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'TGCA',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ('N',)},
 'HpyF10VI': {'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
              'compsite': '(?P<HpyF10VI>GC.......GC)|(?P<HpyF10VI_as>GC.......GC)',
              'dna': None,
              'freq': 256,
              'fst3': -7,
              'fst5': 7,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 3,
              'ovhgseq': 'NNN',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GCNNNNNNNGC',
              'size': 11,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'Hsp92I': {'charac': (2, -2, None, None, 'GRCGYC'),
            'compsite': '(?P<Hsp92I>G[AG]CG[CT]C)|(?P<Hsp92I_as>G[AG]CG[CT]C)',
            'dna': None,
            'freq': 1024,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -2,
            'ovhgseq': 'CG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GRCGYC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('R',)},
 'Hsp92II': {'charac': (4, -4, None, None, 'CATG'),
             'compsite': '(?P<Hsp92II>CATG)|(?P<Hsp92II_as>CATG)',
             'dna': None,
             'freq': 256,
             'fst3': -4,
             'fst5': 4,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 4,
             'ovhgseq': 'CATG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CATG',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ('R',)},
 'HspAI': {'charac': (1, -1, None, None, 'GCGC'),
           'compsite': '(?P<HspAI>GCGC)|(?P<HspAI_as>GCGC)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCGC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'ItaI': {'charac': (2, -2, None, None, 'GCNGC'),
          'compsite': '(?P<ItaI>GC.GC)|(?P<ItaI_as>GC.GC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCNGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'KasI': {'charac': (1, -1, None, None, 'GGCGCC'),
          'compsite': '(?P<KasI>GGCGCC)|(?P<KasI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GCGC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Kpn2I': {'charac': (1, -1, None, None, 'TCCGGA'),
           'compsite': '(?P<Kpn2I>TCCGGA)|(?P<Kpn2I_as>TCCGGA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TCCGGA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'KpnI': {'charac': (5, -5, None, None, 'GGTACC'),
          'compsite': '(?P<KpnI>GGTACC)|(?P<KpnI_as>GGTACC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'GTAC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGTACC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'Ksp22I': {'charac': (1, -1, None, None, 'TGATCA'),
            'compsite': '(?P<Ksp22I>TGATCA)|(?P<Ksp22I_as>TGATCA)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GATC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TGATCA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'Ksp632I': {'charac': (7, 4, None, None, 'CTCTTC'),
             'compsite': '(?P<Ksp632I>CTCTTC)|(?P<Ksp632I_as>GAAGAG)',
             'dna': None,
             'freq': 4096,
             'fst3': 4,
             'fst5': 7,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -3,
             'ovhgseq': 'NNN',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CTCTTC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('M',)},
 'KspAI': {'charac': (3, -3, None, None, 'GTTAAC'),
           'compsite': '(?P<KspAI>GTTAAC)|(?P<KspAI_as>GTTAAC)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTTAAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'KspI': {'charac': (4, -4, None, None, 'CCGCGG'),
          'compsite': '(?P<KspI>CCGCGG)|(?P<KspI_as>CCGCGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'GC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCGCGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M', 'S')},
 'Kzo9I': {'charac': (0, 0, None, None, 'GATC'),
           'compsite': '(?P<Kzo9I>GATC)|(?P<Kzo9I_as>GATC)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'LpnI': {'charac': (3, -3, None, None, 'RGCGCY'),
          'compsite': '(?P<LpnI>[AG]GCGC[CT])|(?P<LpnI_as>[AG]GCGC[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RGCGCY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'LweI': {'charac': (10, 9, None, None, 'GCATC'),
          'compsite': '(?P<LweI>GCATC)|(?P<LweI_as>GATGC)',
          'dna': None,
          'freq': 1024,
          'fst3': 9,
          'fst5': 10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCATC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'MabI': {'charac': (1, -1, None, None, 'ACCWGGT'),
          'compsite': '(?P<MabI>ACC[AT]GGT)|(?P<MabI_as>ACC[AT]GGT)',
          'dna': None,
          'freq': 8192,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -5,
          'ovhgseq': 'CCWGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACCWGGT',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'MaeI': {'charac': (1, -1, None, None, 'CTAG'),
          'compsite': '(?P<MaeI>CTAG)|(?P<MaeI_as>CTAG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTAG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'MaeII': {'charac': (1, -1, None, None, 'ACGT'),
           'compsite': '(?P<MaeII>ACGT)|(?P<MaeII_as>ACGT)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACGT',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'MaeIII': {'charac': (0, 0, None, None, 'GTNAC'),
            'compsite': '(?P<MaeIII>GT.AC)|(?P<MaeIII_as>GT.AC)',
            'dna': None,
            'freq': 256,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'GTNAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTNAC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('M',)},
 'MamI': {'charac': (5, -5, None, None, 'GATNNNNATC'),
          'compsite': '(?P<MamI>GAT....ATC)|(?P<MamI_as>GAT....ATC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GATNNNNATC',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'MbiI': {'charac': (3, -3, None, None, 'CCGCTC'),
          'compsite': '(?P<MbiI>CCGCTC)|(?P<MbiI_as>GAGCGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCGCTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'MboI': {'charac': (0, 0, None, None, 'GATC'),
          'compsite': '(?P<MboI>GATC)|(?P<MboI_as>GATC)',
          'dna': None,
          'freq': 256,
          'fst3': 0,
          'fst5': 0,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GATC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A', 'C', 'F', 'G', 'K', 'N', 'Q', 'R', 'U', 'V', 'X')},
 'MboII': {'charac': (13, 7, None, None, 'GAAGA'),
           'compsite': '(?P<MboII>GAAGA)|(?P<MboII_as>TCTTC)',
           'dna': None,
           'freq': 1024,
           'fst3': 7,
           'fst5': 13,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAAGA',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('A', 'F', 'G', 'I', 'J', 'K', 'N', 'O', 'Q', 'R', 'X')},
 'McrI': {'charac': (4, -4, None, None, 'CGRYCG'),
          'compsite': '(?P<McrI>CG[AG][CT]CG)|(?P<McrI_as>CG[AG][CT]CG)',
          'dna': None,
          'freq': 1024,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'RY',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGRYCG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'MfeI': {'charac': (1, -1, None, None, 'CAATTG'),
          'compsite': '(?P<MfeI>CAATTG)|(?P<MfeI_as>CAATTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'AATT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CAATTG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'MflI': {'charac': (1, -1, None, None, 'RGATCY'),
          'compsite': '(?P<MflI>[AG]GATC[CT])|(?P<MflI_as>[AG]GATC[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RGATCY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('K',)},
 'MhlI': {'charac': (5, -5, None, None, 'GDGCHC'),
          'compsite': '(?P<MhlI>G[AGT]GC[ACT]C)|(?P<MhlI_as>G[AGT]GC[ACT]C)',
          'dna': None,
          'freq': 256,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'DGCH',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GDGCHC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'MjaIV': {'charac': (None, None, None, None, 'GTNNAC'),
           'compsite': '(?P<MjaIV>GT..AC)|(?P<MjaIV_as>GT..AC)',
           'dna': None,
           'freq': 256,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTNNAC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'MlsI': {'charac': (3, -3, None, None, 'TGGCCA'),
          'compsite': '(?P<MlsI>TGGCCA)|(?P<MlsI_as>TGGCCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGGCCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'MluI': {'charac': (1, -1, None, None, 'ACGCGT'),
          'compsite': '(?P<MluI>ACGCGT)|(?P<MluI_as>ACGCGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CGCG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACGCGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'MluNI': {'charac': (3, -3, None, None, 'TGGCCA'),
           'compsite': '(?P<MluNI>TGGCCA)|(?P<MluNI_as>TGGCCA)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGGCCA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'S')},
 'Mly113I': {'charac': (2, -2, None, None, 'GGCGCC'),
             'compsite': '(?P<Mly113I>GGCGCC)|(?P<Mly113I_as>GGCGCC)',
             'dna': None,
             'freq': 4096,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -2,
             'ovhgseq': 'CG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GGCGCC',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I',)},
 'MlyI': {'charac': (10, 5, None, None, 'GAGTC'),
          'compsite': '(?P<MlyI>GAGTC)|(?P<MlyI_as>GACTC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'MmeI': {'charac': (26, 18, None, None, 'TCCRAC'),
          'compsite': '(?P<MmeI>TCC[AG]AC)|(?P<MmeI_as>GT[CT]GGA)',
          'dna': None,
          'freq': 2048,
          'fst3': 18,
          'fst5': 26,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCCRAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N', 'X')},
 'MnlI': {'charac': (11, 6, None, None, 'CCTC'),
          'compsite': '(?P<MnlI>CCTC)|(?P<MnlI_as>GAGG)',
          'dna': None,
          'freq': 256,
          'fst3': 6,
          'fst5': 11,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('E', 'F', 'G', 'I', 'N', 'Q', 'X')},
 'Mph1103I': {'charac': (5, -5, None, None, 'ATGCAT'),
              'compsite': '(?P<Mph1103I>ATGCAT)|(?P<Mph1103I_as>ATGCAT)',
              'dna': None,
              'freq': 4096,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'TGCA',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'ATGCAT',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'MroI': {'charac': (1, -1, None, None, 'TCCGGA'),
          'compsite': '(?P<MroI>TCCGGA)|(?P<MroI_as>TCCGGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCCGGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M', 'O')},
 'MroNI': {'charac': (1, -1, None, None, 'GCCGGC'),
           'compsite': '(?P<MroNI>GCCGGC)|(?P<MroNI_as>GCCGGC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCCGGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'MroXI': {'charac': (5, -5, None, None, 'GAANNNNTTC'),
           'compsite': '(?P<MroXI>GAA....TTC)|(?P<MroXI_as>GAA....TTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GAANNNNTTC',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'MscI': {'charac': (3, -3, None, None, 'TGGCCA'),
          'compsite': '(?P<MscI>TGGCCA)|(?P<MscI_as>TGGCCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGGCCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N', 'O')},
 'MseI': {'charac': (1, -1, None, None, 'TTAA'),
          'compsite': '(?P<MseI>TTAA)|(?P<MseI_as>TTAA)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTAA',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'MslI': {'charac': (5, -5, None, None, 'CAYNNNNRTG'),
          'compsite': '(?P<MslI>CA[CT]....[AG]TG)|(?P<MslI_as>CA[CT]....[AG]TG)',
          'dna': None,
          'freq': 1024,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CAYNNNNRTG',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Msp20I': {'charac': (3, -3, None, None, 'TGGCCA'),
            'compsite': '(?P<Msp20I>TGGCCA)|(?P<Msp20I_as>TGGCCA)',
            'dna': None,
            'freq': 4096,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'TGGCCA',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'MspA1I': {'charac': (3, -3, None, None, 'CMGCKG'),
            'compsite': '(?P<MspA1I>C[AC]GC[GT]G)|(?P<MspA1I_as>C[AC]GC[GT]G)',
            'dna': None,
            'freq': 1024,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CMGCKG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I', 'N', 'R')},
 'MspCI': {'charac': (1, -1, None, None, 'CTTAAG'),
           'compsite': '(?P<MspCI>CTTAAG)|(?P<MspCI_as>CTTAAG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TTAA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CTTAAG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'MspI': {'charac': (1, -1, None, None, 'CCGG'),
          'compsite': '(?P<MspI>CCGG)|(?P<MspI_as>CCGG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCGG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'MspR9I': {'charac': (2, -2, None, None, 'CCNGG'),
            'compsite': '(?P<MspR9I>CC.GG)|(?P<MspR9I_as>CC.GG)',
            'dna': None,
            'freq': 256,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCNGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'MssI': {'charac': (4, -4, None, None, 'GTTTAAAC'),
          'compsite': '(?P<MssI>GTTTAAAC)|(?P<MssI_as>GTTTAAAC)',
          'dna': None,
          'freq': 65536,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTTTAAAC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'MstI': {'charac': (3, -3, None, None, 'TGCGCA'),
          'compsite': '(?P<MstI>TGCGCA)|(?P<MstI_as>TGCGCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGCGCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'MunI': {'charac': (1, -1, None, None, 'CAATTG'),
          'compsite': '(?P<MunI>CAATTG)|(?P<MunI_as>CAATTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'AATT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CAATTG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('E', 'F', 'K', 'M')},
 'Mva1269I': {'charac': (7, -1, None, None, 'GAATGC'),
              'compsite': '(?P<Mva1269I>GAATGC)|(?P<Mva1269I_as>GCATTC)',
              'dna': None,
              'freq': 4096,
              'fst3': -1,
              'fst5': 7,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 2,
              'ovhgseq': 'CN',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GAATGC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F',)},
 'MvaI': {'charac': (2, -2, None, None, 'CCWGG'),
          'compsite': '(?P<MvaI>CC[AT]GG)|(?P<MvaI_as>CC[AT]GG)',
          'dna': None,
          'freq': 512,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'W',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCWGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('A', 'F', 'G', 'K', 'M', 'O', 'S')},
 'MvnI': {'charac': (2, -2, None, None, 'CGCG'),
          'compsite': '(?P<MvnI>CGCG)|(?P<MvnI_as>CGCG)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGCG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'MvrI': {'charac': (4, -4, None, None, 'CGATCG'),
          'compsite': '(?P<MvrI>CGATCG)|(?P<MvrI_as>CGATCG)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'AT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGATCG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'MwoI': {'charac': (7, -7, None, None, 'GCNNNNNNNGC'),
          'compsite': '(?P<MwoI>GC.......GC)|(?P<MwoI_as>GC.......GC)',
          'dna': None,
          'freq': 256,
          'fst3': -7,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCNNNNNNNGC',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'NaeI': {'charac': (3, -3, None, None, 'GCCGGC'),
          'compsite': '(?P<NaeI>GCCGGC)|(?P<NaeI_as>GCCGGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCCGGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'C', 'E', 'K', 'M', 'N', 'O', 'R', 'U')},
 'NarI': {'charac': (2, -2, None, None, 'GGCGCC'),
          'compsite': '(?P<NarI>GGCGCC)|(?P<NarI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('E', 'G', 'J', 'M', 'N', 'O', 'Q', 'R', 'U', 'X')},
 'NciI': {'charac': (2, -2, None, None, 'CCSGG'),
          'compsite': '(?P<NciI>CC[CG]GG)|(?P<NciI_as>CC[CG]GG)',
          'dna': None,
          'freq': 512,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'S',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCSGG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('E', 'G', 'J', 'N', 'O', 'R', 'S')},
 'NcoI': {'charac': (1, -1, None, None, 'CCATGG'),
          'compsite': '(?P<NcoI>CCATGG)|(?P<NcoI_as>CCATGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCATGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'NdeI': {'charac': (2, -2, None, None, 'CATATG'),
          'compsite': '(?P<NdeI>CATATG)|(?P<NdeI_as>CATATG)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CATATG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A', 'E', 'F', 'G', 'J', 'K', 'M', 'N', 'R', 'S')},
 'NdeII': {'charac': (0, 0, None, None, 'GATC'),
           'compsite': '(?P<NdeII>GATC)|(?P<NdeII_as>GATC)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GATC',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('G', 'J', 'M', 'R', 'S')},
 'NgoMIV': {'charac': (1, -1, None, None, 'GCCGGC'),
            'compsite': '(?P<NgoMIV>GCCGGC)|(?P<NgoMIV_as>GCCGGC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'CCGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCCGGC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('N', 'R')},
 'NheI': {'charac': (1, -1, None, None, 'GCTAGC'),
          'compsite': '(?P<NheI>GCTAGC)|(?P<NheI_as>GCTAGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCTAGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'R',
                    'S',
                    'U')},
 'NlaIII': {'charac': (4, -4, None, None, 'CATG'),
            'compsite': '(?P<NlaIII>CATG)|(?P<NlaIII_as>CATG)',
            'dna': None,
            'freq': 256,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 4,
            'ovhgseq': 'CATG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CATG',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('G', 'N')},
 'NlaIV': {'charac': (3, -3, None, None, 'GGNNCC'),
           'compsite': '(?P<NlaIV>GG..CC)|(?P<NlaIV_as>GG..CC)',
           'dna': None,
           'freq': 256,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGNNCC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('G', 'N')},
 'Nli3877I': {'charac': (5, -5, None, None, 'CYCGRG'),
              'compsite': '(?P<Nli3877I>C[CT]CG[AG]G)|(?P<Nli3877I_as>C[CT]CG[AG]G)',
              'dna': None,
              'freq': 1024,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'YCGR',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CYCGRG',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ()},
 'NmuCI': {'charac': (0, 0, None, None, 'GTSAC'),
           'compsite': '(?P<NmuCI>GT[CG]AC)|(?P<NmuCI_as>GT[CG]AC)',
           'dna': None,
           'freq': 512,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'GTSAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GTSAC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'NotI': {'charac': (2, -2, None, None, 'GCGGCCGC'),
          'compsite': '(?P<NotI>GCGGCCGC)|(?P<NotI_as>GCGGCCGC)',
          'dna': None,
          'freq': 65536,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GGCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCGGCCGC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'NruI': {'charac': (3, -3, None, None, 'TCGCGA'),
          'compsite': '(?P<NruI>TCGCGA)|(?P<NruI_as>TCGCGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCGCGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'G',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'NsbI': {'charac': (3, -3, None, None, 'TGCGCA'),
          'compsite': '(?P<NsbI>TGCGCA)|(?P<NsbI_as>TGCGCA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TGCGCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'NsiI': {'charac': (5, -5, None, None, 'ATGCAT'),
          'compsite': '(?P<NsiI>ATGCAT)|(?P<NsiI_as>ATGCAT)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'TGCA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATGCAT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('E', 'G', 'H', 'J', 'M', 'N', 'R', 'S', 'U')},
 'NspBII': {'charac': (3, -3, None, None, 'CMGCKG'),
            'compsite': '(?P<NspBII>C[AC]GC[GT]G)|(?P<NspBII_as>C[AC]GC[GT]G)',
            'dna': None,
            'freq': 1024,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CMGCKG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'NspI': {'charac': (5, -5, None, None, 'RCATGY'),
          'compsite': '(?P<NspI>[AG]CATG[CT])|(?P<NspI_as>[AG]CATG[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RCATGY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M', 'N')},
 'NspIII': {'charac': (1, -1, None, None, 'CYCGRG'),
            'compsite': '(?P<NspIII>C[CT]CG[AG]G)|(?P<NspIII_as>C[CT]CG[AG]G)',
            'dna': None,
            'freq': 1024,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'YCGR',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CYCGRG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('V',)},
 'NspV': {'charac': (2, -2, None, None, 'TTCGAA'),
          'compsite': '(?P<NspV>TTCGAA)|(?P<NspV_as>TTCGAA)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTCGAA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('J', 'K', 'O')},
 'OliI': {'charac': (5, -5, None, None, 'CACNNNNGTG'),
          'compsite': '(?P<OliI>CAC....GTG)|(?P<OliI_as>CAC....GTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACNNNNGTG',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PacI': {'charac': (5, -5, None, None, 'TTAATTAA'),
          'compsite': '(?P<PacI>TTAATTAA)|(?P<PacI_as>TTAATTAA)',
          'dna': None,
          'freq': 65536,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'AT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTAATTAA',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('G', 'N', 'O')},
 'PaeI': {'charac': (5, -5, None, None, 'GCATGC'),
          'compsite': '(?P<PaeI>GCATGC)|(?P<PaeI_as>GCATGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCATGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PaeR7I': {'charac': (1, -1, None, None, 'CTCGAG'),
            'compsite': '(?P<PaeR7I>CTCGAG)|(?P<PaeR7I_as>CTCGAG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'TCGA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTCGAG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'PagI': {'charac': (1, -1, None, None, 'TCATGA'),
          'compsite': '(?P<PagI>TCATGA)|(?P<PagI_as>TCATGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCATGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PalI': {'charac': (2, -2, None, None, 'GGCC'),
          'compsite': '(?P<PalI>GGCC)|(?P<PalI_as>GGCC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('E',)},
 'PasI': {'charac': (2, -2, None, None, 'CCCWGGG'),
          'compsite': '(?P<PasI>CCC[AT]GGG)|(?P<PasI_as>CCC[AT]GGG)',
          'dna': None,
          'freq': 8192,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'CWG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCCWGGG',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PauI': {'charac': (1, -1, None, None, 'GCGCGC'),
          'compsite': '(?P<PauI>GCGCGC)|(?P<PauI_as>GCGCGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CGCG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCGCGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PceI': {'charac': (3, -3, None, None, 'AGGCCT'),
          'compsite': '(?P<PceI>AGGCCT)|(?P<PceI_as>AGGCCT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGGCCT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'PciI': {'charac': (1, -1, None, None, 'ACATGT'),
          'compsite': '(?P<PciI>ACATGT)|(?P<PciI_as>ACATGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACATGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'PctI': {'charac': (7, -1, None, None, 'GAATGC'),
          'compsite': '(?P<PctI>GAATGC)|(?P<PctI_as>GCATTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'CN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAATGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'PdiI': {'charac': (3, -3, None, None, 'GCCGGC'),
          'compsite': '(?P<PdiI>GCCGGC)|(?P<PdiI_as>GCCGGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCCGGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PdmI': {'charac': (5, -5, None, None, 'GAANNNNTTC'),
          'compsite': '(?P<PdmI>GAA....TTC)|(?P<PdmI_as>GAA....TTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAANNNNTTC',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PfeI': {'charac': (1, -1, None, None, 'GAWTC'),
          'compsite': '(?P<PfeI>GA[AT]TC)|(?P<PfeI_as>GA[AT]TC)',
          'dna': None,
          'freq': 512,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'AWT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAWTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'Pfl1108I': {'charac': (None, None, None, None, 'TCGTAG'),
              'compsite': '(?P<Pfl1108I>TCGTAG)|(?P<Pfl1108I_as>CTACGA)',
              'dna': None,
              'freq': 4096,
              'fst3': None,
              'fst5': None,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': None,
              'ovhgseq': None,
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'TCGTAG',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ()},
 'Pfl23II': {'charac': (1, -1, None, None, 'CGTACG'),
             'compsite': '(?P<Pfl23II>CGTACG)|(?P<Pfl23II_as>CGTACG)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'GTAC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CGTACG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('F',)},
 'PflBI': {'charac': (7, -7, None, None, 'CCANNNNNTGG'),
           'compsite': '(?P<PflBI>CCA.....TGG)|(?P<PflBI_as>CCA.....TGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCANNNNNTGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('V',)},
 'PflFI': {'charac': (4, -4, None, None, 'GACNNNGTC'),
           'compsite': '(?P<PflFI>GAC...GTC)|(?P<PflFI_as>GAC...GTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GACNNNGTC',
           'size': 9,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'PflMI': {'charac': (7, -7, None, None, 'CCANNNNNTGG'),
           'compsite': '(?P<PflMI>CCA.....TGG)|(?P<PflMI_as>CCA.....TGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCANNNNNTGG',
           'size': 11,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'PfoI': {'charac': (1, -1, None, None, 'TCCNGGA'),
          'compsite': '(?P<PfoI>TCC.GGA)|(?P<PfoI_as>TCC.GGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -5,
          'ovhgseq': 'CCNGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCCNGGA',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PhoI': {'charac': (2, -2, None, None, 'GGCC'),
          'compsite': '(?P<PhoI>GGCC)|(?P<PhoI_as>GGCC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'PinAI': {'charac': (1, -1, None, None, 'ACCGGT'),
           'compsite': '(?P<PinAI>ACCGGT)|(?P<PinAI_as>ACCGGT)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCGGT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'V')},
 'Ple19I': {'charac': (4, -4, None, None, 'CGATCG'),
            'compsite': '(?P<Ple19I>CGATCG)|(?P<Ple19I_as>CGATCG)',
            'dna': None,
            'freq': 4096,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'AT',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGATCG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'PleI': {'charac': (9, 5, None, None, 'GAGTC'),
          'compsite': '(?P<PleI>GAGTC)|(?P<PleI_as>GACTC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'PmaCI': {'charac': (3, -3, None, None, 'CACGTG'),
           'compsite': '(?P<PmaCI>CACGTG)|(?P<PmaCI_as>CACGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACGTG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'K')},
 'PmeI': {'charac': (4, -4, None, None, 'GTTTAAAC'),
          'compsite': '(?P<PmeI>GTTTAAAC)|(?P<PmeI_as>GTTTAAAC)',
          'dna': None,
          'freq': 65536,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTTTAAAC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('G', 'N')},
 'PmlI': {'charac': (3, -3, None, None, 'CACGTG'),
          'compsite': '(?P<PmlI>CACGTG)|(?P<PmlI_as>CACGTG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CACGTG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'PpiI': {'charac': (-7, -24, 25, 8, 'GAACNNNNNCTC'),
          'compsite': '(?P<PpiI>GAAC.....CTC)|(?P<PpiI_as>GAG.....GTTC)',
          'dna': None,
          'freq': 16384,
          'fst3': -24,
          'fst5': -7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 8,
          'scd5': 25,
          'site': 'GAACNNNNNCTC',
          'size': 12,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PpsI': {'charac': (9, 5, None, None, 'GAGTC'),
          'compsite': '(?P<PpsI>GAGTC)|(?P<PpsI_as>GACTC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'Ppu10I': {'charac': (1, -1, None, None, 'ATGCAT'),
            'compsite': '(?P<Ppu10I>ATGCAT)|(?P<Ppu10I_as>ATGCAT)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'TGCA',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATGCAT',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'PpuMI': {'charac': (2, -2, None, None, 'RGGWCCY'),
           'compsite': '(?P<PpuMI>[AG]GG[AT]CC[CT])|(?P<PpuMI_as>[AG]GG[AT]CC[CT])',
           'dna': None,
           'freq': 2048,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGGWCCY',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('N', 'O')},
 'PpuXI': {'charac': (2, -2, None, None, 'RGGWCCY'),
           'compsite': '(?P<PpuXI>[AG]GG[AT]CC[CT])|(?P<PpuXI_as>[AG]GG[AT]CC[CT])',
           'dna': None,
           'freq': 2048,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGGWCCY',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('V',)},
 'PshAI': {'charac': (5, -5, None, None, 'GACNNNNGTC'),
           'compsite': '(?P<PshAI>GAC....GTC)|(?P<PshAI_as>GAC....GTC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GACNNNNGTC',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('A', 'K', 'N')},
 'PshBI': {'charac': (2, -2, None, None, 'ATTAAT'),
           'compsite': '(?P<PshBI>ATTAAT)|(?P<PshBI_as>ATTAAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'TA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATTAAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('K',)},
 'PsiI': {'charac': (3, -3, None, None, 'TTATAA'),
          'compsite': '(?P<PsiI>TTATAA)|(?P<PsiI_as>TTATAA)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTATAA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'Psp03I': {'charac': (4, -4, None, None, 'GGWCC'),
            'compsite': '(?P<Psp03I>GG[AT]CC)|(?P<Psp03I_as>GG[AT]CC)',
            'dna': None,
            'freq': 512,
            'fst3': -4,
            'fst5': 4,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'GWC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGWCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'Psp124BI': {'charac': (5, -5, None, None, 'GAGCTC'),
              'compsite': '(?P<Psp124BI>GAGCTC)|(?P<Psp124BI_as>GAGCTC)',
              'dna': None,
              'freq': 4096,
              'fst3': -5,
              'fst5': 5,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'AGCT',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GAGCTC',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('I',)},
 'Psp1406I': {'charac': (2, -2, None, None, 'AACGTT'),
              'compsite': '(?P<Psp1406I>AACGTT)|(?P<Psp1406I_as>AACGTT)',
              'dna': None,
              'freq': 4096,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -2,
              'ovhgseq': 'CG',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'AACGTT',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ('F', 'K', 'M')},
 'Psp5II': {'charac': (2, -2, None, None, 'RGGWCCY'),
            'compsite': '(?P<Psp5II>[AG]GG[AT]CC[CT])|(?P<Psp5II_as>[AG]GG[AT]CC[CT])',
            'dna': None,
            'freq': 2048,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GWC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RGGWCCY',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('F',)},
 'Psp6I': {'charac': (0, 0, None, None, 'CCWGG'),
           'compsite': '(?P<Psp6I>CC[AT]GG)|(?P<Psp6I_as>CC[AT]GG)',
           'dna': None,
           'freq': 512,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'CCWGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCWGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'PspAI': {'charac': (1, -1, None, None, 'CCCGGG'),
           'compsite': '(?P<PspAI>CCCGGG)|(?P<PspAI_as>CCCGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCGGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('E',)},
 'PspCI': {'charac': (3, -3, None, None, 'CACGTG'),
           'compsite': '(?P<PspCI>CACGTG)|(?P<PspCI_as>CACGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACGTG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'PspEI': {'charac': (1, -1, None, None, 'GGTNACC'),
           'compsite': '(?P<PspEI>GGT.ACC)|(?P<PspEI_as>GGT.ACC)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'GTNAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGTNACC',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'PspGI': {'charac': (0, 0, None, None, 'CCWGG'),
           'compsite': '(?P<PspGI>CC[AT]GG)|(?P<PspGI_as>CC[AT]GG)',
           'dna': None,
           'freq': 512,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'CCWGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCWGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('N',)},
 'PspLI': {'charac': (1, -1, None, None, 'CGTACG'),
           'compsite': '(?P<PspLI>CGTACG)|(?P<PspLI_as>CGTACG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GTAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGTACG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'PspN4I': {'charac': (3, -3, None, None, 'GGNNCC'),
            'compsite': '(?P<PspN4I>GG..CC)|(?P<PspN4I_as>GG..CC)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGNNCC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'PspOMI': {'charac': (1, -1, None, None, 'GGGCCC'),
            'compsite': '(?P<PspOMI>GGGCCC)|(?P<PspOMI_as>GGGCCC)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GGCC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGGCCC',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ('I', 'N')},
 'PspPI': {'charac': (1, -1, None, None, 'GGNCC'),
           'compsite': '(?P<PspPI>GG.CC)|(?P<PspPI_as>GG.CC)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GNC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGNCC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'PspPPI': {'charac': (2, -2, None, None, 'RGGWCCY'),
            'compsite': '(?P<PspPPI>[AG]GG[AT]CC[CT])|(?P<PspPPI_as>[AG]GG[AT]CC[CT])',
            'dna': None,
            'freq': 2048,
            'fst3': -2,
            'fst5': 2,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GWC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'RGGWCCY',
            'size': 7,
            'substrat': 'DNA',
            'suppl': ('I',)},
 'PspXI': {'charac': (2, -2, None, None, 'VCTCGAGB'),
           'compsite': '(?P<PspXI>[ACG]CTCGAG[CGT])|(?P<PspXI_as>[ACG]CTCGAG[CGT])',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'TCGA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'VCTCGAGB',
           'size': 8,
           'substrat': 'DNA',
           'suppl': ('I', 'N')},
 'PsrI': {'charac': (-7, -25, 25, 7, 'GAACNNNNNNTAC'),
          'compsite': '(?P<PsrI>GAAC......TAC)|(?P<PsrI_as>GTA......GTTC)',
          'dna': None,
          'freq': 16384,
          'fst3': -25,
          'fst5': -7,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 5,
          'ovhgseq': 'NNNNN',
          'results': None,
          'scd3': 7,
          'scd5': 25,
          'site': 'GAACNNNNNNTAC',
          'size': 13,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'PssI': {'charac': (5, -5, None, None, 'RGGNCCY'),
          'compsite': '(?P<PssI>[AG]GG.CC[CT])|(?P<PssI_as>[AG]GG.CC[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'GNC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RGGNCCY',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ()},
 'PstI': {'charac': (5, -5, None, None, 'CTGCAG'),
          'compsite': '(?P<PstI>CTGCAG)|(?P<PstI_as>CTGCAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'TGCA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTGCAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'PsuI': {'charac': (1, -1, None, None, 'RGATCY'),
          'compsite': '(?P<PsuI>[AG]GATC[CT])|(?P<PsuI_as>[AG]GATC[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GATC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RGATCY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PsyI': {'charac': (4, -4, None, None, 'GACNNNGTC'),
          'compsite': '(?P<PsyI>GAC...GTC)|(?P<PsyI_as>GAC...GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNGTC',
          'size': 9,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'PvuI': {'charac': (4, -4, None, None, 'CGATCG'),
          'compsite': '(?P<PvuI>CGATCG)|(?P<PvuI_as>CGATCG)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'AT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGATCG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'PvuII': {'charac': (3, -3, None, None, 'CAGCTG'),
           'compsite': '(?P<PvuII>CAGCTG)|(?P<PvuII_as>CAGCTG)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CAGCTG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A',
                     'C',
                     'E',
                     'F',
                     'G',
                     'H',
                     'I',
                     'J',
                     'K',
                     'M',
                     'N',
                     'O',
                     'Q',
                     'R',
                     'S',
                     'U',
                     'X')},
 'RcaI': {'charac': (1, -1, None, None, 'TCATGA'),
          'compsite': '(?P<RcaI>TCATGA)|(?P<RcaI_as>TCATGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCATGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M', 'V')},
 'RleAI': {'charac': (18, 9, None, None, 'CCCACA'),
           'compsite': '(?P<RleAI>CCCACA)|(?P<RleAI_as>TGTGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': 9,
           'fst5': 18,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 3,
           'ovhgseq': 'NNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCACA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'RsaI': {'charac': (2, -2, None, None, 'GTAC'),
          'compsite': '(?P<RsaI>GTAC)|(?P<RsaI_as>GTAC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTAC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'V',
                    'X')},
 'Rsr2I': {'charac': (2, -2, None, None, 'CGGWCCG'),
           'compsite': '(?P<Rsr2I>CGG[AT]CCG)|(?P<Rsr2I_as>CGG[AT]CCG)',
           'dna': None,
           'freq': 8192,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGGWCCG',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'RsrII': {'charac': (2, -2, None, None, 'CGGWCCG'),
           'compsite': '(?P<RsrII>CGG[AT]CCG)|(?P<RsrII_as>CGG[AT]CCG)',
           'dna': None,
           'freq': 8192,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGGWCCG',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('M', 'N', 'Q', 'V', 'X')},
 'SacI': {'charac': (5, -5, None, None, 'GAGCTC'),
          'compsite': '(?P<SacI>GAGCTC)|(?P<SacI_as>GAGCTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'AGCT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGCTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'F',
                    'G',
                    'H',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SacII': {'charac': (4, -4, None, None, 'CCGCGG'),
           'compsite': '(?P<SacII>CCGCGG)|(?P<SacII_as>CCGCGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'GC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGCGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'E', 'G', 'H', 'J', 'K', 'N', 'O', 'Q', 'R', 'X')},
 'SalI': {'charac': (1, -1, None, None, 'GTCGAC'),
          'compsite': '(?P<SalI>GTCGAC)|(?P<SalI_as>GTCGAC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TCGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTCGAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SanDI': {'charac': (2, -2, None, None, 'GGGWCCC'),
           'compsite': '(?P<SanDI>GGG[AT]CCC)|(?P<SanDI_as>GGG[AT]CCC)',
           'dna': None,
           'freq': 8192,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -3,
           'ovhgseq': 'GWC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GGGWCCC',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('E',)},
 'SapI': {'charac': (8, 4, None, None, 'GCTCTTC'),
          'compsite': '(?P<SapI>GCTCTTC)|(?P<SapI_as>GAAGAGC)',
          'dna': None,
          'freq': 16384,
          'fst3': 4,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCTCTTC',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'SatI': {'charac': (2, -2, None, None, 'GCNGC'),
          'compsite': '(?P<SatI>GC.GC)|(?P<SatI_as>GC.GC)',
          'dna': None,
          'freq': 256,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCNGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'Sau3AI': {'charac': (0, 0, None, None, 'GATC'),
            'compsite': '(?P<Sau3AI>GATC)|(?P<Sau3AI_as>GATC)',
            'dna': None,
            'freq': 256,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GATC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GATC',
            'size': 4,
            'substrat': 'DNA',
            'suppl': ('A',
                      'G',
                      'H',
                      'J',
                      'K',
                      'M',
                      'N',
                      'O',
                      'Q',
                      'R',
                      'S',
                      'U',
                      'X')},
 'Sau96I': {'charac': (1, -1, None, None, 'GGNCC'),
            'compsite': '(?P<Sau96I>GG.CC)|(?P<Sau96I_as>GG.CC)',
            'dna': None,
            'freq': 256,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -3,
            'ovhgseq': 'GNC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGNCC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('G', 'J', 'M', 'N', 'O', 'R', 'U')},
 'SauI': {'charac': (2, -2, None, None, 'CCTNAGG'),
          'compsite': '(?P<SauI>CCT.AGG)|(?P<SauI_as>CCT.AGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'TNA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTNAGG',
          'size': 7,
          'substrat': 'DNA',
          'suppl': ()},
 'SbfI': {'charac': (6, -6, None, None, 'CCTGCAGG'),
          'compsite': '(?P<SbfI>CCTGCAGG)|(?P<SbfI_as>CCTGCAGG)',
          'dna': None,
          'freq': 65536,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'TGCA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTGCAGG',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'ScaI': {'charac': (3, -3, None, None, 'AGTACT'),
          'compsite': '(?P<ScaI>AGTACT)|(?P<ScaI_as>AGTACT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGTACT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'V',
                    'X')},
 'SchI': {'charac': (10, 5, None, None, 'GAGTC'),
          'compsite': '(?P<SchI>GAGTC)|(?P<SchI_as>GACTC)',
          'dna': None,
          'freq': 1024,
          'fst3': 5,
          'fst5': 10,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'SciI': {'charac': (3, -3, None, None, 'CTCGAG'),
          'compsite': '(?P<SciI>CTCGAG)|(?P<SciI_as>CTCGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'ScrFI': {'charac': (2, -2, None, None, 'CCNGG'),
           'compsite': '(?P<ScrFI>CC.GG)|(?P<ScrFI_as>CC.GG)',
           'dna': None,
           'freq': 256,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -1,
           'ovhgseq': 'N',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCNGG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('J', 'M', 'N', 'O', 'S')},
 'SdaI': {'charac': (6, -6, None, None, 'CCTGCAGG'),
          'compsite': '(?P<SdaI>CCTGCAGG)|(?P<SdaI_as>CCTGCAGG)',
          'dna': None,
          'freq': 65536,
          'fst3': -6,
          'fst5': 6,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'TGCA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTGCAGG',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'SduI': {'charac': (5, -5, None, None, 'GDGCHC'),
          'compsite': '(?P<SduI>G[AGT]GC[ACT]C)|(?P<SduI_as>G[AGT]GC[ACT]C)',
          'dna': None,
          'freq': 256,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'DGCH',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GDGCHC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'SecI': {'charac': (1, -1, None, None, 'CCNNGG'),
          'compsite': '(?P<SecI>CC..GG)|(?P<SecI_as>CC..GG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CNNG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCNNGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'SelI': {'charac': (0, 0, None, None, 'CGCG'),
          'compsite': '(?P<SelI>CGCG)|(?P<SelI_as>CGCG)',
          'dna': None,
          'freq': 256,
          'fst3': 0,
          'fst5': 0,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CGCG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGCG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ()},
 'SexAI': {'charac': (1, -1, None, None, 'ACCWGGT'),
           'compsite': '(?P<SexAI>ACC[AT]GGT)|(?P<SexAI_as>ACC[AT]GGT)',
           'dna': None,
           'freq': 8192,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -5,
           'ovhgseq': 'CCWGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ACCWGGT',
           'size': 7,
           'substrat': 'DNA',
           'suppl': ('M', 'N')},
 'SfaNI': {'charac': (10, 9, None, None, 'GCATC'),
           'compsite': '(?P<SfaNI>GCATC)|(?P<SfaNI_as>GATGC)',
           'dna': None,
           'freq': 1024,
           'fst3': 9,
           'fst5': 10,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'NNNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCATC',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('I', 'N')},
 'SfcI': {'charac': (1, -1, None, None, 'CTRYAG'),
          'compsite': '(?P<SfcI>CT[AG][CT]AG)|(?P<SfcI_as>CT[AG][CT]AG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TRYA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTRYAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'SfeI': {'charac': (1, -1, None, None, 'CTRYAG'),
          'compsite': '(?P<SfeI>CT[AG][CT]AG)|(?P<SfeI_as>CT[AG][CT]AG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TRYA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTRYAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'SfiI': {'charac': (8, -8, None, None, 'GGCCNNNNNGGCC'),
          'compsite': '(?P<SfiI>GGCC.....GGCC)|(?P<SfiI_as>GGCC.....GGCC)',
          'dna': None,
          'freq': 65536,
          'fst3': -8,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'NNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCCNNNNNGGCC',
          'size': 13,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SfoI': {'charac': (3, -3, None, None, 'GGCGCC'),
          'compsite': '(?P<SfoI>GGCGCC)|(?P<SfoI_as>GGCGCC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGCGCC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Sfr274I': {'charac': (1, -1, None, None, 'CTCGAG'),
             'compsite': '(?P<Sfr274I>CTCGAG)|(?P<Sfr274I_as>CTCGAG)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'TCGA',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CTCGAG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I',)},
 'Sfr303I': {'charac': (4, -4, None, None, 'CCGCGG'),
             'compsite': '(?P<Sfr303I>CCGCGG)|(?P<Sfr303I_as>CCGCGG)',
             'dna': None,
             'freq': 4096,
             'fst3': -4,
             'fst5': 4,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': 2,
             'ovhgseq': 'GC',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CCGCGG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I',)},
 'SfuI': {'charac': (2, -2, None, None, 'TTCGAA'),
          'compsite': '(?P<SfuI>TTCGAA)|(?P<SfuI_as>TTCGAA)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TTCGAA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('M',)},
 'SgfI': {'charac': (5, -5, None, None, 'GCGATCGC'),
          'compsite': '(?P<SgfI>GCGATCGC)|(?P<SgfI_as>GCGATCGC)',
          'dna': None,
          'freq': 65536,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 2,
          'ovhgseq': 'AT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCGATCGC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('R',)},
 'SgrAI': {'charac': (2, -2, None, None, 'CRCCGGYG'),
           'compsite': '(?P<SgrAI>C[AG]CCGG[CT]G)|(?P<SgrAI_as>C[AG]CCGG[CT]G)',
           'dna': None,
           'freq': 16384,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CRCCGGYG',
           'size': 8,
           'substrat': 'DNA',
           'suppl': ('M', 'N')},
 'SgrBI': {'charac': (4, -4, None, None, 'CCGCGG'),
           'compsite': '(?P<SgrBI>CCGCGG)|(?P<SgrBI_as>CCGCGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -4,
           'fst5': 4,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': 'GC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCGCGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'SimI': {'charac': (2, 0, None, None, 'GGGTC'),
          'compsite': '(?P<SimI>GGGTC)|(?P<SimI_as>GACCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 0,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'GTC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGGTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'SinI': {'charac': (1, -1, None, None, 'GGWCC'),
          'compsite': '(?P<SinI>GG[AT]CC)|(?P<SinI_as>GG[AT]CC)',
          'dna': None,
          'freq': 512,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'GWC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGWCC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('G', 'R')},
 'SlaI': {'charac': (1, -1, None, None, 'CTCGAG'),
          'compsite': '(?P<SlaI>CTCGAG)|(?P<SlaI_as>CTCGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TCGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('C',)},
 'SmaI': {'charac': (3, -3, None, None, 'CCCGGG'),
          'compsite': '(?P<SmaI>CCCGGG)|(?P<SmaI_as>CCCGGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCCGGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SmiI': {'charac': (4, -4, None, None, 'ATTTAAAT'),
          'compsite': '(?P<SmiI>ATTTAAAT)|(?P<SmiI_as>ATTTAAAT)',
          'dna': None,
          'freq': 65536,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATTTAAAT',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('F', 'I')},
 'SmiMI': {'charac': (5, -5, None, None, 'CAYNNNNRTG'),
           'compsite': '(?P<SmiMI>CA[CT]....[AG]TG)|(?P<SmiMI_as>CA[CT]....[AG]TG)',
           'dna': None,
           'freq': 1024,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CAYNNNNRTG',
           'size': 10,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'SmlI': {'charac': (1, -1, None, None, 'CTYRAG'),
          'compsite': '(?P<SmlI>CT[CT][AG]AG)|(?P<SmlI_as>CT[CT][AG]AG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TYRA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTYRAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'SmuI': {'charac': (9, 6, None, None, 'CCCGC'),
          'compsite': '(?P<SmuI>CCCGC)|(?P<SmuI_as>GCGGG)',
          'dna': None,
          'freq': 1024,
          'fst3': 6,
          'fst5': 9,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'NN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCCGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'SnaBI': {'charac': (3, -3, None, None, 'TACGTA'),
           'compsite': '(?P<SnaBI>TACGTA)|(?P<SnaBI_as>TACGTA)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TACGTA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('A', 'C', 'E', 'K', 'M', 'N', 'R')},
 'SnaI': {'charac': (None, None, None, None, 'GTATAC'),
          'compsite': '(?P<SnaI>GTATAC)|(?P<SnaI_as>GTATAC)',
          'dna': None,
          'freq': 4096,
          'fst3': None,
          'fst5': None,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': None,
          'ovhgseq': None,
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTATAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'SpaHI': {'charac': (5, -5, None, None, 'GCATGC'),
           'compsite': '(?P<SpaHI>GCATGC)|(?P<SpaHI_as>GCATGC)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'CATG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'GCATGC',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('V',)},
 'SpeI': {'charac': (1, -1, None, None, 'ACTAGT'),
          'compsite': '(?P<SpeI>ACTAGT)|(?P<SpeI_as>ACTAGT)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACTAGT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'G',
                    'H',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SphI': {'charac': (5, -5, None, None, 'GCATGC'),
          'compsite': '(?P<SphI>GCATGC)|(?P<SphI_as>GCATGC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCATGC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'X')},
 'SplI': {'charac': (1, -1, None, None, 'CGTACG'),
          'compsite': '(?P<SplI>CGTACG)|(?P<SplI_as>CGTACG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GTAC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGTACG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'SrfI': {'charac': (4, -4, None, None, 'GCCCGGGC'),
          'compsite': '(?P<SrfI>GCCCGGGC)|(?P<SrfI_as>GCCCGGGC)',
          'dna': None,
          'freq': 65536,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCCCGGGC',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('E', 'O')},
 'Sse232I': {'charac': (2, -2, None, None, 'CGCCGGCG'),
             'compsite': '(?P<Sse232I>CGCCGGCG)|(?P<Sse232I_as>CGCCGGCG)',
             'dna': None,
             'freq': 65536,
             'fst3': -2,
             'fst5': 2,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'CCGG',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CGCCGGCG',
             'size': 8,
             'substrat': 'DNA',
             'suppl': ()},
 'Sse8387I': {'charac': (6, -6, None, None, 'CCTGCAGG'),
              'compsite': '(?P<Sse8387I>CCTGCAGG)|(?P<Sse8387I_as>CCTGCAGG)',
              'dna': None,
              'freq': 65536,
              'fst3': -6,
              'fst5': 6,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 4,
              'ovhgseq': 'TGCA',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CCTGCAGG',
              'size': 8,
              'substrat': 'DNA',
              'suppl': ('A', 'K')},
 'Sse8647I': {'charac': (2, -2, None, None, 'AGGWCCT'),
              'compsite': '(?P<Sse8647I>AGG[AT]CCT)|(?P<Sse8647I_as>AGG[AT]CCT)',
              'dna': None,
              'freq': 8192,
              'fst3': -2,
              'fst5': 2,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'GWC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'AGGWCCT',
              'size': 7,
              'substrat': 'DNA',
              'suppl': ()},
 'Sse9I': {'charac': (0, 0, None, None, 'AATT'),
           'compsite': '(?P<Sse9I>AATT)|(?P<Sse9I_as>AATT)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'AATT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'AATT',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('I',)},
 'SseBI': {'charac': (3, -3, None, None, 'AGGCCT'),
           'compsite': '(?P<SseBI>AGGCCT)|(?P<SseBI_as>AGGCCT)',
           'dna': None,
           'freq': 4096,
           'fst3': -3,
           'fst5': 3,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 0,
           'ovhgseq': '',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'AGGCCT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('C',)},
 'SsiI': {'charac': (1, -1, None, None, 'CCGC'),
          'compsite': '(?P<SsiI>CCGC)|(?P<SsiI_as>GCGG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCGC',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'SspBI': {'charac': (1, -1, None, None, 'TGTACA'),
           'compsite': '(?P<SspBI>TGTACA)|(?P<SspBI_as>TGTACA)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GTAC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGTACA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M',)},
 'SspD5I': {'charac': (13, 8, None, None, 'GGTGA'),
            'compsite': '(?P<SspD5I>GGTGA)|(?P<SspD5I_as>TCACC)',
            'dna': None,
            'freq': 1024,
            'fst3': 8,
            'fst5': 13,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 0,
            'ovhgseq': '',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GGTGA',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'SspI': {'charac': (3, -3, None, None, 'AATATT'),
          'compsite': '(?P<SspI>AATATT)|(?P<SspI_as>AATATT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AATATT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'G',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'SstI': {'charac': (5, -5, None, None, 'GAGCTC'),
          'compsite': '(?P<SstI>GAGCTC)|(?P<SstI_as>GAGCTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'AGCT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAGCTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('C',)},
 'Sth132I': {'charac': (8, 8, None, None, 'CCCG'),
             'compsite': '(?P<Sth132I>CCCG)|(?P<Sth132I_as>CGGG)',
             'dna': None,
             'freq': 256,
             'fst3': 8,
             'fst5': 8,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'NNNN',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CCCG',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ()},
 'StrI': {'charac': (1, -1, None, None, 'CTCGAG'),
          'compsite': '(?P<StrI>CTCGAG)|(?P<StrI_as>CTCGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TCGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('U',)},
 'StsI': {'charac': (15, 14, None, None, 'GGATG'),
          'compsite': '(?P<StsI>GGATG)|(?P<StsI_as>CATCC)',
          'dna': None,
          'freq': 1024,
          'fst3': 14,
          'fst5': 15,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'NNNN',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGATG',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'StuI': {'charac': (3, -3, None, None, 'AGGCCT'),
          'compsite': '(?P<StuI>AGGCCT)|(?P<StuI_as>AGGCCT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGGCCT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'J',
                    'K',
                    'M',
                    'N',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'StyD4I': {'charac': (0, 0, None, None, 'CCNGG'),
            'compsite': '(?P<StyD4I>CC.GG)|(?P<StyD4I_as>CC.GG)',
            'dna': None,
            'freq': 256,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'CCNGG',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCNGG',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'StyI': {'charac': (1, -1, None, None, 'CCWWGG'),
          'compsite': '(?P<StyI>CC[AT][AT]GG)|(?P<StyI_as>CC[AT][AT]GG)',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CWWG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCWWGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('C', 'E', 'G', 'J', 'M', 'N', 'R', 'S')},
 'SunI': {'charac': (1, -1, None, None, 'CGTACG'),
          'compsite': '(?P<SunI>CGTACG)|(?P<SunI_as>CGTACG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GTAC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CGTACG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('V',)},
 'SwaI': {'charac': (4, -4, None, None, 'ATTTAAAT'),
          'compsite': '(?P<SwaI>ATTTAAAT)|(?P<SwaI_as>ATTTAAAT)',
          'dna': None,
          'freq': 65536,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATTTAAAT',
          'size': 8,
          'substrat': 'DNA',
          'suppl': ('G', 'K', 'M', 'N', 'S')},
 'TaaI': {'charac': (3, -3, None, None, 'ACNGT'),
          'compsite': '(?P<TaaI>AC.GT)|(?P<TaaI_as>AC.GT)',
          'dna': None,
          'freq': 256,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACNGT',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'TaiI': {'charac': (4, -4, None, None, 'ACGT'),
          'compsite': '(?P<TaiI>ACGT)|(?P<TaiI_as>ACGT)',
          'dna': None,
          'freq': 256,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'ACGT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACGT',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'TaqI': {'charac': (1, -1, None, None, 'TCGA'),
          'compsite': '(?P<TaqI>TCGA)|(?P<TaqI_as>TCGA)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCGA',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('A',
                    'C',
                    'E',
                    'F',
                    'I',
                    'J',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'TaqII': {'charac': (17, 9, None, None, 'CACCCA|GACCGA'),
           'compsite': '(?P<TaqII>CACCCA)|(?P<TaqII_as>TGGGTG)',
           'dna': None,
           'freq': 4096,
           'fst3': 9,
           'fst5': 17,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 2,
           'ovhgseq': '(?P<TaqII>CACCCA|GACCGA)|(?P<TaqII_as>TGGGTG|TCGGTC)',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CACCCA|GACCGA',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('X',)},
 'TatI': {'charac': (1, -1, None, None, 'WGTACW'),
          'compsite': '(?P<TatI>[AT]GTAC[AT])|(?P<TatI_as>[AT]GTAC[AT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'GTAC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'WGTACW',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'TauI': {'charac': (4, -4, None, None, 'GCSGC'),
          'compsite': '(?P<TauI>GC[CG]GC)|(?P<TauI_as>GC[CG]GC)',
          'dna': None,
          'freq': 512,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 3,
          'ovhgseq': 'CSG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCSGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'TelI': {'charac': (4, -4, None, None, 'GACNNNGTC'),
          'compsite': '(?P<TelI>GAC...GTC)|(?P<TelI_as>GAC...GTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACNNNGTC',
          'size': 9,
          'substrat': 'DNA',
          'suppl': ('V',)},
 'TfiI': {'charac': (1, -1, None, None, 'GAWTC'),
          'compsite': '(?P<TfiI>GA[AT]TC)|(?P<TfiI_as>GA[AT]TC)',
          'dna': None,
          'freq': 512,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'AWT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAWTC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'TliI': {'charac': (1, -1, None, None, 'CTCGAG'),
          'compsite': '(?P<TliI>CTCGAG)|(?P<TliI_as>CTCGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TCGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'Tru1I': {'charac': (1, -1, None, None, 'TTAA'),
           'compsite': '(?P<Tru1I>TTAA)|(?P<Tru1I_as>TTAA)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'TA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TTAA',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'Tru9I': {'charac': (1, -1, None, None, 'TTAA'),
           'compsite': '(?P<Tru9I>TTAA)|(?P<Tru9I_as>TTAA)',
           'dna': None,
           'freq': 256,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'TA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TTAA',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('G', 'I', 'M', 'R')},
 'TscI': {'charac': (4, -4, None, None, 'ACGT'),
          'compsite': '(?P<TscI>ACGT)|(?P<TscI_as>ACGT)',
          'dna': None,
          'freq': 256,
          'fst3': -4,
          'fst5': 4,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'ACGT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ACGT',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('G',)},
 'TseI': {'charac': (1, -1, None, None, 'GCWGC'),
          'compsite': '(?P<TseI>GC[AT]GC)|(?P<TseI_as>GC[AT]GC)',
          'dna': None,
          'freq': 512,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -3,
          'ovhgseq': 'CWG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GCWGC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'TsoI': {'charac': (None, None, None, None, 'TARCCA'),
          'compsite': '(?P<TsoI>TA[AG]CCA)|(?P<TsoI_as>TGG[CT]TA)',
          'dna': None,
          'freq': 2048,
          'fst3': None,
          'fst5': None,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': None,
          'ovhgseq': None,
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TARCCA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ()},
 'Tsp45I': {'charac': (0, 0, None, None, 'GTSAC'),
            'compsite': '(?P<Tsp45I>GT[CG]AC)|(?P<Tsp45I_as>GT[CG]AC)',
            'dna': None,
            'freq': 512,
            'fst3': 0,
            'fst5': 0,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -5,
            'ovhgseq': 'GTSAC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GTSAC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('N',)},
 'Tsp4CI': {'charac': (3, -3, None, None, 'ACNGT'),
            'compsite': '(?P<Tsp4CI>AC.GT)|(?P<Tsp4CI_as>AC.GT)',
            'dna': None,
            'freq': 256,
            'fst3': -3,
            'fst5': 3,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 1,
            'ovhgseq': 'N',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACNGT',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'Tsp509I': {'charac': (0, 0, None, None, 'AATT'),
             'compsite': '(?P<Tsp509I>AATT)|(?P<Tsp509I_as>AATT)',
             'dna': None,
             'freq': 256,
             'fst3': 0,
             'fst5': 0,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'AATT',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'AATT',
             'size': 4,
             'substrat': 'DNA',
             'suppl': ('N',)},
 'TspDTI': {'charac': (16, 9, None, None, 'ATGAA'),
            'compsite': '(?P<TspDTI>ATGAA)|(?P<TspDTI_as>TTCAT)',
            'dna': None,
            'freq': 1024,
            'fst3': 9,
            'fst5': 16,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ATGAA',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'TspEI': {'charac': (0, 0, None, None, 'AATT'),
           'compsite': '(?P<TspEI>AATT)|(?P<TspEI_as>AATT)',
           'dna': None,
           'freq': 256,
           'fst3': 0,
           'fst5': 0,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'AATT',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'AATT',
           'size': 4,
           'substrat': 'DNA',
           'suppl': ('O',)},
 'TspGWI': {'charac': (16, 9, None, None, 'ACGGA'),
            'compsite': '(?P<TspGWI>ACGGA)|(?P<TspGWI_as>TCCGT)',
            'dna': None,
            'freq': 1024,
            'fst3': 9,
            'fst5': 16,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 2,
            'ovhgseq': 'NN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'ACGGA',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ('X',)},
 'TspRI': {'charac': (7, -7, None, None, 'CASTG'),
           'compsite': '(?P<TspRI>CA[CG]TG)|(?P<TspRI_as>CA[CG]TG)',
           'dna': None,
           'freq': 512,
           'fst3': -7,
           'fst5': 7,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 10,
           'ovhgseq': 'NNCASTGNN',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CASTG',
           'size': 5,
           'substrat': 'DNA',
           'suppl': ('G', 'N')},
 'Tth111I': {'charac': (4, -4, None, None, 'GACNNNGTC'),
             'compsite': '(?P<Tth111I>GAC...GTC)|(?P<Tth111I_as>GAC...GTC)',
             'dna': None,
             'freq': 4096,
             'fst3': -4,
             'fst5': 4,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -1,
             'ovhgseq': 'N',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'GACNNNGTC',
             'size': 9,
             'substrat': 'DNA',
             'suppl': ('G', 'I', 'K', 'N', 'Q', 'R', 'X')},
 'Tth111II': {'charac': (17, 9, None, None, 'CAARCA'),
              'compsite': '(?P<Tth111II>CAA[AG]CA)|(?P<Tth111II_as>TG[CT]TTG)',
              'dna': None,
              'freq': 2048,
              'fst3': 9,
              'fst5': 17,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': 2,
              'ovhgseq': 'NN',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'CAARCA',
              'size': 6,
              'substrat': 'DNA',
              'suppl': ()},
 'UbaF2I': {'charac': (None, None, None, None, 'GAAAYNNNNNRTG'),
            'compsite': '(?P<UbaF2I>GAAA[CT].....[AG]TG)|(?P<UbaF2I_as>CA[CT].....[AG]TTTC)',
            'dna': None,
            'freq': 16384,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GAAAYNNNNNRTG',
            'size': 13,
            'substrat': 'DNA',
            'suppl': ()},
 'UbaF3I': {'charac': (None, None, None, None, 'CACNNNNNNTCC'),
            'compsite': '(?P<UbaF3I>CAC......TCC)|(?P<UbaF3I_as>GGA......GTG)',
            'dna': None,
            'freq': 4096,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CACNNNNNNTCC',
            'size': 12,
            'substrat': 'DNA',
            'suppl': ()},
 'UbaF4I': {'charac': (None, None, None, None, 'GAANNNNNNNTTGG'),
            'compsite': '(?P<UbaF4I>GAA.......TTGG)|(?P<UbaF4I_as>CCAA.......TTC)',
            'dna': None,
            'freq': 16384,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GAANNNNNNNTTGG',
            'size': 14,
            'substrat': 'DNA',
            'suppl': ()},
 'UbaF5I': {'charac': (None, None, None, None, 'CTGATG'),
            'compsite': '(?P<UbaF5I>CTGATG)|(?P<UbaF5I_as>CATCAG)',
            'dna': None,
            'freq': 4096,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CTGATG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'UbaF6I': {'charac': (None, None, None, None, 'GCGAC'),
            'compsite': '(?P<UbaF6I>GCGAC)|(?P<UbaF6I_as>GTCGC)',
            'dna': None,
            'freq': 1024,
            'fst3': None,
            'fst5': None,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': None,
            'ovhgseq': None,
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'GCGAC',
            'size': 5,
            'substrat': 'DNA',
            'suppl': ()},
 'UbaPI': {'charac': (None, None, None, None, 'CGAACG'),
           'compsite': '(?P<UbaPI>CGAACG)|(?P<UbaPI_as>CGTTCG)',
           'dna': None,
           'freq': 4096,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CGAACG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'UbaTI': {'charac': (None, None, None, None, 'TGANNNNNNTCA'),
           'compsite': '(?P<UbaTI>TGA......TCA)|(?P<UbaTI_as>TGA......TCA)',
           'dna': None,
           'freq': 4096,
           'fst3': None,
           'fst5': None,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': None,
           'ovhgseq': None,
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'TGANNNNNNTCA',
           'size': 12,
           'substrat': 'DNA',
           'suppl': ()},
 'UnbI': {'charac': (0, 0, None, None, 'GGNCC'),
          'compsite': '(?P<UnbI>GG.CC)|(?P<UnbI_as>GG.CC)',
          'dna': None,
          'freq': 256,
          'fst3': 0,
          'fst5': 0,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -5,
          'ovhgseq': 'GGNCC',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GGNCC',
          'size': 5,
          'substrat': 'DNA',
          'suppl': ()},
 'UthSI': {'charac': (2, -2, None, None, 'CCCGGG'),
           'compsite': '(?P<UthSI>CCCGGG)|(?P<UthSI_as>CCCGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -2,
           'fst5': 2,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -2,
           'ovhgseq': 'CG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCGGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ()},
 'Van91I': {'charac': (7, -7, None, None, 'CCANNNNNTGG'),
            'compsite': '(?P<Van91I>CCA.....TGG)|(?P<Van91I_as>CCA.....TGG)',
            'dna': None,
            'freq': 4096,
            'fst3': -7,
            'fst5': 7,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': 3,
            'ovhgseq': 'NNN',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CCANNNNNTGG',
            'size': 11,
            'substrat': 'DNA',
            'suppl': ('A', 'F', 'G', 'K', 'M')},
 'Vha464I': {'charac': (1, -1, None, None, 'CTTAAG'),
             'compsite': '(?P<Vha464I>CTTAAG)|(?P<Vha464I_as>CTTAAG)',
             'dna': None,
             'freq': 4096,
             'fst3': -1,
             'fst5': 1,
             'inact_temp': 65,
             'opt_temp': 37,
             'ovhg': -4,
             'ovhgseq': 'TTAA',
             'results': None,
             'scd3': None,
             'scd5': None,
             'site': 'CTTAAG',
             'size': 6,
             'substrat': 'DNA',
             'suppl': ('I',)},
 'VneI': {'charac': (1, -1, None, None, 'GTGCAC'),
          'compsite': '(?P<VneI>GTGCAC)|(?P<VneI_as>GTGCAC)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TGCA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTGCAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'VpaK11AI': {'charac': (0, 0, None, None, 'GGWCC'),
              'compsite': '(?P<VpaK11AI>GG[AT]CC)|(?P<VpaK11AI_as>GG[AT]CC)',
              'dna': None,
              'freq': 512,
              'fst3': 0,
              'fst5': 0,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -5,
              'ovhgseq': 'GGWCC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GGWCC',
              'size': 5,
              'substrat': 'DNA',
              'suppl': ()},
 'VpaK11BI': {'charac': (1, -1, None, None, 'GGWCC'),
              'compsite': '(?P<VpaK11BI>GG[AT]CC)|(?P<VpaK11BI_as>GG[AT]CC)',
              'dna': None,
              'freq': 512,
              'fst3': -1,
              'fst5': 1,
              'inact_temp': 65,
              'opt_temp': 37,
              'ovhg': -3,
              'ovhgseq': 'GWC',
              'results': None,
              'scd3': None,
              'scd5': None,
              'site': 'GGWCC',
              'size': 5,
              'substrat': 'DNA',
              'suppl': ('K',)},
 'VspI': {'charac': (2, -2, None, None, 'ATTAAT'),
          'compsite': '(?P<VspI>ATTAAT)|(?P<VspI_as>ATTAAT)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATTAAT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('E', 'F', 'I', 'R')},
 'XagI': {'charac': (5, -5, None, None, 'CCTNNNNNAGG'),
          'compsite': '(?P<XagI>CCT.....AGG)|(?P<XagI_as>CCT.....AGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCTNNNNNAGG',
          'size': 11,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'XapI': {'charac': (1, -1, None, None, 'RAATTY'),
          'compsite': '(?P<XapI>[AG]AATT[CT])|(?P<XapI_as>[AG]AATT[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'AATT',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RAATTY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'XbaI': {'charac': (1, -1, None, None, 'TCTAGA'),
          'compsite': '(?P<XbaI>TCTAGA)|(?P<XbaI_as>TCTAGA)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CTAG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'TCTAGA',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'H',
                    'I',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'V',
                    'X')},
 'XceI': {'charac': (5, -5, None, None, 'RCATGY'),
          'compsite': '(?P<XceI>[AG]CATG[CT])|(?P<XceI_as>[AG]CATG[CT])',
          'dna': None,
          'freq': 1024,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 4,
          'ovhgseq': 'CATG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'RCATGY',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'XcmI': {'charac': (8, -8, None, None, 'CCANNNNNNNNNTGG'),
          'compsite': '(?P<XcmI>CCA.........TGG)|(?P<XcmI_as>CCA.........TGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -8,
          'fst5': 8,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 1,
          'ovhgseq': 'N',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCANNNNNNNNNTGG',
          'size': 15,
          'substrat': 'DNA',
          'suppl': ('N',)},
 'XhoI': {'charac': (1, -1, None, None, 'CTCGAG'),
          'compsite': '(?P<XhoI>CTCGAG)|(?P<XhoI_as>CTCGAG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'TCGA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTCGAG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('A',
                    'E',
                    'F',
                    'G',
                    'H',
                    'J',
                    'K',
                    'M',
                    'N',
                    'O',
                    'Q',
                    'R',
                    'S',
                    'U',
                    'X')},
 'XhoII': {'charac': (1, -1, None, None, 'RGATCY'),
           'compsite': '(?P<XhoII>[AG]GATC[CT])|(?P<XhoII_as>[AG]GATC[CT])',
           'dna': None,
           'freq': 1024,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'GATC',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'RGATCY',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('G', 'M', 'R')},
 'XmaCI': {'charac': (1, -1, None, None, 'CCCGGG'),
           'compsite': '(?P<XmaCI>CCCGGG)|(?P<XmaCI_as>CCCGGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CCGG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCCGGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('M', 'V')},
 'XmaI': {'charac': (1, -1, None, None, 'CCCGGG'),
          'compsite': '(?P<XmaI>CCCGGG)|(?P<XmaI_as>CCCGGG)',
          'dna': None,
          'freq': 4096,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -4,
          'ovhgseq': 'CCGG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CCCGGG',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N', 'R', 'U')},
 'XmaIII': {'charac': (1, -1, None, None, 'CGGCCG'),
            'compsite': '(?P<XmaIII>CGGCCG)|(?P<XmaIII_as>CGGCCG)',
            'dna': None,
            'freq': 4096,
            'fst3': -1,
            'fst5': 1,
            'inact_temp': 65,
            'opt_temp': 37,
            'ovhg': -4,
            'ovhgseq': 'GGCC',
            'results': None,
            'scd3': None,
            'scd5': None,
            'site': 'CGGCCG',
            'size': 6,
            'substrat': 'DNA',
            'suppl': ()},
 'XmaJI': {'charac': (1, -1, None, None, 'CCTAGG'),
           'compsite': '(?P<XmaJI>CCTAGG)|(?P<XmaJI_as>CCTAGG)',
           'dna': None,
           'freq': 4096,
           'fst3': -1,
           'fst5': 1,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': -4,
           'ovhgseq': 'CTAG',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'CCTAGG',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('F',)},
 'XmiI': {'charac': (2, -2, None, None, 'GTMKAC'),
          'compsite': '(?P<XmiI>GT[AC][GT]AC)|(?P<XmiI_as>GT[AC][GT]AC)',
          'dna': None,
          'freq': 1024,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'MK',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GTMKAC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('F',)},
 'XmnI': {'charac': (5, -5, None, None, 'GAANNNNTTC'),
          'compsite': '(?P<XmnI>GAA....TTC)|(?P<XmnI_as>GAA....TTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -5,
          'fst5': 5,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GAANNNNTTC',
          'size': 10,
          'substrat': 'DNA',
          'suppl': ('E', 'G', 'N', 'R', 'U')},
 'XspI': {'charac': (1, -1, None, None, 'CTAG'),
          'compsite': '(?P<XspI>CTAG)|(?P<XspI_as>CTAG)',
          'dna': None,
          'freq': 256,
          'fst3': -1,
          'fst5': 1,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'TA',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'CTAG',
          'size': 4,
          'substrat': 'DNA',
          'suppl': ('K',)},
 'ZhoI': {'charac': (2, -2, None, None, 'ATCGAT'),
          'compsite': '(?P<ZhoI>ATCGAT)|(?P<ZhoI_as>ATCGAT)',
          'dna': None,
          'freq': 4096,
          'fst3': -2,
          'fst5': 2,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': -2,
          'ovhgseq': 'CG',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'ATCGAT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('V',)},
 'ZraI': {'charac': (3, -3, None, None, 'GACGTC'),
          'compsite': '(?P<ZraI>GACGTC)|(?P<ZraI_as>GACGTC)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'GACGTC',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I', 'N')},
 'ZrmI': {'charac': (3, -3, None, None, 'AGTACT'),
          'compsite': '(?P<ZrmI>AGTACT)|(?P<ZrmI_as>AGTACT)',
          'dna': None,
          'freq': 4096,
          'fst3': -3,
          'fst5': 3,
          'inact_temp': 65,
          'opt_temp': 37,
          'ovhg': 0,
          'ovhgseq': '',
          'results': None,
          'scd3': None,
          'scd5': None,
          'site': 'AGTACT',
          'size': 6,
          'substrat': 'DNA',
          'suppl': ('I',)},
 'Zsp2I': {'charac': (5, -5, None, None, 'ATGCAT'),
           'compsite': '(?P<Zsp2I>ATGCAT)|(?P<Zsp2I_as>ATGCAT)',
           'dna': None,
           'freq': 4096,
           'fst3': -5,
           'fst5': 5,
           'inact_temp': 65,
           'opt_temp': 37,
           'ovhg': 4,
           'ovhgseq': 'TGCA',
           'results': None,
           'scd3': None,
           'scd5': None,
           'site': 'ATGCAT',
           'size': 6,
           'substrat': 'DNA',
           'suppl': ('I',)}}
suppliers = \
{'A': ('Amersham Pharmacia Biotech',
       ['BssHII',
        'XbaI',
        'MluI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'PmaCI',
        'SnaBI',
        'NcoI',
        'ClaI',
        'Bpu1102I',
        'DraI',
        'BstXI',
        'PshAI',
        'AvaI',
        'PvuI',
        'Van91I',
        'TaqI',
        'EaeI',
        'KpnI',
        'NdeI',
        'HapII',
        'Cfr13I',
        'MboII',
        'AflII',
        'SfiI',
        'EcoT14I',
        'BglII',
        'NaeI',
        'AccII',
        'SacII',
        'Aor51HI',
        'NruI',
        'MvaI',
        'Sse8387I',
        'CpoI',
        'HincII',
        'MboI',
        'AluI',
        'SmaI',
        'NheI',
        'StuI',
        'SphI',
        'PvuII',
        'FokI',
        'ApaLI',
        'SpeI',
        'HinfI',
        'EcoO109I',
        'BbeI',
        'HindIII',
        'EcoRV',
        'AatII',
        'EcoRI',
        'XhoI',
        'Bsp1286I',
        'PstI',
        'Sau3AI',
        'BlnI',
        'HaeIII',
        'AccI',
        'SspI',
        'FbaI',
        'Eco81I',
        'FseI',
        'ApaI',
        'EcoT22I',
        'ScaI',
        'BalI',
        'AfaI',
        'NotI',
        'BamHI',
        'AvaII',
        'HpaI',
        'HhaI']),
 'C': ('Minotech Biotechnology',
       ['SgrBI',
        'BclI',
        'BglI',
        'SalI',
        'PspPI',
        'SnaBI',
        'NcoI',
        'BshFI',
        'AsuII',
        'BssAI',
        'BseAI',
        'TaqI',
        'KpnI',
        'SfiI',
        'BglII',
        'NaeI',
        'BseBI',
        'NruI',
        'RsaI',
        'BsiSI',
        'MboI',
        'AluI',
        'SseBI',
        'SmaI',
        'SphI',
        'PvuII',
        'SstI',
        'HinfI',
        'MspCI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'BseCI',
        'PstI',
        'SlaI',
        'SspI',
        'CspAI',
        'ScaI',
        'NotI',
        'BamHI',
        'HpaI',
        'StyI']),
 'E': ('Stratagene',
       ['BssHII',
        'XbaI',
        'MluI',
        'SanDI',
        'BclI',
        'SalI',
        'SnaBI',
        'PalI',
        'NcoI',
        'XmnI',
        'Eco47III',
        'Bpu1102I',
        'BstXI',
        'AvaI',
        'PvuI',
        'DpnI',
        'TaqI',
        'KpnI',
        'BstNI',
        'NdeI',
        'SfiI',
        'BglII',
        'NaeI',
        'SacII',
        'NruI',
        'CspI',
        'NarI',
        'Bsu36I',
        'RsaI',
        'HincII',
        'BspCI',
        'BanI',
        'AluI',
        'EcoRII',
        'SmaI',
        'NheI',
        'PspAI',
        'StuI',
        'SphI',
        'NciI',
        'PvuII',
        'SpeI',
        'Eam1104I',
        'DraIII',
        'EcoO109I',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'MnlI',
        'AccIII',
        'MunI',
        'PstI',
        'VspI',
        'AccI',
        'SspI',
        'SrfI',
        'NsiI',
        'ApaI',
        'ScaI',
        'DdeI',
        'NotI',
        'BamHI',
        'Bsp106I',
        'StyI']),
 'F': ('Fermentas AB',
       ['XbaI',
        'BshTI',
        'MluI',
        'Bsp1407I',
        'HpaII',
        'BclI',
        'SacI',
        'PauI',
        'BglI',
        'SalI',
        'MspI',
        'Bsu15I',
        'Mva1269I',
        'Bsp68I',
        'LweI',
        'SmiI',
        'NcoI',
        'PsyI',
        'BseJI',
        'Eco24I',
        'Eco47III',
        'Bpu1102I',
        'DraI',
        'BseXI',
        'BstXI',
        'Esp3I',
        'BseSI',
        'Cfr9I',
        'AarI',
        'PvuI',
        'DpnI',
        'Hin6I',
        'Van91I',
        'Bst1107I',
        'Bme1390I',
        'BveI',
        'Psp5II',
        'Mph1103I',
        'TaqI',
        'Eco52I',
        'BfiI',
        'KpnI',
        'Kpn2I',
        'SsiI',
        'MlsI',
        'NdeI',
        'PpiI',
        'Cfr13I',
        'MboII',
        'SfiI',
        'SdaI',
        'BglII',
        'AloI',
        'FspBI',
        'SchI',
        'PfoI',
        'Bpu10I',
        'BshNI',
        'Acc65I',
        'XapI',
        'TaaI',
        'MvaI',
        'PasI',
        'Hin1II',
        'Bsh1236I',
        'CpoI',
        'Eco130I',
        'TaiI',
        'FspAI',
        'BfmI',
        'Eco47I',
        'BoxI',
        'RsaI',
        'HincII',
        'HpyF10VI',
        'Cfr10I',
        'Bsp119I',
        'MboI',
        'AluI',
        'SduI',
        'Bsp143II',
        'BseGI',
        'Eco72I',
        'Eco57I',
        'Alw21I',
        'Hpy8I',
        'PsuI',
        'PaeI',
        'SmaI',
        'NheI',
        'BplI',
        'FaqI',
        'AdeI',
        'BcuI',
        'BspTI',
        'GsuI',
        'BseLI',
        'AasI',
        'PvuII',
        'XagI',
        'EheI',
        'Hin1I',
        'Alw26I',
        'Eco31I',
        'HinfI',
        'Eam1105I',
        'BsuRI',
        'XmiI',
        'Eam1104I',
        'Ecl136II',
        'XmaJI',
        'HphI',
        'Psp1406I',
        'Csp6I',
        'EcoO109I',
        'BseMII',
        'HindIII',
        'AatII',
        'BfuI',
        'EcoRI',
        'TauI',
        'XhoI',
        'Bsp143I',
        'BspPI',
        'CfrI',
        'MnlI',
        'PfeI',
        'CaiI',
        'Eco91I',
        'MunI',
        'Tru1I',
        'BspLI',
        'SmuI',
        'Eco105I',
        'NsbI',
        'PstI',
        'VspI',
        'Alw44I',
        'BpiI',
        'XceI',
        'BseMI',
        'Eco57MI',
        'Cfr42I',
        'SatI',
        'Hin4I',
        'SspI',
        'Eco32I',
        'BseDI',
        'KspAI',
        'Eco81I',
        'BauI',
        'MssI',
        'ApaI',
        'Eco88I',
        'ScaI',
        'AlfI',
        'BcnI',
        'Eco147I',
        'OliI',
        'PdmI',
        'NmuCI',
        'Bsp120I',
        'NotI',
        'MbiI',
        'BamHI',
        'TatI',
        'Pfl23II',
        'Bsh1285I',
        'HhaI',
        'BseNI',
        'PagI',
        'PdiI']),
 'G': ('Qbiogene',
       ['XbaI',
        'MluI',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'BstEII',
        'TspRI',
        'NcoI',
        'DraII',
        'XmnI',
        'Eco47III',
        'DraI',
        'BstXI',
        'SwaI',
        'AvaI',
        'PvuI',
        'DpnI',
        'Van91I',
        'SinI',
        'KpnI',
        'Sau96I',
        'HaeII',
        'NdeI',
        'MboII',
        'SfiI',
        'BglII',
        'SacII',
        'Acc65I',
        'BspXI',
        'NruI',
        'MvaI',
        'NarI',
        'RsaI',
        'HincII',
        'AflIII',
        'Cfr10I',
        'MboI',
        'AluI',
        'CfoI',
        'SmaI',
        'NheI',
        'XhoII',
        'SphI',
        'NciI',
        'PvuII',
        'FokI',
        'SpeI',
        'HinfI',
        'DraIII',
        'HindIII',
        'EcoRV',
        'AatII',
        'EcoRI',
        'XhoI',
        'MnlI',
        'AccIII',
        'EagI',
        'AscI',
        'AhdI',
        'NlaIII',
        'PstI',
        'Sau3AI',
        'HaeIII',
        'NdeII',
        'AccI',
        'SspI',
        'Tth111I',
        'NsiI',
        'PmeI',
        'ApaI',
        'ScaI',
        'AgeI',
        'BsaMI',
        'PacI',
        'NlaIV',
        'Tru9I',
        'DdeI',
        'Bsp120I',
        'NotI',
        'BamHI',
        'BslI',
        'AvaII',
        'HpaI',
        'StyI',
        'HhaI',
        'TscI',
        'BseNI']),
 'H': ('American Allied Biochemical, Inc.',
       ['XbaI',
        'MluI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BstEII',
        'NcoI',
        'ClaI',
        'BstXI',
        'KpnI',
        'BglII',
        'SacII',
        'RsaI',
        'HincII',
        'AluI',
        'SmaI',
        'SphI',
        'PvuII',
        'SpeI',
        'HinfI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'PstI',
        'Sau3AI',
        'HaeIII',
        'NsiI',
        'NotI',
        'BamHI',
        'HpaI']),
 'I': ('SibEnzyme Ltd.',
       ['AsuNHI',
        'XbaI',
        'MluI',
        'BstHHI',
        'HpaII',
        'AhlI',
        'PspN4I',
        'BglI',
        'SalI',
        'MspI',
        'VneI',
        'BsoMAI',
        'BmtI',
        'PspXI',
        'CciNI',
        'Sfr274I',
        'SmiI',
        'Ksp22I',
        'BstSFI',
        'BssT1I',
        'MspA1I',
        'Bsp19I',
        'Bse1I',
        'AspS9I',
        'FauNDI',
        'BstMWI',
        'AclWI',
        'DraI',
        'Bst2UI',
        'Vha464I',
        'PsrI',
        'BstACI',
        'BstXI',
        'BstDEI',
        'BstF5I',
        'BstMBI',
        'BstENI',
        'BssECI',
        'FalI',
        'EgeI',
        'Ama87I',
        'BstDSI',
        'BstV2I',
        'AjnI',
        'Bsc4I',
        'DseDI',
        'BstAUI',
        'Bpu14I',
        'TaqI',
        'KpnI',
        'BstSNI',
        'AclI',
        'MboII',
        'SfiI',
        'BglII',
        'AcsI',
        'BstNSI',
        'BseX3I',
        'Bpu10I',
        'Rsr2I',
        'Acc65I',
        'PspEI',
        'BstH2I',
        'NruI',
        'Ple19I',
        'SmiMI',
        'PciI',
        'Bse118I',
        'Bst2BI',
        'BsePI',
        'BstMCI',
        'Bme18I',
        'RsaI',
        'BssNAI',
        'BstV1I',
        'Bsp13I',
        'Bst4CI',
        'MabI',
        'AsuHPI',
        'BtrI',
        'BstC8I',
        'Psp124BI',
        'HgaI',
        'BstX2I',
        'AluI',
        'ZraI',
        'Bse21I',
        'Sfr303I',
        'BstSCI',
        'MhlI',
        'Zsp2I',
        'Bse3DI',
        'Bso31I',
        'AccB7I',
        'BstKTI',
        'AccBSI',
        'SmaI',
        'PsiI',
        'AspA2I',
        'PspPPI',
        'Bsp1720I',
        'AspLEI',
        'SphI',
        'Mly113I',
        'FriOI',
        'PvuII',
        'ErhI',
        'FokI',
        'AsuC2I',
        'HinfI',
        'BsuRI',
        'PpsI',
        'BstPAI',
        'HspAI',
        'Fsp4HI',
        'Kzo9I',
        'Acc36I',
        'DraIII',
        'Acc16I',
        'MspR9I',
        'HindIII',
        'EcoRV',
        'AatII',
        'MroXI',
        'EcoRI',
        'ZrmI',
        'BstFNI',
        'BslFI',
        'Bsa29I',
        'MnlI',
        'SbfI',
        'PstI',
        'Bse8I',
        'FauI',
        'VspI',
        'Bst6I',
        'PspLI',
        'Msp20I',
        'Bbv12I',
        'HaeIII',
        'BstAPI',
        'SspI',
        'AfeI',
        'Tth111I',
        'PspOMI',
        'ApaI',
        'FblI',
        'PctI',
        'BpmI',
        'XmaI',
        'AcuI',
        'AccB1I',
        'PceI',
        'Sse9I',
        'Tru9I',
        'BstBAI',
        'DriI',
        'MroNI',
        'EcoICRI',
        'FatI',
        'BamHI',
        'Psp6I',
        'SfaNI',
        'HpaI',
        'AsiAI',
        'PspCI',
        'HindII']),
 'J': ('Nippon Gene Co., Ltd.',
       ['BssHII',
        'XbaI',
        'AxyI',
        'MluI',
        'BclI',
        'SacI',
        'EcoT38I',
        'BglI',
        'SalI',
        'MspI',
        'BstEII',
        'NcoI',
        'DraI',
        'BstXI',
        'AvaI',
        'TaqI',
        'AseI',
        'KpnI',
        'Sau96I',
        'HaeII',
        'NdeI',
        'MboII',
        'AflII',
        'SfiI',
        'BglII',
        'AccII',
        'SacII',
        'NruI',
        'NarI',
        'RsaI',
        'HincII',
        'AluI',
        'ScrFI',
        'EcoRII',
        'SmaI',
        'NheI',
        'StuI',
        'SphI',
        'NciI',
        'FspI',
        'PvuII',
        'FokI',
        'SpeI',
        'HinfI',
        'EcoO109I',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'Bsp1286I',
        'AccIII',
        'PstI',
        'BsmI',
        'Alw44I',
        'Sau3AI',
        'HaeIII',
        'NdeII',
        'AccI',
        'SspI',
        'NsiI',
        'ApaI',
        'ScaI',
        'AgeI',
        'NspV',
        'BalI',
        'NotI',
        'AcyI',
        'BamHI',
        'AvaII',
        'HpaI',
        'StyI',
        'HhaI']),
 'K': ('Takara Shuzo Co. Ltd.',
       ['BssHII',
        'XbaI',
        'MluI',
        'Bsp1407I',
        'BspT107I',
        'SacI',
        'XspI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'PmaCI',
        'SnaBI',
        'NcoI',
        'ClaI',
        'Bpu1102I',
        'DraI',
        'BstXI',
        'PshAI',
        'SwaI',
        'AvaI',
        'PvuI',
        'Van91I',
        'Bst1107I',
        'EaeI',
        'Eco52I',
        'BspT104I',
        'KpnI',
        'HaeII',
        'EcoO65I',
        'NdeI',
        'HapII',
        'Cfr13I',
        'MboII',
        'AflII',
        'SfiI',
        'EcoT14I',
        'BglII',
        'NaeI',
        'AccII',
        'SacII',
        'Aor51HI',
        'NruI',
        'MvaI',
        'Sse8387I',
        'CpoI',
        'HincII',
        'Cfr10I',
        'MboI',
        'AluI',
        'SmaI',
        'NheI',
        'StuI',
        'SphI',
        'PvuII',
        'MflI',
        'FokI',
        'Hin1I',
        'ApaLI',
        'SpeI',
        'HinfI',
        'Eam1105I',
        'Psp1406I',
        'EcoO109I',
        'BbeI',
        'HindIII',
        'EcoRV',
        'AatII',
        'EcoRI',
        'XhoI',
        'VpaK11BI',
        'Bsp1286I',
        'AccIII',
        'MunI',
        'PstI',
        'Sau3AI',
        'BlnI',
        'HaeIII',
        'AccI',
        'SspI',
        'Tth111I',
        'FbaI',
        'Eco81I',
        'FseI',
        'ApaI',
        'PshBI',
        'EcoT22I',
        'BstPI',
        'ScaI',
        'BcnI',
        'NspV',
        'BalI',
        'AfaI',
        'NotI',
        'BamHI',
        'AvaII',
        'HpaI',
        'HhaI']),
 'M': ('Roche Applied Science',
       ['BssHII',
        'XbaI',
        'MluI',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'Asp718I',
        'MspI',
        'BanII',
        'SnaBI',
        'XmaCI',
        'BstEII',
        'NcoI',
        'ClaI',
        'DraII',
        'Eco47III',
        'DraI',
        'BstXI',
        'BspLU11I',
        'SwaI',
        'AspHI',
        'AvaI',
        'PvuI',
        'BseAI',
        'DpnI',
        'Van91I',
        'Bst1107I',
        'BsiWI',
        'TaqI',
        'BsiYI',
        'EaeI',
        'SexAI',
        'KpnI',
        'Sau96I',
        'HaeII',
        'NdeI',
        'PinAI',
        'SfiI',
        'BglII',
        'AcsI',
        'NaeI',
        'MaeI',
        'AspI',
        'NruI',
        'MvaI',
        'BpuAI',
        'NarI',
        'RsaI',
        'MaeII',
        'AflIII',
        'AspEI',
        'Cfr10I',
        'MvnI',
        'AluI',
        'RsrII',
        'ScrFI',
        'EcoRII',
        'CfoI',
        'SmaI',
        'NheI',
        'XhoII',
        'StuI',
        'BbrPI',
        'SphI',
        'MaeIII',
        'PvuII',
        'SspBI',
        'FokI',
        'MamI',
        'SpeI',
        'HinfI',
        'Psp1406I',
        'DraIII',
        'MluNI',
        'HindIII',
        'EcoRV',
        'AatII',
        'EcoRI',
        'XhoI',
        'MunI',
        'EclXI',
        'PstI',
        'BsmI',
        'Alw44I',
        'Sau3AI',
        'BlnI',
        'HaeIII',
        'NdeII',
        'Ksp632I',
        'AccI',
        'SspI',
        'SgrAI',
        'NsiI',
        'ItaI',
        'ApaI',
        'SfuI',
        'ScaI',
        'BfrI',
        'NspI',
        'KspI',
        'Tru9I',
        'DdeI',
        'NotI',
        'MroI',
        'Asp700I',
        'AcyI',
        'RcaI',
        'BamHI',
        'AviII',
        'AvaII',
        'CelII',
        'HpaI',
        'StyI',
        'HindII',
        'BmyI']),
 'N': ('New England Biolabs',
       ['BssHII',
        'EciI',
        'BsrFI',
        'XbaI',
        'DpnII',
        'AlwI',
        'MluI',
        'AlwNI',
        'NgoMIV',
        'Fnu4HI',
        'HpaII',
        'BclI',
        'MlyI',
        'BsaWI',
        'SacI',
        'MwoI',
        'BfaI',
        'DrdI',
        'BmgBI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'TliI',
        'BmtI',
        'PspXI',
        'BsaBI',
        'SnaBI',
        'BstEII',
        'TspRI',
        'NcoI',
        'MspA1I',
        'BtgI',
        'ClaI',
        'BsaI',
        'BsrBI',
        'XmnI',
        'DraI',
        'Hpy99I',
        'StyD4I',
        'BstXI',
        'PspGI',
        'BsiHKAI',
        'BsoBI',
        'BfrBI',
        'BlpI',
        'PshAI',
        'BstF5I',
        'SwaI',
        'AvaI',
        'PvuI',
        'DpnI',
        'CspCI',
        'PflFI',
        'BpuEI',
        'BsiWI',
        'TaqI',
        'EaeI',
        'SexAI',
        'BsrI',
        'AseI',
        'KpnI',
        'Sau96I',
        'BstNI',
        'HaeII',
        'AclI',
        'ApoI',
        'HpyCH4IV',
        'NdeI',
        'MboII',
        'AflII',
        'SfiI',
        'TseI',
        'BglII',
        'SmlI',
        'NaeI',
        'Bpu10I',
        'SacII',
        'Acc65I',
        'AvrII',
        'NruI',
        'BaeI',
        'BssKI',
        'PciI',
        'MslI',
        'PhoI',
        'BcgI',
        'BsaHI',
        'BsrDI',
        'SfoI',
        'NarI',
        'Bsu36I',
        'RsaI',
        'HincII',
        'AflIII',
        'BsgI',
        'BfuAI',
        'TfiI',
        'PmlI',
        'BbvI',
        'MboI',
        'HgaI',
        'BanI',
        'AluI',
        'ZraI',
        'Hpy188III',
        'RsrII',
        'BspMI',
        'AciI',
        'ScrFI',
        'MscI',
        'BseYI',
        'Bme1580I',
        'BmrI',
        'Hpy188I',
        'SmaI',
        'PleI',
        'EcoNI',
        'NheI',
        'BccI',
        'PsiI',
        'BsiEI',
        'AspCNI',
        'StuI',
        'BspCNI',
        'SphI',
        'NciI',
        'FspI',
        'CviAII',
        'PvuII',
        'MfeI',
        'BssSI',
        'FokI',
        'ApaLI',
        'ApeKI',
        'SpeI',
        'HinfI',
        'BciVI',
        'HinP1I',
        'BceAI',
        'HphI',
        'BsmAI',
        'DraIII',
        'EcoO109I',
        'HindIII',
        'BtsI',
        'SapI',
        'PpuMI',
        'EcoRV',
        'AatII',
        'EcoRI',
        'BsmFI',
        'XhoI',
        'Bsp1286I',
        'MnlI',
        'EagI',
        'AscI',
        'AhdI',
        'NlaIII',
        'SbfI',
        'PstI',
        'Tsp509I',
        'MseI',
        'FauI',
        'SfcI',
        'BspEI',
        'BsmI',
        'Sau3AI',
        'BstUI',
        'BstZ17I',
        'KasI',
        'HaeIII',
        'BsmBI',
        'XcmI',
        'BstAPI',
        'AccI',
        'SspI',
        'HpyCH4III',
        'BsrGI',
        'AfeI',
        'Tth111I',
        'SgrAI',
        'NsiI',
        'PspOMI',
        'BspHI',
        'BstYI',
        'PmeI',
        'BsaJI',
        'FseI',
        'ApaI',
        'BseRI',
        'MmeI',
        'ScaI',
        'AgeI',
        'BtgZI',
        'BpmI',
        'EarI',
        'XmaI',
        'AcuI',
        'BfuCI',
        'NspI',
        'PacI',
        'BstBI',
        'HpyCH4V',
        'NlaIV',
        'BbsI',
        'DdeI',
        'NotI',
        'BsaXI',
        'FatI',
        'BamHI',
        'BslI',
        'AvaII',
        'BspDI',
        'PaeR7I',
        'SfaNI',
        'HpaI',
        'BbvCI',
        'Cac8I',
        'Tsp45I',
        'StyI',
        'PflMI',
        'HhaI',
        'AsiSI',
        'AleI',
        'BsaAI']),
 'O': ('Toyobo Biochemicals',
       ['BssHII',
        'XbaI',
        'MluI',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'BstEII',
        'NcoI',
        'Eco47III',
        'DraI',
        'BstXI',
        'Cfr9I',
        'AvaI',
        'PvuI',
        'BsiWI',
        'TaqI',
        'Eco52I',
        'AseI',
        'KpnI',
        'Sau96I',
        'HaeII',
        'Cfr13I',
        'MboII',
        'AflII',
        'SfiI',
        'TspEI',
        'BglII',
        'NaeI',
        'SacII',
        'NruI',
        'MvaI',
        'CspI',
        'NarI',
        'Eco47I',
        'RsaI',
        'HincII',
        'Cfr10I',
        'BanIII',
        'BanI',
        'AluI',
        'ScrFI',
        'EcoRII',
        'MscI',
        'Csp45I',
        'SmaI',
        'NheI',
        'BbrPI',
        'SphI',
        'NciI',
        'FspI',
        'PvuII',
        'EheI',
        'Hin1I',
        'SpeI',
        'HinfI',
        'HindIII',
        'PpuMI',
        'EcoRV',
        'AatII',
        'EcoRI',
        'AatI',
        'XhoI',
        'Eco105I',
        'PstI',
        'BsmI',
        'Alw44I',
        'Sau3AI',
        'HaeIII',
        'AccI',
        'SspI',
        'SrfI',
        'Eco81I',
        'ApaI',
        'EcoT22I',
        'ScaI',
        'NspV',
        'BfrI',
        'PacI',
        'DdeI',
        'NotI',
        'MroI',
        'BamHI',
        'HpaI',
        'HhaI']),
 'P': ('Megabase Research Products', ['CviTI', 'CviRI']),
 'Q': ('CHIMERx',
       ['BssHII',
        'XbaI',
        'MluI',
        'HpaII',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'NcoI',
        'CviJI',
        'DraI',
        'BstXI',
        'AcvI',
        'PvuI',
        'TaqI',
        'KpnI',
        'MboII',
        'SfiI',
        'BglII',
        'SacII',
        'NruI',
        'NarI',
        'RsaI',
        'HincII',
        'MboI',
        'AluI',
        'RsrII',
        'SmaI',
        'StuI',
        'SphI',
        'PvuII',
        'SpeI',
        'HinfI',
        'BsiHKCI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'MnlI',
        'PstI',
        'Sau3AI',
        'HaeIII',
        'SspI',
        'Tth111I',
        'ApaI',
        'ScaI',
        'NotI',
        'BamHI',
        'HpaI']),
 'R': ('Promega Corporation',
       ['BssHII',
        'XbaI',
        'MluI',
        'NgoMIV',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'BstOI',
        'MspI',
        'BanII',
        'SnaBI',
        'BstEII',
        'NcoI',
        'MspA1I',
        'ClaI',
        'XmnI',
        'Eco47III',
        'DraI',
        'BstXI',
        'AvaI',
        'PvuI',
        'DpnI',
        'BbuI',
        'TaqI',
        'Eco52I',
        'SinI',
        'KpnI',
        'Sau96I',
        'HaeII',
        'NdeI',
        'MboII',
        'SfiI',
        'BglII',
        'NaeI',
        'SacII',
        'Acc65I',
        'NruI',
        'CspI',
        'NarI',
        'Bsu36I',
        'Bst98I',
        'RsaI',
        'HincII',
        'BsrSI',
        'MboI',
        'BanI',
        'EclHKI',
        'AluI',
        'CfoI',
        'Csp45I',
        'AccB7I',
        'SmaI',
        'NheI',
        'XhoII',
        'StuI',
        'SphI',
        'NciI',
        'PvuII',
        'FokI',
        'Alw26I',
        'SpeI',
        'HinfI',
        'HindIII',
        'SgfI',
        'EcoRV',
        'AatII',
        'EcoRI',
        'XhoI',
        'Bsp1286I',
        'AccIII',
        'PstI',
        'VspI',
        'BstZI',
        'Alw44I',
        'Sau3AI',
        'Hsp92I',
        'HaeIII',
        'NdeII',
        'AccI',
        'SspI',
        'Tth111I',
        'NsiI',
        'ApaI',
        'ScaI',
        'AgeI',
        'XmaI',
        'BsaMI',
        'BalI',
        'Tru9I',
        'Hsp92II',
        'DdeI',
        'NotI',
        'EcoICRI',
        'BamHI',
        'AvaII',
        'HpaI',
        'StyI',
        'HhaI']),
 'S': ('Sigma Chemical Corporation',
       ['BssHII',
        'XbaI',
        'MluI',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'BstEII',
        'NcoI',
        'ClaI',
        'DraI',
        'SwaI',
        'AvaI',
        'PvuI',
        'DpnI',
        'TaqI',
        'KpnI',
        'HaeII',
        'NdeI',
        'SfiI',
        'BglII',
        'NruI',
        'MvaI',
        'RsaI',
        'AflIII',
        'AluI',
        'ScrFI',
        'EcoRII',
        'CfoI',
        'SmaI',
        'NheI',
        'StuI',
        'SphI',
        'NciI',
        'PvuII',
        'SpeI',
        'MluNI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'EclXI',
        'PstI',
        'BsmI',
        'Alw44I',
        'Sau3AI',
        'BlnI',
        'HaeIII',
        'NdeII',
        'AccI',
        'SspI',
        'NsiI',
        'ApaI',
        'ScaI',
        'KspI',
        'DdeI',
        'NotI',
        'BamHI',
        'AvaII',
        'HpaI',
        'StyI',
        'HindII']),
 'U': ('Bangalore Genei',
       ['XbaI',
        'MluI',
        'HpaII',
        'BclI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BstEII',
        'NcoI',
        'ClaI',
        'XmnI',
        'DraI',
        'AvaI',
        'PvuI',
        'AssI',
        'TaqI',
        'KpnI',
        'Sau96I',
        'SfiI',
        'BglII',
        'NaeI',
        'NruI',
        'NarI',
        'HincII',
        'StrI',
        'MboI',
        'BanI',
        'AluI',
        'SmaI',
        'NheI',
        'StuI',
        'PvuII',
        'ApaLI',
        'SpeI',
        'HinfI',
        'MvrI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'PstI',
        'Sau3AI',
        'HaeIII',
        'AccI',
        'SspI',
        'NsiI',
        'ApaI',
        'BptI',
        'XmaI',
        'BpcI',
        'NotI',
        'BlfI',
        'BamHI',
        'HpaI',
        'HhaI']),
 'V': ('MRC-Holland',
       ['BssHII',
        'XbaI',
        'MluI',
        'SpaHI',
        'BclI',
        'BanII',
        'XmaCI',
        'BstEII',
        'NcoI',
        'DraI',
        'BstXI',
        'FunII',
        'PflBI',
        'EaeI',
        'PinAI',
        'NspIII',
        'NruI',
        'RsaI',
        'MboI',
        'BanI',
        'BssHI',
        'RsrII',
        'PpuXI',
        'StuI',
        'ZhoI',
        'DraIII',
        'EcoO109I',
        'EcoRV',
        'EcoRI',
        'TelI',
        'BsmI',
        'SunI',
        'ScaI',
        'DdeI',
        'RcaI',
        'BamHI',
        'AviII',
        'FunI']),
 'X': ('EURx Ltd.',
       ['BssHII',
        'XbaI',
        'MluI',
        'HpaII',
        'BspTNI',
        'SacI',
        'BglI',
        'SalI',
        'MspI',
        'BanII',
        'NcoI',
        'CviJI',
        'DraI',
        'BstXI',
        'AcvI',
        'PvuI',
        'TaqI',
        'KpnI',
        'MboII',
        'SfiI',
        'BglII',
        'SacII',
        'NruI',
        'NarI',
        'TaqII',
        'RsaI',
        'HincII',
        'BspANI',
        'TspGWI',
        'MboI',
        'AluI',
        'RsrII',
        'SmaI',
        'StuI',
        'SphI',
        'PvuII',
        'SpeI',
        'HinfI',
        'BsiHKCI',
        'HindIII',
        'EcoRV',
        'EcoRI',
        'XhoI',
        'MnlI',
        'PstI',
        'BspMAI',
        'Sau3AI',
        'HaeIII',
        'SspI',
        'Tth111I',
        'ApaI',
        'MmeI',
        'ScaI',
        'TspDTI',
        'NotI',
        'BamHI',
        'BsuTUI',
        'HpaI'])}
typedict = \
{'type145': (('NonPalindromic',
              'NoCut',
              'Unknown',
              'NotDefined',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['AspCNI']),
 'type146': (('NonPalindromic',
              'NoCut',
              'Unknown',
              'NotDefined',
              'Meth_Dep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['BscGI']),
 'type148': (('NonPalindromic',
              'NoCut',
              'Unknown',
              'NotDefined',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['BmgI',
              'UbaF2I',
              'UbaF3I',
              'UbaPI',
              'UbaTI',
              'BspGI',
              'Hin4II',
              'MjaIV',
              'Pfl1108I',
              'AvaIII',
              'DrdII',
              'TsoI',
              'BspNCI',
              'UbaF5I',
              'BsbI',
              'FinI',
              'UbaF6I',
              'UbaF4I',
              'SnaI',
              'HgiEII']),
 'type209': (('NonPalindromic',
              'OneCut',
              'Blunt',
              'Defined',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['MlyI',
              'SnaBI',
              'CviTI',
              'MspA1I',
              'CviJI',
              'BsrBI',
              'DraI',
              'PshAI',
              'SwaI',
              'NaeI',
              'PhoI',
              'SfoI',
              'RsaI',
              'HincII',
              'AluI',
              'Hpy8I',
              'SmaI',
              'FspI',
              'PvuII',
              'MamI',
              'BsuRI',
              'EcoRV',
              'HaeIII',
              'SspI',
              'ScaI',
              'CviRI',
              'BalI',
              'NlaIV',
              'HpaI',
              'Cac8I',
              'HindII',
              'BsaAI']),
 'type210': (('NonPalindromic',
              'OneCut',
              'Blunt',
              'Defined',
              'Meth_Dep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['FnuDII', 'EsaBC3I']),
 'type211': (('NonPalindromic',
              'OneCut',
              'Blunt',
              'Defined',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['BmgBI',
              'PspN4I',
              'Bsp68I',
              'PmaCI',
              'BsaBI',
              'SmiI',
              'PalI',
              'BseJI',
              'BshFI',
              'XmnI',
              'Eco47III',
              'AcvI',
              'BfrBI',
              'EgeI',
              'DpnI',
              'AssI',
              'Bst1107I',
              'BstSNI',
              'MlsI',
              'SchI',
              'AccII',
              'Aor51HI',
              'NruI',
              'SmiMI',
              'Bsh1236I',
              'MslI',
              'FspAI',
              'BoxI',
              'BssNAI',
              'BtrI',
              'BspANI',
              'BstC8I',
              'PmlI',
              'MvnI',
              'ZraI',
              'Eco72I',
              'MscI',
              'SseBI',
              'AccBSI',
              'PsiI',
              'StuI',
              'BbrPI',
              'EheI',
              'BstPAI',
              'Ecl136II',
              'Acc16I',
              'MluNI',
              'MroXI',
              'AatI',
              'ZrmI',
              'BstFNI',
              'BspLI',
              'Eco105I',
              'NsbI',
              'Bse8I',
              'BstUI',
              'BstZ17I',
              'Msp20I',
              'AfeI',
              'SrfI',
              'Eco32I',
              'KspAI',
              'PmeI',
              'MssI',
              'Eco147I',
              'OliI',
              'PdmI',
              'HpyCH4V',
              'PceI',
              'BstBAI',
              'AfaI',
              'MbiI',
              'Asp700I',
              'EcoICRI',
              'AviII',
              'FunI',
              'PspCI',
              'PdiI',
              'AleI']),
 'type212': (('NonPalindromic',
              'OneCut',
              'Blunt',
              'Defined',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['CdiI',
              'NspBII',
              'HaeI',
              'SciI',
              'SspD5I',
              'LpnI',
              'AhaIII',
              'MstI']),
 'type221': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Defined',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['BssHII',
              'BsrFI',
              'XbaI',
              'DpnII',
              'MluI',
              'NgoMIV',
              'HpaII',
              'BclI',
              'BsaWI',
              'SalI',
              'MspI',
              'Bsu15I',
              'NcoI',
              'ClaI',
              'Cfr9I',
              'TaqI',
              'EaeI',
              'AseI',
              'Kpn2I',
              'AclI',
              'ApoI',
              'HpyCH4IV',
              'NdeI',
              'HapII',
              'BglII',
              'Cfr10I',
              'MboI',
              'AciI',
              'XhoII',
              'CviAII',
              'MfeI',
              'BssSI',
              'ApaLI',
              'HinP1I',
              'HindIII',
              'EcoRI',
              'XhoI',
              'BseCI',
              'CfrI',
              'MunI',
              'EagI',
              'AscI',
              'Tsp509I',
              'MseI',
              'VspI',
              'Sau3AI',
              'SgrAI',
              'BspHI',
              'BstYI',
              'AgeI',
              'XmaI',
              'Sse9I',
              'NotI',
              'BamHI',
              'PaeR7I',
              'Bsp106I',
              'BbvCI']),
 'type222': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Defined',
              'Meth_Dep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['XmaIII']),
 'type223': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Defined',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['AsuNHI',
              'BshTI',
              'Bsp1407I',
              'AhlI',
              'XspI',
              'BfaI',
              'PauI',
              'Asp718I',
              'VneI',
              'TliI',
              'PspXI',
              'CciNI',
              'Sfr274I',
              'XmaCI',
              'Ksp22I',
              'Bsp19I',
              'AsuII',
              'FauNDI',
              'Vha464I',
              'BstACI',
              'BspLU11I',
              'BstMBI',
              'FunII',
              'BssAI',
              'BseAI',
              'Hin6I',
              'BstAUI',
              'BsiWI',
              'Bpu14I',
              'Eco52I',
              'BspT104I',
              'SsiI',
              'PinAI',
              'AflII',
              'TspEI',
              'AcsI',
              'BseX3I',
              'FspBI',
              'Acc65I',
              'AvrII',
              'MaeI',
              'XapI',
              'BspXI',
              'PciI',
              'Bse118I',
              'BsaHI',
              'Bst2BI',
              'NarI',
              'BsePI',
              'Bst98I',
              'MaeII',
              'Bsp13I',
              'BsiSI',
              'StrI',
              'Bsp119I',
              'BanIII',
              'BstX2I',
              'BssHI',
              'BseYI',
              'Csp45I',
              'PsuI',
              'NheI',
              'PspAI',
              'AspA2I',
              'BcuI',
              'BspTI',
              'Mly113I',
              'MflI',
              'SspBI',
              'ZhoI',
              'Hin1I',
              'SpeI',
              'XmaJI',
              'MspCI',
              'HspAI',
              'Psp1406I',
              'Kzo9I',
              'Csp6I',
              'Bsp143I',
              'Bsa29I',
              'AccIII',
              'Tru1I',
              'EclXI',
              'BspEI',
              'SlaI',
              'BstZI',
              'Alw44I',
              'Hsp92I',
              'SunI',
              'PspLI',
              'BlnI',
              'KasI',
              'NdeII',
              'BsrGI',
              'CspAI',
              'FbaI',
              'PspOMI',
              'BauI',
              'PshBI',
              'SfuI',
              'NspV',
              'BfuCI',
              'BfrI',
              'BstBI',
              'Tru9I',
              'Bsp120I',
              'MroI',
              'MroNI',
              'BlfI',
              'AcyI',
              'FatI',
              'RcaI',
              'BsuTUI',
              'BspDI',
              'TatI',
              'AsiAI',
              'Pfl23II',
              'PagI']),
 'type224': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Defined',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['SelI',
              'SimI',
              'Ppu10I',
              'Sse232I',
              'BetI',
              'SplI',
              'GdiII',
              'UthSI',
              'BsiI',
              'BspMII']),
 'type225': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Ambiguous',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['AlwI',
              'Fnu4HI',
              'PspPI',
              'BsaI',
              'StyD4I',
              'PspGI',
              'BsoBI',
              'BlpI',
              'Esp3I',
              'AvaI',
              'SinI',
              'Sau96I',
              'BstNI',
              'Cfr13I',
              'TseI',
              'NspIII',
              'Bpu10I',
              'MvaI',
              'AflIII',
              'BfuAI',
              'TfiI',
              'BbvI',
              'HgaI',
              'BanI',
              'BspMI',
              'ScrFI',
              'EcoRII',
              'FokI',
              'Alw26I',
              'ApeKI',
              'Eco31I',
              'HinfI',
              'BceAI',
              'BsmAI',
              'EcoO109I',
              'PpuMI',
              'FauI',
              'BsmBI',
              'AccI',
              'Tth111I',
              'BsaJI',
              'BcnI',
              'EarI',
              'DdeI',
              'AvaII',
              'Tsp45I']),
 'type226': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Ambiguous',
              'Meth_Dep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['StsI', 'HgiCI', 'EcoHI']),
 'type227': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Ambiguous',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['AxyI',
              'SanDI',
              'BspTNI',
              'BspT107I',
              'BstOI',
              'BsoMAI',
              'LweI',
              'BstSFI',
              'BstEII',
              'BssT1I',
              'PsyI',
              'BtgI',
              'AspS9I',
              'DraII',
              'AclWI',
              'Bpu1102I',
              'Bst2UI',
              'BseXI',
              'BstDEI',
              'BstENI',
              'BssECI',
              'Ama87I',
              'BstDSI',
              'BstV2I',
              'AarI',
              'AjnI',
              'PflFI',
              'Bme1390I',
              'BveI',
              'Psp5II',
              'SexAI',
              'EcoO65I',
              'EcoT14I',
              'SmlI',
              'BseBI',
              'PfoI',
              'BshNI',
              'Rsr2I',
              'PspEI',
              'AspI',
              'BpuAI',
              'PasI',
              'BssKI',
              'CpoI',
              'Eco130I',
              'CspI',
              'BfmI',
              'Eco47I',
              'Bsu36I',
              'Bme18I',
              'BstV1I',
              'MabI',
              'Hpy188III',
              'Bse21I',
              'RsrII',
              'BstSCI',
              'PpuXI',
              'Bso31I',
              'PleI',
              'EcoNI',
              'BccI',
              'FaqI',
              'PspPPI',
              'Bsp1720I',
              'NciI',
              'MaeIII',
              'XagI',
              'ErhI',
              'AsuC2I',
              'PpsI',
              'BsiHKCI',
              'XmiI',
              'Eam1104I',
              'Fsp4HI',
              'Acc36I',
              'MspR9I',
              'SapI',
              'BsmFI',
              'VpaK11BI',
              'BspPI',
              'PfeI',
              'Eco91I',
              'SmuI',
              'TelI',
              'SfcI',
              'Bst6I',
              'BpiI',
              'SatI',
              'Ksp632I',
              'BseDI',
              'Eco81I',
              'ItaI',
              'Eco88I',
              'FblI',
              'BstPI',
              'BptI',
              'BtgZI',
              'AccB1I',
              'BpcI',
              'BbsI',
              'NmuCI',
              'Psp6I',
              'CelII',
              'SfaNI',
              'StyI']),
 'type228': (('NonPalindromic',
              'OneCut',
              'Ov5',
              'Ambiguous',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['DsaI',
              'SauI',
              'Sth132I',
              'UnbI',
              'BbvII',
              'VpaK11AI',
              'BinI',
              'Bbr7I',
              'SfeI',
              'CauII',
              'BscAI',
              'Hpy178III',
              'BcefI',
              'AceIII',
              'AsuI',
              'SecI',
              'EspI',
              'Sse8647I']),
 'type233': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Defined',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['SacI',
              'KpnI',
              'HaeII',
              'SacII',
              'NlaIII',
              'PstI',
              'FseI',
              'ApaI',
              'NspI',
              'HhaI',
              'AsiSI']),
 'type235': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Defined',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['SgrBI',
              'BstHHI',
              'SpaHI',
              'BmtI',
              'PvuI',
              'BbuI',
              'Mph1103I',
              'SdaI',
              'BstNSI',
              'BstH2I',
              'Ple19I',
              'Hin1II',
              'Sse8387I',
              'TaiI',
              'BspCI',
              'Psp124BI',
              'Bsp143II',
              'Sfr303I',
              'Zsp2I',
              'CfoI',
              'PaeI',
              'BstKTI',
              'AspLEI',
              'SphI',
              'SstI',
              'MvrI',
              'BbeI',
              'SgfI',
              'AatII',
              'SbfI',
              'BspMAI',
              'XceI',
              'Cfr42I',
              'NsiI',
              'EcoT22I',
              'PacI',
              'KspI',
              'Hsp92II',
              'TscI']),
 'type236': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Defined',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['ChaI']),
 'type237': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Ambiguous',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['MwoI',
              'EcoT38I',
              'BglI',
              'BanII',
              'TspRI',
              'Hpy99I',
              'BstF5I',
              'BsrI',
              'BfiI',
              'MboII',
              'SfiI',
              'Eco57I',
              'Hpy188I',
              'BspCNI',
              'HphI',
              'DraIII',
              'MnlI',
              'XcmI',
              'MmeI',
              'BslI']),
 'type238': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Ambiguous',
              'Meth_Dep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['HpyAV']),
 'type239': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Ambiguous',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['EciI',
              'AlwNI',
              'DrdI',
              'Mva1269I',
              'Bse1I',
              'BstMWI',
              'Eco24I',
              'BstXI',
              'BsiHKAI',
              'BseSI',
              'PflBI',
              'AspHI',
              'Bsc4I',
              'BpuEI',
              'Van91I',
              'DseDI',
              'BsiYI',
              'TaaI',
              'BsrDI',
              'BstMCI',
              'TaqII',
              'HpyF10VI',
              'Bst4CI',
              'AsuHPI',
              'AspEI',
              'BsgI',
              'BsrSI',
              'TspGWI',
              'EclHKI',
              'SduI',
              'BseGI',
              'MhlI',
              'Alw21I',
              'Bse3DI',
              'Bme1580I',
              'AccB7I',
              'BmrI',
              'AdeI',
              'BsiEI',
              'GsuI',
              'BseLI',
              'FriOI',
              'AasI',
              'BciVI',
              'Eam1105I',
              'BseMII',
              'BtsI',
              'BfuI',
              'TauI',
              'Bsp1286I',
              'CaiI',
              'AhdI',
              'BsmI',
              'Bbv12I',
              'BseMI',
              'Eco57MI',
              'BstAPI',
              'HpyCH4III',
              'BseRI',
              'TspDTI',
              'PctI',
              'BpmI',
              'BsaMI',
              'AcuI',
              'DriI',
              'Bsh1285I',
              'PflMI',
              'BmyI',
              'BseNI']),
 'type240': (('NonPalindromic',
              'OneCut',
              'Ov3',
              'Ambiguous',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['Bce83I',
              'BthCI',
              'Psp03I',
              'ApaBI',
              'Tsp4CI',
              'Nli3877I',
              'CstMI',
              'FmuI',
              'McrI',
              'Tth111II',
              'HgiJII',
              'PssI',
              'HgiAI',
              'RleAI']),
 'type275': (('NonPalindromic',
              'TwoCuts',
              'Ov5',
              'Ambiguous',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['BslFI']),
 'type285': (('NonPalindromic',
              'TwoCuts',
              'Ov3',
              'Ambiguous',
              'Meth_Dep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['AloI', 'BaeI', 'BcgI']),
 'type287': (('NonPalindromic',
              'TwoCuts',
              'Ov3',
              'Ambiguous',
              'Meth_Undep',
              'Commercially_available',
              'AbstractCut',
              'RestrictionType'),
             ['PsrI',
              'FalI',
              'CspCI',
              'PpiI',
              'BplI',
              'Hin4I',
              'AlfI',
              'BsaXI']),
 'type288': (('NonPalindromic',
              'TwoCuts',
              'Ov3',
              'Ambiguous',
              'Meth_Undep',
              'Not_available',
              'AbstractCut',
              'RestrictionType'),
             ['CjeI', 'CjePI', 'Bsp24I'])}
