# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ConnectionInterfaceForwarding(dbus.service.Interface):
    """\
      A connection interface for services which can signal to contacts
    that they should instead contact a different user ID, effectively
    forwarding all incoming communication channels to another contact on
    the service.
    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Connection.Interface.Forwarding')

    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Forwarding', in_signature='', out_signature='u')
    def GetForwardingHandle(self):
        """
        Returns the current forwarding contact handle, or zero if none is set.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Forwarding', in_signature='u', out_signature='')
    def SetForwardingHandle(self, forward_to):
        """
        Set a contact handle to forward incoming communications to. A zero
        handle disables forwarding.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Connection.Interface.Forwarding', signature='u')
    def ForwardingChanged(self, forward_to):
        """
        Emitted when the forwarding contact handle for this connection has been
        changed. An zero handle indicates forwarding is disabled.
      
        """
        pass
  