/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFFile;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.pudl.NameDict;
import de.tu_darmstadt.sp.pudl.Page;
import de.tu_darmstadt.sp.pudl.PageLabel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Document {
    private static final PDFName[] inheritable = new PDFName[]{PDFName.MEDIABOX, PDFName.RESOURCES, PDFName.CROPBOX, PDFName.ROTATE, PDFName.DUR, PDFName.HID, PDFName.TRANS};
    PDFFile pdfFile;
    PDFDictionary trailer;
    PDFArray pageList;
    ArrayList pageObjectList;

    public Document() {
        PDFDictionary pages = new PDFDictionary();
        pages.setIndirect();
        PDFDictionary root = new PDFDictionary();
        root.setIndirect();
        this.pageList = new PDFArray();
        pages.put(PDFName.TYPE, (PDFObject)PDFName.PAGES);
        pages.put(PDFName.KIDS, (PDFObject)this.pageList);
        pages.put(PDFName.COUNT, (PDFObject)PDFInteger.forInt(this.pageList.size()));
        root.put(PDFName.TYPE, (PDFObject)PDFName.CATALOG);
        root.put(PDFName.PAGES, (PDFObject)pages);
        this.trailer = new PDFDictionary();
        this.trailer.put(PDFName.SIZE, (PDFObject)PDFInteger.forInt(3));
        this.trailer.put(PDFName.ROOT, (PDFObject)root);
        this.pdfFile = new PDFFile(this.trailer);
        this.createPageObjects();
        this.setPageNumbers();
    }

    public Document(File file) throws IOException {
        this.pdfFile = new PDFFile(file);
        this.pdfFile.read();
        this.trailer = this.pdfFile.getTrailer();
        this.normalize();
        this.createPageObjects();
        this.setPageNumbers();
    }

    public Document(String fileName) throws IOException {
        this(new File(fileName));
    }

    public void addPage(int pageNo, Page p) {
        if (pageNo < 1 || pageNo > this.numPages() + 1) {
            throw new IndexOutOfBoundsException(String.valueOf(pageNo) + " is not a valid pagenumber");
        }
        PDFDictionary dict = (PDFDictionary)p.getRepresentation();
        dict.put(PDFName.PARENT, this.getRoot().get(PDFName.PAGES));
        if (!p.pageNumber.containsKey(PDFName.St)) {
            p.pageNumber.put(PDFName.St, (PDFObject)PDFInteger.forInt(pageNo));
        }
        this.pageList.add(pageNo - 1, dict);
        this.pageObjectList.add(pageNo - 1, p);
        ((PDFDictionary)this.getRoot().get(PDFName.PAGES)).put(PDFName.COUNT, (PDFObject)PDFInteger.forInt(this.numPages()));
    }

    public void addPage(Page p) {
        this.addPage(this.numPages() + 1, p);
    }

    public Page checkoutPage(int pageNo) throws IndexOutOfBoundsException {
        Page result = new Page(this.getPage(pageNo));
        result.pageNumber = new PDFDictionary(this.getPage((int)pageNo).pageNumber);
        ((PDFDictionary)result.getRepresentation()).remove(PDFName.PARENT);
        return result;
    }

    public void close() throws IOException {
        if (this.pdfFile != null) {
            this.pdfFile.close();
        }
    }

    private void createPageObjects() {
        this.pageObjectList = new ArrayList();
        int i = 0;
        while (i < this.numPages()) {
            this.pageObjectList.add(i, new Page((PDFDictionary)this.pageList.get(i)));
            ++i;
        }
    }

    public PDFDictionary getInfo() {
        return (PDFDictionary)this.trailer.get(PDFName.INFO);
    }

    public NameDict getNamesDictionary() throws IOException {
        PDFDictionary nameTreeRoot;
        PDFDictionary newNameTreeRoot;
        PDFDictionary destsDict = (PDFDictionary)this.getRoot().get(PDFName.DESTS);
        PDFDictionary namesDict = (PDFDictionary)this.getRoot().get(PDFName.NAMES);
        NameDict nd = null;
        if (destsDict != null && namesDict != null && namesDict.get(PDFName.DESTS) != null) {
            throw new IOException("Two Names Dictionary exists; not supported");
        }
        if (destsDict == null && namesDict == null) {
            return null;
        }
        if (destsDict != null) {
            nd = new NameDict(destsDict);
            newNameTreeRoot = new PDFDictionary();
            newNameTreeRoot.setIndirect();
            newNameTreeRoot.put(PDFName.NAMES, (PDFObject)((PDFArray)nd.getRepresentation()));
            if (namesDict == null) {
                namesDict = new PDFDictionary();
                namesDict.setIndirect();
            }
            namesDict.put(PDFName.DESTS, (PDFObject)newNameTreeRoot);
            this.getRoot().put(PDFName.NAMES, (PDFObject)namesDict);
            this.getRoot().remove(PDFName.DESTS);
        }
        if ((nameTreeRoot = (PDFDictionary)namesDict.get(PDFName.DESTS)) != null) {
            if (nameTreeRoot.get(PDFName.KIDS) != null) {
                if (((PDFArray)nameTreeRoot.get(PDFName.KIDS)).size() > 1) {
                    throw new IOException("Root node of Name Tree has more than one kid; not supported");
                }
                PDFDictionary nameTreeNode = (PDFDictionary)((PDFArray)nameTreeRoot.get(PDFName.KIDS)).get(0);
                if (nameTreeNode.get(PDFName.NAMES) == null) {
                    throw new IOException("Intermediate node found in Name Tree; not supported");
                }
                nd = new NameDict((PDFArray)nameTreeNode.get(PDFName.NAMES));
                newNameTreeRoot = new PDFDictionary();
                newNameTreeRoot.setIndirect();
                newNameTreeRoot.put(PDFName.NAMES, (PDFObject)((PDFArray)nd.getRepresentation()));
                namesDict.put(PDFName.DESTS, (PDFObject)newNameTreeRoot);
            } else {
                return new NameDict((PDFArray)nameTreeRoot.get(PDFName.NAMES));
            }
        }
        return nd;
    }

    public Page getPage(int pageNo) throws IndexOutOfBoundsException {
        if (pageNo < 1 || pageNo > this.numPages()) {
            throw new IndexOutOfBoundsException(String.valueOf(pageNo) + " is not a valid pagenumber");
        }
        return (Page)this.pageObjectList.get(pageNo - 1);
    }

    public int getPageIndex(char style, String prefix, int number) {
        PDFDictionary searchDict = new PDFDictionary();
        searchDict.put(PDFName.S, (PDFObject)PageLabel.getValidStyle(style));
        if (!prefix.equals("")) {
            searchDict.put("P", (PDFObject)new PDFTextString(prefix));
        }
        searchDict.put(PDFName.St, (PDFObject)PDFInteger.forInt(number));
        int i = 0;
        while (i < this.numPages()) {
            Page p = this.getPage(i + 1);
            if (searchDict.get(PDFName.S).equals(p.pageNumber.get(PDFName.S)) && searchDict.get(PDFName.St).equals(p.pageNumber.get(PDFName.St))) {
                if (searchDict.containsKey("P")) {
                    if (searchDict.get("P").equals(p.pageNumber.get("P"))) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public PDFDictionary getRoot() {
        return (PDFDictionary)this.trailer.get(PDFName.ROOT);
    }

    public static void main(String[] args) throws IOException {
        Document mydoc;
        block5: {
            mydoc = null;
            try {
                mydoc = new Document(args[0]);
                if (args.length != 2) break block5;
                if ("-".equals(args[1])) {
                    mydoc.write(System.out);
                    break block5;
                }
                mydoc.write(args[1]);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (mydoc != null) {
                    mydoc.close();
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (mydoc != null) {
            mydoc.close();
        }
    }

    PageLabel makevalidPageLabel() {
        if (!this.getRoot().containsKey(PDFName.PAGELABELS)) {
            this.getRoot().put(PDFName.PAGELABELS, (PDFObject)new PDFDictionary());
        }
        return new PageLabel((PDFDictionary)this.getRoot().get(PDFName.PAGELABELS));
    }

    private void normalize() throws IOException {
        ArrayList kids = new ArrayList();
        this.pageList = new PDFArray();
        PDFDictionary newPages = new PDFDictionary();
        newPages.setIndirect();
        this.squashPagesTree((PDFDictionary)this.getRoot().get(PDFName.PAGES), kids);
        Iterator iter = kids.iterator();
        while (iter.hasNext()) {
            PDFDictionary currentPage = (PDFDictionary)iter.next();
            currentPage.put(PDFName.PARENT, (PDFObject)newPages);
            this.pageList.add(currentPage);
        }
        newPages.put(PDFName.TYPE, (PDFObject)PDFName.PAGES);
        newPages.put(PDFName.KIDS, (PDFObject)this.pageList);
        newPages.put(PDFName.COUNT, (PDFObject)PDFInteger.forInt(kids.size()));
        this.getRoot().put(PDFName.PAGES, (PDFObject)newPages);
    }

    public int numPages() {
        return this.pageList.size();
    }

    public void removePage(int pageNo) {
        this.pageList.remove(pageNo - 1);
        this.pageObjectList.remove(pageNo - 1);
        ((PDFDictionary)this.getRoot().get(PDFName.PAGES)).put(PDFName.COUNT, (PDFObject)PDFInteger.forInt(this.numPages()));
    }

    public void setNamesDictionary() {
        this.setNamesDictionary(new NameDict());
    }

    public void setNamesDictionary(NameDict nd) {
        PDFDictionary newNameTreeRoot = new PDFDictionary();
        newNameTreeRoot.setIndirect();
        newNameTreeRoot.put(PDFName.NAMES, (PDFObject)((PDFArray)nd.getRepresentation()));
        PDFDictionary namesDict = (PDFDictionary)this.getRoot().get(PDFName.NAMES);
        if (namesDict == null) {
            namesDict = new PDFDictionary();
            namesDict.setIndirect();
        }
        namesDict.put(PDFName.DESTS, (PDFObject)newNameTreeRoot);
        this.getRoot().put(PDFName.NAMES, (PDFObject)namesDict);
        this.getRoot().remove(PDFName.DESTS);
    }

    public void setPageNumbers() {
        int zaehler = 0;
        PageLabel labels = this.makevalidPageLabel();
        if (labels.PageLabelDict.containsKey(PDFName.NUMS)) {
            int i = 1;
            while (i <= this.numPages()) {
                ++zaehler;
                PDFArray section = labels.getSection(i - 1);
                int startIndex = ((PDFInteger)section.get(0)).intValue();
                PDFDictionary tempdict = (PDFDictionary)section.get(1);
                if (i - 1 == startIndex) {
                    int startNumber = tempdict.containsKey(PDFName.St) ? ((PDFInteger)tempdict.get(PDFName.St)).intValue() : 1;
                    zaehler = startNumber;
                }
                tempdict.put(PDFName.St, (PDFObject)PDFInteger.forInt(zaehler));
                if (!tempdict.containsKey(PDFName.S)) {
                    tempdict.put(PDFName.S, (PDFObject)PageLabel.getValidStyle(' '));
                }
                this.getPage((int)i).pageNumber = new PDFDictionary(tempdict);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= this.numPages()) {
                this.getPage((int)i).pageNumber.put(PDFName.St, (PDFObject)PDFInteger.forInt(i));
                this.getPage((int)i).pageNumber.put(PDFName.S, (PDFObject)PageLabel.getValidStyle(' '));
                ++i;
            }
        }
        this.getRoot().remove(PDFName.PAGELABELS);
    }

    private void squashPagesTree(PDFDictionary pagesSubTree, List kidsList) throws IOException {
        if (PDFName.PAGE.equals(pagesSubTree.get(PDFName.TYPE))) {
            kidsList.add(pagesSubTree);
            return;
        }
        if (PDFName.PAGES.equals(pagesSubTree.get(PDFName.TYPE))) {
            ListIterator j;
            if (!pagesSubTree.containsKey(PDFName.KIDS)) {
                throw new IOException("no key 'Kids' in 'Pages': " + pagesSubTree.toString());
            }
            if (!pagesSubTree.containsKey(PDFName.COUNT)) {
                throw new IOException("no key 'Count' in 'Pages': " + pagesSubTree.toString());
            }
            PDFArray kids = (PDFArray)pagesSubTree.get(PDFName.KIDS);
            int i = 0;
            while (i < inheritable.length) {
                if (pagesSubTree.containsKey(inheritable[i])) {
                    j = kids.listIterator();
                    while (j.hasNext()) {
                        PDFDictionary currPage = (PDFDictionary)j.next();
                        if (currPage.containsKey(inheritable[i])) continue;
                        currPage.put(inheritable[i], pagesSubTree.get(inheritable[i]));
                    }
                    pagesSubTree.remove(inheritable[i]);
                }
                ++i;
            }
            if (!pagesSubTree.containsKey(PDFName.PARENT) && pagesSubTree.size() > 3 || pagesSubTree.containsKey(PDFName.PARENT) && pagesSubTree.size() > 4) {
                throw new IOException("unknown entry in 'Pages': " + pagesSubTree.toString());
            }
            j = kids.listIterator();
            while (j.hasNext()) {
                this.squashPagesTree((PDFDictionary)j.next(), kidsList);
            }
            return;
        }
        throw new IOException("invalid PagesTree: " + pagesSubTree.toString());
    }

    public void write(File file) throws IOException {
        this.writePageNumbers();
        this.pdfFile.write(file);
    }

    public void write(OutputStream out) throws IOException {
        this.writePageNumbers();
        this.pdfFile.write(out);
    }

    public void write(String fileName) throws IOException {
        this.writePageNumbers();
        this.pdfFile.write(fileName);
    }

    public void writePageNumbers() throws IOException {
        PDFArray labelArray = new PDFArray();
        int i = 1;
        while (i <= this.numPages()) {
            labelArray.add(PDFInteger.forInt(i - 1));
            labelArray.add(this.getPage((int)i).pageNumber);
            ++i;
        }
        PageLabel label = this.makevalidPageLabel();
        label.PageLabelDict.put(PDFName.NUMS, (PDFObject)labelArray);
        label.mergeSections();
        if (((PDFArray)label.PageLabelDict.get(PDFName.NUMS)).size() == 0) {
            this.getRoot().remove(PDFName.PAGELABELS);
        }
    }
}

