/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPGraphUI;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.GraphModelProvider;
import org.jgraph.pad.resources.Translator;

public class GPMarqueeHandler
extends BasicMarqueeHandler {
    int m_XDifference;
    int m_YDifference;
    int dx;
    int dy;
    boolean m_dragging;
    Container c;
    GPGraphpad graphpad;
    protected transient Color defaultBorderColor = Color.black;
    protected transient JToggleButton buttonSelect = new JToggleButton();
    protected transient JToggleButton buttonRectangle = new JToggleButton();
    protected transient JToggleButton buttonCircle = new JToggleButton();
    protected transient JToggleButton buttonText = new JToggleButton();
    protected transient JToggleButton buttonImage = new JToggleButton();
    protected transient JToggleButton buttonLine = new JToggleButton();
    protected transient JToggleButton buttonEdge = new JToggleButton();
    protected transient JToggleButton buttonZoomArea = new JToggleButton();
    protected Point start;
    protected Point current;
    protected Rectangle bounds;
    protected PortView port;
    protected PortView firstPort;
    protected PortView lastPort;

    public GPMarqueeHandler(GPGraphpad gPGraphpad) {
        this.graphpad = gPGraphpad;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonSelect);
        buttonGroup.add(this.buttonRectangle);
        buttonGroup.add(this.buttonCircle);
        buttonGroup.add(this.buttonText);
        buttonGroup.add(this.buttonImage);
        buttonGroup.add(this.buttonLine);
        buttonGroup.add(this.buttonEdge);
        buttonGroup.add(this.buttonZoomArea);
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return !this.buttonSelect.isSelected() || this.isPopupTrigger(mouseEvent) || super.isForceMarqueeEvent(mouseEvent);
    }

    protected boolean isPopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return false;
        }
        return SwingUtilities.isRightMouseButton(mouseEvent) && !mouseEvent.isShiftDown();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_XDifference = mouseEvent.getX();
        this.m_YDifference = mouseEvent.getY();
        this.dx = 0;
        this.dy = 0;
        if (!(this.isPopupTrigger(mouseEvent) || mouseEvent.isConsumed() || this.buttonSelect.isSelected())) {
            this.start = this.graphpad.getCurrentGraph().snap(mouseEvent.getPoint());
            this.firstPort = this.port;
            if (this.buttonEdge.isSelected() && this.firstPort != null) {
                this.start = this.graphpad.getCurrentGraph().toScreen(this.firstPort.getLocation(null));
            }
            mouseEvent.consume();
        }
        if (!this.isPopupTrigger(mouseEvent)) {
            super.mousePressed(mouseEvent);
        } else {
            boolean bl = false;
            Object[] objectArray = this.graphpad.getCurrentGraph().getSelectionCells();
            int n = 0;
            while (n < objectArray.length && !bl) {
                bl = this.graphpad.getCurrentGraph().getCellBounds(objectArray[n]).contains(mouseEvent.getPoint());
                ++n;
            }
            if (!bl) {
                this.graphpad.getCurrentGraph().setSelectionCell(this.graphpad.getCurrentGraph().getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY()));
            }
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && !this.buttonSelect.isSelected()) {
            Graphics graphics = this.graphpad.getCurrentGraph().getGraphics();
            Color color = this.graphpad.getCurrentGraph().getBackground();
            Color color2 = Color.black;
            graphics.setColor(color2);
            graphics.setXORMode(color);
            this.overlay(graphics);
            this.current = this.graphpad.getCurrentGraph().snap(mouseEvent.getPoint());
            if (this.buttonEdge.isSelected() || this.buttonLine.isSelected()) {
                this.port = this.getPortViewAt(mouseEvent.getX(), mouseEvent.getY(), !mouseEvent.isShiftDown());
                if (this.port != null) {
                    this.current = this.graphpad.getCurrentGraph().toScreen(this.port.getLocation(null));
                }
            }
            this.bounds = new Rectangle(this.start).union(new Rectangle(this.current));
            graphics.setColor(color);
            graphics.setXORMode(color2);
            this.overlay(graphics);
            mouseEvent.consume();
        } else if (!mouseEvent.isConsumed() && this.isForceMarqueeEvent(mouseEvent) && this.isPopupTrigger(mouseEvent)) {
            this.c = this.graphpad.getCurrentGraph().getParent();
            if (this.c instanceof JViewport) {
                JViewport jViewport = (JViewport)this.c;
                Point point = jViewport.getViewPosition();
                int n = point.x - (mouseEvent.getX() - this.m_XDifference);
                int n2 = point.y - (mouseEvent.getY() - this.m_YDifference);
                this.dx += mouseEvent.getX() - this.m_XDifference;
                this.dy += mouseEvent.getY() - this.m_YDifference;
                int n3 = this.graphpad.getCurrentGraph().getWidth() - jViewport.getWidth();
                int n4 = this.graphpad.getCurrentGraph().getHeight() - jViewport.getHeight();
                if (n < 0) {
                    n = 0;
                }
                if (n > n3) {
                    n = n3;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                jViewport.setViewPosition(new Point(n, n2));
                mouseEvent.consume();
            }
        }
        super.mouseDragged(mouseEvent);
    }

    public PortView getPortViewAt(int n, int n2, boolean bl) {
        Point point = this.graphpad.getCurrentGraph().fromScreen(new Point(n, n2));
        PortView portView = this.graphpad.getCurrentGraph().getPortViewAt(point.x, point.y);
        if (portView == null && bl) {
            Object object = this.graphpad.getCurrentGraph().getFirstCellForLocation(n, n2);
            if (this.graphpad.getCurrentGraph().isVertex(object)) {
                Object object2 = this.graphpad.getCurrentGraph().getModel().getChild(object, 0);
                CellView cellView = this.graphpad.getCurrentGraph().getGraphLayoutCache().getMapping(object2, false);
                if (cellView instanceof PortView) {
                    portView = (PortView)cellView;
                }
            }
        }
        return portView;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        GraphModelProvider graphModelProvider = this.graphpad.getCurrentGraphModelProvider();
        GraphModel graphModel = this.graphpad.getCurrentGraph().getModel();
        if (this.isPopupTrigger(mouseEvent)) {
            if (Math.abs(this.dx) < this.graphpad.getCurrentGraph().getTolerance() && Math.abs(this.dy) < this.graphpad.getCurrentGraph().getTolerance()) {
                Object object = this.graphpad.getCurrentGraph().getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (object == null) {
                    this.graphpad.getCurrentGraph().clearSelection();
                }
                Container container = this.graphpad.getCurrentGraph();
                while ((container = container.getParent()) != null && !(container instanceof GPGraphpad)) {
                }
                GPGraphpad gPGraphpad = (GPGraphpad)container;
                if (gPGraphpad != null) {
                    Object object2;
                    JPopupMenu jPopupMenu = gPGraphpad.getBarFactory().createGraphPopupMenu();
                    final GPGraph gPGraph = this.graphpad.getCurrentDocument().getGraph();
                    final Object object3 = gPGraph.getSelectionCell();
                    if (object3 instanceof DefaultGraphCell && (object2 = ((DefaultGraphCell)object3).getUserObject()) instanceof GPUserObject) {
                        JMenuItem jMenuItem = new JMenuItem("Properties");
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((GPUserObject)object2).showPropertyDialog(gPGraph, object3);
                            }
                        });
                    }
                    jPopupMenu.show(this.graphpad.getCurrentGraph(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            mouseEvent.consume();
        } else if (mouseEvent != null && !mouseEvent.isConsumed() && this.bounds != null && !this.buttonSelect.isSelected()) {
            this.graphpad.getCurrentGraph().fromScreen(this.bounds);
            ++this.bounds.width;
            ++this.bounds.height;
            if (this.buttonZoomArea.isSelected()) {
                Rectangle rectangle = this.graphpad.getCurrentGraph().getBounds();
                if (this.graphpad.getCurrentGraph().getParent() instanceof JViewport) {
                    rectangle = ((JViewport)this.graphpad.getCurrentGraph().getParent()).getViewRect();
                }
                if (this.bounds.width != 0 && this.bounds.height != 0 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    double d = Math.min((double)rectangle.width / (double)this.bounds.width, (double)rectangle.height / (double)this.bounds.height);
                    if (d > 0.1) {
                        Rectangle rectangle2 = this.graphpad.getCurrentGraph().fromScreen(this.bounds);
                        this.graphpad.getCurrentGraph().setScale(d);
                        this.graphpad.getCurrentGraph().scrollRectToVisible(this.graphpad.getCurrentGraph().toScreen(rectangle2));
                    }
                } else {
                    this.graphpad.getCurrentGraph().setScale(1.0);
                }
            } else if (this.buttonRectangle.isSelected()) {
                this.addVertex(2, "", this.bounds, false, Color.black);
            } else if (this.buttonCircle.isSelected()) {
                this.addEllipse("", this.bounds);
            } else if (this.buttonText.isSelected()) {
                Object object = this.addVertex(4, "Type Here", this.bounds, false, Color.black);
                this.graphpad.getCurrentGraph().startEditingAtCell(object);
            } else if (this.buttonImage.isSelected()) {
                this.addVertex(3, GPGraphpad.applicationIcon, this.bounds, false, null);
            } else if (this.buttonEdge.isSelected()) {
                Point point = this.graphpad.getCurrentGraph().fromScreen(new Point(this.start));
                Point point2 = this.graphpad.getCurrentGraph().fromScreen(new Point(this.current));
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(point);
                arrayList.add(point2);
                Map map = GraphConstants.createMap();
                GraphConstants.setPoints(map, arrayList);
                GraphConstants.setRouting(map, GraphConstants.ROUTING_SIMPLE);
                Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
                Object object = graphModelProvider.createCell(graphModel, 6, new GPUserObject(""), map);
                hashtable.put(object, map);
                Object[] objectArray = new Object[]{object};
                ConnectionSet connectionSet = new ConnectionSet();
                if (this.firstPort != null) {
                    connectionSet.connect(object, this.firstPort.getCell(), true);
                }
                if (this.port != null) {
                    connectionSet.connect(object, this.port.getCell(), false);
                }
                this.graphpad.getCurrentGraph().getModel().insert(objectArray, hashtable, connectionSet, null, null);
            } else if (this.buttonLine.isSelected()) {
                Point point = this.graphpad.getCurrentGraph().fromScreen(new Point(this.start));
                Point point3 = this.graphpad.getCurrentGraph().toScreen(new Point(this.current));
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(point);
                arrayList.add(point3);
                Map map = GraphConstants.createMap();
                GraphConstants.setPoints(map, arrayList);
                GraphConstants.setLineEnd(map, 1);
                GraphConstants.setEndFill(map, true);
                Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
                Object object = graphModelProvider.createCell(graphModel, 6, new GPUserObject(""), map);
                hashtable.put(object, map);
                Object[] objectArray = new Object[]{object};
                ConnectionSet connectionSet = new ConnectionSet();
                if (this.firstPort != null) {
                    connectionSet.connect(object, this.firstPort.getCell(), true);
                }
                if (this.port != null) {
                    connectionSet.connect(object, this.port.getCell(), false);
                }
                this.graphpad.getCurrentGraph().getModel().insert(objectArray, hashtable, connectionSet, null, null);
            }
            mouseEvent.consume();
        }
        this.buttonSelect.doClick();
        this.firstPort = null;
        this.port = null;
        this.start = null;
        this.current = null;
        this.bounds = null;
        super.mouseReleased(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.buttonSelect.isSelected() && !mouseEvent.isConsumed()) {
            PortView portView;
            PortView portView2;
            this.graphpad.getCurrentGraph().setCursor(new Cursor(1));
            mouseEvent.consume();
            if ((this.buttonEdge.isSelected() || this.buttonLine.isSelected()) && (portView2 = this.port) != (portView = this.getPortViewAt(mouseEvent.getX(), mouseEvent.getY(), !mouseEvent.isShiftDown()))) {
                Graphics graphics = this.graphpad.getCurrentGraph().getGraphics();
                Color color = this.graphpad.getCurrentGraph().getBackground();
                Color color2 = this.graphpad.getCurrentGraph().getMarqueeColor();
                graphics.setColor(color2);
                graphics.setXORMode(color);
                this.overlay(graphics);
                this.port = portView;
                graphics.setColor(color);
                graphics.setXORMode(color2);
                this.overlay(graphics);
            }
        }
        super.mouseMoved(mouseEvent);
    }

    public void overlay(Graphics graphics) {
        super.overlay(graphics);
        this.paintPort(this.graphpad.getCurrentGraph().getGraphics());
        if (this.bounds != null && this.start != null) {
            if (this.buttonImage.isSelected() || this.buttonZoomArea.isSelected()) {
                ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
            }
            if (this.buttonCircle.isSelected()) {
                graphics.drawOval(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            } else if ((this.buttonLine.isSelected() || this.buttonEdge.isSelected()) && this.current != null) {
                graphics.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
            } else if (!this.buttonSelect.isSelected()) {
                graphics.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
        }
    }

    protected void paintPort(Graphics graphics) {
        if (this.port != null) {
            boolean bl = GraphConstants.getOffset(this.port.getAllAttributes()) != null;
            Rectangle rectangle = bl ? this.port.getBounds() : this.port.getParentView().getBounds();
            rectangle = this.graphpad.getCurrentGraph().toScreen(new Rectangle(rectangle));
            int n = 3;
            rectangle.translate(-n, -n);
            rectangle.setSize(rectangle.width + 2 * n, rectangle.height + 2 * n);
            GPGraphUI gPGraphUI = (GPGraphUI)this.graphpad.getCurrentGraph().getUI();
            gPGraphUI.paintCell(graphics, this.port, rectangle, true);
        }
    }

    public Object addVertex(int n, Object object, Rectangle rectangle, boolean bl, Color color) {
        Object object2;
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        GraphModelProvider graphModelProvider = this.graphpad.getCurrentGraphModelProvider();
        GraphModel graphModel = this.graphpad.getCurrentGraph().getModel();
        Object object3 = object instanceof String ? object : "";
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds(map, rectangle);
        GraphConstants.setOpaque(map, false);
        if (color != null) {
            GraphConstants.setBorderColor(map, color);
        }
        String string = Translator.getString("FontName");
        try {
            int n2 = Integer.parseInt(Translator.getString("FontSize"));
            int n3 = Integer.parseInt(Translator.getString("FontStyle"));
            GraphConstants.setFont(map, new Font(string, n3, n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            GraphConstants.setAutoSize(map, true);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        switch (n) {
            case 3: {
                object2 = graphModelProvider.createCell(graphModel, 3, new GPUserObject(""), map);
                break;
            }
            case 4: {
                object2 = graphModelProvider.createCell(graphModel, 4, new GPUserObject(object.toString()), map);
                break;
            }
            default: {
                object2 = graphModelProvider.createCell(graphModel, 2, new GPUserObject(object.toString()), map);
            }
        }
        hashtable.put(object2, map);
        linkedList.add(object2);
        int n4 = 1000;
        Object object4 = graphModelProvider.createCell(graphModel, 5, "Center", null);
        graphModelProvider.addPort(object2, object4);
        linkedList.add(object4);
        if (object instanceof ImageIcon) {
            GraphConstants.setIcon(map, (ImageIcon)object);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4 / 2, n4 / 2));
            hashtable.put(object4, map);
            linkedList.add(object4);
        } else {
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(0, 0));
            object4 = graphModelProvider.createCell(graphModel, 5, "Topleft", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4 / 2, 0));
            object4 = graphModelProvider.createCell(graphModel, 5, "Topcenter", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4, 0));
            object4 = graphModelProvider.createCell(graphModel, 5, "Topright", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(0, n4 / 2));
            object4 = graphModelProvider.createCell(graphModel, 5, "Middleleft", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4, n4 / 2));
            object4 = graphModelProvider.createCell(graphModel, 5, "Middleright", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(0, n4));
            object4 = graphModelProvider.createCell(graphModel, 5, "Bottomleft", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4 / 2, n4));
            object4 = graphModelProvider.createCell(graphModel, 5, "Bottomcenter", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
            map = GraphConstants.createMap();
            GraphConstants.setOffset(map, new Point(n4, n4));
            object4 = graphModelProvider.createCell(graphModel, 5, "Bottomright", map);
            graphModelProvider.addPort(object2, object4);
            hashtable.put(object4, map);
            linkedList.add(object4);
        }
        this.graphpad.getCurrentGraph().getModel().insert(linkedList.toArray(), hashtable, null, null, null);
        return object2;
    }

    public void addEllipse(Object object, Rectangle rectangle) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        GraphModelProvider graphModelProvider = this.graphpad.getCurrentGraphModelProvider();
        GraphModel graphModel = this.graphpad.getCurrentGraph().getModel();
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds(map, rectangle);
        GraphConstants.setOpaque(map, false);
        GraphConstants.setBorderColor(map, Color.black);
        String string = Translator.getString("FontName");
        try {
            int n = Integer.parseInt(Translator.getString("FontSize"));
            int n2 = Integer.parseInt(Translator.getString("FontStyle"));
            GraphConstants.setFont(map, new Font(string, n2, n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object2 = graphModelProvider.createCell(graphModel, 1, new GPUserObject(object.toString()), map);
        hashtable.put(object2, map);
        linkedList.add(object2);
        int n = 1000;
        Object object3 = graphModelProvider.createCell(graphModel, 5, "Center", null);
        graphModelProvider.addPort(object2, object3);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point((int)((double)n * 0.15), (int)((double)n * 0.15)));
        object3 = graphModelProvider.createCell(graphModel, 5, "Topleft", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point(n / 2, 0));
        object3 = graphModelProvider.createCell(graphModel, 5, "Topcenter", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point((int)((double)n * 0.85), (int)((double)n * 0.15)));
        object3 = graphModelProvider.createCell(graphModel, 5, "Topright", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point(0, n / 2));
        object3 = graphModelProvider.createCell(graphModel, 5, "Middleleft", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point(n, n / 2));
        object3 = graphModelProvider.createCell(graphModel, 5, "Middleright", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point((int)((double)n * 0.15), (int)((double)n * 0.85)));
        object3 = graphModelProvider.createCell(graphModel, 5, "Bottomleft", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point(n / 2, n));
        object3 = graphModelProvider.createCell(graphModel, 5, "Bottomcenter", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        map = GraphConstants.createMap();
        GraphConstants.setOffset(map, new Point((int)((double)n * 0.85), (int)((double)n * 0.85)));
        object3 = graphModelProvider.createCell(graphModel, 5, "Bottomright", map);
        graphModelProvider.addPort(object2, object3);
        hashtable.put(object3, map);
        linkedList.add(object3);
        this.graphpad.getCurrentGraph().getModel().insert(linkedList.toArray(), hashtable, null, null, null);
    }

    public JToggleButton getButtonCircle() {
        return this.buttonCircle;
    }

    public JToggleButton getButtonEdge() {
        return this.buttonEdge;
    }

    public JToggleButton getButtonImage() {
        return this.buttonImage;
    }

    public JToggleButton getButtonLine() {
        return this.buttonLine;
    }

    public JToggleButton getButtonRectangle() {
        return this.buttonRectangle;
    }

    public JToggleButton getButtonSelect() {
        return this.buttonSelect;
    }

    public JToggleButton getButtonText() {
        return this.buttonText;
    }

    public JToggleButton getButtonZoomArea() {
        return this.buttonZoomArea;
    }
}

