<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Jan" => "Ян",
"Feb" => "Фев",
"Mar" => "Мар",
"Apr" => "Апр",
"Jun" => "Юни",
"Jul" => "Юли",
"Aug" => "Авг",
"Sep" => "Сеп",
"Oct" => "Окт",
"Nov" => "Ноем",
"Dec" => "Дек",
"Wiki page" => "Wiki страница",
"pageviews" => "посещения",
"forum topic" => "тема във форума",
"Remove selected packages" => "Премахване на избраните пакети",
"Message box" => "Кутия за съобщения",
"Packages" => "Пакети",
"Sheet" => "Лист",
"Packager Admin" => "Администрация на пакети",
"List of packages" => "Списък с пакети",
"Edit selection" => "Корекция на избора",
"Remove All" => "Премахване на всички",
"Click here to edit this manifest" => "Кликнете тук за да редактирате заявката",
"Are you sure you want to delete these manifests?" => "Наистина ли искате да изтриете тези заявки?",
"Create new package" => "Създаване на нов пакет",
"Package name" => "Име на пакета",
"Save draft" => "Запазване на чернова",
"Create package" => "създаване на пакет",
"Tikiwiki mods Management" => "Управление на модулите за TikiWiki",
"refrech servers list" => "обновяване на списъка със сървърите",
"Content Templates" => "Шаблони съдържание",
"Ranking" => "Класиране",
"v=view, b=rollback, c=compare with current, d=diff to current, s=source" => "v=разглеждане, b=връщане назад, c=сравняване със текущия/та, d=разлики от текущия/та, s=сорс",
"file galleries" => "файлови галерии",
"community" => "общество",
"html pages" => "html страници",
"image galleries" => "картинни галерии",
"maps" => "карти",
"shoutbox" => "мегафон",
"surveys" => "проучвания",
"sheet" => "лист",
"jukebox" => "джубокс",
"homework" => "домашна работа",
"workflow" => "работен процес",
"-Lines: {\$old} changed to +Lines: {\$new}" => "-Редове : {\$old} бяха променени на +Редове : {\$new}",
"Old" => "Стар",
"role" => "роля",
"Artist" => "Художник",
"Add a subscription events" => "Добавяне на събития за абониране",
"ver" => "вер",
"Revision" => "Ревизия",
"Licence" => "Лиценз",
"updated by the phpwiki import process" => "обновен от процеса за импорт на phpwiki",
"created from phpwiki import" => "създаден/а от импорта на phpwiki",
"Icon Theme" => "Стил на иконките",
"Import pages from a PHPWiki Dump" => "Импорт на страници от PhpWiki Dump",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Път до мястото където са dump-натите файлове (спрямо директорията на TikiWiki с последващ slash например: dump/)",
"Jukebox Albums" => "Джубокс албуми",
"create new album" => "създаване на нов албум",
"Admin Genres" => "Админски жанрове",
"Create a new album" => "Създаване на нов албум",
"Edit this album:" => "Промяна на този албум:",
"Max tracks per page" => "Максимален брой парчета на страница",
"Other users can upload tracks to this album" => "Други потребители могат да качват парчета към този албум",
"You can access this album using the following URL" => "Можете да посещавате албума на този адрес",
"Jukebox Genres" => "Джубокс жанрове",
"create new genre" => "създаване на нов жанр",
"Create a new genre" => "Създаване на нов жанр",
"Edit this genre:" => "Редакция на жанр:",
"sort order" => "сортиране по",
"Jukebox Menu" => "Джубокс меню",
"Genres Admin" => "Администрация на жанрове",
"Jukebox Admin" => "Администрация на джубокс",
"Tikiwiki mods Admin" => "Администрация на мод-овете на Tikiwiki",
"rebuild local list" => "реконструкция на локалния списък",
"refresh servers list" => "обновяване на списъка със сървъри",
"post new reply" => "публикация на нов отговор",
"Show forbidden results" => "Показване на забранените резултати",
"Update index" => "Обновяване на индекса",
"Administration" => "Администрация",
"-1m" => "-1m",
"+1m" => "+1m",
"Security check failed!" => "Неуспех на теста за сигурност!",
"You must be logged in to subscribe to events" => "Трябва да сте влезли в системата за да можете да се абонирате за нови събития",
"You have to type a searchword" => "Трябва да въведете дума за търсене",
"Upload was not successful (maybe a duplicate file)" => "Качването бе неуспешно (вероятно дублиращ се файл)",
"You have to provide a name to the image" => "Трябва да въведете име за картината",
"not enough fields in data" => "недостатъчно полета в данните",
"no attachment on this page." => "няма приставка на тази страница",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed." => "num е незадължителен и е номерът на приставката в списъка. Ако не бъде въведен, ще бъде показан списък с всички приставки.",
"to add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "за да добавите/премахнете блогове, отидете на \"Създаване/Промяна на блогове\" в секцията \"Блогове\" на менюто на приложението или",
"Blog settings" => "Настройки на блогове",
"look under \"Articles\" on the application menu for links to" => "вижте под \"Статии\" в менюто на приложението за връзки към",
"to configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "за да конфигурирате вашата директория, намерете \"Настройки на директория\" под \"Директория\" в менюто на приложението или",
"to add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "За да добавите/премахнете FAQ, потърсете \"Настройки за FAQ\" под \"FAQs\" в менюто на приложението, или",
"FAQs settings" => "FAQ настройки",
"FAQ comments" => "Коментари на FAQs",
"to add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "за да добавите/премахнете галерии, отидете на \"Файлови галерии\" в менюто на приложението или",
"to add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "за да добавите/премахнете форуми, отидете на \"Настройки на форуми\" под \"Форуми\" в менюто на приложението или",
"to add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "за да добавите/премахнете картинни галерии, отидете на \"Картинни галерии\" в менюто или",
"Site Identity Settings" => "Настройки за \"самоличността\" на сайта",
"Poll settings" => "Настройки на анкетите",
"to configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "за да конфигурирате вашите tracker-и отидете на  \"Настройки на tracker-и\" под \"Tracker-и\" в менюто или",
"Create a tag for the current wiki" => "Създаване на етикет за текущото wiki",
"Tag Name" => "Име на етикет",
"Restore the wiki" => "Възстановяване на wiki",
"Remove a tag" => "Премахване на етикет",
"Wiki comments settings" => "Настройки за коментарите в Wiki",
"Wiki page list configuration" => "Конфигурация на списъка страници на Wiki",
"Wiki 3D browser configuration" => "Конфигурация на Wiki 3D",
"Set" => "Настройване",
"admin categories template" => "шаблон за настройките на категориите",
"ChatAdmin" => "ЧатАдмин",
"ChatAdmin tpl" => "ЧатАдмин шаблон",
"admin Drawings" => "Администрация на рисунките",
"AdminDSN" => "АдминDSN",
"admin ExternalWiki" => "Настройки външноWiki",
"admin HtmlPages" => "администрация на HTML страници",
"admin HtmlPages template" => "шаблон за администрация на HTMLстраници",
"Add all your site users to this newsletter (broadcast)" => "Добавяне на всички потребители на сайта към тази емисия (newsletter)",
"Add all users" => "Добавяне на всички потребители",
"Batch upload (CSV file)" => "Качване на партида (CSV файлове)",
"Articl" => "Статия",
"assgn" => "определяне",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"today" => "днес",
"events" => "събития",
"Event ID" => "номер на събитие",
"Add Calendar Item" => "Добавяне на елемент към календара",
"drawings" => "рисунки",
"file galleries tpl" => "картинни галерии tpl",
"act status" => "статус на дело",
"running" => "активен в момента",
"admin DynamicContent" => "настройки за динамично съдържание",
"MyTikiDoc" => "МоетоTikiDoc",
"you can see users rank by score in the module users_rank, for that go to" => "можете да видите ранга на потребителите според техния резултат в модула users_rank, затова отидете на",
"Comparing the version {\$old.version} with the version {\$new.version}" => "Сравняване на версия {\$old.version} с версия {\$new.version}",
"Received Pages" => "Получени страници",
"Send Objects" => "Изпратени обекти",
"create new user" => "създаване на нов потребител",
"All tasks" => "Всички задачи",
"mark as done" => "маркирй като готово",
"open tasks" => "отваряне на задачи",
"Add or edit a task" => "Добавяне или редакция на задача",
"Start date" => "Начална дата",
"Completed" => "Завършен",
//"perm" => "perm",
"Tracker Items" => "Елементи на тракъра",
"since this is your registered email address we inform that the" => "Тъй като това е вашият регистриран адрес, ние ви информираме, че",
"password for this account is" => "паролата за този акаунт е",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Страницата {\$mail_page} беше променена от {\$mail_user} на\n{\$mail_date|tiki_short_datetime}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Вие можете да редактирате страницата като посетите този линк:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"Event:" => "Събитие:",
"You can unsubscribe from this event following this link" => "Можете да прекратите абонамента си за това събитие като посетите този линк",
"Welcome to our event!" => "Добре дошли!",
"content templates" => "шаблони съдържание",
"Click the :: option on the menu for more options." => "Кликнете :: опцията в менюто за още опции.",
"Please also see" => "Моля, вижте и",
"Admin->Modules" => "Администрация->Модули",
"List Calendars" => "Списък с календари",
"upgrade to " => "upgrade до",
"up to date" => "up to date",
"Edit Submissions" => "Редактиране на Submissions",
//"<b>*</b>=optional, <b>Topline</b>=small line above Title, <b>Subtitle</b>=small line below Title, <b>Source</b>=URL to article source" => "<b>*</b>=optional, <b>Topline</b>=small line above Title, <b>Subtitle</b>=small line below Title, <b>Source</b>=URL to article source",
"list events" => "списък със събития",
"admin events" => "администрация на събития",
"send events" => "изпращане на събития",
"Company" => "Компания",
"company" => "компания",
"admin events template" => "администрация на шаблоните събития",
"Create/edit events" => "Създаване/редакция на събития",
"There are individual permissions set for this event" => "Има индивидуални позволения настроени за това събитие",
"Add unsubscribe instructions to each event" => "Добавяне на инструкции за прекратяване на абонамент към всяко събитие",
"send event" => "изпращане на събитие",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No events will be sent to you until the subscription is confirmed." => "Благодарим ви, че се абонирахте. Скоро ще получите и-мейл за да потвърдите абонамента си. Няма да ви бъдат изпращани никакви събития докато не потвърдите абонамента си.",
"Subscribe to event" => "Абонация за събитие",
"First Name:" => "Собствено име:",
"Last Name:" => "Фамилия",
"Company:" => "Компания",
"The event was sent to {\$sent} email addresses" => "Това събитие бе изпратено на адрес {\$sent}",
"This event will be sent to {\$subscribers} email addresses." => "Това събитие ще бъде изпратено на следните адреси: {\$subscribers} ",
"Prepare a event to be sent" => "Подготовка за изпращане на събитие",
"Frienship request sent to %s" => "Покана за приятелство изпратена на %s",
"No event indicated" => "Не е посочено събитие",
"Users see and add events in their timezone" => "Потребителите виждат и добавят събития според собствената си часова зона",
"Original Image is default scale" => "Оригиналната снимка е размер по подразбиране",
"%B %e, %Y" => "%e %B %Y",
"Move %s in %s" => "Преместване на %s към/в %s",
"General Admin Doc" => "Главна документация за Админ",
"Also use transition stylesheet" => "Също така използване на transition stylesheet",
"to add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "за да добавите/премахнете анкети, отидете на \"Анкети\" под \"Администрация\" в главното меню, или",
"Communcation Center" => "Център за комуникация",
"Gender" => "Пол",
"You can view a diff back to the previous version by following\nthis link:" => "Можете да видите разликите с предишната версия като посетите \n този линк:",
"To the event:" => "Към събитието:",
"The newletter subject is:" => "Темата на емисията(newsletter) е:",
"Custom Events" => "Custom събития",
"Search : " => "Търсене : ",
"Dont forget to use feature you will need to enable it on the Features icon." => "Не забравяйте, че за да използвате някоя функция, ще трябва да я активирате от иконката с функциите",
"Risk Faktor" => "Риск фактор",
"You can edit the page by following this link:" => "Можете да редактирате страницата като посетите този линк:",
"System Gallery" => "Системна галерия",
"Exact match" => "Точно съвпадение",
"Locations separator:" => "Разделител на локациите:",
"Tag name:" => "Име на етикет:",
"as Creator & Last Editor" => "като създател и последен редактор",
"Tiki RSS Feed Error Message" => "Съобщение за грешка на  Tiki RSS емисия",
"Append CSS file to feed urls" => "Добавяне на CSS файл към url на емисиите",
"Publisher" => "Издател",
"Larger font for:" => "По-голям шрифт за:",
"Sorry, \"\$page\" has not been created." => "Съжалявам, \"\$page\" не е създадена.",
"module" => "модул",
"Php error reporting level for non-admin:" => "Докладване на PHP грешки за не-администратори:",
"make a line break" => "вмъкване на символ за край на ред",
"Currencies" => "Валути",
"Create Currency" => "Създаване на валута",
"Add Transaction" => "Добавяне на транзакция",
"My Ledgers" => "Моите счетоводни книги",
"My Transactions" => "Моите транзакции",
"List Ledgers" => "Списък със счетоводни книги",
"List Transactions" => "Списък с транзакции",
"No entry" => "Вход забранен",
"from account" => "от акаунт",
"to account" => "към акаунт",
"amount" => "количество",
"confirm" => "потвърждение",
"All Currencies" => "Всички валути",
"Registered Currencies" => "Регистрирани валути",
"Owned Currencies" => "Собствени валути",
"Create new currency" => "Създаване на нова валута",
"Register an existing unlisted currency" => "Регистрация на съществуваща валута.",
"Last transaction" => "Последна транзакция",
"Features setting" => "Настройки на функции",
"This is not a Tikiwiki File. Check if this file was uploaded and if it is dangerous." => "Това не е файл на Tikiwiki. Проверете дали този файл е бил качен и дали не е опасен.",
"File Gallery successfully added to the project." => "Файлова галерия бе успешно добавена към проекта.",
"You must provide a project name" => "Трябва да въведете име на проекта",
"You must provide a project description" => "Трябва да въведете описание на проекта",
"A project with that name already exists" => "Проект с това име вече съществува",
"Tiki Projects" => "Tiki Проекти",
"Enable cache images" => "Позволение за кеширане на изображения",
"Import html" => "Внасяне на html",
"Categorie:" => "Категория:",
"Editing tracker item" => "Редактиране на елемент от тракъра",
"Projects Menu" => "Меню Проекти",
"Register New Project" => "Регистриране на нов проект",
"This is not a Tikiwiki 1.9 file. Check if this file was uploaded and if it is dangerous." => "Това не е Tikiwiki 1.9 файл. Проверете дали този файл е бил качен и дали не е опасен.",
"Last transastion" => "Последна транзакция",
"Transaction" => "Транзакция",
"balance" => "баланс",
"transactions" => "транзакции",
"Balance" => "Баланс",
"This file is modified." => "Този файл е променен.",
"Sorry, the currency \$currency is not available." => "Съжалявам, валутата \$currency липсва.",
"Sorry, you are not registered into currency \$currency." => "Съжалявам, вие не сте регистриран/а към валута \$currency.",
"formula" => "формула",
"Renders a graph, with linked pages navigation visually figured.\n" => "Представя графика с линкнати страници, оформена визуално.\n",
"the number of hops the graph follows\n" => "брой стъпки, които следва графиката",
"the title of the map\n" => "заглавието на картата\n",
"the space between nodes\n" => "разстоянието между възлите\n",
"Left to Right, the direction of graph\n" => "От ляво на дясно, посоката на графиката\n",
"the background color, use #rrvvbb color types.\n" => "цвят на фона във формат #rrvvbb.\n",
//"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "nothing there, unlimited size. use 5,3 type sizes in inches\n",
"the font size in pts presumably\n" => "размерът на шрифта вероятно е в pts\n",
"the name of the font used for labels\n" => "името на шрифта използван за етикети\n",
"the shape of a node. can be " => "формата на възела. може да бъде ",
"plaintext ellipse circle egg triangle box diamond trapezium parallelogram house hexagon octagon\n" => "plaintext елипса кръг яйце триъгълник кутия диамант трапец паралел успоредник къща хексагон октагон\n",
"style for drawing nodes.\n" => "стил за рисуване на възли.\n",
"color of the border\n" => "цвят на границата\n",
"background color of the node\n" => "фон на възела\n",
//"sortof relative width ??\n" => "sortof relative width ??\n",
"same mystery as above\n" => "същата мистерия като по-горе\n",
"color for links (called edges here)\n" => "цвят на линковете (наричани ръбове тук)\n",
"shape of the arrow that come with the link\n" => "форма на стрелката, която идва с линка\n",
"Redirects you to another wiki page" => "Препраща ви към друга страница от wiki-то",
"Oops!" => "Опа!",
"Go \n                            back" => "Връщане \n                            назад",
"Return \n                            to home page" => "Връщане \n                             към заглавната страница",
"[sign out]" => "[изход от системата]",
"Confirmation required" => "Изисква се потвърждение",
"Go \n                          back" => "Връщане \n                          назад",
"Return to \n                          home page" => "Връщане към \n                          заглавната страница",
"remember me" => "запомни ме",
"forgot my pass" => "забравих си паролата",
"Go \r\n                    back" => "Връщане назад",
"Return to home \r\n                    page" => "Връщане към заглавната страница",
"DNS check failed for %s" => "DNS проверката се провали за %s",
"Request failed for %s" => "Заявката се провали за %s",
"Register" => "Регистрация",
"Approval?" => "Одобрение?",
"Listed?" => "Показва се?",
"Examine" => "Преглед",
"Unregister" => "Отрегистриране",
"Reregister" => "Пререгистрация",
"Pending Registration" => "Очакваща регистрация",
"Modify a Currency" => "Модифициране на валута",
"Create a new Currency" => "Създаване на нова валута",
"List Currencies" => "Списък с валути",
"My Currencies" => "Моите валути",
"Requires approval" => "Изисква одобрение",
"Listed publicly" => "Публично достъпен/на",
"Register Owner" => "Регистриран собственик",
"Main Ledger" => "Главна счетоводна книга",
"New Transaction with" => "Нова транзакция с",
"last transaction date" => "дата на последната транзакция",
"total volume" => "общ обем",
"with" => "с",
"Revert Transaction" => "Отмяна на транзакция",
"record" => "запис",
"revert" => "отмяна",
"Examine Currency" => "Преглед на валута",
"Edit currency" => "Редакция на валута",
"Amount of transactions" => "Обем на транзакциите",
"Number of transactions" => "Брой на транзакциите",
"Approved?" => "Одобрен?",
"Currencies Admin" => "Администрация валути",
"Contact email" => "И-мейл за контакт",
"Insert javascript into a page." => "Вмъкване на javascript в страница.",
"Friendship network" => "Мрежа от приятели",
"Allow permissions for friendship network" => "Позволяване на права за мрежа от приятели",
"Max friendship distance" => "Максимално разстояние за приятелство",
"tracker item" => "елемент от tracker",
"List all projects" => "Списък с всички проекти",
"Please choose your project categories carefully. You can\nhowever change this later on your project admin panel." => "Изберете категориите на проектите внимателно. Вие ще можете \n да ги променяте от панела за администрация на проектите.",
"All project names are converted to lowercase." => "Всички имена на проекти ще бъдат превърнати в низове от малки букви.",
"permission." => "позволение.",
"Removed %s from group %s" => "%s беше премахнат от група %s",
"No entries available yet!" => "Все още няма въведено нищо!",
"Permission denied: you must be a teacher to access this page." => "Достъпът отказан: трябва да бъдете учител за да разглеждате тази страница.",
"Error: No assignment indicated." => "Грешка: не е посочено възложение.",
"Error: assignment not found." => "Грешка: не е открито възложение.",
"You must be a student to view this page." => "Трябва да сте ученик/студент за да разглеждате тази страница.",
" line " => " линия ",
" is not a student." => " не е студент/ученик.",
"Error: No" => "Грешка: Не",
"specified." => "уточнен.",
"Assignment not found" => "Не е открито възложение",
"Error: Invalid" => "Грешка: невалиден",
"Anonymous Grader" => "Анонимен ученик",
"Anonymous Peer Reviewer" => "Анонимен рецензент сред равни",
"No homework page indicated!" => "Не е посочена страница за домашна работа!",
"Error: Could not fetch page" => "Грешка: не успях да изтегля страницата",
"You must be a student to view this page!" => "Трябва да сте ученик/студент за да разглеждате тази страница!",
"Students may only view their own work!" => "Учениците могат да разглеждат само тяхната собствена работа!",
"Permission denied: You cannot rollback this page." => "Достъпът отказан. Не можете да върнете тази страница.",
"No hw page indicated" => "Не е посочена страница за домашна работа",
"Error: nonexistant version specified." => "Грешка: посочена е несъществуваща версия",
"Error: Could not fetch assignment " => "Грешка: не успях да взема задачата ",
"You must be a student to view homework assignments." => "Трябва да сте ученик за да можете да разглеждате задачите за домашна работа.",
"No assignment indicated" => "Не е посочена задача",
"Permission denied you must be a student to view assignments." => "Достъпът отказан: трябва да сте ученик за да можете да разглеждате задачите.",
"You must be a teacher or grader to access this page." => "Трябва да сте учител или ученик за да разглеждате тази страница.",
"Permission denied: You must be a teacher to edit assignments." => "Достъпът отказан: трябва да сте учител за да редактирате задачите.",
" error: Can not find assignment " => " грешка: Не е открита задача",
"Day" => "Ден",
"Invalid username or activation code" => "Невалидно потребителско име или активационен код.",
"A new password and your IP address has been sent " => "Нова парола и вашето IP бяха изпратени ",
"Feature" => "Свойство",
"Error: Call to hw_page_fetch_by_id failed!" => "Грешка: заявката към hw_page_fetch_by_id се провали!",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Опции за текстова зона: опции,широчина,височина,макс с опция е 1 или 0, останалите са размер посочен в знаци и редове, макс е максималния брой знаци които могат да бъдат запазени.",
"Image options: xSize,ySize indicated in pixels." => "Опции за изображение: xРазмер, yРазмер посочени в пиксели.",
//"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field.",
//"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere.",
"Jukebox settings" => "Настройки на джубокс",
"Jukebox tracks location" => "Местоположение на парчетата от джубокса",
"Jukebox features" => "Функции на джубокса",
"Default ordering for album listing" => "Команди по подразбиране за показване на списъка с албумите",
"Album title (asc)" => "Име на албум (възх)",
"Number of tracks (desc)" => "Брой песни (низх)",
"In album listing show user as" => "При показването на списъка с албуми покажи потребителя като",
"Jukebox listing configuration (when listing available albums)" => "Конфигурация за списъка на джубокса (когато се показват наличните албуми)",
"Tracks" => "Парчета",
"Genre" => "Жанр",
"Hide disabled sections" => "Скриване на деактивираните секции",
"Show disabled sections" => "Показване на деактивираните секции",
"Remind passwords by email" => "Напомняне на пароли по имейл",
"Wiki quick help" => "Wiki бърза помощ",
"Quicklinks" => "Бързи връзки",
"Due Date:" => "Крайна дата:",
"Comparing versions" => "Сравняване на версии",
"Actual_version" => "Сегашната версия",
"Diff to version" => "Разликите с версия",
"Assignments List" => "Списък със задачи",
"My Work" => "Моята работа",
"Assignment" => "Задача",
"Due Date" => "Крайна дата",
"Grading Queue " => "Ред за оценяване ",
"paper" => "документ",
"papers" => "документи",
"Edit Assignment" => "Редактиране на задачи",
"list assignments" => "списък със задачи",
"Due" => "Краен срок",
"create assignment" => "създаване на задача",
"Number Members" => "Брой членове",
"Number Admins" => "Брой админи",
"No projects found" => "Не бяха открити проекти",
"someone coming from IP Address" => "някой от този IP адрес: ",
"requested a reminder of the password for the" => "пожела напомняне на паролата за",
"requested a reset of the password for the" => "пожела генериране на нова парола за",
"The old password remains active until you activate the new one by following this link:" => "Старата парола остава кативна докато не активирате новата чрез посещение на този адрес:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Това е само временна парола. След като влезете с нея, веднага ще ви бъде предоставена бланката за смяна на парола",
"HomeworkMenu" => "МенюДомашни",
"Last Edit:" => "Последна редакция:",
"Grade Paper" => "Документ за оценка",
"Users choose project categories" => "Потребителите избират категории за проектите",
"Prefix for Wiki project home page" => "Преставка за началната страница на проект Wiki",
"Prefix for File Galleries" => "Преставка за файловите галерии",
"Create New Group" => "Създаване на нова група",
"Project Created:" => "Проектът бе създаден:",
"Project Info" => "Информация за проект",
"Project Members:" => "Членове на проекта:",
"View Details" => "Разглеждане на детайлите",
"Edit Project" => "Редакция на проект",
"Add Blog" => "Добавяне на блог",
"Add Articles" => "Добавяне на статия",
"Add Calendar" => "Добавяне на календар",
"Add FAQ" => "добавяне на FAQ секция",
"Add File Gallery" => "Добавяне на файлова галерия",
"Add Forum" => "Добавяне на форум",
"Add Image Gallery" => "Добавяне на картинна галерия",
"Add Newsletter" => "Добавяне на новинарска емисия",
"Add URL" => "Добавяне на URL",
"Project Object Created Successfully" => "Обектът на проекта бе създаден успешно",
"Project Name:" => "Име на проект:",
"Project Description:" => "Описание на проекта:",
"Project Active" => "Проекта е активен",
"Current Objects:" => "Сегашни обекти:",
"Add a File Gallery" => "Добавяне на файлова галерия",
"Permission" => "Позволение",
"Project Admin" => "Администрация на проекти",
"Project Members" => "Членове на проекта",
"Not Set" => "Не е настроен",
"You must be a student to edit homework pages." => "Трябва да сте ученик за да можете да редактирате страниците с домашна работа.",
"Error: Invalid id for hw_pages table." => "Грешка: невалиден номер за таблицата hw_pages.",
"Error: This page is being edited by another user." => "Грешка: Тази страница в момента се редактира от друг потребител.",
"Permission denied: Students may only view or edit their own work." => "Достъп отказан: учениците могат да разглеждат или редактират само собствената си домашна работа.",
"Error: Assignment not found." => "Грешка: не е открита задача.",
"Permission denied: Students may NOT edit their work after the due date." => "Достъп отказан: учениците НЕ МОГАТ да редактират домашната работа след като е изтекъл крайния срок.",
"Permission denied: The teacher must wait until the due date to edit students' work." => "Достъп отказан: Учителят трябва да изчака до изтичане на крайния срок за да може да редактира работата на учениците.",
"Orientation" => "Ориентация",
"Activs" => "Активни",
//"Ins" => "Ins",
"Type:" => "Тип:",
"Page:" => "Страница:",
"Jukebox" => "Джубокс",
"Jukebox preference" => "Предпочитания за джубокса",
"You do not have permission to write the template" => "Нямате позволение да напишете шаблона",
"Textarea options: quicktags,width,height,max - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved." => "Опции за текстова зона: бързиЕтикети,широчина,височина,макс - Употребата на бързиЕтикети е 1 или 0, широчината се обозначава в знаци, височината се обозначава в редове, макс е максималният брой знаци, който може да бъде запазен.",
"You need to supply information for : " => "Трябва да осигурите информация за:",
"Do nothing else that inserts the text" => "Не правете нищо друго, което вмъква текста",
"Insert CSS styles into a wiki page on the fly! You can both include an external file and/or just type the CSS in between the tags" => "Можете да вмъкнете CSS стилове в Уики страницата on the fly! Можете да включите външен файл или направо да напишете CSS код между tag-овете",
//"typed-inline style" => "typed-inline style",
"Change text font" => "Смяна на шрифта на текста",
"Lists ''wanted'' Wiki pages" => "Показва списък със страниците в Уики от типа 'търси се'",
"Like pages" => "Подобни страници",
"Category: wiki, trackers, etc." => "Категория: Уики, тракъри и т.н.",
//"Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='?' /></a>)" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='?' /></a>)",
"Portrait:" => "Портрет:",
"Landscape:" => "Пейзаж:",
"creates an editable drawing named foo" => "създава рисунка foo която може да се редактира",
"time" => "време",
"Preview Poll" => "Предварителен преглед на анкетата",
"Not rated yet" => "Все още не е оценен/а",
"Please follow the steps below to have your password properly reset:\n\n1. Click the following link to confirm you wish to reset your password:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Click the following link to go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nAlternatively, go to {\$mail_site} and login using your username and temporary password:\n Username:   {\$mail_user}\n Temporary password:  {\$mail_pass}\n\n3. Done! You should be logged in." => "Моля, следвайте тези стъпки за да си генерирате нова парола правилно:\n\n1.Кликнете на следващия линк за да потвърдите, че наистина искате да си генерирате нова парола: \n{\$mail_machine}?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n 2. Кликнете следващия линк за да отидете на екрана където трябва да въведете нова \"постоянна\" парола. Изберете парола, която знаете само вие и не я споделяйте с никой друг. \n{\$mail_site}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\n Друга алтернатива е да отидете на {\$mail_site} и да влезете в системата с вашата временна парола  Потребителско име: {\$mail_user}\n Временна парола: {\$mail_pass}\n\n3. Готово, би трябвало да можете да влезете в системата.",
"Information:" => "Информация:",
"Tracker was modified at %s" => "Тракърът е бил модифициран на %s",
"Languages" => "Езици",
"(This last day)" => "(Този последен ден)",
"(These last \$lastdays days)" => "(Тези последни \$lastdays дни)",
"Last days:" => "Последни дни:",
"Top `\$module_rows` Edited Pages" => "Топ `\$module_rows` редактирани страници",
"Top Edited Pages" => "Топ редактирани страници",
"Group:" => "Група:",
"Filter:" => "Филтър:",
"`\$module_rows` Most Commented" => "`\$module_rows` най-коментирани",
"Most Commented" => "Най-коментирани",
"`\$module_rows` Top Voted Comments" => "`\$module_rows` с най-висока оценка",
"Top Voted Comments" => "Най-високо оценени коментари",
"Sort:" => "Сортиране:",
"`\$module_rows` Top Page Editors" => "`\$module_rows` Топ редактори",
"Top Page Editors" => "Топ редактори на страници",
"Connection problem" => "Проблем при свързване",
"Reduce area width" => "Намаляване на ширината на зоната",
"Enlarge area width" => "Разширяване на зоната",
"Admin Translations" => "Администрация на преводите",
"Set of translations" => "Набор от преводи",
"Set language" => "Избор на език",
"Without translation" => "Без превод",
"quater" => "триместър",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Отидете на <a href=\"tiki-friends.php\">приятелска мрежа</a> за да приемете или отхвърлите тази молба",
"New blog post: {\$mail_title}: {\$title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Нов блог пост: {\$mail_title}: {\$title} от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"Upcoming `\$module_rows` modified events" => "Предстоящи `\$module_rows` модифицирани събития",
"You have to create a gallery first!" => "Първо трябва да създадете галерия!",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Използвайте {literal}{{/literal}ed id=name} или {literal}{{/literal}ted id=name} за да вмъкнете динамични зони",
"Please" => "Моля",
"log in" => "вход в системата",
"to access full functionalities" => "за да получите достъп до пълната функционалност",
"Export in CSV" => "Експорт в CSV",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>nomTopic)}{ARTICLES} Вмъкване на статия в Wiki",
"no description" => "няма описание",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize indicated in pixels." => "Опции за изображение: xListРазмер, yListРазмер, xДетайлРазмер, yДетайлРазмер посочени в пиксели.",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: несъответствие в броя редове: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check : провал",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check : последователността за редакция не е оптимална",
"WikiDiff Okay: LCS = %s" => "WikiDiff OK: LCS = %s",
//"Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
"TikiTabs" => "TikiТабове",
"Use Quote plugin for quoting" => "Използвайте Quote плъгина за да цитирате",
//"To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
"Field is hidden? (visible by admin only)" => "Полето е скрито? (Видимо само от администратори)",
"Edit information" => "Промяна на информация",
"Emphasis" => "Ударение",
"italics" => "курсив",
"both" => "и двата/двете",
//"make_headings" => "make_headings",
"underlines text" => "подчертава текста",
"Simple box" => "Обикновена кутия",
"Will display using the indicated HTML color" => "Ще се покаже използвайки посочения HTML цвят",
"Center" => "Центриране",
"Will display the text centered" => "Ще покаже текста центриран",
"Insert Module Output" => "Въведете output на модула",
//"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. ",
//"Rendering Program Code" => "Rendering Program Code",
//"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"slideshow backward" => "Презентация наобратно",
"Skip to navigation" => "Към 'навигация'",
"Download CVS export" => "Сваляне на CVS експорт",
"Project Group for " => "Група проекти за ",
//"Project Admin Group for " => "Project Admin Group for ",
"LDAP Host" => "LDAP Хост",
"LDAP Port" => "LDAP Порт",
"use ...page... to separate pages" => "използвайте ...page... за да разделите страниците",
"Invalid variable value : " => "Невалидна стойност напроменливата: ",
"Gallery Name" => "Име на галерията",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>IdFeed,max=>3,date=>1,body=>1)}{RSS} Вмъкване на rss емисия в уикистраница",
"The tracker needs a text field named Subject" => "Тракърът се нуждае от текстово поле наречено Subject",
"Your previously registered password has been sent " => "Вашата previously registered парола беше изпратена ",
"Displays the value of an tracker item field or the wiki text if test is true (if itemId not specified, the user tracker)." => "Показва стойността на полето от елемента на тракъра или уики текст ако теста е true (ако itemID не е посочен)",
"sorted section" => "сортирана секция",
"Flash binary (.sqf or .dcr)" => "Flash бинарен файл (.sqf ou .dcr)",
"Projects" => "Проекти",
"Projects configuration" => "Конфигурация на проектите",
"view faq" => "вижте FAQ секцията",
"admin FortuneCookie" => "администрация на FortuneCookies",
"admin cache" => "администрация на кеш",
"admin backups" => "администрация на резервни копия",
"admin shoutbox words" => "администрация на думите в мегафона",
"Mark entry as private:" => "Маркиране на елемента като частен:",
"admin content templates" => "администрация на шаблоните съдържание",
//"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n",
"admin Webmail" => "администрация на Уебмейл",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "За повече информация, вижте тук <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
"Search " => "Търсене ",
"Descriptions of the available profiles" => "Описание на наличните профили",
//"For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
"Search and replace" => "Търсене и замяна",
"Look &amp; feel" => "Изглед &amp; усещане",
"themes" => "теми",
"tikiwiki.org help" => "помощ от tikiwiki.org",
"Best language" => "Най-добър език",
"Template Viewing" => "Разглеждане на шаблони",
"HomePage" => "Начална Страница",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
"Incorrect thread" => "Неправилна последователност",
"Create a mouseover feature on some text" => "Създаване на mouseover функционалност за някой текст ",
//"Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
//"Displays the value of a tracker item field or the wiki text if the value of the field is set (if itemId not specified, use the itemId of the url or the user tracker)." => "Displays the value of a tracker item field or the wiki text if the value of the field is set (if itemId not specified, use the itemId of the url or the user tracker).",
// "~np~{~/np~EVENTS(calendarid=>id1+id2,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=>id1+id2,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
"The administrator has not yet validated your account. Please wait." => "Администраторът още не е одобрил вашият акаунт. Моля, изчакайте.",
"You must validate your account first. An email has been sent to you" => "Първо трябва да валидирате вашия акаунт. За целта ви беше изпратен и-мейл.",
"Another post with the same title and content already exists" => "Вече съществува статия със същото заглавие и съдържание",
// "Text area" => "Text area",
"Newsletters Help" => "Помощ за новинарски емисии",
"Format if not the default short one:" => "Format if not the default short one:",
"Show creation date when viewing tracker item?" => "Показване дата на създаване, когато се разглежда елемент от тракъра?",
"Show lastModif date when viewing tracker item?" => "Показване на дата на последна модификация при разглеждане на елемент от тракъра?",
"For more information, please see <a href=\"{\$helpurl}Wiki+Syntax\">Wiki Syntax</a>" => "За повече информация, моля вижте <a href=\"{\$helpurl}Wiki+Syntax\">Syntaxe Wiki</a>",
"Help with Mail-in accounts" => "Help with Mail-in accounts",
"Manage FortuneCookie" => "Настройки на FortuneCookies",
"Editing and Creating Blogs" => "Редактиране и създаване на блогове",
"Help for Backups" => "Помощ за резервни копия",
//"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n",
"Manage Banned Words in Shoutbox" => "Управление на забранените думи в мегафона",
"{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> е пожелал нова парола на {\$mail_site}, но се налага първо да му валидирате акаунта",
"LastModif" => "Последна модификация.",
// "Back links" => "Back links",
//"phpLayers Menus" => "phpLayers Menus",
"Administer modules" => "Администриране на модули",
"All Images" => "Всички изображения",
"Blog Help" => "Помощ за блог",
"View Templates" => "Разглеждане на шаблони",
"stop monitor" => "спиране на мониторинга",
"Text Area" => "Текстова зона",
"Add Pages" => "Добавяне на страници",
"No pages" => "Няма страници",
"Add Pages from Structures" => "Добавяне на страници от структури",
"No structures" => "Няма структури",
"Selected Pages" => "Избрани страници",
"Help system" => "Система за помощ",
"Descriptions of the \navailable profiles" => "Описание на \nналичните профили",
//"For information about tiki-secdb_*.sql files, please see <a target=\"help\" \nhref=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" \nhref=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
"sql queries" => "sql заявки",
//"To aggregate several RSS feeds, use {literal}{rss id=x+y+z}{/literal}. <b>\"show publish date\" must be checked.<b/>" => "To aggregate several RSS feeds, use {literal}{rss id=x+y+z}{/literal}. <b>\"show publish date\" must be checked.<b/>"
"monitor this forum topic and thread" => "Проследяване на тази тема от форума",
"stop monitoring this forum topic and thread" => "Спиране на проследяването на темата от форума",
"Help with Surveys" => "Помощ за анкетите",
"Refresh trackers search index now" => "Обновяване на индекса за търсене на тракерите",
"Refresh tracker search index now" => "Обновяване на индекса за търсене на тракъра",
// "Post level trackback pings" => "Post level trackback pings",
"Browse categories" => "Разглеждане на категориите",
"Administer categories" => "Администрация на категориите",
"Regex search " => "Търсене чрез regular expressions ",
"To display the objects you participate to:" => "За да се покажат обектите в които взимате участие:",
// "Field of view" => "Field of view",
"Import Page" => "Внасяне на страница",
"Regex search and replace" => "Regex търсене и замяна",
//"While classic trackers are mature, mirror table trackers are an experimental feature. Many bugs have been reported when using plugins, etc.  <b>Do NOT use mirror trackers unless you know what you are doing</b> and are ready to participate to development and debugging. Mirror trackers could even eventually be discontinued from Tiki." => "While classic trackers are mature, mirror table trackers are an experimental feature. Many bugs have been reported when using plugins, etc.  <b>Do NOT use mirror trackers unless you know what you are doing</b> and are ready to participate to development and debugging. Mirror trackers could even eventually be discontinued from Tiki."
"Help for managing cache" => "Помощ при управлението на кеша",
"Managing content templates" => "Управление на шаблоните съдържание",
"How to Use FAQs " => "Помощ за употребата на FAQs ",
"Trackers Help" => "Помощ за тракъри",
"How to Use FAQs" => "Как да използвам FAQs",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Description" => "Описание",
"normal" => "нормален",
"Articles" => "Статии",
"Wiki" => "Wiki",
"Forums" => "Форуми",
"FAQs" => "FAQs",
"Newsletter" => "Новинарска емисия",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Това не е TikiWiki файл. Проверете дали този файл е бил качен и дали не е опасен.",
"The file does not have the required header:" => "Файлът няма нужният хедър:",
"TOP" => "TOP",
"tiki-mobile.php" => "tiki-mobile.php",
"Page" => "Страница",
"id" => "номер",
"Image" => "Изображение",
"code" => "код",
"Total" => "Total",
"description" => "описание",
", " => ", ",
"minutes" => "минути",
"Score" => "Рейтинг",
"Pages" => "Страници",
"Article" => "Статия",
"FAQ" => "FAQ",
"Forum" => "Форум",
"forums" => "форуми",
"%d points" => "%d сочи",
"index" => "индекс",
"Plugin " => "Плъгин ",
"Date" => "Дата",
"article" => "статия",
"faq" => "faq",
"forum" => "форум",
"newsletter" => "новинарска емисия",
"image" => "изображение",
"Item" => "Елемент",
"max" => "макс",
"jscalendar" => "jscalendar",
"action" => "действие",
"message" => "съобщение",
"km" => "km",
"Webmail" => "УебМейл",
"Intertiki" => "Intertiki",
"i18n" => "i18n",
"Module" => "Модул",
"page" => "страница",
"Newsletters" => "Новинарски емисии",
"Workflow" => "Работен процес",
"phpinfo" => "информация за php",
"Mods" => "Модове",
"Mobile" => "Мобил",
"Menus" => "Менюта",
"Modules" => "Модули",
"DSN" => "ДСН (DSN)",
"Mail-in" => "Входяща поща",
"Points" => "Сочи",
"Instances" => "Инстанции",
"Type" => "Тип",
"Visible" => "Видим",
"Img" => "Изобр",
"zoom" => "zoom",
"position" => "позиция",
"type" => "тип",
"options" => "опции",
"Public" => "Публичен",
"Action" => "Действие",
"Copyrights" => "Авторски права",
"ID" => "Номер",
"archives" => "архиви",
"Sections" => "Секции",
"option" => "опция",
"Position" => "Позиция",
"Images" => "Изображения",
"sections" => "секции",
"version" => "версия",
"tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
"act" => "акт",
"val" => "val",
"Sites" => "Сайтове",
"Com" => "Com",
"Vers" => "Vers",
"ok" => "ok",
"Avatar" => "Avatar",
"standard" => "стандарт(ен)",
"Messages" => "Съобщения",
"Menu" => "Меню",
"Structures" => "Структури",
"top" => "начало",
"Style" => "Стил",
"images" => "изображения",
"articles" => "статии",
"Question" => "Въпрос",
"Questions" => "Въпроси",
"question" => "въпрос",
"Option" => "Опция",
"votes" => "гласa",
"pos" => "pos",
"chg" => "chg",
"info/vote" => "инфо/глас",
"desc" => "описание",
"Normal" => "Нормален",
"exceptions" => "изключения",
"InterTiki" => "InterTiki",
"Important" => "Важен(ни)",
"port" => "порт",
"IP" => "IP",
"Contact" => "Контакт",
"[-]" => "[-]",
"secs" => "сек",
"Cc" => "Cc",
"stop" => "стоп",
"Direction" => "Посока",
"Site" => "Сайт",
"Mb" => "Mb",
"bytes" => "байта",
"Versions" => "Версии",
"Section" => "Секции",
"Archive" => "Архив",
"JsCalendar" => "JsCalendar",
"page|desc" => "страница|описание",
"col" => "col",
"Actions" => "Действия",
"Port" => "Порт",
"mn" => "mn",
"PHPLayers" => "PHPLayers",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"Regex" => "Regex",
"You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
"score" => "резултат",
"Votes" => "Гласове",
"contacts" => "контакти",
"Contacts" => "Контакти",
"pop" => "pop",
"Msg" => "Msg",
"date" => "дата",
"clip" => "клип",
"cc" => "cc",
"bcc" => "bcc",
"phpLayersMenus" => "phpLayersMenus",
"structure" => "структура",
"table" => "таблица",
"hr" => "hr",
"Message" => "Съобщение",
"CC" => "CC",
"BCC" => "BCC",
"source" => "изходен код",
"points" => "points",
"5 minutes" => "5 минути",
"Items" => "Елементи",
"Expiration" => "Изтичане(на срок)",
"Texte" => "Текст",
"Newsgroup" => "Newsgroup",
"UTC" => "UTC",
"Local" => "Локално време",
"/" => "/",
"messages" => "съобщения",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"proc" => "proc",
"coms" => "coms",
"Alias" => "Псевдоним",
"%" => "%",
"questions" => "въпроси",
"pdf" => "pdf",
"debug" => "debug",
"structures" => "структури",
"Copyright" => "Copyright",
"minute" => "минута",
"Prefs" => "Предпочитания",
"RSS Wiki" => "RSS Wiki",
"RSS Articles" => "RSS Articles",
"RSS Forums" => "RSS Forums",
"pages" => "страници",
"URI" => "URI",
"h" => "h",
"mins" => "mins",
"SysLog" => "SysLog",
"Client" => "Клиент",
"Source" => "Source",
"pixels" => "пиксели",
"quota" => "квота",
"instance" => "инстанция",
"#" => "#",
"RSS" => "RSS",
// "popup" => "изскачащ прозорец",
"Zone" => "Зона",
"zone" => "зона",
"Original" => "Оригинал",
"taskId" => "номер на задча",
"Info" => "Инфо",
"If:SetNextact" => "If:SetNextact",
"<b>Item</b>" => "<b>Елемент</b>",
"Geourl" => "Geourl",
"geo.position" => "geo.position",
"geo.region" => "geo.region",
"geo.placename" => "geo.placename",
"Robots" => "Robots",
"Participants" => "Участници",
"Impressions" => "Впечатления",
"Information" => "Информация",
"Pos" => "Pos",
"Mode" => "Мод",
"interactive" => "интерактив",
"Minutes" => "Минути",
"Int" => "Int",
"Interactive" => "Интерактив",
"inter" => "inter",
"route" => "маршрут",
"Version" => "Версия",
"Quota (Mb)" => "Квота (Mb)",
"Prologue:" => "Пролог:",
"site" => "сайт",
"Distance" => "Разстояние",
"sites" => "сайтове",
"Unix" => "Unix",
"Windows" => "Windows",
"(standard)" => "(standard)",
"image/png" => "изображение/png",
"image/bmp" => "изображение/bmp",
"image/x-icon" => "изображение/x-icon",
"MultiTiki" => "MultiTiki",
"s=source" => "s=source",
"Attention" => "Внимание",
"Table" => "Таблица",
"pts" => "pts",
"actions" => "действия",
"adm" => "adm",
"Distance (km)" => "Разстояние (km)",
"min" => "мин",
"Date (desc)" => "Дата (низходящ)",
"Date (asc)" => "Дата (възходящ)",
"Score (desc)" => "Рейтинг (низходящ)",
"avatar" => "аватар",
"msgs" => "съобщения",
"Ratio" => "Съотношение",
"hist" => "история",
"v" => "v",
"Parent" => "Родител",
"loc" => "loc",
"participants" => "участници",
"cat" => "cat",
"lang" => "език",
"prio" => "prio",
"perso" => "perso",
"latin" => "латински",
"Portrait" => "Портрет",
"Horizontal" => "Хоризонтален",
"Vertical" => "Вертикален",
"Msgs" => "Съобщения",
"Dif" => "Dif",
"Notifications" => "Уведомления",
"Imgs" => "Изобр",
"Pan" => "Pan",
"Page alias" => "Page alias",
"cType" => "cType",
"Structure" => "Структура",
"PEAR::Auth" => "PEAR::Auth",
"LDAP" => "LDAP",
"Version 1.0" => "Version 1.0",
"Version 2.0" => "Version 2.0",
"Documentation" => "Документация",
"section" => "секция",
"+" => "+",
"Ver" => "Ver",
"Q" => "Q",
"1 suggestion" => "1 предложение",
"suggestions" => "предложения",
"auto" => "авто",
"int" => "int",
"Instance" => "Инстанция",
"Workitems" => "Workitems",
"exception" => "изключение",
"tikiwiki.org" => "tikiwiki.org",
"unicode" => "уникод",
"Catalan" => "Catalan",
"Tuvaluan" => "Tuvaluan",
"Afghanistan" => "Afghanistan",
"Antigua" => "Antigua",
"Anguilla" => "Anguilla",
"Angola" => "Angola",
"Aruba" => "Aruba",
"Bangladesh" => "Bangladesh",
"Burundi" => "Burundi",
"Brunei" => "Brunei",
"Bahamas" => "Bahamas",
"Botswana" => "Botswana",
"Belize" => "Belize",
"Canada" => "Canada",
"Congo" => "Congo",
"Cuba" => "Cuba",
"Djibouti" => "Djibouti",
"France" => "France",
"Gabon" => "Gabon",
"Ghana" => "Ghana",
"Gibraltar" => "Gibraltar",
"Guadeloupe" => "Guadeloupe",
"Guatemala" => "Guatemala",
"Guam" => "Guam",
"Guyana" => "Guyana",
"Honduras" => "Honduras",
"Iraq" => "Iraq",
"Iran" => "Iran",
"Jersey" => "Jersey",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Kazakstan" => "Kazakstan",
"Laos" => "Laos",
"Liechtenstein" => "Liechtenstein",
"Lesotho" => "Lesotho",
"Monaco" => "Monaco",
"Madagascar" => "Madagascar",
"Mali" => "Mali",
"Myanmar" => "Myanmar",
"Macao" => "Macao",
"Martinique" => "Martinique",
"Montserrat" => "Montserrat",
"Maldives" => "Maldives",
"Malawi" => "Malawi",
"Mozambique" => "Mozambique",
"Niger" => "Niger",
"Nigeria" => "Nigeria",
"Nicaragua" => "Nicaragua",
"Nauru" => "Nauru",
"Niue" => "Niue",
"Oman" => "Oman",
"Panama" => "Panama",
"Pakistan" => "Pakistan",
"Palestine" => "Palestine",
"Portugal" => "Portugal",
"Paraguay" => "Paraguay",
"Rwanda" => "Rwanda",
"Seychelles" => "Seychelles",
"Swaziland" => "Swaziland",
"Togo" => "Togo",
"Tokelau" => "Tokelau",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Taiwan" => "Taiwan",
"Ukraine" => "Ukraine",
"Uruguay" => "Uruguay",
"Vatican" => "Vatican",
"Venezuela" => "Venezuela",
"Vanuatu" => "Vanuatu",
"Samoa" => "Samoa",
"Mayotte" => "Mayotte",
"Zimbabwe" => "Zimbabwe",
"Europe" => "Europe",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Тази функция е деактивирана",
"No article indicated" => "Не е посочена статия",
"Article not found" => "Не е открита статия",
"Article is not published yet" => "Статията не е публикувана все още",
"Permission denied" => "Достъпът отказан",
"Task" => "Задача",
"was moved into trash" => "бе преместен/а в кошчето",
"trashed by" => "изхвърлен/а от",
"open / in process" => "отваряне / в процес",
"completed (100%)" => "готово (100%)",
"Task user" => "Потребител задача",
"Public for group" => "Публичен/а за група",
"Rights by creator" => "Права за създател",
"Title" => "Заглавие",
"Start" => "Старт",
"END" => "Финал",
"Priority" => "Приоритет",
"Status" => "Статус",
"Percentage" => "Процент",
"Task accepted by creator" => "Задачата е приета от създателя",
"Task accepted by task user" => "Задачата е приета от потребителя на задачата",
"Task NOT accepted by creator" => "Задачата не е приета от създателя",
"Task NOT accepted by task user" => "Задачата не е приета от потребителя",
"Must be logged to use this feature" => "Трябва да сте влезли в системата за да използвате тази функция",
"Permission denied to use this feature" => "Достъпът до тази функция ви е отказан",
"Sorry this task does not exist or you have no rights to view this task" => "Съжалявам, тази задача не съществува или вие нямате права за достъп до нея",
"Task entries:" => "Елементи на задачата:",
"Changes:" => "Промени:",
"Info message" => "Инфо съобщение",
"The task title must have at least 3 characters" => "Заглавието на задачата трябва да бъде дълго поне 3 символа",
"NEW Task" => "Нова задача",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Съжалявам, не е позволено да изпращате задачи на други потребители, или другият потребител няма права за получаване на задачи!",
"Changes on Task" => "Промени на задачата",
"You received a new task" => "Вие получихте нова задача",
"from" => "от",
"The priority is" => "Приоритетът е",
"very low" => "много нисък",
"low" => "нисък",
"high" => "висок",
"very high" => "много висок",
"You've to start your work at least on" => "Трябва да започнете вашата работа не по-късно от",
"You've to finish your work on" => "Трябва да довършите работата на",
"Login and click the link below" => "Влезте в системата и проверете този адрес",
"Please read the task and work on it!" => "Моля, прочетете задачата и работете над нея!",
"Sorry, there was an error while trying to write data into the database" => "Съжалявам, имаше грешка при опита за писане в базата данни",
"You don't have permission to edit quizzes." => "Нямате права за редакция на тестове",
"You do not have permission to use this feature" => "Нямате права за използване на тази функция.",
"Please create a category first" => "Моля, първо създайте категория",
"Image Galleries Admin Panel" => "Административен панел за картинните галерии",
"Could not read image %s." => "Неуспех при опит за четене на изображение %s.",
"Image %s upload failed." => "Опитът за качване на изображение %s се провали.",
"Image %s uploaded successfully." => "Изображение %s качено успешно.",
"Image %s removed from Batch directory." => "Изображение %s бе премахнато от директорията с партидата.",
"Impossible to remove image %s from Batch directory." => "Неуспех при премахването на изображение %s от директорията с партидата.",
"Permission denied you cannot use the batch directory loading" => "Достъпът отказан: Вие нямате право да използвате функцията за качване на директории с партиди",
"Incorrect directory chosen for batch upload of images." => "Неправилна директория избрана за качване на партида изображения.",
"Please setup that dir on " => "Моля, настройте тази директория на ",
"Please contact the website administrator." => "Моля, свържете се с администратора на уеб сайта.",
"Invalid directory name" => "Невалидно име на директория",
"You must specify a page name, it will be created if it doesn't exist." => "Трябва да посочите име на страница. Тя ще бъде създадена ако не съществува.",
"page not added (Exists)" => "страницата не беше добавена (Съществува)",
"Permission denied you cannot edit this article" => "Достъпът отказан: нямате право да редактирате тази статия",
//"The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
"page imported" => "страницата бе внесена",
"created from import" => "създадена от импорт",
"You have mistyped the anti-bot verification code; please try again." => "Не сте написали правилно анти-бот кода. Опитайте отново",
"Can't import remote HTML page" => "Невъзможно импортиране на далечна HTML страница",
"Can't parse remote HTML page" => "Невъзможна обработка на далечната HTML страница",
"You cannot edit this page because it is a user personal page" => "Нямате право да редактирате тази страница, защото тя е персонална страница на някой потребител",
"The SandBox is disabled" => "SandBox-ът е деактивиран",
"Cannot edit page because it is locked" => "Невъзможна редакция на страницата, защото тя е заключена",
"Permission denied you cannot edit this page" => "Достъпът отказан: вие нямате право да редактирате тази страница",
"UserPageadmin" => "АдминПотребителскиСтраници",
"No content id indicated" => "Не е посочен номер на съдържание",
"No page indicated" => "Не е посочена страница",
"Permission denied you cannot assign permissions for this page" => "Достъп отказан: вие не можете да определяте позволенията за тази страница",
"Page cannot be found" => "Страницата не може да бъде намерена",
"You are not logged in" => "Вие не сте влезли в системата",
"You do not have permission to view other users data" => "Нямате позволение да разглеждате информацията на другите потребители",
"Upload was not successful" => "Качването беше успешно",
"Invalid filename (using filters for filenames)" => "Невалидно име на файл (Използват се филтри за имената на файловете - те могат да съдържат само латински букви и цифри)",
"No permission to upload zipped file packages" => "Нямате права да качвате архивирани файлови пакети",
"Errors detected" => "Възникнаха грешки",
"Cannot read file" => "Грешка при четене на файл",
"Cannot write to this file:" => "Грешка при писане във файл:",
"File update was successful" => "Обновяването на файла протече успешно",
"Permission denied you cannot upload files" => "Достъп отказан: нямате право да качвате файлове",
"Could not find the file requested" => "Не успях да открия желания файл",
"Permission denied you can upload files but not to this file gallery" => "Достъп отказан: вие имате право да качвате файлове, но не и към тази галерия",
"Insert list of items for the current/given category into wiki page" => "Въведете лист предмети за сегашната/някоя категория във уики страницата",
"Categories are disabled" => "Категориите са деактивирани",
"Access Denied" => "Достъпът отказан",
"Top" => "Топ",
"Re:" => "Re:",
"at" => "на",
"edit" => "редакция",
"Quick edit a Wiki page" => "Бърза редакция на Уики страница",
"This module requires parameters trackerId and name set" => "Този модул изисква параметри trackerID и имена",
"move %s in %s" => "преместване на %s в %s",
"Please provide an Id" => "Моля, осигурете номер (ID)",
"no object here yet" => "тук все още няма обекти",
"Since your last visit" => "След последното ви посещение",
"Changes" => "Модификации",
"since" => "след",
"Changes since" => "Промени след",
"new comments" => "Нови коментари",
"by" => "от",
"new posts" => "нови постинги",
"wiki pages changed" => "променени Уики страници",
"new articles" => "нови статии",
"new FAQs" => "нови FAQs",
"new blogs" => "нови блогове",
"new blog posts" => "нови блог статии",
"new image galleries" => "нови картинни галерии",
"new images" => "нови изображения",
"new file galleries" => "нови файлови галерии",
"new files" => "нови файлове",
"new polls" => "нови анкети",
"new users" => "нови потребители",
"new tracker items" => "нови елементи в тракъра",
"no such file" => "не съществува такъв файл",
"Error" => "Грешка",
"Account validated successfully." => "Акаунтът бе валидиран успешно.",
"Invalid username or password" => "Невалидно потребителско име или грешна парола",
"A SheetId is required." => "Номерът на листа (SheetId) е задължителен.",
"You don't have permission to use this feature" => "Нямате позволение да използвате тази функция",
//"Post recommendation at" => "Post recommendation at",
"No post indicated" => "Не е посочен постинг",
"Permission denied you can not view this section" => "Достъпът отказан: вие нямате право да разглеждате тази секция",
"Blog not found" => "Блогът не бе открит",
"One of the email addresses you typed is invalid" => "Един от и-мейл адресите които въведохте е невалиден",
"You must be logged in to subscribe to newsletters" => "Трябва да сте влезли в системата за да можете да се абонирате за новинарски емисии",
"Unknown group" => "Непозната група",
"Group doesnt exist" => "Групата не съществува",
"You must log in to use this feature" => "Трябва да влезете в системата за да използвате тази функция",
"Please login" => "Моля, влезте в системата",
"Permission denied you cannot view this page" => "Достъпът отказан: вие не можете да разглеждате тази страница",
"Permission denied you cannot view the calendar" => "Достъпът отказан: вие не можете да разглеждате този календар",
"Image Gallery" => "Картинна галерия",
"Blogs" => "Блогове",
"Directory" => "Директория",
"File Gallery" => "Файлова галерия",
"Quizzes" => "Тестове",
"Trackers" => "Тракъри",
"Survey" => "Проучване",
"Ephemerides" => "Еднодневки",
"Charts" => "Схеми",
"event without name" => "събитие без име",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Първи ден от седмицата: понеделник (неговото ID е 1)",
"%H:%M %Z" => "%Hh%M",
"%m/%d" => "%d/%m",
"Sunday" => "Неделя",
"Monday" => "Понеделник",
"Tuesday" => "Вторник",
"Wednesday" => "Сряда",
"Thursday" => "Четвъртък",
"Friday" => "Петък",
"Saturday" => "Събота",
"No tracker indicated" => "Не е посочен тракър",
"No topic id specified" => "Не е посочен номер на тема",
"Invalid topic id specified" => "Невалиден номер на тема",
"This feature has been disabled" => "Тази функция е деактивирана",
"unsafe" => "необезопасено",
"register_globals should be off by default. See the php manual for details." => "register_globals трябва да е изключен по подразбиране. Вижте ръководството на php за подробности.",
"safe" => "безопасно",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid трябва да е изключено по подразбиране. Вижте ръководството на php за подробности.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir вероятно е в вътре в директорията на Tikiwiki. Има риск някой да успее да качи файлове в тази директория и да ги достъпва чрез уеб браузър",
"unknown" => "незнаен",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "не мога да проверя дали upload_tmp_dir е достъпна през уеб браузър. За да бъдете сигурни, би трябвало да проверите настройките на вашия уеб сървър.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "позволяването на опцията xbithack е опасно. В зависимост от начина на обработка на файлове от вашия уебсървър и вашите Тики настройки, може да е възможно някой да успее да качи скриптове във файловата галерия и да ги изпълни",
"risky" => "рискован",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen peut е възможно да бъде използвана за качване на файлове и скриптове. Ако не използвате функцията за блог, най-добре е да изключите опцията",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Пътят за съхранение на файловете във файловата галерия трябва да бъде извън главната директория на ТикиУики.",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Пътят за съхранение на файловете на картинната галерия трябва да бъде извън главната директория на ТикиУики.",
"on" => "на",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "Функцията \"Редакция на шаблони\" е включена. Не позволявайте тя да бъде използвана от някой на когото не можете да имате пълно доверие. Тя може да лесно да бъде използвана за инжектиране на php код.",
"installed" => "инсталиран",
//"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
//"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
//"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
//"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
"Path disclosure" => "Разкриване на пътя (file path)",
//"Path disclosure through error message" => "Path disclosure through error message",
"SQL injection" => "SQL Инжекция",
"SQL injection by authenticated user" => "SQL инжекция от неидентифициран потребител",
"SQL injection by authenticated user with special privileges" => "SQL инжекция от идентифициран потребител със специални привилегии",
"SQL injection without authentication" => "SQL инжекция без идентификация",
"PHP command injection" => "инжекция PHP команда",
"PHP command injection by authenticated user" => "Инжекция на PHP команда от регистриран потребител",
"PHP command injection by authenticated user with special privileges" => "Инжекция на PHP команда от регистриран потребител със специални функции",
"PHP command injection without authentication" => "Инжекция на PHP команда без идентификация",
"File upload" => "Качване на файл",
"File is not readable. Unable to check." => "Файлът не може да бъде прочетен. Проверка невъможна.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Това е модифициран файл. Не мога да проверя версията. Проверете дали е опасен.",
"This file is from another Tikiwiki version: " => "Този файл е от друга версия на Tikiwiki",
" or " => " или ",
"Top pages" => "Топ страници",
"Last pages" => "Последни страници",
"Most relevant pages" => "Най-подходящите страници",
"Top authors" => "Топ автори",
"Permission denied you cannot view this section" => "Достъпът отказан: вие не можете да разглеждате тази секция",
"Permission denied you cannot create galleries and so you cant edit them" => "Достъпът отказан: вие не можете да създавате галерии, следователно не можете да ги модифицирате.",
"Permission denied you cannot edit this gallery" => "Достъпът отказан: нямате право да модифицирате тази галерия",
"Permission denied you cannot remove this gallery" => "Достъпът отказан: нямате право да премахнете тази галерия",
"Must enter a name to add a site. " => "Трябва да въведете име за да добавите сайт. ",
"Must enter a url to add a site. " => "Трябва да въведете URL за да добавите сайт. ",
"URL already added to the directory. Duplicate site? " => "Този адрес вече е добавен към директорията. ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Адресът не може да бъде открит. Грешен адрес, или сайтът е офлайн и не може да бъде добавен към директорията. ",
"Must select a category. " => "Трябва да изберете категория. ",
"No item indicated" => "Не е посочен елемент",
"That tracker don't use extras." => "Тракърът не ползва екстри.",
"The file is not a CSV file or has not a correct syntax" => "Файлът не е CSV файл или съдържа синтактични грешки",
"No records were found. Check the file please!" => "Не са открити записи. Проверете файла, ако обичате!",
"User login is required" => "Задължително трябва да се въведе потребителско име",
"Password is required" => "Задължително трябва да се въведе парола",
"Email is required" => "Задължително трябва да се въведе и-мейл",
"Login contains invalid characters" => "Потребителското име съдържа невалидни знаци",
"User is duplicated" => "Съществува такъв потребител",
"Created account %s <%s>" => "Създаване на акаунт %s <%s>",
"Unknown" => "Непознат",
"Assigned %s in group %s" => "Записах %s в група %s",
"The passwords don't match" => "Паролата в двете полета не съвпада",
"User %s already exists" => "Потребител %s вече съществува",
"User login contains invalid characters" => "Потребителското име съдържа непозволени символи",
"New %s created with %s %s." => "Нов/а %s беше създаден/а със %s %s.",
"user" => "потребител",
"username" => "потребителско име",
"Impossible to create new %s with %s %s." => "Невъзможност за създаване на нов %s с %s %s.",
"%s %s successfully deleted." => "%s %s бе изтрит/а успешно.",
"%s %s removed from %s %s." => "%s %s бе премахнат/а от %s %s.",
"group" => "група",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> бе изтрит/а успешно.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> приписан на %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> премахнат от %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "le groupe <b>%s</b> бе настроена като група по подразбиране за потребител <b>%s</b>.",
"User already exists" => "Този потребител вече съществува",
"The passwords dont match" => "Паролата в двете полета не съвпада",
"Password should be at least" => "Паролата трябва да бъде дълга най-малко",
"characters long" => "символа",
"Password must contain both letters and numbers" => "Паролата трябва да съдържа и букви и цифри",
"%s modified successfully." => "%s модифициран успешно.",
"password" => "парола",
"%s modification failed." => "модификацията на %s се провали.",
"%s changed from %s to %s" => "%s бе променен/а от %s на %s",
"email" => "и-мейл",
"Impossible to change %s from %s to %s" => "Невъзможност за промяна на %s от %s на %s",
"login" => "вход в системата",
"No category indicated" => "Не е посочена категория",
"Permission denied; you cannot assign permissions for this category" => "Достъпът отказан: не можете да определяте позволения за тази категория",
"This script cannot be called directly" => "Този скрипт не може да бъде извикан директно",
//"merged note:" => "merged note:",
"File is too big" => "Файлът е прекалено голям",
"No cache information available" => "Не е налична информация за кеша",
"You do not have permissions to edit banners" => "Нямате права за редактиране на банери",
"Banner not found" => "Банерът не беше открит",
"You do not have permission to edit this banner" => "Нямате права за редактиране на този банер",
"Unknown user" => "Непознат потребител",
"User doesnt exist" => "Потребителят не съществува",
"You have to indicate a group" => "Трябва да посочите група",
"This group is invalid" => "Групата е невалидна",
"Permission denied you cannot remove this blog" => "Достъпът отказан: нямате права да изтриете този блог",
"You couldn't abort a instance" => "Не успяхте да спрете инстанцията",
//"You couldn't exception a instance" => "You couldn't exception a instance",
"Top visited blogs" => "Най посещавани блогове",
"Last posts" => "Последни постинги",
"Top active blogs" => "Най-активни блогове",
"Permission denied you cannot view backlinks for this page" => "Достъп отказан: нямате право да разглеждате backlinks за тази страница",
"The page cannot be found" => "Страницата не може да бъде открита",
"No image indicated" => "Не е посочено изображение",
"picture not found" => "снимката не беше открита",
"Permission denied you cannot move images from this gallery" => "Нямате право да премествате изображения от тази галерия",
"Permission denied you cannot create or edit blogs" => "Достъп отказан - нямате право да създавате или модифицирате блогове",
"Permission denied you cannot edit this blog" => "Достъп отказан: нямате право да редактирате този блог",
"No newsletter indicated" => "Не е посочена новинарска емисия",
"overwriting old page" => "записвам върху старата страница(overwrite)",
//"updated from structured text import" => "updated from structured text import",
"page created" => "страницата бе създадена",
//"created from structured text import" => "created from structured text import",
"Permission denied you cannot view pages like this page" => "Достъпът отказан: вие не можете да разглеждате страници като тази",
"Permission denied you cannot browse this page history" => "Достъпът отказан: вие не можете да разглеждате историята на тази страница",
"No forum indicated" => "Не е посочен форум",
"last version" => "последна версия",
"Permission denied you cannot remove versions from this page" => "Достъп отказан: вие не можете да премахвате версии от тази страница",
"Must enter a name to add a site" => "Трябва да въведете име за да добавите сайт",
"Must enter a url to add a site" => "Трябва да добавите адрес за да добавите сайт",
"Must select a category" => "Трябва да изберете категория",
"Pageviews" => "Брой посещения на страницата",
"Upload failed" => "Качването се провали",
"No activity indicated" => "Не е посочено действие",
//"A start activity requires a name for the instance" => "A start activity requires a name for the instance",
"You cant execute this activity" => "Нямате право да извършвате това действие",
"Page must be defined inside a structure to use this feature" => "Страницата трябва да бъде дефинирана вътре в структура за да използвате тази функция",
"Cannot create or update module: You need to specify a name to the module" => "Невъзможност за създаване или ъпдейт на модул: Трябва да посочите име за модула",
"Cannot create or update module: You cannot leave the data field empty" => "Невъзможност за създаване или ъпдейт на модула: Не може да оставите полето с данни празно",
"Invalid username or activation code. Maybe this code has already been used." => "Невалидно потребителско име или активационен код. Може би този код вече е бил използван.",
"Unable to send mail. User has not configured email" => "Невъзможност за изпращане на мейл. Потребителят не е посочил имейл адрес.",
"The mail can't be sent. Contact the administrator" => "Невъзможност за изпращане на мейл. Свържете се с администратор",
"A password and your IP address reminder email has been sent " => "Парола и вашето IP бяха изпратени. ",
"A new (and temporary) password and your IP address has been sent " => "Нова (и временна) парола и вашето IP бяха изпратени ",
"to the registered email address for" => "to the registered email address for",
"Invalid or unknown username" => "Невалидно или непознато потребителско име",
"No banner indicated" => "Не е посочен банер",
"No thread indicated" => "Не е посочена тема",
"Feature disabled" => "Функцията е деактивирана",
"You do not have permissions to view the maps" => "Нямате позволение да разглеждате картите",
"You dont have permission to do that" => "Нямате право да извършвате това действие",
"Maps feature is not correctly setup : Maps path is missing." => "Функцията \"Карти\" не е правилно настроена: Липсва път (path) за карти",
"Please create a directory named \$map_path to hold your map files." => "Моля, създайте директория с име \$map_path за да съхранява вашите файлове с карти.",
"mapfile name incorrect" => "името на файла с картата е неправилно",
"The passwords didn't match" => "Паролите не съвпадат",
"You can not use the same password again" => "Не можете да използвате същата парола отново",
"Invalid old password" => "Невярна стара парола",
"URL already added to the directory. Duplicate site?" => "Адресът вече е добавен към директорията.",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Адресът не може да бъде открит: грешен адрес или сайтът е офлайн и не може да бъде добавен към директорията",
"indicates if the process is active. Invalid processes cant be active" => "показва дали процесът е активен. Невалиден процес не може да бъде активен",
"No Errors detected" => "Не са открити грешки",
"Welcome at Hawiki" => "Добре дошли в Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Този Тикиуики сайт е настроен така, че да може да бъде достъпван от много мобилни устройства, например WAP телефони, PDA, i-mode устройства и много други.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Можете да разглеждате този сайт като насочите мобилното си устройство към следния адрес:",
"About" => "Относно",
"Permission denied you cannot view pages" => "Достъпът отказан: вие нямате право да разглеждате страници",
"You do not have permissions to view the layers" => "Достъпът отказан, вие нямате право да разглеждате тези слоеве",
"Could not upload the file" => "Неуспех при качването на файла",
"You do not have permissions to delete a file" => "Вие нямате разрешение да изтриете този файл",
"File not found" => "Файлът не е открит",
"You do not have permissions to create a directory" => "Нямате права за създаване на директория",
"The Directory is not empty" => "Директорията не е празна",
"You do not have permissions to delete a directory" => "Нямате право да изтривате директории",
"You do not have permissions to create an index file" => "Нямате право да създадете индекс файл",
"Invalid file name" => "Невалидно име на файл",
"Invalid files to index" => "Невалидни файлове за индексиране",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Не знам къде е gdaltindex. Настройте правилно функцията 'карти'",
"I could not create the index file" => "Не успях да създам индекс файл",
"You have to enable cookies to be able to login to this site" => "Трябва да позволите cookies на вашия браузър за да можете да влезете в този сайт",
"Unable to contact remote server." => "Не мога да се свържа с отдалечения сървър.",
"XMLRPC Error: " => "Грешка XMLRPC: ",
"Unable to create login" => "Не успях да създам потребител",
"rss feed disabled" => "rss емисията е деактивирана",
"No parent specified" => "Не е посочен родител",
"Tiki RSS feed for directory sites" => "RSS Tiki емисия за сайтовете в директорията",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Последни сайтове от директорията \".\$rc[\"name\"].\" .",
"Error : The file %s doesn't exist." => "Грешка: файлът %s не съществува.",
"Tiki RSS feed for file galleries" => "RSS емисия за файловите галерии",
"Last files uploaded to the file galleries." => "Последни файлове качени във файловите галерии.",
"No user indicated" => "Не е посочен потребител",
"No title indicated" => "Не е посочено заглавие",
"No comment indicated" => "Не е посочен коментар",
"No date indicated" => "Не е посочена дата",
"No note indicated" => "Не е посочена бележка",
"The passwords do not match" => "Паролите не съвпадат",
"Wrong registration code" => "Грешен код за регистрация",
"Invalid username" => "Невалидно потребителско име",
"Username is too long" => "Потребителското име е прекалено дълго",
"Username cannot contain whitespace" => "Потребителското име не може да съдържа интервали",
"Wrong passcode you need to know the passcode to register in this site" => "Грешен пас-код. Трябва да знаете пас-кода за да се регистрирате в този сайт",
"Invalid email address. You must enter a valid email address" => "Невалиден и-мейл адрес. Трябва да посочите валиден и-мейл адрес за да се регистрирате",
"The registration mail can't be sent. Contact the administrator" => "Регистрационния и-мейл не може да бъде изпратен. Свържете се с администратор.",
"No menu indicated" => "Не е посочено меню",
"The process name already exists" => "Това име за процес вече съществува",
"Process already exists" => "Процесът вече съществува",
"Tiki RSS feed for articles" => "RSS емисия за статии",
"Last articles." => "Последни статии",
"Permission denied you cannot post" => "Достъп отказан. Не можете да публикувате",
"Permission denied you cannot edit this post" => "Достъп отказан:не можете да редактирате тази статия",
"You can't post in any blog maybe you have to create a blog first" => "Не можете да публикувате в нито един блог. Вероятно първо трябва да си създадете блог.",
"No survey indicated" => "Не е посочено проучване",
"No version indicated" => "Не е посочена версия",
"Non-existent version" => "Несъществуваща версия",
"Permission denied you cannot rollback this page" => "Достъп отказан: не можете да се върнете назад в тази страница",
"unknown error" => "непозната грешка",
"cannot be found" => "не може да бъде открит/а",
"Tiki RSS feed for image galleries" => "RSS емисия за картинните галерии",
"Last images uploaded to the image galleries." => "Последните качени снимки в картинните галерии.",
"Name" => "Име",
"Creation Date" => "Дата на създаване",
"Owner" => "Собственик",
"Hits" => "Посещения",
"Size" => "Размер",
"first uploaded image" => "първо качена снимка",
"last uploaded image" => "последно качена снимка",
"first image" => "първа снимка",
"last image" => "последна снимка",
"random image" => "случайна снимка",
"Permission denied you cannot make the map of this gallery" => "Достъп отказан. Не можете да създадете карта на тази галерия",
"Non-existent link" => "Несъществуваща връзка",
"Permission denied you cannot access this gallery" => "Достъп отказан. Нямате права за достъп до тази галерия",
"No gallery indicated" => "Не е посочена галерия",
"Permission denied you cannot remove images from this gallery" => "Достъп отказан: Не можете да премахвате снимки от тази галерия",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Достъп отказан. Нямате права да построите наново малките картинки в тази галерия",
"Permission denied you cannot rotate images in this gallery" => "Достъп отказан. Нямате право да завъртате картини в тази галерия.",
"No structure indicated" => "Не е посочена структура",
"Invalid structure_id or page_ref_id" => "Невалидна structure_id или page_ref_id",
"Tiki RSS feed for the wiki pages" => "RSS емисия за Wiki страниците",
"Last modifications to the Wiki." => "Последни модификации на уикито.",
"No questions group indicated" => "Не е посочена група въпроси",
"You do not have permission to do that" => "Нямате права за извършване на това",
"You do not have permission to write the template:" => "Нямате права да запишете шаблона",
"You do not have permission to read the template" => "Нямате права да разгледате шаблона",
"Tiki RSS feed for calendars" => "RSS емисия за календарите",
"Upcoming events." => "Предстоящи събития",
"Start:" => "Старт:",
"End:" => "Край:",
"Last sites." => "Последни сайтове.",
"Shortname must be 2 Characters" => "Краткото име трябва да се състои от два символа",
"You must provide a longname" => "Трябва да въведете дълго име",
"Language created" => "Езикът бе създаден",
"NONE" => "ЛИПСВА",
"child categories" => "дъщерни категории",
"objects in category" => "обекти в категория",
"An error occured in a database query!" => "Възникна грешка при заявката към базата данни!",
"continued" => "продължен",
"in" => "в",
"new image uploaded by" => "ново изображение качено от",
"uploaded by" => "качен/а от",
"new item in tracker" => "нов елемент в тракъра",
"new subscriptions" => "нови абонаменти",
"not specified" => "не е посочен",
"Anonymous" => "Анонимен",
"Link" => "Връзка",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Постава връзка към котва (anchor) в уики страницата. Използвайте заедно с ANAME плъгина, който настройва локацията и името на котвата",
//"linktext" => "linktext",
"Create page:" => "Създаване на страница:",
"Links to a translated content" => "Връзки към преведено съдържание",
"Split a page into rows and columns" => "Раздробяване на страница по редове и колони",
"row1col1" => "ред1кол1",
"row1col2" => "ред1кол2",
"row2col1" => "ред2кол1",
"row2col2" => "ред2кол2",
"Provides a list of plugins on this wiki." => "Показва списък с пългини на това уики.",
"No arguments indicated" => "Не са посочени аргументи",
"Displays the data using a monospace font" => "Показва данните в шрифт monospace",
"text" => "текст",
"Display wiki text if user has one of listed permissions" => "Показване на уики текст ако потребителят има едно от следните позволения",
"Displays a SWF on the wiki page" => "Показва SWF на уики страницата",
"Displays text between an html tag" => "Показва текст в html етикета (tag)",
"Displays a snippet of code" => "Показва отрязък код",
"note: colors and ln are exclusive" => "забележка: цветовете и ln са специални",
"Example" => "Пример",
"Wiki text" => "Wiki текст",
"Displays text in subscript." => "Показва текста като долен индекс.",
"Upcoming events" => "Предстоящи събития",
" wrote:" => " написа:",
"Quote:" => "Цитат:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Цитирайте текст като го оградите с кутия, както [QUOTE] в BBCode",
"Displays a map" => "Показва карта",
"List wiki pages" => "Списък с Wiki страници",
"Last modified by" => "Последна модификация от",
"Insert a javascript file or/and some javascript code." => "Въведете javascript файл или/и код на javascript.",
"javascript code" => "javascript код",
"Sorts the plugin content in the wiki page" => "Сортира съдържанието на плъгина в уики страницата",
"data" => "данни",
"one data per line" => "1 елемент на ред (one data per line)",
"Displays an alphabetically sorted list of registered users" => "Показва азбучно сортиран списък с регистрираните потребители",
"Send a message to" => "Изпращане на съобщение до",
"Send message" => "Изпращане на съобщение",
"Real Name" => "Истинско име",
"userpage" => "страница на потребителя",
"Include an article" => "Включване на статия",
"Formula" => "Формула",
"No formula specified." => "Не е посочена формула.",
"Impossible to render the graphic." => "Грешка при обработване на графиката.",
"View graphic" => "Вижте графиката",
"Please choose a module" => "Моля, изберете модул",
// "to be used as argument" => "to be used as argument",
"Displays a module inlined in page" => "Показва модула вмъкнат в страницата",
"Sorry no such module" => "Съжалявам, няма такъв модул",
"Displays object hit info by object and days" => "Показва информацията за посещенията на обекта по обекти и дни",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
"Tracker was modified at " => "Тракърът е бил модифициран на ",
"Following mandatory fields are missing" => "Следните задължителни полета липсват",
"Following fields are incorrect" => "Следните полета са неправилни",
"Other:" => "Друг/а:",
"select all" => "избор на всички",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
"Save" => "Запазване",
"You do not have permission to insert an item" => "Нямате право да вмъкнете елемент",
"Fields marked with a * are mandatory." => "Полетата, отбелязани с * са задължителни.",
"Display Tiki objects that have not been categorized" => "Показване на Тики обектите, които не са категоризирани",
// "TikiSheet" => "TikiSheet",
"Sheet Heading" => "Заглавие на лист",
"Edit Sheet" => "Редакция на лист",
"Automatically creates a link to the appropriate SourceForge object" => "Автоматично създава хипервръзка към правилния обект в Sourceforge",
"Displays the data using the Tikiwiki odd/even table style" => "Показва информацията чрез използването на ТикиУики табличния стил 'четно/нечетно' ",
"cells" => "клетки",
"heads and cells separated by ~|~" => "Заглавията и клетките, разделени с ~|~",
"Clickable Skype link" => "Кликаема Skype връзка",
"Displays an miniquiz" => "Показва минитест",
"Search the titles of all pages in this wiki" => "Показва заглавията на всички страници в това уики",
"No pages found for title search" => "Не са открити страници за търсенето по заглавие",
"One page found for title search" => "Една страница е открита за търсенето по заглавие",
" pages found for title search" => " страници са открити за търсенето по заглавие",
"no such attachment on this page" => "не съществува такава приставка на тази страница",
"Displays an attachment or a list of them" => "Показва приставка или списък с приставки",
"comment" => "коментар",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num е по желание и е номерът на приставката в списъка. Ако не бъде посочен, ще бъде показан списък с всички приставки",
"incorrect filterfield" => "неправилно поле за филтриране",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Показва output от съдържанието на тракъра, полетата са посочени с номера",
"missing tracker ID for plugin TRACKER" => "липсва тракър ID за плъгина TRACKER",
"missing fields list" => "липсва списък с полета",
"Error in tracker ID" => "Грешка в ID на тракъра",
"No field indicated" => "Aucun champ indiqué",
"Displays the text only if the language matchs" => "Показва текста само ако езикът съвпада",
"Missing db param" => "Липсва db параметър",
"Run a sql query" => "Извършване на sql заявка",
"sql query" => "sql заявка",
"All fields must be from the same tracker" => "Всички полета трябва да са от един и същ тракър",
"filter" => "филтриране",
"Filters the items of a tracker, fields are indicated with numeric ids." => "Филтриране на елементите на тракър, полетата са обозначени с номера.",
"missing parameters" => "липсващи параметри",
// "tracker field type not processed yet" => "tracker field type not processed yet",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Поставя котва (anchor) в уики страница. Използвайте заедно с плъгина ALINK, който прави връзки (links) към котвата",
"Insert copyright notices" => "Вмъкване на бележки за авторско право",
// "~np~{~/np~RSS(id=>feedId+feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId+feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
"Displays the number of registered users" => "Показва броя на регистрираните потребители",
"Runs a Java applet to access a local Jabber service" => "Стартира Java аплет за да достъпи локална Jabber услуга",
"Displays the output of a poll, fields are indicated with numeric ids." => "Показва 'output' от анкета. Полетата са посочени с номера.",
"missing poll ID for plugin POLL" => "Липсва номер на анкета за плъгин POLL (анкета)",
"Centers the plugin content in the wiki page" => "Центрира съдържанието на плъгина в уики страницата",
"Displays the user Avatar" => "Показва потребителския аватар",
"Insert the full category path for each category that this wiki page belongs to" => "Вмъкнете пълен път (path) до категорията, за всяка категория към която принадлежи тази уики страница.",
"Displays browser client info" => "Показва информация за браузъра на клиент(ите)",
"List all pages which link to specific pages" => "Списък с всички страници, които имат връзки (линкове) към специфични страници",
"No pages links to" => "Няма страници с връзки към",
"One page links to" => "Една страница има връзка към",
"pages link to" => "Страниците имат връзки към",
"Display wiki text if user is in one of listed groups" => "Показване на уики текст ако потребителят е в една от посочените групи",
"Creates a definition list" => "Създава списък с дефиниции",
"term" => "термин",
"definition" => "дефиниция",
"one definition per line" => "една дефиниция на ред",
"Displays a graphical GAUGE" => "Показва графичен GAUGE",
"Lists ''wanted'' Wiki pages: " => "Показва списък със страници 'издирва се': ",
// "Page-Pattern" => "Page-Pattern",
"^Parameters: key=>value,...\n" => "^Параметри: ключ=>стойност,...\n",
"__key__ | __default__ | __comments__\n" => "__ключ__ | __по подразбиране__ | __коментари__\n",
"empty string" => "Празна последователност (стринг)",
"A wildcard pattern of originating pages to be ignored.<br />" => "Wildcard pattern от страници, които да бъдат игнорирани.<br />",
"(refer to PHP function fnmatch() for details)\n" => "(вижте функцията на PHP fnmatch() за детайли)\n",
"The character, by which ignored patterns are separated.<br />" => "Знакът, чрез който игнорираните последователности (patterns) са разделени.<br />",
"possible values: characters\n" => "възможни стойности: символи\n",
"Whether to include external wikis in the list.<br />" => "Дали да се включат външни уикита в списъка.<br />",
"possible values: " => "възможни стойности: ",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Събиране или на дъщерни (originating) или на 'търсени' (wanted) страници в клетка и показване на страниците във втората колона.<br />",
"Switch-on debug output with details about the items.<br />" => "Включване на debug output с детайли за елементите.<br />",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Множеството събрани елементи са разделени на отделни редове в таблицата, или чрез запетая или чрез нов ред в една клетка.<br />",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
"a valid regex-expression (PCRE)" => "валидна regex (PCRE)",
"non-valid custom regex" => "невалидна custom regex",
"ignored" => "игнориран",
"External Wiki" => "Външно Уики",
"dash-WikiWord" => "WikiWord-тире",
"WikiWord" => "WikiWord",
"not in level" => "не е на ниво",
"valid" => "валиден",
"End of debug output." => "Край на debug output.",
"Wanted Page" => "'Желана' Страница",
"Referenced By Page" => "Споменат/а в страница",
"days" => "дни",
"hours" => "часа",
"and" => "и",
"seconds" => "секунди",
"Insert a division block on wiki page" => "Вмъкване на разделителен блок в уики страница",
"Displays the thumbnail for an image" => "Показва умалена версия (thumbnail) на изображение",
"Insert theme styled box on wiki page" => "Показва стилизирана кутийка на уики страница",
"Split the text in parts visible only under some conditions" => "Разделяне на текста на части видими само при определени условия",
"Line:" => "Ред:",
"Lines:" => "Редове:",
"refresh" => "опресняване",
"locked" => "заключен/а",
"locked by" => "заключен/а от",
"Administration:" => "Администрация:",
"Newsletter subscription information at " => "Информация за абониране към новинарски емисии на ",
"Login" => "Потребителско име",
"See other user's profile" => "Разглеждане на профила на друг потребител",
// "Have your profile seen" => "Have your profile seen",
"Make friends" => "Сприятеляване",
"Receive message" => "Получаване на съобщение",
"Read an article" => "Прочитане на статия",
"Publish an article" => "Публикуване на статия",
// "Have your article read" => "Have your article read",
"Create new file gallery" => "Създаване на нова файлова галерия",
"Upload new file to gallery" => "Качване на нов файл в галерията",
"Download other user's file" => "Сваляне на файла на друг потребител",
"Have your file downloaded" => "Е свалил вашия файл",
"Create a new image gallery" => "Създаване на нова картинна галерия",
"Upload new image to gallery" => "Качване на нова снимка в галерията",
"See other user's gallery" => "Разглеждане на галерията на друг потребител",
"See other user's image" => "Разглеждане на снимката на друг потребител",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
"Create new blog" => "Създаване на нов блог",
"Post in a blog" => "Публикуване в блог",
"Read other user's blog" => "Четене на блога на друг потребител",
// "Have your blog read" => "Have your blog read",
"Create a new wiki page" => "Създаване на нова уики страница",
"Edit an existing page" => "Редактиране на съществуваща страница",
"Attach file" => "Прикачване на файл",
"Wiki Home" => "Уики Начало",
"Home" => "Начало",
"Blog" => "Блог",
"previous page" => "предишна страница",
"next page" => "следваща страница",
"posted on" => "публикуван/а на",
"Continue" => "Продължение",
"By:" => "От:",
"Read" => "Прочетени",
"List articles" => "Списък със статии",
"Last post" => "Последна публикация",
"This poll is closed." => "Тази анкета е приключила.",
"Cannot write to this file: " => "Невъзможност за писане в този файл: ",
"Cannot upload this file maximum upload size exceeded" => "Невъзможност за качване на този файл - максималният позволен размер е превишен",
"Use this thread to discuss the %s page." => "Използвайте тази страница за дискусия за да дискутирате страница %s",
"created from structure" => "създаден/а от структура",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
"Wiki top pages" => "Уики топ страници",
// "Relevance" => "Relevance",
"Wiki last pages" => "Последни уики страници",
"Modified" => "Модифициран/а",
"Forums last topics" => "Последни теми във форумите",
"Topic date" => "Дата на темата",
"Forums last posts" => "Последни публикации във форумите",
"Forums most read topics" => "Най-четени теми във форумите",
// "Reads" => "Reads",
"Forums best topics" => "Най-популярни теми във форумите",
"Forums most visited forums" => "Най-посещавани форуми",
"Visits" => "Посещения",
"Forums with most posts" => "Форуми с най-много публикации",
"Posts" => "Публикации",
"Wiki top galleries" => "Wiki топ галерии",
"Wiki top file galleries" => "Уики топ файлови галерии",
"Wiki top images" => "Wiki топ снимки",
"Wiki top files" => "Уики топ файлове",
"Downloads" => "Сваляния",
"Wiki last images" => "Най-нови Wiki снимки",
"Upload date" => "Дата на качване",
"Wiki last files" => "Най-нови файлове",
"Wiki top articles" => "Най-популярни статии",
"Most visited blogs" => "Най-посещавани блогове",
"Most active blogs" => "Най-активни блогове",
"Activity" => "Активност",
"Blogs last posts" => "Последни публикации в блоговете",
"Post date" => "Дата на публикация",
"Wiki top authors" => "Уики топ автори",
"Top article authors" => "Топ автори на статии",
"Help" => "Помощ",
"(AT)" => "(В)",
"(DOT)" => "(ТОЧКА)",
"Tracker" => "Тракър",
"Trackeritem" => "Елемент на тракър",
"Directory category" => "Категория директории",
"Fatal error: setting next activity to an unexisting activity" => "Фатална грешка: setting next activity to an unexisting activity",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Фатална грешка: nextActivity does not match any candidate in autorouting switch activity",
"Fatal error: non-deterministic decision for autorouting activity" => "Фатална грешка: non-deterministic decision for autorouting activity",
"Fatal error: trying to send an instance to an activity but no transition found" => "Фатална грешка: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// " is interactive but has no role assigned" => " is interactive but has no role assigned",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is non-interactive and non-autorouted but has no role assigned",
"Role" => "Роля",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
"Process %d has been activated" => "Процес %d бе активиран",
"Process %d has been deactivated" => "Процес %d бе деактивиран",
"Process %s %s imported" => "Процес %s %s импортиран",
"Process %s removed" => "Процес %s премахнат",
"Process %s has been updated" => "Процес %s бе обновен",
"Process %s has been created" => "Процес %s бе създаден",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "This instance of activity is already complete" => "This instance of activity is already complete",
"You are banned from" => "Забранен ви е достъп до ",
"wiki" => "уики",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "faqs" => "faqs",
"quizzes" => "викторини",
"arts" => "статии",
"blogs" => "блогове",
"games" => "игри",
"drawing not found" => "рисунката не бе открита",
"Click to edit dynamic variable" => "Кликнете за да редактирате динамичната променлива",
"Update variables" => "Обновяване на променливи",
"Altering database table failed" => "Промяната на таблицата бе неуспешна",
"No image yet, sorry." => "Все още няма изображение, съжалявам.",
"Removed" => "Премахнат",
"Created" => "Създаден/а",
"__WARNING__: No such module \$plugin! " => "__WARNING__: Не съществува модул \$plugin! ",
"new" => "нов/а",
"show" => "показване",
"hide" => "скриване",
"Updated" => "Обновен",
"Unknown language" => "Непознат език",
"Cannot open this file:" => "Не мога да отворя този файл:",
"There was a problem with your upload." => "Имаше проблем с качването на вашия файл",
"The file you are trying to upload is too big." => "Файлът, който се опитвате да качите е прекалено голям.",
"The file you are trying to upload was only partially uploaded." => "Файлът беше качен само частично.",
"You must select a file for upload." => "Трябва да изберете файл за качване.",
"Invalid imagename (using filters for filenames)" => "Невалидо име на снимка (използват се филтри за имената на файловете)",
"failed" => "провален",
"Include all post in a blog" => "Включване на всички публикации в блог",
"Author" => "Автор",
"Lists files in a directory" => "Списък с файловете в директория",
"could not be opened because it doesn't exist or permission was denied" => "отварянето неуспешно, защото не съществува или достъпът беше отказан",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
"Include a page" => "Включване на страница",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
"Missing url parameter for SNARF plugin." => "Липсва URL за плъгина SNARF.",
"Gallery" => "Галерия",
"File" => "Файл",
"Blog post" => "Публикация в блог",
"Tracker item" => "Елемент в тракър",
"File %s not found" => "Файл %s не е открит",
"File %s is not a valid archive" => "Файлът %s не е валиден архив",
"%s is an empty archive file" => "%s е празен архив",
"Invalid remote file on url %s" => "Невалиден отдалечен файл на този адрес %s",
"Impossible to open %s : %s" => "Неуспех при отварянето на %s : %s",
"blog" => "блог",
"directory" => "директория",
"file gallery" => "файлова галерия",
"image gallery" => "картинна галерия",
"poll" => "анкета",
"quiz" => "тест",
"survey" => "проучване",
"tracker" => "тракър",
"wiki page" => "уики страница",
"calendar" => "календар",
"unlocked" => "отключен",
"Click here to confirm your action" => "Кликнете тук за да потвърдите действието",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
"Other" => "Друг/а",
"User Map Generated in:" => "Потребителска карта генерирана в:",
// "Image Map Generated in:" => "Image Map Generated in:",
"Status:" => "Статус:",
"(unchanged)" => "(непроменен)",
"Item Modification" => "Модификация на елемент",
"Item creation" => "Създаване на елемент",
"field is not numeric" => "Полето не е цифра",
"text field" => "текстово поле",
// "half column" => "half column",
"size" => "размер",
"prepend" => "пре-ставяне",
"append" => "наставяне",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Текстови опции: 1, размер, пре-ставяне, наставяне, макс размер в символи, пре-ставянето ще бъде показано преди полето, наставянето ще бъде показано непосредствено след. Макс е максималния брой знаци които могат да бъдат запазени. А началното 1 е за да покаже, че текстовото поле и или кутийката  за отмятане е на същия ред. Ако посочите само 1, това означава, че следващото поле е не следващия ред, също така.",
"textarea" => "текстова зона",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Опции на текстовата зона: quicktags, ширина, височина, макс, listmax - Use Quicktags е 1 или 0, ширината се посочва в символи, височината се посочва в редове. Макс е максималният размер знаци, които могат да бъдат запазени. Listmax е максималният брой знаци, които се показват в режим на показване",
"checkbox" => "кутийка за отмятане",
"Checkbox options: put 1 if you need that next field is on the same row." => "Опции на кутийката за отмятане: поставене 1 ако се нуждаете следващото поле да е на същия ред.",
"numeric field" => "числово поле",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Числови опции: 1, размер, пре-ставяне, наставяне с размер в символи. Пре-ставянето ще бъде изобразено преди полето, наставянето ще бъде изобразено непосредствено след него, а началното 1 за да накарате следващото текстово поле или кутийка за отмятане да се изобрази на същия ред. ако посочите само 1, това означава, че следващото поле е на същия ред.",
"drop down" => "падащо меню",
"Dropdown options: list of items separated with commas." => "Опции за падащо меню: списък с елементи, разделен със запетаи.",
"Default value is specified by having the value indicated twice consecutively" => "Стойността по подразбиране се обозначава, като я напишете два пъти едно след друго",
"drop down with other textfield" => "Падащо меню с поле за друг текст",
// "user selector" => "user selector",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "group selector" => "group selector",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
"country selector" => "поле за избор на държава",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
"date and time" => "дата и време",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
"header" => "хедър",
"category" => "категория",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
"items list" => "списък с елементи",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
"system" => "система",
"open" => "отворен/а",
"pending" => "очакващ/а",
"closed" => "затворен/а",
"Added:" => "Добавен/а:",
"Removed:" => "Премахнат/а:",
"Remaining:" => "Оставащ/а:",
"Old:" => "Стар/а:",
"New:" => "Нов/а:",
"No extra information for that attached file. " => "Няма допълнителна информация за този добавен файл. ",
"Text cut here" => "Текстът се отрязва тук",
"for" => "за",
"Start date:" => "Начална дата:",
"End date:" => "Крайна дата:",
"%a %d of %b, %Y" => "%e/%m/%y",
"%a %d of %b, %Y[%H:%M %Z]" => "%e/%m/%y [%Hh%M]",
"The text is" => "Текстът е",
"character(s) too long - please edit it." => "символ(а) по-дълъг - моля, оправете го",
"help" => "помощ",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B %Y [%Hh%M]",
"%H:%M:%S %Z" => "%Hh%M",
"%A %d of %B, %Y" => "%A %d %B %Y",
"Friend" => "Приятел",
"Last seen on " => "Последно видян на ",
"(idle for %s seconds)" => "(неактивен от %s секунди)",
"User information - Click for more info" => "Информация за потребителя - кликнете за повече",
"More info about \$other_user" => "Повече информация за \$other_user",
"(idle for \$idletime seconds)" => "(неактивен от \$idletime секунди)",
"tikiwiki logo" => "TikiWiki лого",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
"You have to create a topic first" => "Първо трябва да създадете тема",
"Tag already exists" => "Етикетът (Tag) вече съществува",
"Tag not found" => "Етикетът (tag) не бе открит",
"No url indicated" => "Не е посочен адрес (url)",
"This gallery does not exist" => "Тази галерия не съществува",
"The text in RED is" => "Текстът в ЧЕРВЕНО е",
"No server indicated" => "Не е посочен сървър",
"Cannot connect to" => "Невъзможност за свързване към",
"Permision denied" => "Достъпът отказан",
"ERROR: Either the subject or body must be non-empty" => "ГРЕШКА: или темата, или тялото трябва не са празни",
"ERROR: No valid users to send the message" => "ГРЕШКА: няма валидни потребители на които да се изпрати съобщението",
"Invalid user" => "Невалиден потребител",
"Message will be sent to: " => "Съобщението ще бъде изпратено на: ",
"No newsletters available." => "Не са налични новинарски емисии.",
"Back to preferences" => "Обратно, към 'предпочитания'",
"No quiz indicated" => "Не е посочен тест",
"Group already exists" => "Групата вече съществува",
"Permission denied you cannot remove pages" => "Достъпът откаан: не можете да премахвате страници",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Кутията с изпратени съобщения е пълна. Архивирайте или изтрийте някое съобщение първо, ако искате да изпращате други съобщения.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Трябва да можете да получавате съобщения, за да можете да изпращате такива. Отидете на страницата с вашите предпочитания и активирайте 'Позволяване на съобщения от други потребители'",
"User %s can not receive messages, mailbox is full" => "Потребител %s не може да получава съобщения, пощенската му кутия е пълна.",
"User %s can not receive messages" => "Потребител %s не може (или не иска) да получава съобщения",
"Invalid user: %s" => "Невалиден потребител: %s",
"No blog indicated" => "Не е посочен блог",
"Permission denied you cannot remove the post" => "Достъп отказан: не можете да премахнете публикацията",
"This feature is for admins only" => "Тази функция е достъпна само за администратори",
"You have to provide a word" => "Трябва да въведете дума",
"No channel indicated" => "Не е посочен канал",
"No nickname indicated" => "Не е посочен псевдоним",
"No site indicated" => "Не е посочен сайт",
"Site No validated yet" => "Сайтът не е валидиран все още",
"Tiki RSS feed for maps" => "RSS емисия за карти",
"List of maps available." => "Списък с наличните карти.",
"Cannot upload this file not enough quota" => "Не мога да кача този файл, квотата е превишена",
"You do not have permission to write the style sheet" => "Нямате позволение да пишете style sheet",
"Error processing zipped image package" => "Грешка при обработката на zip архива със снимки",
"No permission to upload zipped image packages" => "Нямате право да качвате zip архиви със изображения",
"The uploaded file ist not recognized as a image" => "Каченият файл не е разпознат като изображение",
"Permission denied you cannot upload images" => "Достъптъ отказан: нямате право да качвате изображения",
"Permission denied you can upload images but not to this gallery" => "Достъп отказан: имате право да качвате изображения, но не и в тази галерия",
"Cannot get image from URL" => "Не мога да взема изображение от посочения адрес",
"That is not an image (or you have php < 4.0.5)" => "Това не е изображение (или версията на php < 4.0.5)",
"cannot process upload" => "Не мога да обработя качването",
"changed '%s' from '%s' to '%s'" => "променен: '%s' от '%s' на '%s'",
"Archive is full. Delete some messages from archive first." => "Архивът е пълен. Изтрийте няколко съобщения от архива първо.",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
"Frequency should be a positive integer!" => "Честотата трябва да бъде положително цяло число!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
"No poll indicated" => "Не е посочена анкета",
"Not enough information to display this page" => "Недостатъчно информация за да бъде показана тази страница",
"Fatal error" => "Фатална грешка",
"You do not have permission to edit messages" => "Нямате позволение да редактирате съобщения",
// "No repository" => "No repository",
"Search is mandatory field" => "'Търсене' е задължително поле",
"File not found " => "Файлът не бе открит",
"Requested action in not supported on repository" => "Пожеланата категория не е поддръжана от repository-то",
"Top galleries" => "Популярни галерии",
"Top images" => "Топ снимки",
"Last images" => "Най-нови снимки",
"Map" => "Карта",
"changed" => "променен/а",
"This mapfile already exists" => "Този файл-карта вече съществува",
"You do not have permission to write to the mapfile" => "Нямате права за писане във файла-карта",
"You do not have permission to delete the mapfile" => "Нямате право да изтриете файла-карта",
"I could not make a copy" => "Копирането не бе успешно",
"You do not have permission to read the mapfile" => "Нямате права да четете файла-карта",
"No faq indicated" => "Не е посочена FAQ секция",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
"No sheet specified." => "Не е посочен лист.",
"You must select a renderer." => "Трябва да посочите renderer",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
"Daily Usage" => "Всекидневно потребление",
"Usage" => "Потребление",
"No object indicated" => "Не е посочен обект",
"No type indicated" => "Не е посочен тип",
"Your email address has been removed from the list of addresses monitoring this item" => "Вашият и-мейл адрес бе премахнат от списъка с и-мейл адреси проследяващи тази тема",
"Your email address has been added to the list of addresses monitoring this елемент" => "Вашият и-меийл адрес бе добавен към списъка адреси проследяващи този елемент",
"Cancel monitoring" => "Спиране на проследяване",
"Monitor" => "Проследяване",
"Last page" => "Последна страница",
"First page" => "Първа страница",
"Accepted friendship request from %s" => "Молбата за приятелство беше одобрена от %s",
"Refused friendship request from %s" => "Молбата за приятелство беше отхвърлена от %s",
"Broke friendship with %s" => "Развалихте приятелството с %s",
"I have broken our friendship!" => "Развалих нашето приятелство!",
"You must be logged in to use this feature" => "Трябва да сте влезли в системата за да използвате тази функция",
"Friendship request sent to %s" => "Молбата за приятелство беше изпратена на %s",
"You're already friend of %s" => "Вие вече сте приятели с %s",
"I have accepted your friendship request!" => "Одобрих молбата ви за приятелство.",
"I have refused your friendship request!" => "Отхвърлих молбата ви за приятелство.",
"An error occurred." => "Възникна грешка.",
"Notice: invalid variable value:" => "Забележка: невалидна стойност на променлива:",
"No process indicated" => "Не е посочен процес",
"Repository name can't be an empty" => "Името на хранилището не може да бъде празно",
"Requested action is not supported on repository" => "Пожеланото действие не се поддържа от хранилището",
"You are not permitted to remove someone else\\'s post!" => "Нямате право да премахнете публикацията на някой друг!",
"Wrong password. Cannot post comment" => "Грешна парола. Не можете да публикувате коментар",
"Please wait 2 minutes between posts" => "Моля, изчакайте 2 минути между публикациите",
"No subject" => "Няма тема",
"Your email was sent" => "Вашият и-мейл бе изпратен",
"%s enabled" => "%s активиран/а",
"%s disabled" => "%s деактивиран/а",
"Features" => "Функции",
"Enable/disable Tiki features here, but configure them elsewhere" => "Активиране/Деактивиране на функции на Тики се извършва от тук, но конфигурацията им е другаде",
// "General" => "General",
"General preferences and settings" => "Общи предпочитания и настройки",
"User registration, login and authentication" => "Потребителска регистрация, вход в системата и идентификация",
"Wiki settings" => "Настройки на Уики",
"Wiki Attachments" => "Добавки към Уики",
"Wiki attachments" => "Добавки към Уики",
"Image galleries" => "Картинни галерии",
"File galleries" => "Файлови галерии",
"Article/CMS settings" => "Настройки на статии/CMS",
"Polls" => "Анкети",
"Poll comments settings" => "Настройки на коментарите в анкетите",
"Configuration options for all blogs on your site" => "Общи настройки за всички блогове на вашия сайт",
"Forums settings" => "Настройки на форуми",
"FAQ comments settings" => "Настройки на коментарите във FAQ секциите",
"Trackers settings" => "Настройки на тракъри",
"RSS feeds" => "RSS емисии",
"RSS settings" => "Конфигурации за RSS",
"Directory settings" => "Настройки на директории",
"User files" => "Потребителски файлове",
"Maps" => "Карти",
"Maps configuration" => "Настройки на карти",
"Meta Tags" => "Мета Таг-ове",
"Meta Tags settings" => "Настройки на мета таг-ове",
"Search" => "Търсене",
"Search settings" => "Настройки за търсене",
"Score settings" => "Настройки за рейтинг",
"Community" => "Общество",
"Community settings" => "Настройки за общество",
"Site Identity" => "Идентичност на сайта",
"Site Identity features" => "Функции за идентичност на сайта",
"Calendar" => "Календар",
"Calendar settings" => "Настройки на календара",
"Intertiki settings" => "Intertiki настройки",
"Google Maps" => "Google Карти",
"Category" => "Категория",
"Nothing has changed" => "Няма промени",
"Poll" => "Анкета",
"Theme" => "Тема",
"Help on \$admintitle Config" => "Помощ за конфигурация на \$admintitle",
"You cannot admin blogs" => "Вие нямате право да администрирате блогове",
"No permission to view the page" => "Нямате право да видите тази страница",
"You can not download files" => "Нямате право да сваляте файлове",
"Registered" => "Регистриран",
"Top visited file galleries" => "Най посещавани файлови галерии",
"Most downloaded files" => "Най-сваляни файлове",
"Last files" => "Последни файлове",
"Last forum topics" => "Последни теми във форума",
"Most read topics" => "Най-четени теми",
"Top topics" => "Топ теми",
"Forum posts" => "Публикации във форума",
"Most visited forums" => "Най-посещавани форуми",
" successfully sent" => " бе изпратен/а/о успешно",
" not sent" => " не беше изпратен/а/о",
"Error: " => "Грешка:",
"No instance indicated" => "Не са посочени инстанции",
"The game file must have .swf or .dcr extension" => "Игровият файл трябва да има .swf или .dcr разширение",
"The thumbnail name must be" => "Името на малката картинка трябва да бъде",
"or" => "или",
"Please supply both files" => "Моля, осигурете и двата файла",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
"Your message has been sent to %d users" => "Вашето съобщение беше изпратено до %d потребители",
"No email was selected" => "Не беше посочен и-мейл",
"Permission denied you cannot remove banners" => "Достъпът отказан: нямате право да премахвате банери",
"Non-existent user" => "Несъществуващ потребител",
"Find" => "Намиране",
"No charts defined yet" => "Не са дефинирани схеми все още",
"prev" => "предишен",
"next" => "следващ",
"Activity completed" => "Действието е завършено",
"Process" => "Процес",
"Comment" => "Коментар",
"Subject" => "Тема",
"Crosslinks to other features and settings" => "Кръстосани връзки с други фунции и настройки",
"Other sections" => "Други секции",
// "Spreadsheet" => "Spreadsheet",
"Surveys" => "Проучвания",
"Integrator" => "Интегратор",
"HTML pages" => "HTML страници",
"Shoutbox" => "Мегафон",
"Shoutbox Words" => "Думи в мегафона",
"Live support" => "Помощ 'на живо'",
"Chat" => "Чат",
"Games" => "Игри",
"Contact us" => "Свържете се с нас",
"Administration features" => "Административни функции",
"Users" => "Потребители",
"Groups" => "Групи",
"Security" => "Сигурност",
"System" => "Система",
"SysLogs" => "Системни логове",
"Backups" => "Резервни копия",
// "Banning" => "Banning",
// "Transversal features" => "Transversal features",
"which apply to more than one section" => "които се отнасят за повече от една секция",
"Mail notifications" => "Известяване по мейл",
"Navigation features" => "Функции за навигация",
"Categories" => "Категории",
"Links" => "Връзки",
"Text area features" => "Функции на текстова зона",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "функции, които можете да използвате във всички текстови полета, като уики страници, блогове, статии, форуми и т.н.",
"Cookies" => "Кукита",
// "Hotwords" => "Hotwords",
"Cache" => "Кеш",
"QuickTags" => "Бързи етикети",
"Content templates" => "Шаблони съдържание",
"Drawings" => "Рисунки",
"Dynamic content" => "Динамично съдържание",
"External wikis" => "Външни уикита",
"Stats &amp; banners" => "Статистика &amp; банери",
"Stats" => "Статистика",
// "Referer stats" => "Referer stats",
"Search stats" => "Статистики за търсене",
"Banners" => "Банери",
"Vote poll" => "Гласуване",
"Other Polls" => "Други анкети",
"Tip" => "Подсказка",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "За да добавите/премахнете анкети, вижте за 'Анкети' под 'Админ' в менюто на приложението, или",
"click here" => "Кликнете тук",
"Allow Anonymous Poll Voting" => "Позволяване на анонимно гласуване в анкети",
"Comments" => "Коментари",
"Default number of comments per page" => "Брой коментари на страница по подразбиране",
"Comments default ordering" => "Подредба на коментарите по подразбиране",
"Newest first" => "Първо най-новите",
"Oldest first" => "Първо най-старите",
"Change settings" => "Промяна на настройки",
"User Activities" => "Потребителски действия",
"Galaxia User Activities" => "Действия на потребителите на Galaxia",
"View tpl" => "Разглеждане на шабл",
"Galaxia User Activities tpl" => "шаблон за действията на потребителите на Galaxia",
"edit tpl" => "редакция на шабл",
"List of activities" => "Списък с действия",
"process" => "процес",
"find" => "намиране",
"All" => "Всички",
"Enter the name of this instance" => "Въведете името на инстанцията",
"The name is not valid. Please, enter the name again" => "Името не е валидно, моля въведете го отново",
// "run" => "run",
"run activity" => "извършване на действие",
"No processes defined or activated yet" => "Все още не е дефиниран или активиран процес",
// "Process Graph for" => "Process Graph for",
"Replicate" => "Репликация",
"Tikiwiki.org help" => "Помощ от Tikiwiki.org",
"system admin" => "системен админ",
"system admin tpl" => "шабл системен админ",
"Slave" => "Роб",
"Master" => "Господар",
"Change" => "Промяна",
"Operations" => "Операции",
"Operations Log" => "Лог на операциите",
"Look under \"Articles\" on the application menu for links to" => "Вижте под 'Статии' в менюто на приложението за връзки към",
"Admin topics" => "Администрация на теми",
"Admin types" => "Администрация на типове",
"CMS features" => "Функции на CMS",
// "Submissions" => "Submissions",
"Rankings" => "Класации",
"Spellchecking" => "Проверка на правопис",
"Not Installed" => "Не е инсталиран/а",
"Use templates" => "Използване на шаблони",
"Print article" => "Принтиране на статия",
"Change preferences" => "Промяна на настройки",
// "Settings for page articles home" => "Settings for page articles home",
// "Maximum number of articles in home" => "Maximum number of articles in home",
"Article comments settings" => "Настройки на коментарите на статии",
"Fields to display on page" => "Полета за показване на страницата",
"Topic" => "Тема",
"Publish Date" => "Дата на публикация",
"Expire Date" => "Дата на изтичане",
"Preview" => "Предварителен преглед",
"posted by" => "публикуван/о от",
// "Live support:Console" => "Live support:Console",
"Operator" => "Оператор",
// "be online" => "be online",
// "be offline" => "be offline",
"Support requests" => "Молби за подкрепа",
"User" => "Потребител",
"Reason" => "Причина",
// "Requested" => "Requested",
"Accept" => "Приемане",
"Join" => "Присъединяване",
"Show/Hide Left Menus" => "Показване/Скриване на левите менюта",
"Show/Hide Right Menus" => "Показване/Скриване на десните менюта",
"Change password enforced" => "Задължителна промяна на паролата",
"Old password" => "Стара парола",
"New password" => "Нова парола",
"Again please" => "Отново, ако обичате",
"change" => "промяна",
"Write a note" => "Писане на бележка",
"Notes" => "Бележки",
"Data" => "Данни",
"save" => "запазване",
"close" => "затваряне",
"details" => "детайли",
"remove" => "премахване",
"click to edit" => "кликнете за редакция",
"click to view" => "кликнете за преглед",
"Tasks per page" => "Задачи на страница",
"all" => "всички",
"title" => "заглавие",
"start" => "старт",
"end" => "край",
"priority" => "приоритет",
"completed" => "довършен/и",
// "delete" => "изтриване",
"trash" => "кошче",
"not accepted by one user" => "не е одобрен/о/а от един потребител",
"not accepted user" => "неодобрен потребител",
"waiting for me" => "очаква/т ме",
"accepted by task user and creator" => "одобрен/и от потребителя и създателя на задачата",
"accepted user and creator" => "одобрени потребител и създател",
"waiting for other user" => "очакване на друг потребител",
"%m/%d/%Y [%H:%M]" => "%d/%m/%Y [%H:%M]",
"waiting" => "очакване",
"No tasks entered" => "Не са въведени задачи",
"select one" => "изберете един/а",
"undo trash" => "връщане на боклука",
"go" => "OK",
"show:" => "показване:",
"private" => "частен(скрит)",
"received" => "получени",
// "submitted" => "submitted",
"shared" => "споделени",
"all shared tasks" => "всички споделени задачи",
"reload" => "презареждане",
"Tasks" => "Задачи",
"Admin tracker" => "Админ тракър",
"List trackers" => "Списък с тракъри",
"Admin trackers" => "Админ тракъри",
"Edit this tracker" => "Редакция на този тракър",
"View this tracker items" => "Разглеждане на елементите на този тракър",
"Edit tracker fields" => "Разглеждане на полетата на тракъра",
"Is column visible when listing tracker items?" => "Видима ли е колоната когато се показва списък с елементите на тракъра?",
// "Column links to edit/view item?" => "Column links to edit/view item?",
"Column is searchable?" => "Може ли да се търси в тази колона?",
"Field is public? (for use thru trackerlist plugin)" => "Полето публично ли е? (за употреба в trackerlist плъгина)",
"Field is hidden?" => "Полето скрито ли е?",
"not hidden" => "видимо",
"visible by admin only" => "видимо само за админи",
"editable by admin only" => "редактируемо само от админи",
"Field is mandatory?" => "Полето е задължително?",
"Order" => "Ред",
"Tracker fields" => "Полета на тракъра",
"rows" => "редове",
"Id" => "ID",
"name" => "име",
"isMain" => "еГлавен",
"Tbl vis" => "Видим",
"Searchable" => "Филтрируем",
"Hidden" => "Скрит",
"Mandatory" => "Задължителен",
"down" => "надолу",
"Import/export trackers fields" => "Импорт/експорт на полета на тракъри",
"Import" => "Импорт",
"configure listing" => "конфигурация на списъка",
"create new blog" => "създаване на нов блог",
"Last Modified" => "Последна модификация",
"post" => "публикуване",
// "active perms" => "active perms",
// "perms" => "perms",
"No records found" => "Не са открити записи",
"Year" => "Година",
"Authors" => "Автори",
"Remove" => "Премахване",
"up" => "нагоре",
"add" => "добавяне",
"Admin newsletters" => "Администрация на новинарски емисии",
"View template" => "Разглеждане на шаблон",
"admin newsletters template" => "администрация на шаблони новинарски емисии",
"list newsletters" => "списък с новинарски емисии",
"send newsletters" => "изпращане на новинарски емисии",
"Create/edit newsletters" => "Създаване/редакция на новинарски емисии",
"There are individual permissions set for this newsletter" => "Има настроени индивидуални позволения за тази новинарска емисия",
"Users can subscribe/unsubscribe to this list" => "Потребителите могат да се абонират/прекратяват абонамента към този списък",
"Users can subscribe any email address" => "Потребителите могат да абонират всеки и-мейл адрес",
"Add unsubscribe instructions to each newsletter" => "Добавяне на инструкции за прекратяване на абонамент към всяко писмо от новинарската емисия",
"Validate email addresses" => "Валидиране на и-мейл адрес",
"users" => "потребители",
"editions" => "редакции",
"last sent" => "списък изпратени",
"Assign Permissions" => "Назначаване на права",
"subscriptions" => "абонаменти",
"send newsletter" => "изпращане на писмо в новинарската емисия",
// "Admin layout" => "Admin layout",
"layout options" => "настройки за изглед",
"Left column" => "Лява колона",
"Right column" => "Дясна колона",
"Top bar" => "Горен блок",
"Bottom bar" => "Блок в дъното",
"Set features" => "Настройване на функции",
"Admin Menu" => "Админ Меню",
"List menus" => "Списък с менюта",
"Edit this menu" => "Редакция на това меню",
"Edit menu options" => "Редакция на опциите на това меню",
"Show Quick Urls" => "Показване на бързи URLs",
"Hide Quick Urls" => "Скриване на бързи URLs",
"Some useful URLs" => "Някои полезни URLs",
"URL" => "URL",
"Permissions" => "Права",
"Group" => "Група",
"section level 0" => "секция ниво 0",
"section level 1" => "секция ниво 1",
"section level 2" => "секция ниво 2",
"section level 3" => "секция ниво 3",
// "sorted section level 0" => "sorted section level 0",
"separator" => "разделител",
"Choose" => "Избор",
"Home Page" => "Начална страница",
"Home Blog" => "Начален блог",
"Home Image Gal" => "Начална картинна гал",
"Home Image Gallery" => "Начална картинна галерия",
"Home File Gal" => "Начална файлова гал",
"Home File Gallery" => "Начална файлова галерия",
"User preferences" => "Потребителски предпочитания",
"User prefs" => "Потр настр",
"Last changes" => "Последни промени",
"List pages" => "Списък със страници",
"Sandbox" => "Пясъчна кутия",
"List galleries" => "Списък с галерии",
"List image galleries" => "Списък с картинни галерии",
"Upload image" => "Качване на файл",
"Upload" => "Качване",
"Gallery Rankings" => "Рейтинг на галериите",
"Browse a gallery" => "Разглеждане на галерия",
"Articles home" => "Начало на статии",
"All articles" => "Всички статии",
"Submit" => "Потвърждение",
"List Blogs" => "Списък с блогове",
"Create blog" => "Създаване на блог",
"Post" => "Публикация",
"Files" => "Файлове",
"Upload file" => "Качване на файл",
"View a forum" => "Разглеждане на форум",
"View a thread" => "Разглеждане на тема",
"View a FAQ" => "Разглеждане на FAQ",
"Take a quiz" => "Решаване на тест",
"Quiz stats" => "Статистики на тестове",
"Stats for a Quiz" => "Статистики за тест",
"Preview menu" => "Предварителен преглед на меню",
"Menu options" => "Опции на меню",
"Number of lines" => "Брой редове",
"url" => "url",
"permissions" => "права за достъп",
// "admin Trackers tpl" => "admin Trackers tpl",
"Edit fields for tracker" => "Редакция на полета за тракър",
"Edit tracker" => "Редакция на тракър",
"Create trackers" => "Създаване на тракъри",
"Import/export" => "Импорт/Експорт",
"created" => "създаден/а",
"last modif" => "последна модиф.",
"items" => "елементи",
"view" => "разглеждане",
"active permissions" => "активни права за достъп",
"fields" => "полета",
"Create/edit trackers" => "Създаване/промяна на тракъри",
"There are individual permissions set for this tracker" => "Има индивидуални права настроени за този тракър",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "Името на тракъра трябва да е уникално. Полетата трябва да са уникални за тракъра и те трябва да са валидни в SQL",
"Show status" => "Показване на статус",
"Default status displayed in list mode" => "Статус по подразбиране, при показване на списък",
// "Show status to tracker admin only" => "Show status to tracker admin only",
"Send copies of all activity in this tracker to this e-mail address" => "Изпращане на копия от всяко действие в този тракър на този и-мейл адрес",
"Use simplified e-mail format" => "Използване на опростен и-мейл формат",
"The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "Тракърът ще използва полето 'тема' за тема (ако е попълнено) и ще използва потребителкия и-мейл, или мейлът на 'Анонимен' ако е посочил такъв",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
"No change" => "Липсва промяна",
"Item creator can modify his items?" => "Създателят на елементи може да модифицира собствените елементи?",
"The tracker needs a user field with the option 1" => "Тракърът се нуждае от потребителско поле с опция 1",
"Member of the default group of creator can modify items?" => "Член на групата по подразбиране на създателя може да модифицира елементи?",
"The tracker needs a group field with the option 1" => "Тракърът се нуждае от групово поле с опция 1",
"Show creation date when listing tracker items?" => "Показване на дата на създаване когато се показва списък с елементи?",
"Date and Time Format Help" => "Помощ за формата на датата и времето",
"Show lastModif date when listing tracker items?" => "Показване на дата на последна модификация когато се показва списък с елементите?",
"What field is used for default sort?" => "Кое поле да се използва за сортиране по подразбиране?",
"lastModif" => "последна модификация",
"What is default sort order in list?" => "Какъв е редът за сортиране по подразбиране?",
"ascending" => "възходящ",
"descending" => "низходящ",
"Tracker items allow ratings?" => "Елементите на тракъра позволяват рейтинги?",
"with values" => "със стойности",
"and display rating results in listing?" => "и показване на резултатите от рейтингите при показване на списък?",
"Tracker items allow comments?" => "Елементите на тракъра позволяват коментари?",
"and display comments in listing?" => "и показване на коментарите при показване на списък?",
"Tracker items allow attachments?" => "Елементите на тракъра позволяват приложения?",
"and display attachments in listing?" => "и показване на приложенията при показване на списък?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Опции за показване на приложения (Използвайте цифри за да подредите елементите, 0 = няма да се покаже, а негативни стойности означават, че ще се отвори в нов прозорец",
"filename" => "име на файл",
"downloads" => "сваляния",
"filesize" => "размер на файл",
"filetype" => "тип на файл",
"longdesc" => "дълго описание",
"Do not show empty fields in item view?" => "Празните полета не се показват при преглед на елементите?",
"Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Показване на тези полета (номера, разделени със запетаи) в изскачащ прозорец на връзка към елемент когато се показва лист с елементите на тракъра?",
"Import/export trackers" => "Импорт/експорт на тракъри",
"Import/Export CSV Data" => "Импорт/експорт на CSV данни",
"Download CSV export" => "Сваляне на CSV експорт",
"Import file" => "Импорт на файл",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
"This process is invalid" => "Този процес е невалиден",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
"List of processes" => "Списък с процеси",
"Active" => "Активен/ни",
"Inactive" => "Неактивен/ни",
"active" => "aктивен/ни",
"active process" => "активен процес",
"invalid" => "невалиден",
"invalid process" => "невалиден процес",
"valid process" => "валиден процес",
"activities" => "действия",
"graph" => "графа",
"roles" => "роли",
"export" => "експорт",
// "new minor" => "new minor",
// "new major" => "new major",
"No processes defined yet" => "Все още не са дефинирани процеси",
// "Validate sites" => "Validate sites",
// "Validate Sites" => "Validate Sites",
// "directory validate sites tpl" => "directory validate sites tpl",
"validate" => "валидация",
"country" => "държава",
"hits" => "посещения",
"categories" => "категории",
"Featured links" => "Връзки",
"admin featured links" => "администрация на връзки",
"admin featured links template" => "администрация на шаблоните връзки",
"Edit template" => "Редакция на шаблон",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
"Generate positions by hits" => "Генериране на позиции според брой посещения",
"List of featured links" => "Списък с Връзки",
"Add Featured Link" => "Добавяне на връзка",
"Edit this Featured Link:" => "Редакция на тази връзка:",
"Create new Featured Link" => "Създаване на нова връзка",
"disables the link" => "Деактивация на тази връзка",
"Link type" => "Тип връзка",
"replace current page" => "Замяна на сегашната страница",
"framed" => "рамкирана",
"open new window" => "отваряне в нов прозорец",
"Total categories" => "Общо категории",
"Total links" => "Общо връзки",
"Links to validate" => "Връзки за валидация",
"Searches performed" => "Извършени търсения",
"Total links visited" => "Общ брой посетени страници",
"Last mod" => "Последна мод.",
"Creator" => "Създател",
"Last author" => "Последен автор",
"Last ver" => "Последна вер",
"Backlinks" => "Обратни връзки",
"Language" => "Език",
// "with checked" => "with checked",
"Last `\$module_rows` modified file galleries" => "Последни `\$module_rows` модифицирани файлови галерии",
"Last modified file galleries" => "Последни модифицирани файлови галерии",
"Last `\$module_rows` Modified blogs" => "Последни `\$module_rows` модифицирани блогове",
"Last Modified blogs" => "Последни модифицирани блогове",
"Search Wiki PageName" => "Търсене по име на Уики страница",
"Top Images" => "Топ снимки",
"Last `\$module_rows` modified events" => "Последни `\$module_rows` модифицирани събития",
"Last modifed events" => "Последни модифицирани събития",
"Email" => "И-мейл",
"Last login" => "Последно влизане",
"Never" => "Никога",
"default" => "по подразбиране",
"Logs" => "Логове",
"Most commented forums" => "Най-коментирани форуми",
"Last `\$module_rows` Items" => "Последни `\$module_rows` елемента",
"Last Items" => "Последни елементи",
"Google Search" => "Търсене в Google",
"Top `\$module_rows` files" => "Топ `\$module_rows` файла",
"Top files" => "Топ файлове",
"Top `\$module_rows` File Galleries" => "Топ `\$module_rows` файлови галерии",
"Top File Galleries" => "Топ файлови галерии",
"Online users" => "Онлайн потребители",
"Send a message" => "Изпращане на съобщение",
"Last `\$module_rows` blog posts" => "Последни `\$module_rows` блог публикации",
"Last blog posts" => "Последни публикации в блоговете",
"Last `\$module_rows` Modified Comments" => "Последни `\$module_rows` модифицирани коментари",
"Last Modified Comments" => "Последни модифицирани коментари",
"Top `\$module_rows` topics" => "Топ `\$module_rows` теми",
"Logout" => "Изход от системата",
"User informations" => "Информация за потребители",
"Group informations" => "Информация за групи",
"You need to activate user and/or group trackers" => "Вие трябва да активирате потребителски и/или групови тракъри",
"Most `\$module_rows` visited blogs" => "`\$module_rows` най-посещавани блогове",
"My galleries" => "Моите галерии",
// "Exact&nbsp;match" => "Exact&nbsp;match",
"Last `\$module_rows` Created FAQs" => "Последни `\$module_rows` FAQs",
"Last Created FAQs" => "Последни FAQs",
"Top `\$module_rows` galleries" => "Топ `\$module_rows` галерии",
"January" => "Януари",
"February" => "Февруари",
"March" => "Март",
"April" => "Април",
"May" => "Май",
"June" => "Юни",
"July" => "Юли",
"August" => "Август",
"September" => "Септември",
"October" => "Октомври",
"November" => "Ноември",
"December" => "Декември",
"Current events" => "Текущи събития",
"Last `\$module_rows` Created blogs" => "Последни `\$module_rows` създадени блогове",
"Last Created blogs" => "Последно създадени блогове",
"Random Pages" => "Случайни страници",
"logged as" => "Потребителско име",
"set" => "ОК",
"Login through CAS" => "Логин през CAS",
"Login as admin" => "Логин като администратор",
"pass" => "парола",
"Remember me" => "Запомни ме",
"Click here to register" => "Кликнете тук за да се регистрирате",
"register" => "регистрация",
"Click here if you've forgotten your password" => "Кликнете тук ако сте си забравили паролата",
"I forgot my pass" => "Забравих си паролата",
"Click here to login using the default security protocol" => "Кликнете тук за да се логнете чрез протокола по подразбиране",
"Click here to login using a secure protocol" => "Кликнете тук за да се регистрирате чрез сигурен протокол",
"secure" => "сигурен",
"stay in ssl mode" => "Оставане в режим SSL",
"local account" => "локален акаунт",
// "Waiting Submissions" => "Waiting Submissions",
"We have" => "Ние имаме",
"submissions waiting to be examined" => "submissions waiting to be examined",
"Top `\$module_rows` Images" => "Топ `\$module_rows` снимки",
"Last `\$module_rows` Created Quizzes" => "Последни `\$module_rows` тестове",
"Last Created Quizzes" => "Последно създадени тестове",
"Top `\$module_rows` Forum Posters" => "Топ `\$module_rows` участници във форума (по брой публикации)",
"Top Forum Posters" => "Топ публикуващи във форума",
"online users" => "потребители онлайн",
"Last `\$module_rows` Modified Items" => "Последни `\$module_rows` модифицирани елементи",
"Last Modified Items" => "Последни модифицирани елементи",
"Directory Stats" => "Статистики на директориите",
"Sites to validate" => "Сайтове за валидиране",
"Searches" => "Търсения",
"Visited links" => "Посетени връзки",
"Top `\$module_rows` Visited FAQs" => "Топ `\$module_rows` FAQs по посещения",
"Top Visited FAQs" => "Топ посещавани FAQs",
"Last `\$module_rows` visitors" => "Последни `\$module_rows` потребители",
"Last visitors" => "Последни потребители",
"Open operator console" => "Отвяряне на операторска конзола",
"You have" => "Вие имате",
"new messages" => "нови съобщения",
"new message" => "ново съобщение",
"You have 0 new messages" => "Нямате нови съобщения",
"Top `\$module_rows` Quizzes" => "Топ `\$module_rows` тестове",
"Top Quizzes" => "Топ тестове",
"MyMenu" => "Моето Меню",
"MyTiki" => "МоетоTiki",
"MyTiki home" => "МоетоTiki Начална страница",
"Preferences" => "Настройки",
"Bookmarks" => "Отметки",
"Newsreader" => "Новинарска емисия",
"Notepad" => "Блок за бележки",
"My files" => "Моите файлове",
"User menu" => "Потребителско меню",
"Mini calendar" => "Мини календар",
"My watches" => "Моите наблюдения",
// "WfMenu" => "WfMenu",
"Admin processes" => "Администриране на процеси",
"Monitor processes" => "Проследяване на процеси",
"Monitor activities" => "Проследяване на действия",
"Monitor instances" => "Проследяване на инстанции",
"User processes" => "Потребителски процеси",
"User activities" => "Потребителски действия",
"User instances" => "Потребителски инстанции",
"FriendsMenu" => "Меню Приятели",
"User list" => "Списък с потребители",
"Friendship Network" => "Приятелска мрежа",
"WikiMenu" => "Уики Меню",
// "Dump" => "Dump",
"Orphan pages" => "Страници сирачета",
"Print" => "Принтиране",
"Send pages" => "Изпратени страници",
"Received pages" => "Получени страници",
// "GalMenu" => "GalMenu",
"Image Galleries" => "Картинни галерии",
"Galleries" => "Галерии",
"System gallery" => "Системна гелерия",
"Submit article" => "Предаване на статия",
// "View submissions" => "View submissions",
"Edit article" => "Редакция на статия",
"Send articles" => "Изпращане на статии",
"Received articles" => "Получени статии",
"List blogs" => "Списък с блогове",
"Create/Edit blog" => "Създаване/Редакция на блог",
"Admin posts" => "Администрация на публикации",
// "ForMenu" => "ForMenu",
"List forums" => "Списък с форуми",
"Admin forums" => "Администрация на форуми",
// "DirMenu" => "DirMenu",
"Submit a new link" => "Предаване на нова връзка",
"Browse directory" => "Разглеждане на директория",
"Admin directory" => "Администрация на директория",
// "FileGalMenu" => "FileGalMenu",
"File Galleries" => "Файлови галерии",
"List FAQs" => "Списък с FAQs",
"Admin FAQs" => "Администрация на FAQs",
"Mapfiles" => "Картови файлове",
"Layer management" => "Layer management",
"QuizMenu" => "Меню тестове",
"List quizzes" => "Списък с тестове",
"Admin quiz" => "Администрация на тестове",
// "ShtMenu" => "ShtMenu",
// "TrkMenu" => "TrkMenu",
// "SrvMenu" => "SrvMenu",
"List surveys" => "Списък с проучвания",
"Admin surveys" => "Администрация на проучвания",
"Send newsletters" => "Изпращане на новинарски емисии",
"Events" => "Събития",
"Send events" => "Изпращане на събития",
"Admin events" => "Администрация на събития",
// "EphMenu" => "EphMenu",
// "Ephemerides Admin" => "Ephemerides Admin",
// "ChartMenu" => "ChartMenu",
// "Charts Admin" => "Charts Admin",
// "AdmMenu" => "AdmMenu",
"Admin" => "Администрация",
"Admin home" => "Админ Начало",
// "Debugger console" => "Debugger console",
"RSS modules" => "RSS модули",
"Theme control" => "Контрол на теми",
"Edit templates" => "Редакция на шаблони",
"Edit languages" => "Редакция на езици",
// "System Admin" => "System Admin",
// "Mods Admin" => "Mods Admin",
"Security Admin" => "Администрация сигурност",
"UsrMenu" => "Потр. Меню",
"Click here to manage your personal menu" => "Кликнете тук за да управлявате личното си меню",
"User Menu" => "Потребителско меню",
"Tikiwiki Assistant" => "Tikiwiki асистент",
"Thank you for installing Tikiwiki" => "Благодарим ви, че инсталирахте TikiWiki",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
"Please, also see" => "Моля, вижте още",
"for more setup details." => "за още детайли по настройката.",
"Note 1:" => "Забележка 1:",
"You can remove this module in" => "Можете да премахнете този модул в",
"as well as assign or edit many others." => "както и да дефинирате или редактирате много други.",
"Note 2:" => "Забележка 2:",
"The menu module installed by default is named" => "Меню модулът инсталиран по подразбиране е се нарича",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
"That menu is stored in database and it can be edited from " => "Това меню се съхранява в база данни и може да бъде редактирано от ",
"Do not mix this with the original <em>application_menu</em> module" => "Не бъркайте това с оригиналния <em>application_menu</em>",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
"Last `\$module_rows` changes" => "Последни `\$module_rows` промени",
"Last `\$module_rows` Images" => "Последни `\$module_rows` изображения",
"Last Images" => "Последни изображения",
"Last `\$module_rows` actions" => "Последни `\$module_rows` действия",
"Last actions" => "Последни действия",
"Recently visited pages" => "Скоро посетени страници",
"Last `\$module_rows` galleries" => "Последни `\$module_rows` галерии",
"Last galleries" => "Последни галерии",
"in:" => "в:",
"Entire Site" => "Целия сайт",
"Wiki Pages" => "Wiki Страници",
"Image Gals" => "Картинни галерии",
"Blog Posts" => "Блог публикации",
"My blogs" => "Моите блогове",
// "User tasks" => "User tracks",
"done" => "готово",
"del" => "изтриване",
"Last `\$module_rows` Sites" => "Последни `\$module_rows` сайта",
"Last Sites" => "Последни сайтове",
"Last `\$module_rows` articles" => "Последни `\$module_rows` статии",
"Last articles" => "Последни статии",
"Register as a new user" => "Регистрация на нов потребител",
"Your email could not be validated; make sure you email is correct and click register below." => "Вашият и-мейл не бе валидиран; уверете се, че въвеждате правилен и-мейл и кликнете 'регистрация' отдолу",
"Your registration code:" => "Вашият код за регистрация е:",
"Random Image" => "Случайна снимка",
"Username" => "Потребителско име:",
"Passcode to register (not your user password)" => "Паскод за регистрация (това не е вашата потребителска парола)",
"Registration code" => "Код за регистрация",
"Password" => "Парола",
"Repeat password" => "Повторете паролата",
"Generate a password" => "Генериране на парола",
"Top `\$module_rows` Pages" => "Топ `\$module_rows` страници",
"Top Pages" => "Топ страници",
"My Pages" => "Моите страници",
"Last" => "Последни",
"RSS Feeds" => "RSS емисии",
"Wiki RSS" => "Уики RSS",
"Blogs RSS" => "RSS блогове",
"Articles RSS" => "RSS статии",
"Image Galleries RSS" => "RSS картинни галерии",
"File Galleries RSS" => "RSS файлови галерии",
"Forums RSS" => "RSS Форуми",
"Maps RSS" => "RSS Карти",
"Directories" => "Директории",
"Calendars" => "Календари",
"cache" => "кеш",
"mark" => "маркиране",
"Received objects" => "Получени обекти",
"Pages:" => "Страници:",
"Top `\$module_rows` Objects" => "Топ `\$module_rows` обекти",
"Top Objects" => "Топ обекти",
"Top \$module_rows Sites" => "Топ \$module_rows сайтове",
"Top Sites" => "Топ сайтове",
"Top `\$module_rows` games" => "Топ `\$module_rows` игри",
"Top games" => "Топ игри",
"Admin drawings" => "Администрация  на рисунки",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
"Admin dsn" => "Администрация на DSN",
// "Syntax highlighting" => "Syntax highlighting",
"Public tasks" => "Публични задачи",
"select" => "избор",
"Top users" => "Топ потребители",
"Last `\$module_rows` submissions" => "Последни `\$module_rows` submissions",
// "Last submissions" => "Last soumissions",
"Last `\$module_rows` wiki comments" => "Последни `\$module_rows` коментари в Уикито",
"Last wiki comments" => "Последни коментари в уикито",
" on page " => " на страница ",
"Most Active blogs" => "Най активни блогове",
"Random Images" => "Случайни снимки",
"random images" => "случайни снимки",
"Language: " => "Език: ",
"Whats related" => "Какво е подобно?",
"Old articles" => "Стари статии",
"Since your last visit on" => "След последното ви посещение на:",
"online user" => "онлайн потребител",
// "on host" => "on host",
"Last `\$module_rows` forum posts" => "Последни `\$module_rows` публикации във форума",
"Last forum posts" => "Последни публикации във форума",
"Upcoming `\$module_rows` events" => "Предстоящи `\$module_rows` събития",
"send" => "изпращане",
"Read More" => "Прочетете Повече",
"Tiki Logo" => "Tiki Лого",
"Last `\$module_rows` forum topics" => "Последни `\$module_rows` теми във форума",
"Top `\$module_rows` articles" => "Топ `\$module_rows` статии",
"Top articles" => "Топ статии",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
"Last `\$module_rows` Files" => "Последни `\$module_rows` файлове",
"Last Files" => "Последни файлове",
"Filter" => "Филтър",
"Today" => "Днес",
"Available Repositories" => "Налични хранилища",
"configure repositories" => "конфигуриране на хранилища",
"A valid email is mandatory to register" => "Задължително е да посочите валиден и-мейл адрес за да се регистрирате",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
"Search results" => "Резултати от търсенето",
"Search in" => "Търсене в",
"galleries" => "галерии",
"files" => "файлове",
"blog posts" => "блог постове",
"trackers" => "тракъри",
"Found" => "Намерен/и",
"entire site" => "целия сайт",
"wiki pages" => "уики страници",
"Simple search" => "Просто търсене",
"Last modification date" => "Дата на последна модификация",
"No pages matched the search criteria" => "Никакви страници не съвпаднаха с критерия за търсене",
"Edit survey questions" => "Редакции на въпросите в проучването",
"survey stats" => "статистики на проучването",
"this survey stats" => "статистики на това проучване",
"edit this survey" => "редакция на това проучване",
"admin surveys" => "администрация на проучванията",
"Create/edit questions for survey" => "Създаване/редакция на въпросите за проучването",
"One choice" => "1 избор",
"Multiple choices" => "Множество избори",
"Short text" => "Къс текст",
// "Rate (1..5)" => "Rate (1..5)",
// "Rate (1..10)" => "Rate (1..10)",
"For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "За въпрос с множествен избор, поставете отговорите в следното поле, разделени от запетаи - например: едно,две,много,адски много",
"Options (if apply)" => "Опции (ако подхождат)",
"Admin Polls" => "Администрация на анкетите",
"List polls" => "Списък с анкети",
"Edit this poll" => "Редакция на тази анкета",
"Preview poll" => "Предварителен преглед на анкетата",
"Edit or add poll options" => "Редакция или добавяне на опции в анкетата",
"Poll options" => "Опции на анкетата",
"Admin Article Types" => "Администрация на типовете статии",
// "Article Types tpl" => "Article Types tpl",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
"Rate" => "Оценка",
"Allow ratings by the author" => "Разрешаване на оценяване от автора",
"Show before publish date" => "Показване преди датата за публикация",
"non-admins can view before the publish date" => "неадминистратори могат да разглеждат преди датата за публикация",
"Show after expire date" => "Показване след крайната дата",
"non-admins can view after the expire date" => "неадминистраторите могат да разглеждат след крайната дата",
"Heading only" => "Само заглавието",
"No article body, heading only" => "Само заглавието, без текста на статията",
"Allow comments for this type" => "Позволяване на коментари за този тип",
"Comment Can Rate Article" => "Коментарите могат да оценяват статията",
"Allow comments to include a rating value" => "Позволяване на коментарите да съдържат оценка",
"Show image" => "Показване на изображение",
"Show topic or own image" => "Показване на тема или собствено изображение",
"Show avatar" => "Показване на аватар",
"Show author's avatar" => "Показване на аватара на автора",
"Show author" => "Показване на автора",
"Show author name" => "Показване на името на автора",
"Show publish date" => "Показване на дата на публикация",
"Show expire date" => "Показване на дата на изтичане",
"Show reads" => "Показване на брой прочити",
"Show the number of times the article was read" => "Показване на броя прочитания на статията",
"Show size" => "Показване на размер",
"Show the size of the article" => "Показване на размера на страницата",
"Show topline" => "Показване на заглавен ред",
"Show a small title over the title" => "Показване на малко заглавие над заглавието",
"Show subtitle" => "Показване на под-заглавие",
"Show the subtitle" => "Показване на подзаглавието",
"Show source" => "Показване на източник",
"Show link to source after article body" => "Показване на връзка към източника след текста на статията",
"Show Image Caption" => "Показване на обяснение към изображението",
"Show a legend under the image" => "Показване на легенда под изображението",
"Show Language" => "Показване на език",
"Show the language" => "Показване на езика",
"Creator can edit" => "Създателят може да редактира",
"The person who submits an article of this type can edit it" => "Човекът който предаде статия от този тип може и да я редактира",
"Delete" => "Изтриване",
"Delete this type" => "Изтрива този тип",
"List of types" => "Списък с типове",
"Show lang" => "Показване на език",
"Review" => "Повторен преглед",
"Event" => "Събитие",
"Classified" => "Класифициран",
"Create a new type" => "Създаване на нов тип",
"viewed" => "разгледан",
"times" => "пъти",
// "edit chart" => "edit chart",
"edit items" => "редакция на елементи",
"list charts" => "списък схеми",
"last chart" => "последна схема",
"previous chart" => "предишна схема",
"Chart created" => "Схема създадена",
"next chart" => "следваща схема",
// "pre" => "pre",
"permanency" => "постоянство",
"item" => "обект",
"avg" => "avg",
"cool" => "relax",
"Next chart will be generated on" => "Следващата схема ще бъде генерирана на",
"View or vote items not listed in the chart" => "Разглеждане или гласуване по елементи, които не са показани на схемата",
"Select something to vote on" => "Изберете нещо по което да гласувате",
"Rename page" => "Преименуване на страница",
"New name" => "Ново име",
"rename" => "преименуване",
"Stats for surveys" => "Статистики за проучвания",
"list surveys" => "списък с проучвания",
// "taken" => "taken",
// "Last taken" => "Last taken",
"browse category" => "разглеждане на категория",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
"Started" => "Започнат/а",
"Ended" => "Завършен/а",
"Not ended" => "Незавършен/а",
"No instances created yet" => "Все още няма създадени инстанции",
"security admin" => "администрация на сигурността",
// "security admin tpl" => "security admin tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
"PHP settings" => "PHP настройки",
"PHP variable" => "PHP променлива",
"Setting" => "Настройка",
"Risk Factor" => "Риск Фактор",
"Explanation" => "Обяснение",
"Tikiwiki settings" => "настройки на ТикиУики",
"Tiki variable" => "Tikiwiki променлива",
"Check all tiki files" => "Проверете всички файлове на тики",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
"File checks" => "Файлови проверки",
"Filename" => "Име на файл",
"State" => "Статус",
// "Assign user" => "Assign user",
// "to groups" => "to groups",
"Admin groups" => "Администрация на групи",
"Admin users" => "Администрация на потребители",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Внимание: тъй като тики сайтът е във slave режим, всичката потребителска информация, която въвеждате ръчно ще бъде автоматично overriden от другата информация в сайта, включително и потребителските права",
"User Information" => "Информация за потребител",
"Default Group" => "Група по подразбиране",
"Available groups" => "Налични групи",
"assign perms to this group" => "назначаване на права за тази група",
"assign" => "назначаване",
"to" => "на/за",
"Broadcast message" => "Съобщение за масово изпращане",
"Message Broadcast" => "Масово изпращане на съобщения",
"edit template" => "редакция на шаблон",
"All users" => "Всички потребители",
"Lowest" => "Най-нисък",
"Low" => "Нисък",
"High" => "Висок",
"Very High" => "Много висок",
"processes" => "процеси",
"being run" => "които се извършват",
"aborted" => "прекъснат/и",
"I forgot my password" => "Забравих си паролата",
"send me my password" => "изпратете ми паролата",
"Important: Username & password are CaSe SenSitiVe" => "Важно! Потребителското име и паролата различават главни от малки букви",
"Return to HomePage" => "Връщане към началната страница",
"Intertiki exchange feature" => "Функция за обмен InterTiki",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
"Intertiki client" => "Intertiki клиент",
"Tiki Unique key" => "Tiki уникален ключ",
"InterTiki Slave mode" => "InterTiki Slave режим",
"Warning: overrides manually registered local users" => "Внимание! overrides manually registered local users",
"No" => "Не",
" as master" => " като господар",
"Import user preferences" => "Импорт на потребителски предпочитания",
"Import user groups" => "Импорт на потребителски групи",
"Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Лимитиране на импорта на групи (разделен със запетаи списък групи, оставете празно за да се предпазите от лимитиране)",
"InterTiki Server" => "InterTiki сървър",
"host" => "хост",
"path" => "път",
"groups" => "групи",
"Add new server" => "добавяне на нов сървър",
"Intertiki server" => "Интертики сървър",
"Intertiki Server enabled" => "Intertiki сървърът е активиран",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
"Known hosts" => "Познати хостове",
"Key" => "Ключ",
"New" => "Нов",
"Galaxia Admin Processes" => "Администрация на процесите в Galaxia",
"Galaxia Admin Processes tpl" => "Шаблони за администрация на процесите в Galaxia",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
"Add or edit a process" => "Добавяне или редакция на процес",
"Process Name" => "Име на процес",
"ver:" => "вер:",
"is active?" => "е активен?",
"update" => "обновяване",
"create" => "създаване",
"Or upload a process using this form" => "Или качете процес като използвате тази форма",
"upload" => "качване",
"Click to see the ratings" => "Кликнете за да видите рейтингите",
"Rating" => "Рейтинг",
"vote" => "гласуване",
// "Powered by" => "Powered by",
"Made with" => "Направено с",
// "powered by" => "powered by",
"Execution time" => "Време за изпълнение",
"Memory usage" => "Потребление на памет",
"database queries used" => "използвани заявки към базата данни",
"Server load" => "Натоварване на сървъра",
"Read message" => "Четене на съобщение",
"Prev" => "Предишен",
"Next" => "Следващ",
"Return to outbox" => "Връщане към кутията с изпратени съобщения",
"Unflag" => "Отмаркиране",
"Flag this message" => "Маркиране на съобщението като важно",
"From" => "От",
"To" => "За",
"Browsing Image" => "Разглеждане на изображение",
"return to gallery" => "връщане към галерията",
"edit image" => "редакция на изображение",
"smaller" => "по-малък/ка",
"original size" => "оригинален размер",
"bigger" => "по-голям/а",
"prev image" => "предишно изображение",
"Popup window" => "Изскачащ прозорец",
"popup window" => "изскачащ прозорец",
"next image" => "следващо изображение",
"slideshow forward" => "презентация напред",
"Cyclic" => "Цикличен/на",
"Click to zoom" => "Кликнете за приближаване",
"Image Name" => "Име на изображение",
"Image size" => "Размер на изображение",
"imagescale" => "умален размер",
"Latitude (WGS84/decimal degrees)" => "Географска ширина (WGS84/градуси)",
"Longitude (WGS84/decimal degrees)" => "Географска дължина (WGS84/градуси)",
"Move image" => "Преместване на изображение",
"move" => "преместване",
"You can view this image in your browser using" => "Можете да видите това изображение във вашия браузър като посетите този адрес",
"You can include the image in an HTML page using one of these lines" => "Можете да включите тази снимка в HTML страница като използвате някой от тези редове код",
"You can include the image in a tiki page using one of these lines" => "Можете да включите тази снимка в тики страница като използвате някой от тези редове код",
"Quiz result stats" => "Статистика на резултатите от теста",
"edit quiz questions" => "Редактиране на въпросите на теста",
"edit quiz stats tpl" => "редактиране на шаблоните за статистика на теста",
"list quizzes" => "списък с тестове",
"quiz stats" => "статистика на тестове",
"this quiz stats" => "статистика на теста",
"edit this quiz" => "редакция на теста",
"admin quizzes" => "администраторски тестове",
"Quiz" => "Тест",
"Time" => "Време",
"User answers" => "Потребителски отговори",
"Answer" => "Отговор",
// "CMS" => "CMS",
"Most viewed objects" => "Най-разглеждани обекти",
"Most viewed objects in the last 7 days" => "Най-разглеждани обекти през последните 7 дни",
"Site Stats" => "Статистика на сайта",
"Days online" => "Дни онлайн",
"Total pageviews" => "Общ брой посещения на страница",
"Average pageviews per day" => "Среден брой посещения на ден",
"Best day" => "Най-добър ден",
// "pvs" => "pvs",
"Worst day" => "Най-лош ден",
"Wiki Stats" => "Уики статистика",
"Size of Wiki Pages" => "Размер на Wiki страниците",
"Average page length" => "Средна дължина на страницата",
"Average versions per page" => "Среден брой версии на страница",
"Visits to wiki pages" => "Посещения на уики страници",
"Average links per page" => "Среден брой връзки на страница",
"Image galleries Stats" => "Статистики на картинните галерии",
"Average images per gallery" => "Среден брой картини на галерия",
"Total size of images" => "Тотален размер на снимките",
"Average image size" => "Среден размер на картините",
"Visits to image galleries" => "Посещения на картинните галерии",
"File galleries Stats" => "Статистика на файловите галерии",
"Average files per gallery" => "Среден брой файлове на галерия",
"Total size of files" => "Тотален размер на файловете",
"Average file size" => "Среден размер на файловете",
"Visits to file galleries" => "Посещения на файловите галерии",
"CMS Stats" => "CMS Статистика",
"Total reads" => "Общ брой прочити",
"Average reads per article" => "Среден брой прочитания на страница",
"Total articles size" => "Общ размер на статиите",
"Average article size" => "Среден размер на статиите",
"Topics" => "Теми",
"Forum Stats" => "Статистика на форумите",
"Total topics" => "Общ брой теми",
"Average topics per forums" => "Среден брой теми на форум",
"Total threads" => "Общ брой нишки",
"Average threads per topic" => "Среден брой нишки на тема",
"Visits to forums" => "Посещения на форумите",
"Blog Stats" => "Статистики на блоговете",
"Weblogs" => "Уеблогове",
"Total posts" => "Общ брой публикации",
"Average posts per weblog" => "Среден брой публикации на блог",
"Total size of blog posts" => "Общ размер на блог публикациите",
"Average posts size" => "Среден размер на блог публикациите",
"Visits to weblogs" => "Посещения на уеблоговете",
"Poll Stats" => "Статистики на анкетите",
"Total votes" => "Общ брой гласове",
"Average votes per poll" => "Среден брой гласове на анкета",
"Faq Stats" => "Статистики на FAQs",
"Total questions" => "Общ брой въпроси",
"Average questions per FAQ" => "Среден брой въпроси на FAQ",
"User Stats" => "Потребителски статистики",
"User bookmarks" => "Отметки на потребителите",
"Average bookmarks per user" => "Среден брой отметки на потребител",
"Quiz Stats" => "Статистики на тестовете",
"Average questions per quiz" => "Среден брой въпроси на тест",
"Quizzes taken" => "Решавания на тестовете",
"Average quiz score" => "Среден резултат от тестовете",
"Average time per quiz" => "Средно време на тест",
"Object" => "Обект",
"Usage chart" => "Графика на потреблението",
"Usage chart image" => "Изображение на графиката на потреблението",
"Viewing blog post" => "Разглеждане на публикация в блог",
"Return to blog" => "Връщане към блог",
"Edit" => "Редакция",
// "Permalink" => "Permalink",
// "referenced by" => "referenced by",
"posts" => "публикации",
// "references" => "references",
"comments" => "коментари",
"view comments" => "разглеждане на коментарите",
"print" => "принтиране",
"email this post" => "изпращане на тази публикация по пощата",
"Directory batch upload" => "Качване на партида в директорията",
"Browse gallery" => "Разглеждане на галерията",
"Upload from disk" => "Качване от локален диск",
"available images" => "налични изображения",
"width" => "ширина",
"height" => "височина",
"remove file extension from image name" => "премахване на файловото разширение от името на снимката",
"eg. \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "например, от \"digicam0001.jpg\" за име ще се използва digicam0001",
"convert sub directories to sub galleries" => "Конвертиране на поддиректориите в подгалерии",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "например, от \"misc/screenshots/digicam0001.jpg\" ще бъде създадена галерия с име 'screenshots'",
"use sub directory names as description" => "използване на имента на поддиректориите като описание",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "например от 'misc/screenshots/digicam0001.jpg' ще бъде създадено описание misc/screenshots",
"Mailbox" => "Пощенска кутия",
"Compose" => "Композиране",
"Broadcast" => "Масово изпращане",
"Sent" => "Изпратени",
"Auto-archive age for read messages:" => "Възраст, на която прочетените съобщения ще бъдат архивирани автоматично",
"Edit Post" => "Редакция на публикация",
"Use wysiwyg editor" => "Използване на wysiwyg редактор",
"Use normal editor" => "Използване на нормален редактор",
"view blog" => "разглеждане на блог",
"list blogs" => "списък с блогове",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Забележка: ако искате да използвате изображения, първо запаметете публикацията и ще ви бъде дадена възможност да редактирате и да поставите изображения. Използвайте &lt;img&gt; код за да включите качените изображения в редактора на текстовата зона, или използвайте адреса на изображението за да го включите чрез WYSIWYG редактора. ",
"Smileys" => "Ухилени човечета",
"Use ...page... to separate pages in a multi-page post" => "Използвайте ...page... за да разделите страниците в публикация с много страници",
"Upload image for this post" => "Качване на изображение за тази публикация ",
"Trash" => "Кошче",
"Send trackback pings to:" => "Изпращане на trackback pings до:",
"(comma separated list of URIs)" => "(списък с адреси, разделени със запетаи)",
"Spellcheck" => "Проверка на правописа",
"preview" => "предварителен преглед",
"save and exit" => "запаметяване и изход",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Забележка: Това е само предварителен преглед. И страницата (все още) не е запазена!",
"Add a new site" => "Добавяне на нов сайт",
"You cannot add sites until Directory Categories are setup." => "Не можете да добавяте сайтове преди настройките на Категориите Директории да са нагласени",
"Please contact the Site Administrator" => "Моля, свържете се с администратора на сайта",
"Site added" => "Сайтът бе добавен",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Този сайт беше добавен и валидация от администратор може да е необходима преди той да се появи в списъците",
"Country" => "Държава",
"Add or edit a site" => "Добавяне или редактиране на сайт",
"Name:" => "Име:",
"Description:" => "Описание:",
"URL:" => "Адрес:",
"Categories:" => "Категории:",
"Is valid" => "Е валиден/на",
"EditTemplates" => "Редакция на шаблони",
"EditTemplates tpl" => "Редакция на шаблоните за шаблони",
"Edit CSS" => "Редактиране на CSS",
"Template listing" => "Списък с шаблони",
"Available templates" => "Налични шаблони",
"Template" => "Шаблон",
"save only in the theme:" => "запазване само в темата:",
"Delete the copy in the theme:" => "Изтриване на копието в темата",
"Last update from CVS" => "Последен ъпдейт от CVS",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "За да добавите/премахнете календари, вижте за 'Календар' под 'Администрация' в менюто на приложението, или",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
"Show Plugins Help" => "Показване на помощ за плъгините",
"Close" => "Затваряне",
"Bold text" => "Задебелен шрифт",
"underscores" => "долни тирета",
"Italic text" => "Курсив",
"single quotes" => "единични кавички",
"Centered text" => "Центриран текст",
"colons" => "двуеточия",
"some text" => "някакъв текст",
"Underlined text" => "Подчертан текст",
"equals" => "е равно на",
"Text box" => "Текстово поле",
"One carat" => "Един карат",
"Creates a box with the data" => "Създава поле с данни",
"Box content" => "Съдържание на полето",
"Title bar" => "Заглавно поле",
"creates a title bar" => "създава заглавно поле",
"Colored text" => "Оцветен текст",
"Will display using the indicated HTML color or color name" => "Ще се покаже в посочения HTML цвят или име на цвят",
"Lists" => "Списъци",
"for bullet lists" => "за списъци с предхождащ bullet",
"for numbered lists" => "за номерирани списъци",
"for definiton lists" => "за списъци с дефиниции",
"Headings" => "Залавия",
"make headings" => "създаване на заглавия",
"Show/Hide" => "Показване/Скриване",
"show/hide heading section. + (shown) or - (hidden) by default" => "скриване/показване на заглавни секции. + (видима) или - (скрита) по подразбиране",
"Wiki References" => "Уики references",
"JoinCapitalizedWords or use" => "ИзпишетеДумитеСГлавниБуквиИСлято или използвайте",
// "for wiki references" => "for wiki references",
"SomeName" => "НякаквоИме",
// "prevents referencing" => "prevents referencing",
"External links" => "Външни връзки",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "Използвайте квадратни скоби за външна страница:  [адрес] или [адрес|описание] или [адрес|описание|nocache] (последната форма казва на уикито да не кешира страницата; моля, използвайте тази опция за големи страници!).",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "За външно уики, използвайте: ИмеНаВъншнотоУики:ИмеНаСтраница или  ((Име на външното уики: Име на страница))",
"Tables" => "Таблици",
"row" => "ред",
"creates a table" => "създава таблица",
"displays an image" => "показва изображение",
// "height width desc link and align are optional" => "height width desc link and align are optional",
"Non cacheable images" => "Изображения, които не могат да се кешират",
"Line break" => "Нов ред",
"(very useful especially in tables)" => "(много полезно, особено в таблици)",
// "Horizontal rule" => "Horizontal rule",
// "makes a horizontal rule" => "makes a horizontal rule",
"creates the editable drawing foo" => "Създава редактируема рисунка с име 'foo'",
"Multi-page pages" => "Многостранични страници",
"use" => "използване",
"to separate pages" => "за разделяне на страници",
"Wiki File Attachments" => "Прикачени файлове към уикито",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Създава свръзка към въпросния файл. Ако не се посочи страница, файлът тряба да бъде прикачен към настоящата страница. Ако не бъде посочено описание, името на файла се използва за текст на хипервръзката, освен ако не е включена опцията showdesc (показване на описание), при което като текст на хипервръзката се изполазва описанието на самия файл. Ако е подаден аргумент image=1, прикаченият файл се възприема за изображение и се показва директно на страницата; не се генерира хипервръзка.",
"displays rss feed with id=n maximum=m items" => "показва RSS емисия с елементи id=n maximum=m",
// "Will be replaced by the actual value of the dynamic content block with id=n" => "Will be replaced by the actual value of the dynamic content block with id=n",
"Dynamic variables" => "Динамични променливи",
"Inserts an editable variable" => "Вмъква редактируема променлива",
"Non parsed sections" => "Необработени (non-parsed) секции",
"Prevents wiki parsing of the enclosed data." => "Забранява на уикито да обработва (parse) оградените данни.",
"Preformated sections" => "Предварително форматирани секции",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Показва преформатиран текст/код; не се извършва Уики обработка вътре в в тези секции (as with np), и интервалите са фиксирани (не се извършва подравняване)",
"Square Brackets" => "Квадратни скоби",
"Use [[foo] to show [foo]." => "Използвайте [[пример] за да се покаже [пример].",
"Block Preformatting" => "Преформатиране на блокове",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Отместете текст с произволен брой интервали, за да го превърнете в еднакво-отместен блок, който все пак следва инструкциите за форматиране на Уикито. Той ще бъде отместен с еднакъв брой интервали. Забележете, че тожи режим не запазва точно интервалите и новите редове; използвайте ~pp~...~/pp~ за това.",
"Table of contents" => "Таблица със съдържанието",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)"
"Misc" => "Разни",
"Show Text Formatting Rules" => "Показване на правилата за форматиране на текст",
"No description available" => "Не е налично описание",
"Edit Translation:" => "Редакция на превод:",
"edit translations" => "редакция на преводи",
"edit translations template" => "редакция на шаблона за преводи",
"View page" => "Разглеждане на страница",
"View" => "Разглеждане",
"You must specify the object language" => "Трябва да уточните изик за обекта",
"The object doesn't exist" => "Обектът не съществува",
"The object doesn't have a language" => "Обектът няма език",
"The object has already a translation for this language" => "Обектът вече има превод на този език",
"The object is already in the set of translations" => "Обектът вече е в комплекта преводи",
"Use this section to set the language of the version you are currently working on." => "Използвайте тази секция за да настроите езика на версията, над която работите",
"Set of Translations" => "Комплект преводи",
// "detach" => "detach",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
"Translation of:" => "Превод на:",
"Enter the name of the page for which the current page is the translation." => "Въведете името на страницата за която е превод настоящата страница",
"add to the set" => "добавяне към комплекта",
// "Mail-in accounts" => "Mail-in accounts",
// "admin mailin template" => "admin mailin template",
"Account" => "Акаунт",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
"Account name" => "Име на акаунта",
"POP server" => "POP сървър",
"SMTP server" => "SMTP сървър",
"SMTP requires authentication" => "SMTP изисква автентикация",
"Yes" => "Да",
// "article-put" => "article-put",
// "wiki-get" => "wiki-get",
// "wiki-put" => "wiki-put",
// "wiki-append" => "wiki-append",
"Article Topic" => "Тема на статията",
// "None" => "None",
"Article Type" => "Тип статия",
"Allow anonymous acces" => "Позволяване на анонимен достъп",
"Allow attachments" => "Позволяване на прикачени файлове",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
"Check automatically" => "Автоматично проверяване",
"Frequency" => "Честота",
// "Reported messages for" => "Reported messages for",
"back to forum" => "обратно към форума",
"List of messages" => "Списък съобщения",
// "Reported by" => "Reported by",
"No messages queued yet" => "Все още няма чакащи съобщения",
"Edit File:" => "Редакция на файл:",
"Upload File" => "Качване на файл",
"File Title" => "Заглавие на файл",
"File Description" => "Описание на файл",
"Now enter the file URL" => "Сега въведете адрес на файла",
" or upload a local file from your disk" => " или качете локален файл от вашия диск",
"Upload from disk:" => "Качване от диск:",
"Batch upload" => "Качване на партида",
"Unzip all zip files" => "Разархивиране на всички zip архиви",
"The following file was successfully uploaded" => "Следният файл бе качен успешно",
"You can download this file using" => "Можете да свалите този файл като използвате",
"You can include the file in an HTML/Tiki page using" => "Можете да включите файла в HTML/Tiki страница, като използвате",
"You have to \ncreate a gallery first!" => "Първо трябва \nда създадете галерия!",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
"Tiki sections and features" => "Тики секции и функции",
// "Featured Help" => "Featured Help",
// "Workflow engine" => "Workflow engine",
"Live Support" => "Помощ на живо",
"Live support system" => "Система за помощ на живо",
"Mini Calendar" => "Мини календар",
"Show Module Controls" => "Показване на контрола на модулите",
"Tiki Calendar" => "Tiki календар",
"Tiki Template Viewing" => "Tiki разглеждане на шаблони",
"PhpLayers Dynamic menus" => "PhpLayers динамични менюта",
"Use Tabs" => "Използвайте таб-ове",
"Tiki Sheet" => "Tiki лист",
"Site Logo and Identity" => "Лого и идентичност на сайта",
"Content Features" => "Особености на съдържанието",
// "Hotwords in New Windows" => "Hotwords in New Windows",
// "Custom Home" => "Custom Home",
"HTML Pages" => "HTML Страници",
"Dynamic Content System" => "Система за динамично съдържание",
"Allow Smileys" => "Разрешаване на ухилени човечета",
// "AutoLinks" => "AutoLinks",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
"Banning System" => "Система за бан-ване",
"Banning system" => "Система за бан-ване",
"Debugger Console" => "Debugger Console",
"Communications (send/receive objects)" => "Комуникация (изпратени/получени) съобщения",
"Theme Control" => "Контрол на темата",
// "XMLRPC API" => "XMLRPC API",
// "Referer Stats" => "Referer Stats",
"Contact Us" => "Свържете се с нас",
"Contact Us (Anonymous)" => "Свържете се с нас (анонимно)",
// "Redirect On Error" => "Redirect On Error",
"User Features" => "Потребителски функции",
"User Preferences Screen" => "Екран за потребителски предпочитания",
"Users can Configure Modules" => "Потребителите могат да си конфигурират модули",
"User Bookmarks" => "Потребителски отметки",
"always" => "винаги",
"module decides" => "модулът решава",
"never" => "никога",
"Users can Shade Modules" => "Потребителите могат да  скриват модули",
"User Watches" => "Потребителско наблюдение",
"User Watches Translations" => "Потребителско наблюдение на преводите",
"User Tasks" => "Потребителски задачи",
"User Messages" => "Потребителски съобщения",
"User Files" => "Потребителски файлове",
"User Notepad" => "Потребителски блок за бележки",
"General Layout options" => "Опции за генерална подредба",
"Users can Flip Columns" => "Потребителите могат да разместват колони",
"user decides" => "потребителят решава",
"Layout per section" => "подредба за секция",
"Admin layout per section" => "Администрация на подредба за секция",
"Bottom bar icons" => "Икони в долния блок",
"Bottom bar debug" => "Дебъг информация в долния блок",
"Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
"tiki-import_phpwiki tpl" => "шаблон на tiki-import_phpwiki",
"Name of the dump file (it has to be in dump/)" => "Име на дъмп файла (трябва да бъде в директория dump/)",
"Overwrite existing pages if the name is the same" => "Записване върху стари страници, ако името съвпада",
"yes" => "да",
"no" => "не",
"Previously remove existing page versions" => "Предварително премахване на съществуващите версии на страницата",
"import" => "импортиране",
// "excerpt" => "excerpt",
"result" => "резултат",
"body" => "тяло",
"Edit or ex/import Languages" => "Редакция или екс/импорт на езици",
"Edit and create Languages" => "Редакция и създаване на езици",
"Im- Export Languages" => "Импорт/Експорт на езици",
"Im- Export languages" => "Импорт/Експорт на езици",
"Select the language to Import" => "Избор на език за импорт",
"Export" => "Експорт",
"Select the language to Export" => "Избор на език за експорт",
"Live support:User window" => "Помощ на живо: потребителски прозорец",
"Request live support" => "Молба за помощ на живо",
"Request support" => "Молба за помощ",
// "Open a support ticket instead" => "Open a support ticket instead",
"Your request is being processed" => "Вашата заявка се обработва",
"cancel request and exit" => "отказване от заявката и изход",
"cancel request and leave a message" => "отказване от заявката и оставяне на съобщение",
"Return to archive" => "Връщане към архив",
"Admin cookies" => "Администрация на кукита",
"admin FortuneCookie tpl" => "администрация на FortuneCookie шаблон",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
"Cookie" => "Куки",
"Upload Cookies from textfile" => "Качване на кукита от текстов файл",
"Remove all cookies" => "Премахване на всички кукита",
"cookie" => "куки",
"Edit Rules for Repository:" => "Редакция на правилата за хранилището:",
"list repositories" => "списък хранилища",
"configure this repository" => "конфигуриране на хранилището",
"view this repository" => "разглеждане на хранилището",
"Add new rule" => "Добавяне на правило",
"new rule" => "ново правило",
"view/hide copy rules dialog" => "показване/скриване на диалога 'копиране на правила'",
"copy rules" => "копиране на правила",
"Source repository" => "Сорс хранилище",
"Copy" => "Копиране",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
"Text to search for" => "Текст за търсене",
"Text to replace" => "Текст за замяна",
"Replace" => "Замяна",
"Is this regular expression or simple search/replacer" => "Това regular expression ли е или обикновен текст за търсене/замята",
"Is case sensitive (for simple replacer)" => "Различава главни и малки букви (за обикновено заместване)",
"Case sensitive" => "Различава главни и малки букви",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
"Human readable text description of rule" => "Четимо за хора текстово описание на правило",
"Check to enable this rule" => "Отметнете за да активирате това правило",
"Enabled" => "Активен",
"Preview options" => "Предварителен преглед на опции",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
"Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
"Code preview" => "Предварителен преглед на кода",
"Generate HTML preview" => "Генериране на HTML предварителен преглед",
"HTML preview" => "HTML предварителен преглед",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
"Preview Results" => "Предварителен преглед на резултатите",
"Rules List" => "Списък с правила",
// "Case" => "Case",
"Configure/Options" => "Конфигурация/Опции",
"Any" => "Any",
"Tip: hold down CTRL to select multiple" => "Подсказка: задръжте CTRL за множествена селекция",
"Pick your avatar" => "Изберете си аватар",
"Your current avatar" => "Вашият сегашен аватар",
"no avatar" => "липсва аватар",
"reset" => "зануляване",
"Pick avatar from the library" => "Изберете си аватар от библиотеката",
"Hide all" => "Скриване на всички",
"icons" => "иконки",
"Show all" => "Показване на всички",
"Avatar Image" => "Изображение аватар",
"random" => "случаен",
"Upload your own avatar" => "Качване на собствен аватар",
"(Only .gif images, and aproximately 45px x 45px)" => "(Само .gif файлове и приблизително 45 x 45 пиксела)",
"Google Map setup" => "Настройки за Google карти",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y for map center",
// "Default zoom level" => "Default zoom level",
"whole earth" => "цялата Земя",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
"author" => "автор",
// "stars" => "stars",
"user level" => "потребителско ниво",
"private message" => "лично съобщение",
"send email to user" => "изпращане на мейл на потребител",
"user online" => "потребителят онлайн",
"user offline" => "потребителят офлайн",
"Vote" => "Гласуване",
"reply" => "отговор",
"attachment" => "прикачен файл",
// "Admin Hotwords" => "Admin Hotwords",
// "admin hotwords" => "admin hotwords",
// "admin hotwords template" => "admin hotwords template",
// "Add Hotword" => "Add Hotword",
"Word" => "Дума",
"Add" => "Добавяне",
"Tiki Shoutbox" => "Tiki мегафон",
"admin Tiki Shoutbox" => "администрация на Tiki мегафон",
"admin Tiki Shoutbox tpl" => "администрация на Tiki мегафон шаблон",
"Change shoutbox general settings" => "Редакция на генералните настройки на мегафона",
"auto-link urls" => "авто-линк URLs",
"Post or edit a message" => "Публикация или редакция на съобщение",
"Results" => "Резултати",
"Average:" => "Среден/на:",
"List Votes" => "Списък с гласове",
"add comment" => "добавяне на коментар",
"1 comment" => "1 коментар",
"Webmail Doc" => "Webmail документация",
// "Webmail Doc template" => "Webmail Doc template",
"settings" => "настройки",
"Settings" => "Настройки",
"mailbox" => "пощенска кутия",
"compose" => "композиране",
"Edit mail account" => "Редактиране на мейл акаунт",
"Add new mail account" => "Добавяне на нов мейл акаунт",
"Messages per page" => "Съобщения на страница",
"User accounts" => "Потребителски акаунти",
"account" => "акаунт",
"Activate" => "Активиране",
"View All" => "Разглеждане на всички",
"Unread" => "Непрочетени",
"Flagged" => "Важни",
// "of" => "of",
"First" => "Първи/а",
"Mark as flagged" => "Маркиране като важно",
"Mark as unflagged" => "Маркиране като маловажно",
"Mark as read" => "Маркиране като прочетено",
"Mark as unread" => "Маркиране като непрочетено",
"sender" => "подател",
"subject" => "тема",
"flagged" => "важно",
"replied" => "отговорено",
"back to mailbox" => "обратно към пощенската кутия",
// "full headers" => "full headers",
// "normal headers" => "normal headers",
"reply all" => "отговор на всички",
"forward" => "препращане",
"Create/edit contacts" => "Създаване/редактиране на контакти",
"First Name" => "Първо име",
"Last Name" => "Фамилно име",
"Nickname" => "Прякор",
"select from address book" => "избиране от адресник",
"Attachments" => "Прикачени файлове",
"Use HTML mail" => "Използване на HTML поща",
"The following addresses are not in your address book" => "Следните адреси не са във вашия адресник",
"add contacts" => "добавяне на контакти",
"Attachment 1" => "Прикачен файл 1",
"Attachment 2" => "Прикачен файл 2",
"Attachment 3" => "Прикачен файл 3",
"Create/edit questions for quiz" => "Създаване/Редакция на въпроси за тест",
"From Points" => "От точки",
"To Points" => "До точки",
"answer" => "отговор",
"Return to mailbox" => "Връщане към пощенската кутия",
"replyall" => "отговор на всички",
"List Movies" => "Списък с филми",
"Choose a movie" => "Избор на филм",
"Display" => "Показване",
"Edit Blog" => "Редактиране на блог",
"Create Blog" => "Създаване на блог",
"edit blog tpl" => "Създаване на шаблон за блогове",
"Current heading" => "Сегашно заглавие",
"There are individual permissions set for this blog" => "Има индивидуални права, настроени за този блог",
"Number of posts to show" => "Брой публикации, които да се покажат",
"Allow other user to post in this blog" => "Разрешаване на друг потребител да публикува в този блог",
"Use titles in blog posts" => "Използване на заглавия в блог публикациите",
"Allow search" => "Позволяване на търсене",
"Allow comments" => "Позволяване на коментари",
"Allow trackback pings" => "Позволяване на trackback pings",
"Show user avatar" => "Показване аватара на потребител",
"Blog heading" => "Заглавие на блог",
"Browser not supported" => "Браузърът не се поддържа",
"content" => "съдържание",
"Assign permissions to category" => "Настройване на позволения за категория",
"Admin categories" => "Администрация на категории",
"Current permissions for this category" => "Текущи позволения за тази категория",
"permission" => "позволение",
"remove from this category &amp; all its children" => "премахване от тази категория &amp; всичките и дъщерни",
"remove from this category only" => "премахване само от тази категория",
"No individual permissions global permissions apply" => "Няма индивидуални позволения: в сила са глобалните позволения",
"Assign permissions" => "Настройване на позволения",
"to group" => "на група",
"this category &amp; all its children" => "тази категория &amp; всичките и дъщерни",
"this category only" => "само тази категория",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Даването на права за <b>всички дъщерни категории</b> е препоръчително за най-добро функциониране.",
"Anti-Bot verification code" => "Анти-бот верификационен код",
"Enter the code you see above" => "Въведете кода, който виждате отгоре",
// "any" => "any",
"Sort by" => "Сортиране по",
"name (desc)" => "име (низх)",
"name (asc)" => "име (възх)",
"hits (desc)" => "посещения (низх)",
"hits (asc)" => "посещения (възх)",
"creation date (desc)" => "дата на създаване (низх)",
"creation date (asc)" => "дата на създаване (възх)",
"last updated (desc)" => "последно обновление (низх)",
"last updated (asc)" => "последно обновление (възх)",
"Added" => "Добавен/а",
"Last updated" => "Последно обновление",
"Save to notepad" => "Запазване към блок с бележки",
"Previous page" => "Предишна страница",
"Next page" => "Следваща страница",
"Categorize" => "Категоризация",
"show categories" => "показване на категории",
"hide categories" => "скриване на категории",
"Tip: hold down CTRL to select multiple categories" => "Подсказка: задръжте CTRL за да изберете много категории",
"categorize this object" => "категоризиране на обекта",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Подсказка: премахнете отметката от горната кутийка за да декатегоризирате тази страница/обект",
"No categories defined" => "Не са дефинирани категории",
// "admin admin tpl" => "admin admin tpl",
"Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Използването на тази функция НЕ СЕ ПРЕПОРЪЧВА. Моля, използвайте phpMyAdmin или mysqldump вместо това.",
"List of available backups" => "Списък с наличните резервни копия",
"restore" => "възстановяване",
"Restoring a backup" => "Възстановяване от резервно копие",
"Warning!" => "Предупреждение!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Възстановяването от резервно копие унищожава всичката стара информация в базата данни на вашето Тики. Всички ваши таблици ще бъдат заменени с информацията в резервното копие.",
"Click here to confirm restoring" => "Кликнете тук за да потвърдите възстановяването",
"Create new backup" => "Създаване на ново резервно копие",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Създаването на резервни копия може да отнеме много време. Ако процесът не бъде завършен, ще видите празен екран. Ако се случи това, трябва да повишите максималното време за изпълнение на скриптове от вашия php.ini файл",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Вашата директория за съхранение на снимки е \"{\$gal_use_dir}\", трябва да и направите резервно копие чрез FTP или SCP.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Вашата директория за файлови галерии е \"{\$fgal_use_dir}\", трябва да и направите резервно копие чрез FTP или SCP.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Ако някой от вашите форуми съхранява прикачени файлове в някоя директория, трябва да и направите резервно копие през FTP или SCP.",
"Upload a backup" => "Качване на резервно копие",
"Upload backup" => "Качване на резервно копие",
"Admin Modules" => "Администрация на модули",
"admin modules" => "администрация на модули",
"admin modules template" => "администрация на шаблони за модули",
"assign module" => "настройване на модул",
"left modules" => "леви модули",
"right modules" => "десни модули",
"edit/create" => "създаване/редакция",
"clear cache" => "изчистване на кеша",
"User Modules" => "Потребителски модули",
"Assign new module" => "Настройване на нов модул",
"Edit this assigned module:" => "Редактиране на този модул:",
"Module Name" => "Име на модул",
"left" => "ляв/о",
"right" => "десен/дясно",
// "Cache Time" => "Cache Time",
"Rows" => "Редове",
"Parameters" => "Параметри",
"Visibility" => "Видимост",
"Displayed for the eligible users with no personal assigned modules" => "Показва се на избрани потребители без персонално настроени модули",
"Displayed now for all eligible users even with personal assigned modules" => "Показва се на всички избрани потребители, дори и с персонално настроени модули",
"Displayed now, can't be unassigned" => "Показва се сега, не може да бъде премахнат (unassigned)",
"Not displayed until a user chooses it" => "Не се показва докато потребител на го избере",
// "Assigned Modules" => "Assigned Modules",
"Left Modules" => "Леви модули",
"order" => "ред",
"parameters" => "параметри",
// "x" => "x",
"Right Modules" => "Десни модули",
"Create new user module" => "Създаване на нов потребителски модул",
"Edit this user module:" => "Редактиране на този потребителски модул:",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site.",
// "Must be wiki parsed" => "Must be wiki parsed",
"create/edit" => "създаване/редакция",
"Objects that can be included" => "Обекти, които могат да бъдат включени",
"Available polls" => "Налични анкети",
"Random active poll" => "Случайна активна анкета",
"Random current poll" => "Случайна текуща анкета",
"use poll" => "използване на анкета",
"Random image from" => "Случайна снимка от",
"All galleries" => "Всички галерии",
"use gallery" => "използване на галерия",
"Dynamic content blocks" => "Блокери на динамично съдържание",
"use dynamic  content" => "използване на динамично съдържание",
"use rss module" => "използване на RSS модул",
"use menu" => "използване на меню",
"use phplayermenu" => "използване на phplayermenu",
"Banner zones" => "Банер зони",
"use banner zone" => "потребителска банер зона",
"Quicktags" => "Бързи етикети",
"bold" => "получер",
"italic" => "курсив",
"underline" => "подчертан",
"table new" => "нова таблица",
"external link" => "външна връзка",
"wiki link'" => "уики линк'",
"heading1" => "заглавие1",
"title bar" => "заглавен блок",
"box" => "кутия",
"rss feed" => "RSS емисия",
"dynamic content" => "динамично съдържание",
// "tagline" => "tagline",
"center text" => "центриране на текст",
"colored text" => "оцветен текст",
"dynamic variable" => "динамична променлива",
// "New wms Metadata" => "New wms Metadata",
"New Class" => "Нов клас",
"New Projection" => "Нов проект",
"New Query" => "Нов въпросник",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
"New Label" => "Нов етикет",
// "New Reference" => "New Reference",
"New Legend" => "Нова легенда",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
"New Mapfile" => "Нов файл карта",
"special chars" => "специални символи",
"special characters" => "специални символи",
"admin quicktags" => "администрация на бързи етикети",
"Move module up" => "Преместване модула нагоре",
"Move module down" => "Преместване модула надолу",
"Hide module contents" => "Скриване на съдържанието на модула",
"Move module to opposite side" => "Преместване на модула от другата страна",
"opp side" => "отсрещна страна",
"Unassign this module" => "Премахване на този модул",
"Are you sure you want to unassign this module?" => "Сигурни ли сте, че искате да премахнете този модул?",
"Remove page" => "Премахване на страница",
"You are about to remove the page" => "Вие сте на път да премахнете страницата",
"permanently" => "перманентно",
"Remove all versions of this page" => "Премахване на всички версии на тази страница",
"big grin" => "голяма и нагла усмивка",
"confused" => "объркан",
"cry" => "плач",
"eek" => "ох!",
"evil" => "зъл",
"exclaim" => "възклицание",
"frown" => "намръщване",
"idea" => "идея",
"lol" => "смях!",
"mad" => "луд",
"mr green" => "г-н зелен",
"neutral" => "неутрален",
"razz" => "изплезване",
"redface" => "почервеняване",
// "rolleyes" => "rolleyes",
"sad" => "тъга",
"smile" => "усмивка",
"surprised" => "изненада",
// "twisted" => "twisted",
"wink" => "намигване",
"arrow" => "стрелка",
"santa" => "дядо коледа",
"Admin Shoutbox Words" => "Администрация на думите в мегафона",
"admin shoutbox words template" => "администрация на шаблоните думи в мегафона",
"Add Banned Word" => "Добавяне на забранена дума",
"Are you sure you want to delete this word?" => "Сигурни ли сте, че искате да изтриете тази дума?",
"New user registration" => "Регистрация на нов потребител",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Картата - {\$mail_page} - е била променена от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Можете да видите обновената карта като отидете на този адрес:",
"You can edit the map following this link:" => "Можете да редактирате картата на този адрес:",
"If you don't want to receive these notifications follow this link:" => "Ако не искате да получавате тези известия, отидете на този адрес:",
"You sent a request with the subject:" => "Изпратихте зявка с тема:",
"Use the subject to indicate the operation to apply:" => "Използвайте темата за да посочите операцията, която да потвърдите:",
"GET:WikiName to get a wiki page" => "GET:УикиИме за да вземете уики страница",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
"Thank you for you registration. You may log in now." => "Благодарим ви за регистрацията. Сега можете да влезете в системата.",
"Tracker was modified at" => "Тракърът е бил модифициран: ",
"Tiki User Registration Request" => "Заявка за регистрация на потребител",
"Hi" => "Здрасти",
"has requested an account on" => "е помолил за нов акаунт на",
"To validate that account, please follow the link:" => "За да валидирате този акаунт, моля последвайте тази връзка:",
"best regards" => "най-добри пожелания",
"your Tikiwiki" => "вашето Tikiwiki",
// "Your Tiki information registration" => "Your Tiki information registration",
"New blog post at %s" => "Нова блог публикация на %s",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Вашата молба за акаунт бе съхранена успешно и ще бъде разгледана от администратор в най-скоро време",
"Wiki page renamed" => "Уики страницата бе преименувана",
"Old name" => "Старо име",
"Welcome to %s at %s" => "Добре дошли в %s на %s",
"A new message was posted to forum" => "Ново съобщение бе публикувано във форум",
"New topic:" => "Нова тема:",
"Topic:" => "Тема:",
"You can unsubscribe from this newsletter following this link" => "Можете да прекратите абонамента си от тази новинарска емисия като отидете на следния адрес",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Нова блог публикация: {\$mail_title}, \"{\$mail_post_title}\", от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Разгледайте блога на:",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
"New article post at %s" => "Нова статия публикувана на %s",
"You're invited to join my network of friends!" => "Каня ви да се присъедините към моята мрежа от приятели!",
"Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Вашата молба за Тики акаунт {\$mail_site} бе валидирана от администратор и вашият акаунт вече е активен.",
"To login with your username and password, please follow this link:" => "За да влезете с вашето потребителско име и парола, посетете този адрес:",
"Enjoy the site!" => "Надяваме се, че сайтът ще ви хареса!",
"You will receive an email with information to login for the first time into this site" => "Ще получите и-мейл с информация как да влезете за първи път в този сайт.",
"Welcome to our newsletter!" => "Добре дошли в нашата новинарска емисия!",
"This email address has been added to the list of subscriptors of:" => "Този и-мейл бе добавен към списъка с абонати на:",
"Newsletter:" => "Новинарска емисия:",
"You can always cancel your subscription using:" => "Винаги можете да прекратите абонамента си чрез:",
"Your Tiki account information for %s" => "Информация за вашия Тики акаунт %s",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Страницата - {\$mail_page} - бе коментирана от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:" => "Можете да разгледате страницата като посетите този адрес:",
"Title:" => "Заглавие:",
"Comment:" => "Коментар:",
"Go to your friendship network to accept or refuse this request" => "Отидете на страницата за вашата мрежа от приятели за да приемете или откажете тази покана",
"A new file have been attached to page" => "Нов файл е бил прикачен към страница:",
"File name" => "Име на файла",
"View the tracker item at:" => "Вижте елемента от тракъра на:",
// "New attachment on %s, page" => "New attachment on %s, page",
"A new file was posted to file gallery" => "Нов файл е бил публикуван във файлова галерия",
"Posted by" => "Публикуван от",
"File Name" => "Име на файла",
"Image Gallery {\$galleryName} changed" => "Картинна галерия {\$galleryName} бе променена",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Нова статия бе предложена за публикуване от {\$mail_user} в {\$mail_site} на {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Можете да редактирате предложената статия като проследите тази връзка:",
"Heading:" => "Заглавие:",
"Body:" => "Тяло:",
"you or someone registered this email address at" => "Вие или някой друг е регистрирал този и-мейл адрес на",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Ако желаете да бъдете регистриран потребител в този сайт, вие ще трябва да използвате този линк за да се лог-нете за пръв път:",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
"Page not found:" => "Страницата не бе открита:",
"Someone coming from IP Address" => "Някой от следния IP адрес:",
"requested a reminder of the password for your account" => "е пожелал напомняне на паролата за вашия акаунт",
"requested password reset for your account" => "е пожелал генериране на нова парола за вашия акаунт",
"Since this is your registered email address we inform that the password for this account is" => "И тъй като вие сте регистрирали този и-мейл адрес, ние ви информираме на него, че паролата за този акаунт е",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Моля, кликнете на следния линк за да потвърдите, че искате да ви бъде генерирана нова парола и отидете на страницата, където ще трябва да въведете нова \"перманентна\" парола. Моля, изберете парола, която само вие ще знаете и не я казвайте на никой друг.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n Готово, би трябвало вече да сте вътре в системата.",
"Important: The old password remains active if you don't click the link above." => "Важно: старата парола остава активна ако не кликнете на връзката отгоре.",
"Tiki email notification" => "Tiki известяване по и-мейл",
"File Gallery %s changed" => "Файлова галерия %s бе променена",
"New article submitted at %s" => "Нова статия предложена за публикация в %s",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Страницата - {\$mail_page} - е създадена от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Страницата - {\$mail_page} - е била променена от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"You can view a diff back to the previous version by following this link:" => "Вие можете да видите разликите с предишната версия като проследите този линк:",
"The changes in this version follow below, followed after by the current full page text." => "Промените в тази версия следват от тук надолу, след това е целия сегашен текст на страницата.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Редове: {\$oldd} са били променени на +Lignes: {\$newd}",
"The new page content follows below." => "Съдържанието на страницата следва надолу:",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Нова статия публикувана: {\$mail_title} от {\$mail_user} на {\$mail_date|tiki_short_datetime}",
"View the article at:" => "Вижте статията на адрес:",
"Somebody or you tried to subscribe this email address at our site:" => "Някой (вероятно вие) се опита да абонира този и-мейл адрес на нашия сайт:",
"To the newsletter:" => "За новинарска емисия:",
"In order to confirm your subscription you must access the following URL:" => "За да потвърдите абонамента си, трябва да посетите следния адрес:",
"The user" => "Потребителят",
"registered at your site" => "се регистрира на вашия сайт",
"Bye bye!" => "Довиждане!",
"This email address has been removed to the list of subscriptors of:" => "Този и-мейл адрес бе премахнат от списъка с абонати на:",
"Hi {\$mail_user} has sent you this link:" => "Здравейте, {\$mail_user} ви е изпратил този линк:",
"Blog post:" => "Блог публикация:",
"at:" => "на:",
"Bye bye from %s at %s" => "Довиждане от %s на %s",
"Hi," => "Здравейте,",
"A new message was posted to you at {\$mail_machine}" => "Ново съобщение бе изпратено до вас на {\$mail_machine}",
"New message arrived from %s" => "Ново съобщение пристигна от %s",
"Wiki page %s changed" => "Wiki страница %s бе променена",
"A file was removed from the file gallery" => "Файл бе премахнат от тази файлова галерия",
"Removed by" => "Премахнат от",
"Tiki User Account Activated" => "Тики потребителски акаунт бе активиран",
"A new file was posted to image gallery" => "Нов файл бе публикуван във файлова галерия",
"My activities" => "Моите дейности",
"Current Activity" => "Настояща дейност",
"Assigned To" => "Назначена на",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "send instance" => "send instance",
// "run instance" => "run instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
"No activities found" => "Не са открити дейности",
"Go back" => "Назад",
"Return to home page" => "Връщане към заглавната страница",
"Compose message" => "Композиране на съобщение",
"Compose Message" => "Композиране на съобщение",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Ако желаете хората да могат да ви отговарят, трябва да закоментирате <a href='tiki-user_preferences.php'>Позволяване на съобщения от други потребители</a>",
"Internationalization" => "Интернационализация",
"I18n setup" => "I18n настройки",
"Multilingual" => "Многоезичен",
// "Best Language" => "Best Language",
"Detect browser language" => "Засичане езика на браузъра",
"Reg users can change language" => "Регистрираните потребители могат да си променят езика",
"Restrict available languages" => "Лимитиране на позволените езици",
"Available languages:" => "Налични езици:",
"Use database for translation" => "Използване на базата данни за превода",
"Record untranslated" => "Запис на непреведените",
"Show Babelfish Translation URLs" => "Показване на Babelfish адреси за превод",
"Show Babelfish Translation Logo" => "Показване на логото на Babelfish",
"unlock" => "отключване",
"lock" => "заключване",
"history" => "история",
"similar" => "подобен/ни",
// "undo" => "undo",
"slides" => "слайдове",
"discuss" => "дискусия",
"wiki help" => "Уики помощ",
"attach file" => "прикачване на файл",
"1 file attached" => "1 прикачен файл",
"{\$atts_cnt} files attached" => "{\$atts_cnt} прикачени файла",
"translation" => "превод",
"Edit question options" => "Редакция на опциите за отговор",
"Create/edit options for question" => "Създаване/редакция на опции за отговор",
// "Admin charts" => "Admin charts",
// "admin charts template" => "admin charts template",
// "Add or edit a chart" => "Add or edit a chart",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Users can suggest new items" => "Users can suggest new items",
"Auto validate user suggestions" => "Авто валидация на потребителските предложения",
// "Ranking shows" => "Ranking shows",
// "All items" => "All items",
// "Top 10 items" => "Top 10 items",
// "Top 20 items" => "Top 20 items",
// "Top 40 items" => "Top 40 items",
// "Top 50 items" => "Top 50 items",
// "Top 100 items" => "Top 100 items",
// "Top 250 items" => "Top 250 items",
"Voting system" => "Система за гласуване",
"Vote items" => "Елементи за гласуване",
"Rank 1..5" => "Ранг 1..5",
"Rank 1..10" => "Ранг 1..10",
// "Ranking frequency" => "Ranking frequency",
"Realtime" => "Реално време",
"Each 5 minutes" => "Всеки 5 минути",
"Daily" => "Всекидневно",
"Weekly" => "Ежеседмично",
"Monthly" => "Ежемесечно",
// "Show Average" => "Show Average",
"Show Votes" => "Показване на гласове",
"Use Cookies for unregistered users" => "Използване на бисквитки за нерегистрирани потребители",
"Users can vote again after" => "Потребителите могат да гласуват пак след",
"Anytime" => "По всяко време",
"1 day" => "1 на ден",
"1 week" => "1 на седмица",
"1 month" => "1 месечно",
"Ranks" => "Ранглисти",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "За да добавите/премахнете картинни галерии, отидете на \"Картинни галерии\" в менюто на приложението, или",
"You can upload images of a size of " => "Вие можете да качвате снимки, не по-големи от ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Променете php.ini променливите file_uploads, upload_max_filesize, post_max_size и променливите на базата данни (max_allowed_packet за mysql) за да промените този размер.",
"Home Gallery" => "Начална галерия",
"Home Gallery (main gallery)" => "Начална галерия (главна галерия)",
"Galleries features" => "Функции на галериите",
"Uses Slideshow" => "Използва слайдшоу",
"Use database to store images" => "Използване на базата данни за съхранение на изображения",
"Use a directory to store images" => "Използване на директория за съхранение на изображения",
"Directory path" => "Път на директорията",
"Library to use for processing images" => "Библиотека за обработка на изображения",
"Uploaded image names must match regex" => "Имената на качените снимки трябва да съвпадат с regex",
"Uploaded image names cannot match regex" => "Имената на качените снимки не трябва да съвпадат с regex",
"Directory Batch Loading" => "Директории за качване на партиди",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Ако активирате 'Директории за качване на партиди', трябва да настроите web-четима директория (извън вашето уеб-дърво е по-добре). Тогава настройте начин за качване на изображения в тази директория - чрез ftp или други протоколи",
"Enable directory batch loading" => "Активиране на директории за качване на партиди",
"Batch loading directory" => "Директория за качване на партиди",
"Enable cache images to all galleries" => "Позволяване на кеширане на изображения за всички галерии",
"Images cache directory" => "Директория за кеширане на изображения",
"Exterminator" => "Екстерминатор",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Премахване на изображения от системната директория, които не се използват в Уики страници, статии или блог публикации",
// "Mover" => "Mover",
"Move images from database storage to filesystem storage" => "Преместване на изображения от съхранение в базата данни към съхранение във файловата система",
"Move images from filesystem storage to database storage" => "Преместване на изображения от файловата система, към съхранение във базата данни",
"Move" => "Преместване",
"Move images from old filesystem store to new directory" => "Преместване на изображения от старо хранилище във файловата система, към нова директория",
"Moved" => "Преместен/и",
"Gallery listing configuration" => "Конфигуриране на показването на списъка с галерии",
"Last modified" => "Последна редакция",
"Change configuration" => "Промяна на конфигурация",
"Image galleries comments settings" => "Настройки за коментарите на файловите галерии",
"Upload Image" => "Качване на изображение",
"Image Gallery tpl" => "Шаблон за картинна галерия",
"Directory batch" => "Директория партида",
"or use filename" => "или използване на файловото име",
"Image Description" => "Описание на изображението",
"Now enter the image URL" => "Сега въведете адреса на изображението",
" or upload a local image from your disk" => " или качете локално изображение от вашия диск",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Малка картинка (незадължително, отменя автоматичното генериране на малки картинки)",
"Note: Maximum image size is limited to" => "Забележка: Максималният размер на изображенията е ограничен до",
"Upload successful!" => "Качването бе успешно!",
"The following image was successfully uploaded" => "Следното изображение бе успешно качено",
"Image ID" => "Номер на изображение",
"Thumbnail" => "Малка картинка",
// "Image ID thumb" => "Image ID thumb",
"You can include the image in an Wiki page using" => "Можете да включите изображението в Уики страница, използвайки този синтаксис:",
"Batch Upload Results" => "Резултат от качването на партидата",
"Tracker item:" => "Елемент от тракъра:",
"Edit fields" => "Редакция на полета",
"back" => "назад",
"Previous" => "Предишен/на",
"View item" => "Разглеждане на елемент",
"Filter Tracker Items" => "Филтриране на елементи от тракъра",
"Number of voices" => "Брой гласове",
"Average" => "Средно",
"Add a comment" => "Добавяне на коментар",
"Attach a file to this item" => "Прикачване на файл към този елемент",
"attach" => "прикачване",
"more info" => "повече информация",
"download" => "сваляне",
"No attachments for this item" => "Няма прикачени файлове към този елемент",
"Edit item" => "Редакция на елемент",
"Insert new item" => "Вмъкване на нов елемент",
"remove image" => "премахване на изображение",
"Special Operations" => "Специални операции",
"fields marked with a * are mandatory" => "Полетата, маркирани с * са задължителни",
"Close Window" => "Затваряне на прозорец",
"Change user preferences" => "Промяна на потребителски предпочитания",
"Homepage" => "Лична страница",
// "Users HomePage" => "Users HomePage",
"Personal Wiki Page" => "Лична страница в уикито",
"Create page" => "Създаване на страница",
"Displayed time zone" => "Часова зона",
"This user is your friend" => "Потребителят е ваш приятел",
"Request friendship from this user" => "Станете приятели с този потребител",
"Send me a message" => "Изпратете ми съобщение",
// "Score System" => "Score System",
// "Reading article from" => "Reading article from",
"Back to servers" => "Обратно към сървъри",
"Back to groups" => "Обратно към групи",
"Back to list of articles" => "Обратно към списък със статии",
"My instances" => "My instances",
// "No instances found" => "No instances found",
"edit new submission" => "редакция на новите предложения",
"PublishDate" => "Дата на публикация",
"Approve" => "Одобрение",
"friends tpl" => "шаблон приятели",
"Pending requests" => "Изчакващи заявки",
"Request Time" => "Време на заявление",
"accept" => "приемане",
"refuse" => "отказ",
"Waiting requests" => "Чакащи заявки",
"Your friends" => "Вашите приятели",
"break friendship" => "разваляне на приятелство",
"User Preferences" => "Потребителски настройки",
"UserPreferences tpl" => "шаблон Потребителски настройки",
"Assign Group" => "Назначаване на група",
"Personal Information" => "Лична информация",
"General preferences" => "Генерални предпочитания",
"Other preferences" => "Други предпочитания",
"flag" => "знаме",
"use google map locator" => "използване на google map locator",
"Pick user Avatar" => "Изберете потребителски аватар",
"Your personal Wiki Page" => "Вашата лична страница в Wiki",
"Your personal tracker information" => "Вашата лична информация в тракъра",
"View extra information" => "Разглеждане на допълнителна информация",
"Change information" => "Промяна на информация",
"Is email public? (uses scrambling to prevent spam)" => "Публично видим ли е и-мейл адреса? (Използва антиспам синтаксис)",
"Unavailable - please set your e-mail below" => "Не е наличен - моля, настройте си и-мейл адрес отдолу",
"Does your mail reader need a special charset" => "Вашият и-мейл четец нуждае ли се от специална кодировка?",
"Number of visited pages to remember" => "Брой на посетените страници, които да запомни системата",
"User information" => "Потребителска информация",
"public" => "публична",
"Use double-click to edit pages" => "Използване на двоен клик за редакция на страници",
"Show user's info on mouseover" => "Показване на потребителска информация при посочване с мишката",
"Account Information" => "Информация за акаунт",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Оставете полетата \"Нова парола\" и \"Потвърждение на парола\" празни за да запазите сегашната си парола",
"Email address" => "И-мейл адрес",
"Confirm new password" => "Потвърждение на парола",
"Current password (required)" => "Сегашна парола (задължително поле)",
"Change administrative info" => "Промяна на информацията за акаунта",
"Allow messages from other users" => "Позволяване на съобщения от други потребители",
"Note author when reading his mail" => "Известяване на автора, когато четете неговото писмо",
"Send me an email for messages with priority equal or greater than" => "Изпращане на и-мейл за съобщения с приоритет равен или по-голям от",
// "none" => "none",
"Auto-archive read messages after x days" => "Авто-архивиране на прочетените съобщения след x дни",
"My Tiki" => "Моето Tiki",
"My pages" => "Моите страници",
"My messages" => "Моите съобщения",
"My tasks" => "Моите задачи",
"My items" => "Моите неща",
"My workflow" => "Моят работен процес",
"EMail notifications" => "Известяване по и-мейл",
"admin Email Notifications" => "администрация на нотификациите по и-мейл",
"admin notifications template" => "администрация на шаблон за известяване по и-мейл",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Трябва да настроите <a href=\"tiki-admin.php?page=general\">Подателски адрес</a>",
"Add notification" => "Добавяне на известяване",
"A user registers" => "Потребител се регистрира",
"A user submits an article" => "Потребител предлага статия",
"Any wiki page is changed" => "Някоя страница в уикито е променена",
"Any wiki page is changed, even minor changes" => "Някоя страница в уикито е променена, дори и минорни промени",
"PHP error" => "PHP грешка",
"use admin email" => "използване на админски и-мейл",
"event" => "събитие",
"object" => "обект",
"No records found." => "не са открити записи.",
"Cached" => "Кеширан/и",
"This is a cached version of the page." => "Това е кеширана версия на страницата.",
"Click here to view the Google cache of the page instead." => "Кликнете тук за да видите Гугъл кеша на страницата вместо това.",
"Admin Menus" => "Администрация на менюта",
// "admin menu builder" => "admin menu builder",
"admin menus template" => "шаблони админски менюта",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
"This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "това ще работи добре (или не!) в зависимост от вашата тема. За да научите повече за <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">теми</a>",
"Edit this Menu:" => "Редакция на менюто:",
"Create new Menu" => "Създаване на ново меню",
"dynamic collapsed" => "динамично, минимизирано",
"dynamic extended" => "динамично, разтворено",
"fixed" => "фиксирано",
"games tpl" => "шаблони игри",
"All games are from" => "Всички игри са от",
"visit the site for more games and fun" => "Посетете сайта за повече игри и веселба",
"Upload a game" => "Качване на игра",
"Upload a new game" => "Качване на нова игра",
"Flash binary (.swf or .dcr)" => "Бинарен Flash файл (.swf or .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Малка картинка (ако играта е foo.swf, картинката трябва да се казва foo.swf.gif или foo.swf.png или foo.swf.jpg)",
"Edit game" => "Редакция на игра",
"Played" => "Играна",
"If you can't see the game then you need a flash plugin for your browser" => "Ако не можете да видите играта, тогава вие се нуждаете от Flash плъгин за вашия браузър",
"Syntax" => "Синтаксис",
"Watchlist" => "Списък за наблюдение",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "features matched" => "features matched",
"Sent Messages" => "Изпратени съобщения",
"Replied" => "Отговорено",
"Not replied" => "Не е отговорено",
"Containing" => "Съдържащи",
"move to archive" => "преместване в архива",
"receiver" => "получател",
"replies" => "отговори",
"No messages to display" => "Няма съобщения за показване",
"Galaxia Monitor Processes" => "Galaxia Монитор на процеси",
"Galaxia Monitor Processes tpl" => "Galaxia монитор на процеси шабл",
"Valid" => "Валиден",
"Invalid" => "Невалиден",
"Activities" => "Действия",
"admin live support tpl" => "администрация на шаблон за помощ на живо",
"Open client window" => "Отваряне на клиентски прозорец",
"Generate HTML" => "Генериране на HTML",
// "Transcripts" => "Transcripts",
// "Support tickets" => "Support tickets",
"Online operators" => "Онлайн оператори",
"stats" => "статистика",
"Accepted requests" => "Приети заявки",
// "transcripts" => "transcripts",
"Offline operators" => "Офлайн оператори",
"Add an operator to the system" => "Добавяне на оператор към системата",
"Operators must be tiki users" => "Операторите трябва да бъдат Tiki потребители",
"set as operator" => "даване на операторски права",
"Users Map" => "Карта на потребителите",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
"Properties" => "Характеристики",
"Property" => "Характеристика",
"Value" => "Стойност",
"backlinks to" => "обратни връзки към",
"Last edited by" => "Последно редактиран/а от",
// "based on work by" => "based on work by",
"Page last modified on" => "Страницата последно модифицирана на",
// "Contributors to this page" => "Contributors to this page",
"Created by" => "Създаден/а от",
"last modification" => "последна модификация",
"Use this thread to discuss the page:" => "Използвайте тази тема за да дискутирате страницата:",
// "atts" => "atts",
"List Attachments" => "Списък с прикачените файлове",
"Message Archive" => "Архив съобщения",
"Archive is full!" => "Архивът е пълен!",
"Unflagged" => "Маловажни",
"admin structures template" => "шаблон администраторски структури",
"Structure ID" => "Номер на структура",
"export pages" => "експорт на страници",
// "dump tree" => "dump tree",
"create webhelp" => "създаване на уеб-помощ",
"view webhelp" => "разглеждане на уеб-помощ",
"Destroy the structure leaving the wiki pages" => "Разрушаване на структурата, оставяйки уики страниците",
"Destroy the structure and remove the pages" => "Разрушаване на структурата и изтриване на страниците",
"Create new structure" => "Създаване на нова структура",
"Use single spaces to indent structure levels" => "Използвайте по един интервал за да indent-нете нивата на структурата",
"tree" => "дърво",
"create new structure" => "създаване на нова структура",
"Stats for quiz" => "Статистика за тестове",
"clear stats" => "изчистване на статистики",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
"Stats for this quiz Questions " => "Статистики за въпросите от тестовете",
"Admin Quicktags" => "Администрация на бързите етикети (quicktags)",
"admin QuickTags" => "администрация на quicktags",
// "tiki admin quicktags template" => "tiki admin quicktags template",
"Create/Edit QuickTags" => "Създаване/Редакция на quicktags",
"label" => "етикет",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
"Path to the tag icon" => "Път до таг иконата",
"Label" => "Етикет",
"Insert" => "Вмъкване",
"Icon" => "Иконка",
// "on:" => "on:",
// "reads" => "reads",
"Article image" => "Изображение на статията",
"Topic image" => "Изображение на темата",
"Admin quizzes" => "Администрация на тестове",
"admin quizzes tpl" => "Администрация на шаблони тестове",
"Create/edit quizzes" => "Създаване/редакция на тестове",
"There are individual permissions set for this quiz" => "Има зададени индивидуални позволения за този тест",
"Expiration Date" => "Дата на изтичане (на срока)",
"Quiz can be repeated" => "Тестът може да бъде повтарян",
"Store quiz results" => "Съхраняване на резултата от теста",
"Immediate feedback" => "Моментални резултати",
"Show correct answers" => "Показване на верните отговори",
"Shuffle questions" => "Разбъркване на въпросите",
"Shuffle answers" => "Разбъркване на отговорите",
"Questions per page" => "Въпроси на страница",
"Quiz is time limited" => "Тестът има лимит за време",
"Maximum time" => "Максимално време",
// "Passing Percentage" => "Passing Percentage",
// "canRepeat" => "canRepeat",
// "timeLimit" => "timeLimit",
"results" => "резултати",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "Watches" => "Watches",
"A user submits a blog post" => "Потребител предложи нова публикация в блог",
// "A user posts a forum thread" => "A user posts a forum thread",
"A user posts a forum topic" => "Потребител добави нова тема във форума",
"A user edited a wiki page" => "Потребител редактира уики страница",
"Favorites" => "Любими",
"User List" => "Списък с потребители",
"Homework" => "Домашна работа",
"Assignments" => "Задачи",
"Last Changes" => "Последни промени",
"Click" => "Кликнете",
"page id" => "номер на страница",
"cached" => "кеширан/а",
"backlinks" => "обратни връзки",
"3d browser" => "3д браузър",
"create pdf" => "създаване на pdf",
"monitor this page" => "наблюдаване на тази страница",
"stop monitoring this page" => "спиране на наблюдението на тази страница",
"attachments" => "прикачени файлове",
"Page generated in" => "Страницата бе генерирана за",
"User Pages" => "Потребителски страници",
"List pages where I am a creator" => "Списък със страници на които аз съм създател",
"by creator" => "от създател",
"List pages where I am a modificator" => "Списък със страници които съм модифицирал",
"by modificator" => "от редактор",
"User Galleries" => "Потребителски галерии",
// "Assigned items" => "Assigned items",
// "at tracker" => "at tracker",
"Unread Messages" => "Непрочетени съобщения",
"User Blogs" => "Потребителски блогове",
"Create this page" => "Създаване на тази страница",
"To edit the copyright notices" => "За да редактирате съобщението за авторски права",
"The content on this page is licensed under the terms of the" => "Съдържанието на тази страница е лицензирано по силата на",
"The newsletter was sent to {\$sent} email addresses" => "Тази новина бе разпратена на {\$sent} електронни адреса",
"This newsletter will be sent to {\$subscribers} email addresses." => "Тази новина ще бъде разпратена на {\$subscribers} електронни адреса.",
"cancel" => "отказ",
"Prepare a newsletter to be sent" => "Подготовка на новината за разпращане",
// "Apply template" => "Apply template",
"Send Newsletters" => "Изпращане на новини",
// "Sent editions" => "Sent editions",
"sent" => "изпратени",
"Are you sure you want to remove this module?" => "Сигурни ли сте, че искате да премахнете този модул?",
"Parent page" => "Родителска страница",
"Child" => "Дъщерна",
"Add Page" => "Добавяне на страница",
"home" => "начало",
"chat" => "чат",
"contact us" => "свържете се с нас",
"last changes" => "последни промени",
// "dump" => "dump",
"rankings" => "класации",
"list pages" => "списък със страници",
"orphan pages" => "страници сирачета",
"sandbox" => "пясъчна кутия",
"received pages" => "получени страници",
"Articles Home" => "Статии - Начало",
"Create/Edit Blog" => "Създаване/Редакция на блог",
"Browse Directory" => "Разгледжане на директория",
"List Quizzes" => "Списък с тестове",
"List Trackers" => "Списък с тракъри",
"List Surveys" => "Списък с проучвания",
"This is" => "Това е",
"by the" => "създадено от",
"Tiki community" => "общество Tiki",
"uploaded" => "качен/и",
// "dls" => "dls",
"No attachments for this page" => "Не са открити прикачени файлове за тази страница",
"This page is being edited by" => "Тази страница се редактира от",
"Proceed at your own peril" => "Продължавате на собствен риск",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Пясъчната кутия е място къдто можете да тренирате уменията си за писане на текст. Можете да използвате функцията за предварителен преглед, за да видите как ще изглежда страницата. Нищо не се запазва на сайта.",
// "My Footnotes" => "My Footnotes",
// "Edit Summary" => "Edit Summary",
"Year:" => "Година:",
"Authors:" => "Автори:",
"Allow HTML" => "Позволяване на HTML",
"Import page" => "Импорт на страница",
"export all versions" => "експорт на всички версии",
"Upload picture" => "Качване на изображение",
// "no cache" => "no cache",
"hour" => "час",
"License" => "Лиценз",
"Minor" => "Минорна модификация",
"cancel edit" => "отмяна на редакция",
"There are no wiki pages similar to '{\$page}'" => "Няма уики страници, подобни на '{\$page}'",
"Click here to create it" => "Кликнете тук за да я създадете",
"Translate in" => "Превод на",
// "babelfish it" => "babelfish it",
"Member list" => "Списък с членове",
"back to homepage" => "обратно към началната страница",
"logout" => "изход от системата",
"MyFiles" => "Моите файлове",
"Welcome to" => "Добре дошли на/в",
"RSS Blogs" => "RSS блогове",
"RSS Image Galleries" => "RSS картинни галерии",
"RSS File Galleries" => "RSS файлови галерии",
"RSS Maps" => "RSS карти",
"RSS Directories" => "RSS Директории",
"RSS Trackers" => "RSS тракъри",
// "debugger console" => "debugger console",
"Edit mapfiles" => "Редакция на картови файлове",
"switch" => "превключване",
"left/right" => "ляво/дясно",
"Unassign module" => "Отмяна на модул",
"Location : " => "Позиция: ",
"Find:" => "Намиране:",
"Sort posts by:" => "Сортиране на публикации по:",
"read more" => "четене на повече",
"Refresh" => "Обновяване",
// "Trackback pings" => "Trackback pings",
"Blog name" => "Име на блог",
"User Calendar" => "Потребителски календар",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
"List" => "Списък",
"topic image" => "изображение на темата",
"Remove old events" => "Премахване на старите събития",
"duration" => "времетраене",
"topic" => "тема",
"Add or edit event" => "Добавяне или редакция на събитие",
"Duration" => "Времетраене",
"Orphan Pages" => "Страници сирачета",
// "User Bookmarks tpl" => "User Bookmarks tpl",
"Current folder" => "Сегашна папка",
"Folders" => "Папки",
// "Folder in" => "Folder in",
"remove folder" => "премахване на папка",
"refresh cache" => "обновяване на кеш",
"Admin folders and bookmarks" => "Администрация на папките и отметките",
"Add or edit folder" => "Добавяне или редакция на папка",
"Add or edit a URL" => "Добавяне или редакция на URL",
"RSS Calendars" => "RSS Календари",
"Admin external wikis" => "Администрация на външни уикита",
"admin External Wikis" => "администраця на външни уикита",
// "tiki admin external wikis template" => "tiki admin external wikis template",
"Create/Edit External Wiki" => "Създаване/Редакция на външно уики",
// "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
"extwiki" => "външноУики",
"Perhaps you were looking for:" => "Може би търсехте:",
"(page will be orphaned)" => "(страницата ще остане сираче)",
"system logs" => "системни логове",
"system logs tpl" => "системни логове шабл",
"Send a message to us" => "Изпратете ни съобщение",
"Contact us by email" => "Свържете се с нас по и-мейл",
"click here to send us an email" => "кликнете тук за да ни изпратите и-мейл",
"Edit Article" => "Редакция на статия",
"edit article tpl" => "редацния на статия шабл",
"list articles" => "списък статии",
"view articles" => "разглеждане на статии",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
"Author Name" => "Име на автор",
"Own Image" => "Собствено изображение",
"Use own image" => "Използване на собствено изображение",
// "Float text around image" => "Float text around image",
"Own image size x" => "Собствен размер на изображението - х",
"Own image size y" => "Собствен размер на изображението - у",
// "Image caption" => "Image caption",
"Heading" => "Заглавие",
"Body" => "Тяло",
"Use ...page... to separate pages in a multi-page article" => "Използвайте ...page... за да разделите на отделни страници някоя много дълга статия",
"Wiki attachments preferences" => "Предпочитания за прикачените файлове в уикито",
"Use database to store files" => "Използване на базата данни за съхранение на файлове",
"Use a directory to store files" => "Използване на директория за съхранение на файлове",
"Path" => "Път",
// "Storage" => "Storage",
"Change all to db" => "Промяна на всички към базата данни",
"Change all to file" => "Промяна на всички към файл",
"List Articles" => "Списък статии",
"list articles tpl" => "списък статии шабл",
"edit new article" => "редакция на нова статия",
"ExpireDate" => "Краен срок",
"AuthorName" => "Име на Автор",
"No notes yet" => "Все още няма бележки",
"merge selected notes into" => "съединяване на избраните бележки в",
"admin" => "администрация",
"browse" => "разглеждане",
"new sites" => "нови сайтове",
"cool sites" => "любими сайтове",
"add a site" => "добавяне на сайт",
"add a category" => "добавяне на категория",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
"Elapsed time" => "Изминало време",
"You can see users rank by score in the module users_rank, for that go to" => "Можете да видите потребителския ранг по резултат в модула users_rank, за тази цел отидете на",
"Admin modules" => "Администрация на модули",
"Clear cached version and refresh cache" => "Изчистване на кешираните версии и обновяване на кеша",
"configure rules" => "конфигурация на правила",
"edit repository" => "редакция на хранилище",
// "Browsing Gallery" => "Browsing Gallery",
"edit gallery" => "редакция на галерия",
"rebuild thumbnails" => "генериране на нови малки картинки",
"upload image" => "качване на изображение",
"browse gallery" => "разглеждане на галерията",
// "Gallery Images" => "Gallery Images",
"Filesize" => "Размер на файл",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "any category" => "any category",
"Display modules to all groups always" => "Винаги показва модулите на всички групи",
"Hide anonymous-only modules from registered users" => "Скриване на 'само за анонимни' модулите от регистрираните потребители",
// "Package Config" => "Package Config",
"list galleries" => "списък с галерии",
"list gallery" => "списък в галерия",
"monitor this gallery" => "наблюдение на тази гелерия",
"stop monitoring this gallery" => "спиране на наблюдението на тази галерия",
"Sort Images by" => "Сортиране на снимките по:",
"subgallery" => "подгалерия",
"Subgallery" => "Подгалерия",
"hit" => "посещение",
"rotate right" => "завъртане на дясно",
"rotate" => "завъртане",
"Configure news servers" => "Конфигуриране на новинарски сървъри",
"Configure Newsreader" => "Конфигуриране на четец на новини",
"configure newsreader server tpl" => "шаблон за конфигуриране на четеца на новини",
"Select a news server to browse" => "Избиране на новинарски сървър за четене",
"server" => "сървър",
"Read the news" => "Четене на новините",
"Add or edit a news server" => "Добавяне/редактиране на новинарски сървър",
"News server" => "Новинарски сървър",
"Time Left" => "Оставащо време",
"send answers" => "изпращане на отговори",
"Result" => "Резултат",
"Thank you for your submission" => "Благодарим ви за предложението",
"Calendar import" => "Импорт на календар",
"Calendar has been updated" => "Календарът бе обновен",
"CSV File" => "CSV файл",
"File Galleries tpl" => "шаблон Файлови галерии",
"Create a file gallery" => "Създаване на файлова галерия",
"Edit this file gallery:" => "Редакция на тази файлова галерия:",
"create new gallery" => "създаване на нова галерия",
"There are individual permissions set for this file gallery" => "Има настроени индивидуални позволения за тази галерия",
"Gallery is visible to non-admin users?" => "Галерията е видима за неадминистратори?",
"Listing configuration" => "Конфигурация за показване на списък",
"icon" => "иконка",
"Name-filename" => "Име-име на файла",
"Filename only" => "Само файлово име",
"Max description display size" => "Максимален размер за показване на описанието",
"Max Rows per page" => "Максимален брой редове на страница",
"Other users can upload files to this gallery" => "Други потребители могат да качват файлове в тази галерия",
"You can access the file gallery using the following URL" => "Можете да посещавате файловата галерия през този адрес",
"Available File Galleries" => "Налични файлови галерии",
"Allow viewing HTML mails?" => "Разрешаване на разглеждане на HTML писма?",
"Maximum size for each attachment" => "Максимален размер за всеки прикачен файл",
"Unlimited" => "Без лимит",
"Published" => "Публикуван/а",
"Theme Control Center: categories" => "Контролен център за теми: категории",
"ThemeControl" => "Контрол на теми",
"ThemeControl tpl" => "шаблон Контрол на теми",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
"Theme is selected as follows" => "Темата се избира както следва",
"If a theme is assigned to the individual object that theme is used." => "Ако бъде посочена тема за индивидуалния обект, тогава тя се използва.",
"If not then if a theme is assigned to the object's category that theme is used" => "Ако не бъде посочена тема, тогава се използва темата посочена за категорията на обекта",
"If not then a theme for the section is used" => "В противен случай се използва темата на секцията",
"If none of the above was selected the user theme is used" => "Ако никое от горните не е вярно, тогава се използва темата избрана от потребителя",
"Finally if the user didn't select a theme the default theme is used" => "Ако потребителят не си е избрал тема, тогава се използва темата по подразбиране на сайта",
"Control by Objects" => "Контрол по обекти",
"Control by Sections" => "Контрол по секции",
"Assign themes to categories" => "Назначаване на теми към категориите",
"Assigned categories" => "Избрани теми",
"theme" => "тема",
// "Save clicked point" => "Save clicked point",
"Save current view as default" => "Запазване на сегашния изглед като такъв по подразбиране",
"Reset view to site-wide default" => "Зануляване на изгледа към глобалния изглед по подразбиране на сайта",
// "list posts tpl" => "list posts tpl",
"edit blog" => "редактиране на блог",
"Blog Title" => "Заглавие на блог",
// " on " => " on ",
"RSS feed" => "RSS емисия",
"Edit blog" => "Редактиране на блог",
"monitor this blog" => "наблюдение на блога",
"stop monitoring this blog" => "спиране на наблюдението на блога",
"visits" => "посещения",
// "Activity=" => "Activity=",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
"status" => "статус",
// "Inst Status" => "Inst Status",
"Not defined" => "Не е дефиниран/а",
// "No instances defined yet" => "No instances defined yet",
"admin the category system" => "администрация на системата категории",
"admin category" => "администрация на категория",
// "Browse in" => "Browse in",
"Wiki pages" => "Уики страници",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "search category" => "search category",
// "deep" => "deep",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
"Current category" => "Настояща категория",
"Upper level" => "По-горно ниво",
"Objects" => "Обекти",
"Admin newsletter subscriptions" => "Администрация на абонаментите към новинарски емисии",
"admin newsletters" => "администрация на новинарските емисии",
// "Add a subscription newsletters" => "Add a subscription newsletters",
"You can add several email addresses by separating them with commas." => "Можете да добавите няколко и-мейл адреса като ги разделите със запетаи.",
"Add email:" => "Добавяне на и-мейл:",
"Add user:" => "Добавяне на потребител:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
"Don't send confirmation mail" => "Не изпращай и-мейл за потвърждение",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
"Subscribe group" => "Абониране на група",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
"Subscriptions" => "Абонаменти",
"subscribed" => "абониран",
"Stats for quizzes" => "Статистики за тестове",
"list quizzes tpl" => "списък с шаблоните тестове",
"Av score" => "Среден резултат",
"Av time" => "Средно време",
"Assign permissions to " => "Даване на права за достъп на: ",
"Current permissions for this object" => "Текущи позволения за този обект",
"Assign permissions to this object" => "Назначаване на позволения за този обект",
// "Mail-in feature" => "Mail-in feature",
// "Listing Gallery" => "Listing Gallery",
"upload file" => "качване на файл",
"Edit a file using this form" => "Редактирайте файл като използвате тази бланка",
// "Gallery Files" => "Gallery Files",
"move selected files" => "преместване на избраните файлове",
"delete selected files" => "изтриване на избраните файлове",
"Move to" => "Преместване в",
"Dls" => "Сваляния",
"Translation" => "Превод",
// "admin HTML page dynamic zones" => "admin HTML page dynamic zones",
"Admin HTML pages" => "Администрация на HTML страниците",
"Edit this page" => "Редакция на страницата",
// "Edit zone" => "Edit zone",
"Content" => "Съдържание",
"Dynamic zones" => "Динамични зони",
"Mass update" => "Масово обновление (update)",
// "User assigned modules" => "User assigned modules",
// "User Assigned Modules" => "User Assigned Modules",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
"Restore defaults" => "Възстановяване на първоначалните настройки",
"move to right column" => "преместване в дясната колона",
// "unassign" => "unassign",
"move to left column" => "преместване в лява колона",
// "Assign module" => "Assign module",
"Column" => "Колона",
// "Reading note:" => "Reading note:",
"List notes" => "Списък с бележки",
"Write note" => "Запис на бележка",
"wiki create" => "уики създаване",
// "wiki overwrite" => "wiki overwrite",
"Edit and create languages" => "Редакция и създаване на езици",
"Create Language" => "Създаване на език",
"Shortname" => "Кратко име",
"like" => "като",
"Longname" => "Пълно име",
"Select the language to edit" => "Избиране на език за редакция",
"Add a translation" => "Добавяне на превод",
"Edit translations" => "Редакция на преводи",
"Translate recorded" => "Превод на записи",
"search" => "търсене",
"translate" => "превод",
"reset table" => "зануляване на таблица",
"admin Html Pages" => "администрация на HTML страници",
"admin Html Pages template" => "администрация на HTML страници шаблон",
"Create new HTML page" => "Създаване на нова HTML страница",
"Edit this HTML page:" => "Редакция на тази HTML страница:",
"Page name" => "Име на страница",
"Dynamic" => "Динамичен/на",
"Static" => "Статичен/на",
"Refresh rate (if dynamic) [secs]" => "Период на обновяване (ако е динамична)[secs]",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
"Edit task" => "Редактиране на задача",
"red" => "червен/а",
// "NOT accept" => "NOT accept",
"remove from trash" => "премахване от кошчето",
"move into trash" => "преместване в кошчето",
"Task saved" => "Задачата запаметена",
"Edit Task" => "Редактиране на задача",
"View Task" => "Разглеждане на задача",
"Open a new task" => "Отваряне на нова задача",
"Only the creator can delete this task" => "Само създателят може да изтрие тази задача",
"use start date and time" => "използване на дата и време за начало",
"End" => "Край",
"use end date and time" => "използване на крайна дата и време",
"waiting / not started" => "изчакваща / не стартирала",
"Percentage completed" => "Процент на завършеност",
"shared for group" => "обща за група",
"accepted by user" => "приета от потребител",
"no / rejected" => "не / отказана",
"accepted by creator" => "приета от създател",
"This message will be send to users if you are makeing changes of assigned tasks" => "Това съобщение ще бъде изпратено на потребителите, ако направите промени по приети задачи",
"Send message with changes" => "Изпращане на съобщение с промените",
"Modified by" => "Редактиран/а от",
"Marked as deleted" => "Маркиран/а като изтрит/а",
"Inform task user by email" => "Информиране на потребителя на задачата по и-мейл",
"You can only view this task" => "Можете само да разгледате тази задача",
// "Admin process sources" => "Admin process sources",
// "select source" => "select source",
"Shared code" => "Споделен код",
"template" => "шаблон",
// "Set next user" => "Set next user",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Complete" => "Complete",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "Switch construct" => "Switch construct",
"Enlarge area height" => "Увеличаване на височината на зоната",
"Reduce area height" => "Намаляване на височината на зоната",
// "Site Calendar" => "Site Calendar",
"<b>Value</b>" => "<b>Стойност</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "meta robots" => "meta robots",
"revisit after" => "повторно посещение след",
"Edit Calendar Item" => "Редактиране на елемент от календара",
"New Calendar Item" => "Нов елемент в календара",
"or create a new category" => "или създаване на нова категория",
"Location" => "Локация",
"or create a new location" => "или създаване на нова локация",
"Organized by" => "Организация според",
"comma separated usernames" => "потребителски имена, разделени от запетая",
"comma separated username:role" => "разделени със запетая потребителскоИме:Роля",
"with roles" => "с роли",
// "Chair" => "Chair",
"Required" => "Задължително",
"Optional" => "Незадължително",
"Syntax error" => "Синтактична грешка",
"Format: mm/dd/yyyy hh:mm<br />..." => "Формат: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "Tentative" => "Tentative",
// "Confirmed" => "Confirmed",
// "Cancelled" => "Cancelled",
"Subscription List" => "Списък с абонати",
"duplicate" => "дуплициране",
// "save_to" => "save_to",
"Change style only" => "Промяна само на стила",
"Slideshows theme" => "Тема на презентациите",
"Edit Templates" => "Редактиране на шаблони",
"admin Banners" => "администрация на банери",
// "admin Banners tpl" => "admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
"Create banner" => "Създаване на банер",
"Method" => "Метод",
"Use Dates?" => "Използване на дати?",
// "Max Impressions" => "Max Impressions",
"Clicks" => "Кликове",
// "expires:" => "expires:",
"no comments" => "без коментари",
"Theme Control Center: Objects" => "Център за контрол на темата: Обекти",
// "ThemeControl Objects" => "ThemeControl Objects",
// "theme control objects tpl" => "theme control objects tpl",
// "Control by Categories" => "Control by Categories",
// "Assign themes to objects" => "Assign themes to objects",
// "Assigned objects" => "Assigned objects",
"Top 10" => "Топ 10",
"Top 20" => "Топ 20",
"Top 50" => "Топ 50",
"Top 100" => "Топ 100",
"topics" => "теми",
// "ppd" => "ppd",
"last post" => "последна публикация",
"configure forum" => "конфигуриране на форум",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "За да конфигурирате вашата директория, намерете \"Администрация на директории\" под \"Директории\" в менюто на приложението или",
"Number of columns per page when listing categories" => "Брой колони на страница при показване на списък с категории",
"Links per page" => "Връзки на страница",
"Validate URLs" => "Валидиране на адреси",
"enable cool sites" => "Активиране на 'любими сайтове'",
"Method to open directory links" => "Метод за отваряне на връзките в директорията",
"replace current window" => "Изместване на настоящия прозорец - replace (r)",
"new window" => "нов прозорец - new (n)",
"inline frame" => "вътре в сайта - inline frame (i)",
"monitor" => "наблюдение",
"Choose a filter" => "Избиране на филтър",
" item found" => " елемент открит",
" items found" => " елементи открити",
"list attachments" => "списък с прикачени файлове",
"View inserted item" => "Разглеждане на вмъкнатия елемент",
"Import From File" => "Импорт от файл",
// "Grab Wiki Tables" => "Grab Wiki Tables",
"Don't forget: to use feature you will need to enable it on" => "Не забравяйте, че за да използвате функцията, първо ще трябва да я активирате",
"Admin->Features" => "Администрация->Функции",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
"Publish" => "Публикуване",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
"at top of page" => "най-отгоре на страницата",
"at top of center column" => "най-отгоре на централната колона",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
"Larger font for" => "По голям шрифт за",
// "entire location" => "entire location",
"page name" => "име на страница",
"Use page description:" => "Използване на описание за страницата:",
"Site Search" => "Търсене в сайта",
// "Site search bar" => "Site search bar",
"Site Logo" => "Лого на сайта",
"Site logo" => "Лого на сайта",
"Site logo source" => "Адрес на логото на сайта",
"Site logo background color" => "Цвят за фон на логото на сайта",
"Site logo title (on mouse over)" => "Заглавие на логото на сайта (при посочване с мишка)",
"Alt. description (e.g. for text browsers)" => "Алтернативно описание (за текстови браузъри)",
"Site Ads and Banners" => "Реклами и банери на сайта",
"Site ads and banners" => "Реклами и банери на сайта",
"Site Menu" => "Меню на сайта",
// "Site menu bar" => "Site menu bar",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Забележка: тази функция изисква phplayers да бъдат включени в Админ->Функции",
"full path to mapfiles" => "Път до картови файлове",
"default mapfile" => "Картов файл по подразбиране",
"Wiki Page for Help" => "Уики Страница за помощ",
"Wiki Page for Comments" => "Уики страница за коментари",
"Full path to gdaltindex" => "Път до gdaltindex",
"Full path to ogr2ogr" => "Път до ogr2ogr",
// "Map Zone" => "Map Zone",
"Generate User Map" => "Генериране на потребителска карта",
"May need to refresh twice to see changes" => "Трябва да обновите страинцата два пъти за да видите промените",
"Add top level bookmarks to menu" => "Добавяне на отметка в менюто",
"delete selected" => "изтриване на избраните",
"Add or edit an item" => "Добавяне или изтриване на елемент",
"replace window" => "замяна на прозорец",
"Enable/disable Tiki features in " => "Активиране/Деактивиране на Тики функции в ",
", but configure them elsewhere" => ", но конфигуриране другаде",
"subscribe" => "абонация",
"Sent edition" => "Изпращане на издание",
// "Admin process roles" => "Admin process roles",
"Add or edit a role" => "Добавяне/Редакция на роля",
// "Process roles" => "Process roles",
"No roles defined yet" => "Все още няма дефинирани роли",
"Map users to roles" => "Картиране на потребители към ролите",
"Roles" => "Роли",
"map" => "карта",
"Map groups to roles" => "Картиране на групи към ролите",
// "Operation" => "Operation",
"Warning" => "Предупреждение",
"No roles are defined yet so no roles can be mapped" => "Все още няма дефинирани роли, затова не могат да се картират такива",
"List of mappings" => "Списък с карти",
"No mappings defined yet" => "Все още няма дефинирани карти",
// "Admin process activities" => "Admin process activities",
"Add or edit an activity" => "Добавяне или редакция на дейност",
"activity" => "дейност",
"split" => "разцепване",
"join" => "съединяване",
"standalone" => "самостоятелен/на",
// "auto routed" => "auto routed",
"Expiration Time" => "Краен срок",
"Years" => "Години",
"Months" => "Месеци",
"Days" => "Дни",
"Hours" => "Часове",
// "Add transitions" => "Add transitions",
// "Add transition from:" => "Add transition from:",
// "Add transition to:" => "Add transition to:",
// "No roles associated to this activity" => "No roles associated to this activity",
"Add role" => "Добавяне на роля",
"add new" => "добавяне на нов/а",
"add role" => "добавяне на роля",
// "Process activities" => "Process activities",
// "Routing" => "Routing",
"Automatic" => "Автоматично",
// "Auto routed" => "Auto routed",
"Manual" => "Ръчно",
"(no roles)" => "(няма роли)",
"No activities defined yet" => "Няма дефинирани дейности",
// "Process Transitions" => "Process Transitions",
// "List of transitions" => "List of transitions",
"From:" => "От:",
"Origin" => "Произход",
// "No transitions defined yet" => "No transitions defined yet",
// "Add a transition" => "Add a transition",
"Assign permissions to group" => "Даване на права на група",
"Group Information" => "Информация за група",
"Desc" => "Описание",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
"Create level" => "Създаване на ниво",
"all permissions in level" => "Всички позволения на ниво",
"level" => "ниво",
"inherited from" => "наследен/и от",
"inherited" => "наследен/и",
// "Admin related categories" => "Admin related categories",
// "Admin Directory Related " => "Admin Directory Related ",
// "directory admin related tpl" => "directory admin related tpl",
"Parent category" => "Родителска категория",
// "Add a related category" => "Add a related category",
// "Mutual" => "Mutual",
// "Related categories" => "Related categories",
"You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page?" => "Вие сте на път да напуснете тази страница. Всички промени, които сте направили без да ги запаметите ще бъдат загубени безвъзвратно. Сигурни ли сте, че искате да напуснете страницата?",
"Details" => "Детайли",
"No messages to download" => "Няма съобщения за сваляне",
"Use database to store userfiles" => "Използване на базата данни за съхранение на потребителските файлове",
"Use a directory to store userfiles" => "Използване на директория за съхранение на потребителските файлове",
"Toggle options" => "Превключване на опции",
"Toggle" => "Превключване",
"admin groups" => "администрация на групи",
// "admin groups template" => "admin groups template",
"Add new group" => "Добавяне на нова група",
"Edit group" => "Редакция на група",
"Members" => "Членове",
"Add a new group" => "Добавяне на нова група",
"List of existing groups" => "Списък със съществуващи групи",
"Number of displayed rows" => "Брой на показвани редове",
// "Includes" => "Includes",
"assign permissions" => "настройване на позволения",
"Include" => "Включване",
"Group Homepage" => "Начална страница на групата",
"Use wiki page name or full URL" => "Използвайте име на уики страница или пълен адрес",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
"choose a field ..." => "избиране на поле ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
"Create item" => "Създаване на елемент",
"Members List" => "Списък с потребители",
"remove from group" => "премахване от група",
"users in group" => "потребители в група",
"List all members" => "Списък с всички потребители",
"Edit quiz" => "Редакция на тест",
"Current Version" => "Текуща версия",
"General Options" => "Общи настройки",
"Publication Date" => "Дата на публикуване",
// "at " => "at ",
// "Use " => "Use ",
"randomly selected questions." => "случайно избрани въпроси.",
"Test-time Options" => "Опции по време на решаване на теста",
"Limit questions displayed per page to " => "Лимитиране на броя на въпросите, показвани на една страница до ",
"&nbsp question(s)." => "&nbsp; въпрос(и).",
"Impose a time limit of " => "Въвеждане на времево ограничение от ",
"Allow students to store partial results and return to quiz." => "Позволяване на учениците да си запазват частични резултати и да се връщат към теста по-късно",
"Allow students to retake this quiz " => "Позволяване на учениците да пререшават теста отново",
"Grading and Feedback" => "Оценки и забележки",
"Grading method " => "Метод за оценяване ",
"Show students their score " => "Показване на резултата на учениците",
"Show students the correct answers " => "Показване на правилните отговори",
"Publish statistics " => "Публикуване на статистиките ",
"Extra Options" => "Допълнителни опции",
// "Solicit additional questions from students" => "Solicit additional questions from students",
"Link quiz to forum named: " => "Връзка на теста с форум, наречен: ",
"Epilogue:" => "Епилог:",
"admin polls" => "администрация на анкетите",
"admin polls template" => "администрация на шаблон анкети",
"configure polls" => "конфигурация на анкетите",
"Set last poll as current" => "Настройване на последната анкета като текуща",
"Close all polls but last" => "Затваряне на всички анкети освен последната",
"Activate all polls" => "Активиране на всички анкети",
"Create/edit Polls" => "Създаване/Редакция на анкети",
"current" => "текущ/а",
"Send objects" => "Изпращане на обекти",
// "Help on Communication Center" => "Help on Communication Center",
// "admin send objects tpl" => "admin send objects tpl",
// "Transmission results" => "Transmission results",
// "Send objects to this site" => "Send objects to this site",
"Send Wiki Pages" => "Изпращане на Уики страници",
"add page" => "добавяне на страница",
"clear" => "изчистване",
"Send Articles" => "Изпращане на статии",
"add article" => "добавяне на статия",
// "Rollback page" => "Rollback page",
"to_version" => "до_версия",
// "rollback" => "rollback",
"activate" => "активиране",
"monitor processes" => "наблюдение на процес",
"monitor activities" => "наблюдение на дейности",
"monitor instances" => "наблюдение на инстанции",
// "received pages tpl" => "received pages tpl",
"Edit received page" => "Редактиране на получена страница",
// "User identity features" => "User identity features",
"Picture" => "Изображение",
"Number of friends" => "Брой приятели",
"E-mail" => "И-мейл",
"Tikiwiki Mods Configuration" => "Конфигурация на Tikiwiki модс",
"Mods Install/uninstall" => "Инсталиране/деинсталиране на модули",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
"Mini Calendar: Preferences" => "Мини календар: Предпочитания",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "Calendar Interval in daily view" => "Calendar Interval in daily view",
"Start hour for days" => "Начален час за дните",
"End hour for days" => "Краен час за дните",
// "Reminders" => "Reminders",
// "no reminders" => "no reminders",
"Import CSV file" => "Импорт на CSV файл",
"Or enter path or URL" => "Или въведете път, или адрес",
"add topic" => "добавяне на тема",
// "related" => "related",
"Admin FAQ" => "Администрация на FAQ",
"View FAQ" => "Разглеждане на FAQ",
"Edit this FAQ" => "Модификация на FAQ",
"new question" => "нов въпрос",
"Edit FAQ questions" => "Редакция на FAQ въпроси",
"Use a question from another FAQ" => "Използване на въпрос от друг FAQ",
"FAQ questions" => "FAQ въпроси",
"Suggested questions" => "Предложени върпроси",
"approve" => "одобряване",
"No suggested questions" => "Няма предложени въпроси",
// "Print multiple pages" => "Print multiple pages",
// "Print Wiki Pages" => "Print Wiki Pages",
"add structure" => "добавяне на структура",
"General Preferences" => "Генерални предпочитания",
"Use group homepages" => "Използване на групова начална страница",
"Go to group homepage only if login from default homepage" => "Отиване на груповата начална страница само ако се влезе в системата от заглавната страница.",
"Use URI as Home Page" => "Използване на адрес като начална страница",
"Home page" => "Лична страница",
// "Custom home" => "Custom home",
"OS" => "ОС",
"Unknown/Other" => "Непозната/Друга",
"PHP error reporting level for non-admin:" => "Ниво за докладване на PHP грешки за неадминистратори:",
"No error reporting" => "Без докладване на грешки",
"Report all PHP errors" => "Докладване на всички PHP грешки",
"Report all errors except notices" => "Докладване на всички грешки с изключение на забележките",
"Report PHP errors only for admin" => "Докладване на PHP грешки само за администратори",
"Default charset for sending mail:" => "Кодова таблица по подразбиране при изпращането на и-мейл:",
"Mail end of line:" => "Край на ред в писмата:",
"(some Unix MTA)" => "(Някакъв Unix МТА)",
"General Settings" => "Генерални настройки",
"Disallow access to the site (except for those with permission)" => "Забраняване на достъп до сайта (с изключение на тези с права)",
"Message to display when site is closed" => "Съобщение, което да се показва, когато сайтът е спрян",
"Disallow access when load is above the threshold (except for those with permission)" => "Отказване на достъп когато натоварването на сайта е над някакво ниво (с изключение на тези с права)",
"Max average server load threshold in the last minute" => "Максимално средно сървърно натоварване в последната минута",
"Message to display when server is too busy" => "Съобщение, което да се показва, когато сървърът е прекалено натоварен",
"Open external links in new window" => "Отваряне на външните връзки в нов прозорец",
"Use cache for external pages" => "Използване на кеш за външни страници",
"Use cache for external images" => "Използване на кеш за външни изображения",
"Use direct pagination links" => "Използване на линкове с direct pagination",
"Display menus as folders" => "Показване на менютата като папки",
"Use gzipped output" => "Използване на компресиран output (gzip)",
// "output compression is active." => "output compression is active.",
"compression is handled by" => "компресията се извършва от",
"Count admin pageviews" => "Преброяване на администраторските посещения на страници",
"Server name (for absolute URIs)" => "Име на сървъра (за цели URIs)",
"HTTPS Server" => "HTTPS сървър",
"Automatic (uses HTTPS variable)" => "Автоматичен (използва HTTPS променливи)",
"Browser title" => "Заглавие в браузъра",
// "Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"Temporary directory" => "Временна директория",
"Sender Email" => "И-мейл на подател",
"Contact user" => "Свързване с потребител",
"Allow anonymous users to \"Contact Us\"" => "Позволяване на анонимни потребители да \"Свържете се с нас\"",
"contact feature disabled" => "функцията за контакт е деактивирана",
"Store session data in database" => "Съхраняване на session data в базата данни",
"Session lifetime in minutes" => "Времетраене на сесията в минути",
"Use proxy" => "Използване на прокси",
"Proxy Host" => "Прокси Хост",
"Proxy port" => "Прокси порт",
"Maximum number of records in listings" => "Максимален брой записи в списъците",
"Help System" => "Система за помощ",
"Help URL" => "URL за помощ",
"Please expect not found help-pages with the default-URL." => "Моля, не очаквайте да откриете помощни страници на адреса по подразбиране",
"Any help with the documentation is welcome." => "Всякаква помощ с документацията е добре дошла.",
"Date and Time Formats" => "Формати за дата и време",
"Long date format" => "Дълъг формат за дата",
"Short date format" => "Къс формат за дата",
"Long time format" => "Дълъг формат за време",
"Short time format" => "Къс формат за време",
"Favicon icon file name:" => "Име на файла за favicon:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
"Locations separator" => "Разделител на локации",
"Register this site at tikiwiki.org" => "Регистриране на сайта в tikiwiki.org",
"Click here for more details." => "Кликнете за повече детайли.",
"Change admin password" => "Промяна на администраторската парола",
"Change password" => "Промяна на парола",
"Directory Administration" => "Администрация на директории",
// "admin directory tpl" => "admin directory tpl",
"Statistics" => "Статистики",
"There are" => "Има",
"invalid sites" => "невалидни сайта",
"valid sites" => "валидни сайта",
"Users have visited" => "Вие сте посетили",
"sites from the directory" => "сайта от директорията",
"Users have searched" => "Потребителите са търсили",
"times from the directory" => "пъти от тази директория",
"Admin sites" => "Администрация на сайтове",
"Admin category relationships" => "Администрация на връзките между категориите",
"Validate links" => "Валидиране на връзки",
"Structures:" => "Структури:",
"show structures" => "показване на структури",
"hide structures" => "скриване на структури",
"Manage structures" => "Управление на структури",
// "admin Referer stats" => "admin Referer stats",
// "admin Referer stats tpl" => "admin Referer stats tpl",
"last" => "последен/на",
"Tiki installer" => "Tiki инсталатор",
"MultiTiki setup" => "MultiTiki настройки",
"To add a new virtual host" => "За да добавите нов виртуален хост",
"To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "За да добавите нов виртуален хост, стартирайте setup.sh с името на домейна  на новия хост като последен параметър",
"Tiki cannot find a database connection" => "Тики не може да намери връзка с база данни",
"Please enter your database connection info" => "Моля, въведете информация за връзка с вашата база данни",
"Database type" => "Тип на базата данни",
"The type of database you intend to use" => "Типът база данни, който възнамерявате да използвате",
"Host:" => "Хост:",
"Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname или IP за вашият MySQL сървър, например: localhost, ако той е на същата машина като Тики",
"If you use SQLite, insert the path and filename to your database file" => "Ако вашият сайт използва SQLite, въведете пътя и името на вашия файл - база данни",
"Database user" => "Потребител за базата данни",
"Database password" => "Парола за базата данни",
"Database name" => "Име на базата данни",
"The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "Името на базата данни, където Тики ще създаде таблици. Можете да създадете база данни използвайки mysqladmin или PHPMyAdmin, или да помолите някой от вашата хостинг компания да ви създаде база данни. Обикновено Тики таблиците няма да влязат в конфликт с таблиците на други продукти",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "Ако използвате Oracle, можете да въведете TNS Name тук и да оставите полето за име на хост (hostname) празно, or you override tnsnames.ora and put your SID here and fill your hostname:port above",
"Welcome to the installation &amp; upgrade script!" => "Добре дошли на скрипта за инсталация и ъпгрейд!",
"Install" => "Инсталиране",
"Create database (clean install) with profile" => "Създаване на база данни (инсталация 'на чисто') с профил",
"Upgrade" => "Ъпгрейд",
"backup your database" => "създайте резервно копие на вашата база данни",
"with mysqldump or phpmyadmin before you proceed" => "чрез mysqldump или phpmyadmin преди да продължите",
"Update database using script" => "Обновете базата данни чрез скрипт",
"For database update from 1.8 or later" => "За обновяване на база данни от версия 1.8 или по-късна",
"If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "Ако обновявате от версия 1.8.х, вие <b>ТРЯБВА</b> да стартирате tiki_1.8to1.9 и не се нуждаете от никакъв допълнителен скрипт ",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
"Do nothing and enter Tiki" => "Не правете нищо и влезте в Тики",
"Reset database connection settings" => "Зануляване на настройките за връзка с базта данни",
"This site has an admin account configured" => "Този сайт вече има настроен администраторски акаунт",
"Please enter your admin password to continue" => "Моля, въведете администраторската си парола за да продължите",
"Print operations executed successfully" => "Принт операциите изпълнени успешно",
"Print operations failed" => "Принт операциите се провалиха",
"Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Вашата база данни е конфигурирана и Тики е готово за експлоатация. Ако това е вашата първа инсталация, вашата администраторска парола е 'admin'. Можете да влезете в Тики с 'admin' - 'admin' и да започнете конфигурацията на приложението",
"Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Забележка: Този инсталационен скрипт е потенциално опасен, затова ние горещо препоръчваме да деактивирате скрипта и тогава да продължите в Тики. Ако решите да го използвате пак по-късно, само следвайте инструкциите в tiki-install.php за да го възстановите",
"READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "ПРОЧЕТЕТЕ ЗАБЕЛЕЖКИТЕ ПРЕДИ ДА ВЛЕЗЕТЕ В ТИКИ ЧРЕЗ ВРЪЗКИТЕ ОТДОЛУ!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
"Note" => "Забележка",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
"do not use your Back button in your browser!" => "не използвайте бутона за връщане на вашия браузър!",
"History" => "История",
"Preview of version" => "Предварителен преглед на версия",
"(current)" => "(текущ/а)",
"rollback to this version" => "връщане към тази версия",
"Source of version" => "Източник на версията",
"Comparing version {\$old.version} with version {\$new.version}" => "Сравнение на версия {\$old.version} с версия {\$new.version}",
"Version:" => "Версия:",
"Versions are identical" => "Версиите са идентични",
"Legend:" => "Легенда:",
"v=view" => "v=разглеждане (view)",
"c=compare" => "c=сравнение (compare)",
"d=diff" => "d=разлики (diff)",
"b=rollback" => "b=връщане (rollback)",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
"Ip" => "IP",
"compare" => "сравнение",
"diff" => "разлики",
"older version" => "по-стара версия",
"user processes" => "потребителски процеси",
"user activities" => "потребителски действия",
// "user instances" => "user instances",
"Send blog post" => "Изпращане на блог публикация",
"A link to this post was sent to the following addresses:" => "Връзка към тази публикация бе изпратене на следните адреси:",
"Send post to this addresses" => "Изпращане на публикация на тези адреси",
"List of email addresses separated by commas" => "Списък с и-мейл адреси, разделени със запетаи",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Tikiwiki Mods" => "Tikiwiki Mods",
"Mods Configuration" => "Конфигурация на модули",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
"Republish all" => "Препубликация на всички",
"Publish all" => "Публикация на всички",
// "Unpublish all" => "Unpublish all",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
"all types" => "всички типове",
"Display only this type" => "Показване само на този тип",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
"Download" => "Сваляне",
"install" => "инсталиране",
"Admin RSS modules" => "Администрация на RSS модули",
"admin RSS modules" => "администрация на RSS модули",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
"Content for the feed" => "Съдържание на емисията",
"Edit this RSS module:" => "Редакция на този RSS модул:",
"Create new RSS module" => "Създаване на RSS модул",
"Refresh rate" => "Период на обновяване",
"day" => "ден/дни",
"show feed title" => "показване на заглавието на емисията",
"show publish date" => "показване датата на публикуване",
"Rss channels" => "RSS емисии",
"Last update" => "Последна модификация",
"show pubdate" => "показване дата на публ.",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Ако вашето Тики се държи странно, първото нещо, което трябва да опитате е да изчистите кеша от линковете по-долу. Също, много е важно да чистите вашия кеш след ъпгрейд (по FTP/SSH) когато е необходимо.",
"Empty" => "Изпразване",
"Templates compiler" => "Компилатор на шаблони",
"Compile" => "Компилиране",
"Fix UTF-8 Errors in Tables" => "Поправяне на UTF-8 грешки в таблиците",
"Warning: Make a backup of your Database before using this function!" => "Внимание: направете резервно копие на вашата база данни преди да използвате тази функция!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Внимание: Ако опитате да трансформирате големи таблици, повишете максималното време за изпълнение на скриптове във вашия php.ini файл!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Тази функция превръща ISO-8859-1 стрингове от вашите таблици в UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 грешки поправени",
"Field" => "Поле",
"Investigate" => "Изследване",
"Fix it" => "Поправяне",
"new topic" => "нова тема",
"Forum List" => "Списък с форуми",
"Edit Forum" => "Редакция на форум",
"monitor this forum" => "наблюдение на този форум",
"stop monitoring this forum" => "спиране на наблюдението на този форум",
"You have {\$unread} unread private messages" => "Имате {\$unread} непрочетени лични съобщения",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Вашето съобщение бе изпратено за одобрение. То ще бъде публикувано след като модератор го одобри.",
"You have to enter a title and text" => "Трябва да въведете заглавие и текст",
"Editing comment" => "Редактиране на коментар",
"post new comment" => "публикуване на нов коментар",
"announce" => "обявяване",
"hot" => "горещо",
"sticky" => "важено",
// "no feeling" => "no feeling",
"happy" => "щастлив",
"Summary" => "Обобщение",
"Posting comments" => "Публикуване на коментари",
// "Use" => "Use",
// "for links" => "for links",
"HTML tags are not allowed inside comments" => "HTML таговете не са позволени в коментари",
"moderator actions" => "модераторски действия",
"move selected topics" => "преместване на избраните теми",
"unlock selected topics" => "отключване на избраните теми",
"lock selected topics" => "заключване на избраните теми",
"delete selected topics" => "изтриване на избраните теми",
"merge" => "смесване",
"merge selected topics" => "смесване на избраните теми",
"reported messages:" => "докладвани съобщения:",
"queued messages:" => "чакащи съобщения:",
"Merge into topic" => "смесване с тема",
"emot" => "емот",
"No topics yet" => "Все още няма теми",
"topics in this forum" => "теми в този форум",
"Show posts" => "Показване на публикации",
"All posts" => "Всички публикации",
"Last hour" => "През последния час",
"Last 24 hours" => "През последните 24h",
"Last 48 hours" => "През последните 48h",
"Jump to forum" => "Скачане към форум",
"Address book" => "Адресник",
"Edit quiz questions" => "Редактиране на въпросите в теста",
// "edit quiz questions tpl" => "edit quiz questions tpl",
"Question Type" => "Тип на въпроса",
"Import questions from text" => "Импорт на въпроси от текст",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Инструкции: Напишете или paste-нете вашите въпроси с множествен избор отдолу. Един ред за въпроса, след това започвате възможните варианти за отговор на следващите редов. Разделете отделните въпроси с празен ред. Посочете верните отговори като ги започнете със звезда (*) (без скобите, разбира се).",
"Input" => "Въвеждане",
"maxScore" => "Максимален резултат",
"Survey stats" => "Статистики на проучването",
"take survey" => "взимане на участие в проучването",
"View Results" => "Виж резултата",
"users registered" => "регистрирани потребители",
// "administer surveys template" => "administer surveys template",
"Edit this Survey:" => "Редактиране на проучването:",
"Create New Survey" => "Създаване на ново проучване",
"There are individual permissions set for this survey" => "Има настроени индивидуални права за това проучване",
"Search features" => "Функции за търсене",
"Full Text Search" => "Търсене на цялостен текст",
"SearchStats" => "Статистики на търсенето",
// "Referer Search Highlighting" => "Referer Search Highlighting",
"Refresh wiki search index now" => "Обновяване на индекса за търсене сега",
// "Performance issues" => "Performance issues",
"Search may show forbidden results. Much better performance though." => "Търсенето може да показва и забранени страници в резултатите. При това бързодействието се увеличава многократно",
"Ignore individual object permissions" => "Игнориране на индивидуалните позволения за обектите",
"Ignore category viewing restrictions" => "Игнориране на рестрикциите за разглеждане на категории",
"Settings for searching content" => "Настройки за търсене на съдържание",
// "Search refresh rate" => "Search refresh rate",
"Minimum length of search word" => "Минимална дължина на дума за търсене",
"Max. number of words containing a syllable" => "Максимален брой думи съдържащи наставка",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "За да добавите/премахнете форуми, потърсете за 'Администриране на форуми' под 'Форуми' в менюто на приложението, или",
"Home Forum" => "Начален форум",
"Home Forum (main forum)" => "Начален форум (главен форум)",
"Forums features" => "Функции на форумите",
"Accept wiki syntax" => "Позволяване на уики синтаксис",
"Forum quick jumps" => "Бързи прескачания между форумите",
"Ordering for forums in the forum listing" => "Ред на показване на форумите в списъците с форуми",
"Creation Date (desc)" => "Дата на създаване (низх)",
"Topics (desc)" => "Брой теми (низх)",
// "Threads (desc)" => "Threads (desc)",
"Last post (desc)" => "Последна публикация (низх)",
"Visits (desc)" => "Посещения (низх)",
"Name (desc)" => "Име (низх)",
"Name (asc)" => "Име (възх)",
"Forum listing configuration" => "Конфигуриране на показването на списък с форумите",
"Posts per day" => "Публикации на ден",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Благодарим ви за абонамента. Скоро ще получите и-мейл чрез който да потвърдите абонамента си. Няма да ви бъдат изпращани новини преди да потвърдите абонамента.",
"Your email address was removed from the list of subscriptors." => "Вашият и-мейл адрес бе премахнат от списъка с абонати",
"Subscription confirmed!" => "Абонаментът потвърден!",
"Subscribe to newsletter" => "Абонация за новинарска емисия",
"Email:" => "И-мейл:",
"Subscribe" => "Абонация",
"Available Newsletters" => "Налични новинарски емисии",
"Admin Forums" => "Администрация на форуми",
// "admin forums template" => "admin forums template",
"Create new forum" => "Създаване на нов форум",
"Edit existing forums" => "Редактиране на съществуващи форуми",
"Edit this Forum:" => "Редактиране на този форум:",
"Create New Forum" => "Създаване на нов форум",
"There are individual permissions set for this forum" => "Има настроени индивидуални права за този форум",
"Show description" => "Показване на описание",
"Prevent flooding" => "Предодвратяване на флууд",
"Minimum time between posts" => "Минимум време между две публикации",
"Topics per page" => "Теми на страница",
"Create new" => "Създаване на нов/а",
"Moderator user" => "Потребител модератор",
"Moderator group" => "Група модератор",
"Password protected" => "Защитен/а с парола",
"Topics only" => "Само теми",
"Forum password" => "Парола за форума",
"Default ordering for topics" => "Подредба по подразбиране за темите",
"Replies (desc)" => "Отговори (низх)",
"Reads (desc)" => "Брой посещения (низх)",
"Title (desc)" => "Заглавие (низх)",
"Title (asc)" => "Заглавие (възх)",
"Default ordering for threads" => "Подредба по подразбиране на дискусиите (threads)",
"Send this forums posts to this email" => "Изпращане на публикациите в този форум на следния и-мейл адрес",
"Prune unreplied messages after" => "Изчистване на съобщенията на които не е отговорено след",
"Prune old messages after" => "Изчистване на старите съобщения след",
"Topic list configuration" => "Конфигурация на списъка с темите",
"Replies" => "Отговори",
"Posts can be rated" => "Публикациите могат да бъдат оценявани",
"Display last post titles" => "Показване на заглавията на последните публикации",
"no display" => "без показване",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Препращане на съобщенията в този форум на следния и-мейл адрес във формат, който може да се използва за изпращане обратно на и-мейл адреса на форума",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
"Originating e-mail address for mails from this forum" => "Изходящ и-мейл адрес за писмата от този форум",
"Add messages from this email to the forum" => "Добавяне на съобщения от този и-мейл към форума",
"POP3 server" => "POP3 сървър",
"Use topic smileys" => "Използване на ухилени човечета в темата",
"Show topic summary" => "Показване на обобщение от темата",
"User information display" => "Показване на потребителска информация",
// "online" => "online",
"Approval type" => "Тип одобрение",
"All posted" => "Всички публикувани",
// "Queue anonymous posts" => "Queue anonymous posts",
// "Queue all posts" => "Queue all posts",
"No attachments" => "Без прикачени файлове",
"Everybody can attach" => "Всеки може да прикачва файлове",
"Only users with attach permission" => "Само потребители с позволение за прикачване на файлове",
"Moderators and admin can attach" => "Модераторите и администраторите могат да прикачват файлове",
"Store attachments in:" => "Съхранение на прикачените файлове в:",
"Database" => "База данни",
"Max attachment size (bytes)" => "Максимален размер на прикачените файлове (байтове)",
"Edit Existing Forums" => "Редактиране на съществуващите форуми",
"age" => "възраст",
"Assign Permissions (Active)" => "Настройване на позволения (Активни)",
"Click here to delete this forum" => "Кликнете тук за да изтриете този форум",
"Create PDF" => "Създаване на PDF",
"PDF Settings" => "Настройки на PDF",
"Font" => "Шрифт",
"Textheight" => "Височина на текста",
"Height of top Heading" => "Височина на 'баш' заглавията",
"Height of mid Heading" => "Височина на заглавията от ниво 2",
"Height of inner Heading" => "Височина на заглавията от ниво 3",
// "tbheight" => "tbheight",
"Automatic Page Breaks" => "Автоматични 'нови редове'",
"Select Wiki Pages" => "Избор на Уики страници",
"remove page" => "Премахване на страница",
// "Support chat transcripts" => "Support chat transcripts",
"back to admin" => "обратно към администрация",
"operator" => "оператор",
"started" => "стартиран/а",
"reason" => "причина",
// "Transcript" => "Transcript",
"Chat Administration" => "Чат администрация",
"Chat Admin" => "Чат админ",
// "Chat Admin tpl" => "Chat Admin tpl",
"Create/edit channel" => "Създаване/редакция на канал",
"Half a second" => "Половин секунда",
"second" => "секунда",
"Chat channels" => "Чат канали",
"Admin Topics" => "Администрация на теми",
// "admin topics template" => "admin topics template",
"Create a new topic" => "Създаване на нова тема",
"Topic Name" => "Име на тема",
"List of topics" => "Списък с теми",
"Active?" => "Активен/на?",
"Articles (subs)" => "Теми (subs)",
"Remove with articles" => "Премахване с теми",
"Deactivate" => "Деактивация",
"Help on Articles" => "Помощ по статии",
// "edit submissions tpl" => "edit submissions tpl",
"list submissions" => "списък с предложения",
"<b>*</b>=optional" => "<b>*</b>=незадължително",
"<b>Topline</b>=small line above Title" => "<b>Надзаглавие</b>=малък ред над заглавието",
"<b>Subtitle</b>=small line below Title" => "<b>Подзаглавие</b>=малък ред под заглавието",
"<b>Source</b>=URL to article source" => "<b>Източник</b>=адрес на статията",
"Edit or create banners" => "Редакция или създаване на банери",
"List banners" => "Списък с банери",
"URL to link the banner" => "Адрес към който ще води банера",
// "Max impressions" => "Max impressions",
"create zone" => "създаване на зона",
"Show the banner only between these dates" => "Показване на банера само между тези дати",
"From date" => "От дата",
"To date" => "До дата",
"Use dates" => "Използване на дати",
"Show the banner only in this hours" => "Показване на банера само през тези часове",
"Show the banner only on" => "Показване на банера само в/на",
"Mon" => "Пон",
"Tue" => "Втр",
"Wed" => "Срд",
"Thu" => "Чет",
"Fri" => "Пет",
"Sat" => "Съб",
"Sun" => "Нед",
"Select ONE method for the banner" => "Изберете ЕДИН метод за банера",
"Use HTML" => "Използване на HTML",
"HTML code" => "HTML код",
"Use image" => "Използване на изображение",
"Image:" => "Изображение:",
"Current Image" => "Сегашно изображение",
// "Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
"Use text" => "Използване на текст",
"Text" => "Текст",
"save the banner" => "запазване на банера",
"Remove Zones (you lose entered info for the banner)" => "Премахване на зоните (губите въведената информация за банера",
"IRC log" => "IRC лог",
"Select" => "Избиране",
"display" => "показване",
"Show All" => "Показване на всички",
"Insert Row" => "Вмъкване на ред",
"Insert Column" => "Вмъкване на колона",
"Remove Row" => "Премахване на ред",
"Remove Column" => "Премахване на колона",
"Merge Cells" => "Сливане на клетки",
"Restore Cells" => "Възстановяване на клетки",
"Copy Calculation" => "Копиране на изчисление",
"Format Cell" => "Форматиране на клетка",
"Before" => "Преди",
"After" => "След",
"Received Articles" => "Получени статии",
// "received articles tpl" => "received articles tpl",
"Edit received article" => "Редактиране на получени статии",
"Use Image" => "Използване на Изображение",
"Image x size" => "Размер x на изображение",
"Image y size" => "Размер y на изображение",
"Image name" => "Име на изображение",
"Publishing date" => "Дата на публикуване",
"Accept Article" => "Одобряване на статия",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "За да добавите/премахнете блогове, отидете на 'Създаване/Редакция на блог' под 'Блогове' в менюто на приложението, или",
"Home Blog (main blog)" => "Начален блог (главен блог)",
"Blog features" => "Функции на блог",
"Blog level comments" => "Коментари на ниво блог",
"Post level comments" => "Коментари на ниво публикация",
"Trackbacks Pings" => "Trackback пинг-ове",
"Default ordering for blog listing" => "Подредба по подразбиране при показване на списък с блогове",
"Creation date (desc)" => "Дата на създаване (низх)",
"Last modification date (desc)" => "Дата на последна модификация (низх)",
"Blog title (asc)" => "Заглавие на блога (възх)",
"Number of posts (desc)" => "Брой публикации (низх)",
"Activity (desc)" => "Активност (низх)",
"Blog listing configuration (when listing available blogs)" => "Конфигурация на показване на списък с блогове (когато се показват наличните блогове)",
"Creation date" => "Дата на създаване",
"Last modification time" => "Време на последна модификация.",
"Disabled" => "Деактивиран",
"Plain text" => "Обикновен текст",
"Link to user information" => "Връзка към потребителска информация",
"User avatar" => "Потребителски аватар",
"Blog comments settings" => "Настройки за коментарите на блоговете",
"Chatroom" => "Чат стая",
"Active Channels" => "Активни канали",
"Users in this channel" => "Потребители в този канал",
"Channel Information" => "Информация за канала",
"Channel" => "Канал",
"Use :nickname:message for private messages" => "Използвайте :потребителскоИме:съобщение за лични съобщения",
"Use [URL|description] or [URL] for links" => "Използвайте [адрес|описание] или [адрес] за линкове",
"Use (:smileyname:) for smileys" => "Използвайте (:smileyname:) за ухилени човечета",
// "User Tasks tpl" => "User Tasks tpl",
"New task" => "Нова задача",
"Task list" => "Списък задачи",
"Admin mode off" => "Админ режим изкл.",
"Admin mode on" => "Админ режим вкл.",
"Task help" => "Помощ задачи",
"Received task" => "Получена задача",
"You received this task, please read and execute it" => "Вие получихте тази задача. Моля, прочетете я и я решете",
"Send task" => "Изпращане на задача",
"You send this task to a other user" => "Вие изпращате тази задача на друг потребител",
"Shared task" => "Споделена задача",
"This task is public to a special group" => "Тази задача е публична за специална група",
"Task is accepted by user and creator" => "Задачата е приета от потребителя и създателя",
"Task is rejected by one user" => "Задачата е отхвърлена от един потребител",
"Task is not accepted by you, read the task and accept or reject it" => "Задачата не е приета от вас. Прочетете задачата и я приемете или отхвърлете",
"Task is not accepted/rejected by other user" => "Задачата не е одобрена/отхвърлена от друг потребител",
"admin mode" => "админ режим",
"empty trash" => "изпразване на кошче",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
"Cancel" => "Анулиране",
"choose a stylesheet" => "избиране на stylesheet",
"try" => "опит",
// "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model.",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
"week" => "седмица",
"Weeks" => "Седмици",
"month" => "месец",
"Search by Date" => "Търсене по дата",
"LastChanges" => "DerniersChangements",
"admin categories" => "администрация на категории",
// "admin categories tpl" => "admin categories tpl",
"browse the category system" => "разглеждане на системата категории",
"Child categories" => "Дъщерни категории",
"Edit this category:" => "Редакция на тази категория:",
"create new" => "създаване на нов/а",
"Add new category" => "Добавяне на нова категория",
"Perms inherited from closest parent if possible or from global perms" => "Правата се унаследяват от най-близката родителска категория (ако е възможно) или от глобалните права",
"Assign permissions automatically" => "Назначаване на позволения автоматично",
"recommended for best performance" => "препоръчвано за най-добра производителност",
"Edit permissions for this category" => "Редактиране на позволенията за тази категория",
"Objects in category" => "Обекти в категорията",
"Add objects to category" => "Добавяне на обкети към категорията",
"image gal" => "картинна галерия",
"file gal" => "файлова галерия",
"Search Stats" => "Статистики за търсене",
// "search stats tpl" => "search stats tpl",
// "searched" => "searched",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "За да добавите/премахнете FAQs, вижте за 'Администрация на FAQs' под 'FAQs' в менюто на приложението, или",
// "Message queue for" => "Message queue for",
"Edit queued message" => "Редактиране на чакащо съобщение",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
"summary" => "обобщение",
"save and approve" => "запазване и одобрение",
"convert to topic" => "превръщане в тема",
"no summary" => "без обобщение",
"reject" => "отказване",
"Show Category Path" => "Показване на път до категорията",
"Show Category Objects" => "Показване на обектите в категорията",
"Use rating" => "Използване на рейтинг",
"disable" => "деактивация",
"There is no available poll template." => "Няма наличен шаблон за анкети",
"You should ask an admin to create them." => "Трябва да помолите администратор да ги създаде",
"or use" => "или използвайте",
"an existing poll" => "съществуваща анкета",
"Case Insensitivity" => "Нечувствителност за малки и главни букви",
"replace" => "замяна",
"Import HTML" => "Импорт на HTML",
"Try to convert HTML to wiki" => "Опит за трансформация на HTML в Уики",
// "my tiki tpl" => "my tiki tpl",
"Last editor" => "Последен редактор",
"Last modification" => "Последна модификация",
"y" => "да",
"Admin Calendars" => "Администрация на календари",
"List of Calendars" => "Списък с календари",
"subscription" => "абонамент",
"Create/edit Calendars" => "Създаване/редакция на календари",
// "Custom Locations" => "Custom Locations",
// "Custom Participants" => "Custom Participants",
// "Custom Categories" => "Custom Categories",
// "Custom Languages" => "Custom Languages",
// "Custom Subscription List" => "Custom Subscription List",
// "Custom Priorities" => "Custom Priorities",
"Personal Calendar" => "Персонален календар",
"Moderator actions" => "Модераторски действия",
"Move to topic:" => "Преместване в тема:",
"reported:" => "докладван/и:",
"queued:" => "чакащи:",
"Posted messages" => "Публикувани съобщения",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
"Headers Only" => "Само заглавията",
"Sort" => "Сортиране",
// "Threshold" => "Threshold",
// "below your current threshold" => "below your current threshold",
"new reply" => "нов отговор",
"Editing reply" => "Редактиране на отговор",
"Reply to the selected post" => "Отговор на избраната публикация",
"Post new message" => "Публикуване на ново съобщение",
"Comment on the selected post" => "Коментар по избраната публикация",
"Post new comment" => "Публикуване на нов коментар",
"Reply" => "Отговор",
"Reply to parent post" => "Отговор на родителска публикация",
"Post new reply" => "Публикуване на нов отговор",
// "Posting replies" => "Posting replies",
"HTML tags are not allowed inside posts" => "HTML таговете не са позволени в публикациите",
"Stats for survey" => "Статистики за проучвания",
"Stats for this survey Questions " => "Статистики за въпросите на това проучване",
"Dynamic content system" => "Система с динамично съдържание",
"Help on Dynamic Content" => "Помощ по динамично съдържание",
// "admin DynamicContent tpl" => "admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
"create new block" => "създаване на нов блок",
"Available content blocks" => "Налични блокове със съдържание",
"Current ver" => "Текуща версия",
"Next ver" => "Следваща версия",
"Future vers" => "Бъдещи версии",
"Old vers" => "Стари версии",
"Program" => "Програма",
"List of attached files" => "Списък с прикачените файлове",
"Banner stats" => "Статистики на банерите",
"Create new banner" => "Създаване на нов банер",
"Banner Information" => "Информация за банер",
// "Click ratio" => "Click ratio",
"Weekdays" => "Дни от седмицата",
"mon" => "пон",
"tue" => "втр",
"wed" => "срд",
"thu" => "чет",
"fri" => "пет",
"sat" => "съб",
"sun" => "нед",
// "Banner raw data" => "Banner raw data",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Dumps" => "Dumps",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
"Wiki Comments Settings" => "Настройки на коментарите в уикито",
"Export Wiki Pages" => "Експорт на уики страници",
"Wiki Administration" => "Уики администрация",
"Manage attachment preferences" => "Управление на предпочитанията за прикачените файлове",
"Remove unused pictures" => "Премахване на неизползвани изображения",
"Wiki Home Page" => "Уики начална страница",
"Wiki Discussion" => "Уики дискусия",
"Discuss pages on forums" => "Страници за дискусия във форума",
"Wiki Link Format" => "Формат на линковете в уикито",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
"complete" => "завършен",
"english" => "анлийски",
"Wiki Page List Configuration" => "Конфигурация за показване на списъка с уики страници",
"Last version" => "Последна версия",
"Categories path" => "Път на категориите",
"Wiki 3D Browser Configuration" => "Конфигурация на Wiki 3D Browser",
"Enable wiki 3D browser" => "Активиране на Wiki 3D Browser",
"Browser width" => "Широчина на браузъра",
"Browser height" => "Височина на браузъра",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Node size" => "Node size",
"Text size" => "Размер на текста",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
"HTML in Wiki Pages" => "HTML в уики страници",
"Wiki syntax used when a page contains HTML" => "Уики синтаксис, който се използва когато страницта съдържаHTML",
// "full" => "full",
// "partial" => "partial",
"Wysiwyg editor" => "WYSIWYG редактор",
"optional" => "незадължителен",
"Wiki Features" => "Уики функции",
"Anonymous editors must input anti-bot code" => "Анонимните редактори трябва да попълнят анти-бот код",
"Similar" => "Подобен",
"Undo" => "Undo",
"MultiPrint" => "MultiPrint",
"PDF generation" => "Генериране на PDF",
"Warn on edit conflict" => "Предупреждение при конфликт по време на редакция",
// "Edit idle timeout" => "Edit idle timeout",
"Pictures" => "Изображения",
"Use page description" => "Използване на описание за страница",
"Show page title" => "Показване на заглавието на страницата",
"Show page ID" => "Показване номера на страницата",
"Cache wiki pages (global)" => "Кеширане на уики страници (глобално)",
"Individual cache" => "Индивидуален кеш",
// "Footnotes" => "Footnotes",
"Users can lock pages (if perm)" => "Потребителите могат да заключват страници (ако имат права)",
// "Use WikiWords" => "Use WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Automonospaced text" => "Automonospaced text",
// "Tables syntax" => "Tables syntax",
"|| for rows" => "|| за редs",
"\\n for rows" => "\\n за ред",
// "Open page as structure" => "Open page as structure",
"Use external link icons" => "Използване на икони за външни линкове",
"User's Page" => "Потребителска страница",
// "UserPage prefix" => "UserPage prefix",
"Page creators are admin of their pages" => "Създателите на страници са и техни администратори",
"List authors" => "Списък с автори",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
"Business style" => "Бизнес стил",
// "Collaborative style" => "Collaborative style",
"no (disabled)" => "не (деактивиран/о)",
"Print Page" => "Принтиране на страница",
"Wiki History" => "Wiki история",
"Maximum number of versions for history" => "Максимален брой версии за историята",
"unlimited" => "без лимит",
"Never delete versions younger than days" => "Никога не трий версии по-млади от дни",
"IP not displayed in history" => "IP не се показва в историята",
// "Diff style" => "Diff style",
"Only with last version" => "Само с последната версия",
"Any 2 versions" => "Които и да е две версии",
// "History only for data, description, comment change" => "History only for data, description, comment change",
"Copyright Management" => "Управление на авторските права",
"Enable Feature" => "Активиране на функция",
"License Page" => "Лицензиране на страница",
"Submit Notice" => "Предлагане на забележка",
// "Wiki Watch" => "Wiki Watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "Current URL" => "Current URL",
"Command" => "Команда",
// "exec" => "exec",
// "Type <code>help</code> to get list of available commands" => "Type <code>help</code> to get list of available commands",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Пощенската кутия е пълна! Изтрийте или архивирайте някои съобщения ако искате да можете да получавате нови.",
"reply to" => "отговор на",
"find replied message" => "намиране на съобщения на които е отговорено",
"Tiki integrator" => "Tiki интегратор",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
"Edit Repository:" => "Редакция на хранилище:",
// "Create New Repository" => "Create New Repository",
// "new repository" => "new repository",
"view repository" => "разглеждане на хранилище",
"Human readable repository name" => "Четимо за хора име на хранилището",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
"Start page" => "Стартова страница",
"CSS file to load when browse this repository" => "Файл на CSS, който да се зареди когато се браузва това хранилище",
"CSS file" => "CSS файл",
"Is repository visible to users" => "Хранилището видимо ли е за потребители",
"Can files from repository be cached" => "Могат ли файове от хранилището да се кешират",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
"Clear all cached pages of this repository" => "Изчистване на всички кеширани страници от това хранилище",
"Clear cache" => "Изчистване на кеш",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
"Human readable text description of repository" => "Описание на хранилището чрез четим за хора код",
"CSS File" => "CSS Файл",
"Edit rules" => "Редактиране на правила",
"Help on Banning System" => "Помощ по системата за банване",
// "admin banning tpl" => "admin banning tpl",
"Add or edit a rule" => "Добавяне/редакция на правило",
"Rule title" => "Заглавие на правило",
// "Username regex matching" => "Username regex matching",
// "IP regex matching" => "IP regex matching",
// "Banned from sections" => "Banned from sections",
// "check / uncheck all" => "check / uncheck all",
// "Rule activated by dates" => "Rule activated by dates",
"Rule active from" => "Правилото валидно от",
"Rule active until" => "Правилото валидно до",
"Custom message to the user" => "Съобщение до потребител",
"Rules" => "Правила",
"User/IP" => "Потребител/IP",
"Select Graphic Type" => "Избиране на тип на графиката",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
"Landscape" => "Пейзаж",
// "Independant Scale" => "Independant Scale",
"Horizontal Scale" => "Хоризонтална скала",
// "Bottom" => "Bottom",
"Vertical Scale" => "Вертикална скала",
"Left" => "Ляв/а",
"Right" => "Десен/дясна",
// "Series" => "Series",
// "User_versions_for" => "User_versions_for",
"Select news group" => "Избор на новинарска група",
"Item information" => "Информация за елемента",
// "Chart" => "Chart",
"Permanency" => "Постоянство",
"Best Position" => "Най-добра позиция",
"Vote this item" => "Гласуване за този елемент",
// "Highest" => "Highest",
// "Assign permissions to page" => "Assign permissions to page",
"Current permissions for this page" => "Сегашни позволения за тази страница",
"remove from this page" => "премахване от тази страница",
"remove from this structure" => "премахване от тази структура",
"No individual permissions; category or global permissions apply" => "Няма индивидуални позволения; в сила са позволенията за категорията или глобалните такива",
"this page" => "тази страница",
"this structure" => "тази структура",
"Current permissions for categories that this page belongs to" => "Сегашни позволения за категориите към които принадлежи тази страница",
"No category permissions; global permissions apply" => "Няма настроени позволения за категорията - в сила са глобалните такива",
"Send email notifications when this page changes to" => "Изпращане на известие по и-мейл когато тази страница се промени на",
"add email" => "добавяне на и-мейл",
// "galleries tpl" => "galleries tpl",
// "rebuild cache" => "rebuild cache",
"Create a gallery" => "Създаване на галерия",
"Edit this gallery:" => "Модифициране на тази галерия:",
"There are individual permissions set for this gallery" => "Има индивидуални позволения, настроени за тази галерия",
"Geographic" => "Географски",
"Images per row" => "Изображения на ред",
"Thumbnails size X" => "Размер X на малките картинки (thumbnail)",
"Thumbnails size Y" => "Размер Y на малките картинки (thumbnail)",
"Default sort order" => "Сортиране по подразбиране според",
"Fields to show during browsing the gallery" => "Полета, които да се показват при разглеждане на галерията",
"XY-Size" => "XY-Размер",
"Gallery Image" => "Снимка на галерията",
"Parent gallery" => "Родителска галерия",
"Available scales" => "Налични размери",
"Bounding box" => "Рамка",
"default scale" => "Оригинален размер",
"No scales available" => "Не са налични размери",
"Original image is default scale" => "Оригиналното изображение е размера по подразбиране",
"Add scaled images with bounding box of square size" => "Показване на изображението уголемено/намалено до квадратна рамка със страна",
"Owner of the gallery" => "Собственик на галерията",
"Other users can upload images to this gallery" => "Други потребители могат да качват изображения в тази галерия",
"You can access the gallery using the following URL" => "Можете да посещавате галерията използвайки следния адрес",
"Available Galleries" => "Налични галерии",
"Make Map" => "Създаване на карта",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
"Validate choice" => "Валидиране на избора",
// "Trackers attachments" => "Trackers attachments",
"Edit Image" => "Модифициране на изображение",
"browse image" => "разглеждане на изображение",
"Edit successful!" => "Редакцията е успешна!",
"The following image was successfully edited" => "Следното изображение бе успешно редактирано",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Scale" => "Scale",
"Zoom out x4" => "Отдалечаване x4",
"Zoom out x3" => "Отдалечаване x3",
"Zoom out x2" => "Отдалечаване x2",
"Query" => "Заявка",
"Zoom in x2" => "Приближаване x2",
"Zoom in x3" => "Приближаване x3",
"Zoom in x4" => "Приближаване x4",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
"Go" => "OK",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
"Legend" => "Легенда",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
"hits last 7 days" => "посещения през последните 7 дни",
"monitor this map" => "наблюдение на тази карта",
"stop monitoring this map" => "спиране на наблюдението на тази карта",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
"Reload" => "Презареждане",
"You can view this map in your browser using" => "Можете да посещавате тази карта, като използвате",
// "Mapfile History" => "Mapfile History",
// "back to" => "back to",
"Upload From Disk:" => "Качване от диск:",
"Upload Files" => "Качване на файлове",
// "Bytes maximum" => "Bytes maximum",
"Create Directory:" => "Създаване на директория:",
"Create" => "Създаване",
"index file (.shp):" => "Индекс файл (.shp):",
"files to index (regexp):" => "файлове за индексиране (regexp):",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from\nthe mapfile:" => "from\nthe mapfile:",
"Here are the files to download, do not forget to rename them:" => "Тук са файловете за сваляне. Не забравяйте да ги преименувате:",
"Modify Structure" => "Модифициране на структура",
"You will remove" => "Вие ще премахнете",
"and its subpages from the structure, now you have two options:" => "и неините подстраници от структурата, сега имате две възможности:",
"Remove only from structure" => "Премахване само от структурата",
"Remove from structure and remove page too" => "Премахване от структурата и изтриване на страницата",
// "Current Node" => "Current Node",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Add pages to current node" => "Add pages to current node",
"After page" => "След страницата",
"create page" => "създаване на страница",
"Use pre-existing page" => "Използване на съществуваща от преди страница",
// "Structure Layout" => "Structure Layout",
// "monitor workitems" => "monitor workitems",
// "Admin directory categories" => "Admin directory categories",
// "admin directory categories tpl" => "admin directory categories tpl",
// "Add a directory category" => "Add a directory category",
// "Edit this directory category" => "Edit this directory category",
// "Children type" => "Children type",
"Most visited sub-categories" => "Най-посещавани подкатегории",
"Category description" => "Описание на категорията",
"Random sub-categories" => "Случайни подкатегории",
// "Maximum number of children to show" => "Maximum number of children to show",
"Allow sites in this category" => "Allow sites in this category",
"Show number of sites in this category" => "Показване на броя сайтове в тази категория",
"Editor group" => "Добавяне на група",
"Subcategories" => "Подкатегории",
"allow" => "позволяване",
"count" => "брой",
"editor" => "редактор",
// "relate" => "relate",
"Pages like" => "Страници като",
"No pages found" => "Не са открити страници",
// "Create WebHelp" => "Create WebHelp",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
"Top page" => "Топ страница",
// "first" => "first",
// "admin cache tpl" => "admin cache tpl",
"edit user files" => "редактиране на потребителски файлове",
"Users &amp; groups" => "Потребители &amp; групи",
"User registration and login" => "Потребителска регистрация и логин",
"Authentication method" => "Метод за автентикация",
"Just Tiki" => "Само Tiki",
"Web Server" => "Уеб сървър",
"Tiki and PEAR::Auth" => "Tiki и PEAR::Auth",
"Tiki and PAM" => "Tiki и PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Tiki and HTTP Auth" => "Tiki and HTTP Auth",
// "Use WebServer authentication for Tiki" => "Use WebServer authentication for Tiki",
"Users can register" => "Потребителите могат да се регистрират",
"... but need admin validation" => "... но се нуждаят от администраторско одобрение",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
"Create a group for each user <br />(with the same\nname as the user)" => "Създаване на група за всеки потребител<br />(със същото име като потребителя)",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
"Request passcode to register" => "Изискване на пас-код за регистрация",
"Prevent automatic/robot registration" => "Предотвратяване на автоматично/роботско регистриране",
" - Php GD library required" => " - изисква се PHP GD библиотека",
"Validate users by email" => "Валидиране на потребители по и-мейл",
"Validate email address (may not work)" => "Валидиране на и-мейл адрес (може да не работи)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
"Users accept internal messages by default" => "Потребителите приемат вътрешни съобщения по подразбиране",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
"Store plaintext passwords" => "Съхраняване на пароли като обикновен текст",
"Reg users can change password" => "Регистрираните потребители могат да си сменят паролата",
"Reg users can change theme" => "Регистрираните потребители мотат да си сменят темата на сайта",
"Restrict available themes" => "Ограничаване на наличните теми",
"Available styles:" => "Налични стилове:",
"Maximum mailbox size (messages, 0=unlimited)" => "Максимален размер на пощенската кутия (съобщения, 0=без лимит)",
"Maximum mail archive size (messages, 0=unlimited)" => "Максимален размер на пощенския архив (съобщения, 0=без лимит)",
"Maximum sent box size (messages, 0=unlimited)" => "Максимален размер на кутията с изпратени съобщения (съобщения, 0=без лимит)",
// "Use challenge/response authentication" => "Use challenge/response authentication",
"Force to use chars and nums in passwords" => "Задължително използване на букви и цифри в паролата",
"Minimum password length" => "Минимална дължина на паролата",
"Password invalid after days" => "Паролата невалидна след дни",
// "Require HTTP Basic authentication" => "Require HTTP Basic authentication",
"Allow secure (https) login" => "Позволяване на сигурна връзка при вход в системата (HTTPS)",
"Require secure (https) login" => "Изискване на сигурна връзка при вход в системата (HTTPS)",
"HTTP server name" => "Име на HTTP сървър",
"HTTP port" => "HTTP порт",
// "HTTP URL prefix" => "HTTP URL prefix",
"HTTPS server name" => "Име на HTTPS сървър",
"HTTPS port" => "HTTPS порт",
// "HTTPS URL prefix" => "HTTPS URL prefix",
"Remember me feature" => "Функция 'запомни ме'",
"Only for users" => "Само за потребители",
"Users and admins" => "Потребители и администратори",
"Duration:" => "Времетраене:",
"year" => "година",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
"choose a group ..." => "избор на група...",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "Create user if not in Tiki?" => "Create user if not in Tiki?",
// "Create user if not in Auth?" => "Create user if not in Auth?",
// "Just use Tiki auth for admin?" => "Just use Tiki auth for admin?",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "LDAP Scope" => "LDAP Scope",
// "LDAP Base DN" => "LDAP Base DN",
// "LDAP User DN" => "LDAP User DN",
// "LDAP User Attribute" => "LDAP User Attribute",
// "LDAP User OC" => "LDAP User OC",
// "LDAP Group DN" => "LDAP Group DN",
// "LDAP Group Attribute" => "LDAP Group Attribute",
// "LDAP Group OC" => "LDAP Group OC",
// "LDAP Member Attribute" => "LDAP Member Attribute",
// "LDAP Member Is DN" => "LDAP Member Is DN",
// "LDAP Admin User" => "LDAP Admin User",
// "LDAP Admin Pwd" => "LDAP Admin Pwd",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
"Currently unused" => "В момента не се използва",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
"in entire directory" => "в цялата директория",
"in current category" => "в сегашната директория",
"sort" => "сортиране",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "За да добавите/премахнете файлови галерии, отидете на 'Файлови галерии' в менюто на приложението, или",
"Allow same file to be uploaded more than once" => "Позволяване един и същи файл да бъде качван повече от веднъж",
"Uploaded filenames must match regex" => "Имената на качените файлове трябва да съвпадат с regex",
"Uploaded filenames cannot match regex" => "Имената на качените файлове не трябва да съвпадат с regex",
"Storing files in a directory" => "Сортиране на файлове в директория",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Ако решите да съхранявате файловете в директория, трябва да се уверите, че потребителят не може да достигне директно до тази директория",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "За да конфигурирате пътя към директорията използвайте UNIX подобен синтаксис, например: files/ или c:/foo/files или /www/files/",
"please read" => "моля, прочетете",
"File galleries comments settings" => "Настройки за коментарите във файловите галерии",
"File galleries search indexing" => "Индексиране на файловите галерии за търсене",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
"Enable auto indexing on file upload or change" => "Активиране на авто индексиране при качване или промяна на файл",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
"Reindex all files for search" => "Реиндексиране на всички файлове за търсене",
"Welcome to the Tiki Chat Rooms" => "Добре дошли в Чат стаите на Тики",
"Please select a chat channel" => "Моля, изберете чат канал",
"enter chat room" => "влизане в чат стая",
"There are no channels setup, please contact a site admin" => "Няма настроени никакви канали. Моля, свържете се с администратор на сайта",
"admin users" => "администрация на потребители",
// "admin users template" => "admin users template",
"Add a new user" => "Добавяне на нов потребител",
"Added users" => "Добавени потребители",
"Rejected users" => "Отказани потребители",
"Edit user" => "Редакция на потребител",
"edit account settings" => "редакция на настройките на акаунта",
"edit included group" => "редакция на включената група",
// "Perform action with checked:" => "Perform action with checked:",
"remove users and their userpages" => "премахване на потребители и техните потребителски страници",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
"Remove selected from" => "Премахване на избраните от",
"the following groups:" => "следните групи:",
"Set the default group of the selected users to" => "Настройване на групата по подразбиране на избраните потребители на",
// "assign to groups" => "assign to groups",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Предупреждение: промяната на името на потребителя ще го задължи да си смени паролата и ще предизвика бъркотия в slave intertiki сайтове, които използват този за master",
"Warning: changing the username will require the user to change his password" => "Предупреждение: промяната на името на потребителя ще го задължи да си промени паролата",
"Pass" => "Парола",
"Again" => "Отново",
"Registration" => "Регистрация",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "Overwrite" => "Overwrite",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
"Admin templates" => "Администрация на шаблони",
// "admin content templates template" => "admin content templates template",
"Edit this template:" => "Редакция на този шаблон:",
"Create new template" => "Създаване на нов шаблон",
"use in cms" => "използване в cms",
"use in wiki" => "използване в уики",
"use in newsletters" => "използване в новинарските емисии",
"use in events" => "използване в събития",
"use in HTML pages" => "използване в HTML страници",
"Templates" => "Шаблони",
// "Apply content template" => "Apply content template",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
"<b>Feed</b>" => "<b>Емисия</b>",
"<b>enable/disable</b>" => "<b>активиране/деактивиране</b>",
"<b>Max number of items</b>" => "<b>Максимален брой елементи</b>",
"Feed for Articles" => "Емисия за статии",
"Feed for Weblogs" => "Емисия за блогове",
"Feed for Image Galleries" => "Емисия за картинни галерии",
"Feed for File Galleries" => "Емисия за файлови галерии",
"Feed for the Wiki" => "Емисия за Уики",
"Feed for individual Image Galleries" => "Емисия за индивидуални картинни галерии",
"Feed for individual File Galleries" => "Емисия за индивидуални файлови галерии",
"Feed for individual weblogs" => "Емисия за индивидуални уеблогове",
"Feed for forums" => "Емисия за форуми",
"Feed for individual forums" => "Емисия за индивидуални форуми",
// "Feed for mapfiles" => "Feed for mapfiles",
"Feed for directories" => "Емисия за директории",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
"Feed for upcoming calendar events" => "Емисия за наближаващи събития в календара",
// "Default RDF version" => "Default RDF version",
"Specification" => "Спецификация",
"Editor" => "Редактор",
"Webmaster" => "Уебмастър",
// "Caching time :" => "Caching time :",
"seconds (0 = cache inactive)" => "секунди (0 = кеша е неактивен)",
"Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Активирайте кеширането само ако цялото съдържание разпространявано по RSS е публично (видимо за всеки) или може да изтекат частни документи. Кеширането игнорира съществуващите позволения",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
"Header Rows" => "Заглавни редове",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
"Theme Control Center: sections" => "Център за контрол на темата: секции",
// "theme control sections tpl" => "theme control sections tpl",
// "Assign themes to sections" => "Assign themes to sections",
// "Assigned sections" => "Assigned sections",
"Directory ranking" => "Ранглиста на директориите",
"Chat started" => "Чатът е стартиран",
"User:" => "Потребител:",
"Operator:" => "Оператор:",
// "Map process roles" => "Map process roles",
"admin processes" => "администрация на процеси",
"admin activities" => "администрация на дейности",
"admin roles" => "администрация на роли",
"edit this process" => "редактиране на този процес",
"Process:" => "Процес:",
"add item" => "добавяне на елемент",
"Edit/Create" => "Редакция/Създаване",
"Date Selector" => "Избор на дата",
"click to navigate" => "кликнете за навигация",
"Focus:" => "Фокус:",
"change focus" => "промяна на фокус",
"quarter" => "тримесечие",
"semester" => "шестмесечие",
"calendar view" => "изглед като календар",
"list view" => "изглед като списък",
"Group Calendars" => "Групиране на календари",
// "Tools Calendars" => "Tools Calendars",
// "Help on Drawings" => "Help on Drawings",
// "admin Drawings tpl" => "admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
"Available drawings" => "Налични рисунки",
// "Admin DSN" => "Admin DSN",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Create/edit dsn" => "Create/edit dsn",
// "dsn" => "dsn",
"No backlinks to this page" => "Няма обратни връзки към тази страница",
// "view faq tpl" => "view faq tpl",
// "admin menus tpl" => "admin menus tpl",
"Answers" => "Отговори",
"A" => "О",
"add suggestion" => "добавяне на предложение",
"Program dynamic content for block" => "Програмиране на динамично съдържание за блок",
// "Return to block listing" => "Return to block listing",
"Block description: " => "Описание на блок: ",
"Create or edit content" => "Създаване или редактиране на съдържание",
"You are editing block:" => "Вие редактирате блок:",
"Publishing Date" => "Дата на публикация",
// "Admin ephemerides" => "Admin ephemerides",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "All ephemerides" => "All ephemerides",
"Browse" => "Разглеждане",
// "list trackers tpl" => "list trackers tpl",
// "Admin Directory Sites" => "Admin Directory Sites",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
"Delete selected" => "Изтриване на избраните",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "routing" => "routing",
"Edit a topic" => "Редакция на тема",
// "Admin instance" => "Admin instance",
// "Send all to" => "Send all to",
// "Don't move" => "Don't move",
// "Act status" => "Act status",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Add property" => "Add property",
"value" => "стойност",
// "Tiki site registered" => "Tiki site registered",
"You don't have permission to use this feature." => "Нямате позволение да използвате тази функция",
"Please register." => "Моля, регистрирайте се",
"Read this first!" => "Първо прочетете това!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
"Registering is voluntary." => "Регистрацията е по желание",
"Registering does not give you any benefits except one more link to your site." => "Регистрацията не ви дава други облаги освен още една връзка към вашия сайт",
"You don't get any emails, we don't sell the data about your site." => "Няма да получавате никакви и-мейли, ние не продаваме информацията за вашия сайт",
"Registering is just for us to get an overview of Tiki's usage." => "Регистрацията е просто един реверанс към нас, за да имаме добра представа за употребата на Тики",
"If your site is private or inside your intranet, you should not register!" => "Ако вашият сайт не е публичен, или ако е вътре във вашата интранет мрежа (не е достъпен в www), не е редно да се регистрирате!",
"Information about your site" => "Информация за вашия сайт",
" unread private messages" => " непрочетени лични съобщения",
"prev topic" => "предишна тема",
"next topic" => "следваща тема",
"posts:" => "публикации:",
"monitor this topic" => "проследяване на тази тема",
"stop monitoring this topic" => "спиране на проследяването на тази тема",
// "Comments below your current threshold" => "Comments below your current threshold",
// "list faqs tpl" => "list faqs tpl",
"Edit this FAQ:" => "Редактиране на този FAQ:",
"Create new FAQ" => "Създаване на нов FAQ",
"Create New FAQ:" => "Създаване на нов FAQ:",
"Users can suggest questions" => "Потребителите могат да предлагат въпроси",
"Available FAQs" => "Налични FAQs",
// "Executed" => "Executed",
"Pop-up" => "Изскачащ прозорец",
"erase" => "изтриване",
// "Admin chart items" => "Admin chart items",
// "charts" => "charts",
// "Chart items" => "Chart items",
"No items defined yet" => "Все още няма дефинирани елементи",
"News from" => "Новини от",
// "Save position" => "Save position",
// "No galleryId specified" => "No galleryId specified",
"Tiki RSS feed for the image gallery: " => "RSS емисия за картинната галерия: ",
"No pages indicated" => "Не са посочени страници",
"No more messages" => "Няма съобщения",
"You cannot have a blank password" => "Не можете да имате празна парола",
"Your admin password has been changed" => "Вашата администраторска парола бе променена",
// "DATE-of" => "DATE-of",
"Error Message" => "Съобщение за грешка",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
"Tiki RSS feed for forums" => "Тики RSS емисия за форумите",
"Last topics in forums." => "Последни теми във форумите.",
// "Invalid server key" => "Invalid server key",
// "No chart indicated" => "No chart indicated",
"Permission denied you cannot remove articles" => "Достъпът отказан: нямате право да премахвате статии",
"You cannot mix old and new trackers" => "Не можете да смесвате стари и нови тракъри",
"The copyright management feature is not enabled." => "Функцията за управление на авторски права не е активирана",
"You do not have permission to use this feature." => "Нямате право да използвате тази функция.",
"You must supply all the information, including title and year." => "Трябва да подадете цялата информация, включително заглавие и година",
"Tiki RSS feed for weblogs" => "RSS емисия за уеблоговете",
"Last posts to weblogs." => "Последни публикации в уеблоговете",
"Role name cannot be empty" => "Името на ролята не може да бъде празно",
"Activity name cannot be empty" => "Името на действието не може да бъде празно",
"Activity name already exists" => "Името на дейността вече съществува",
"Permission denied you cannot remove submissions" => "Достъп отказан: нямате право да премахвате предложения",
"Permission denied you cannot approve submissions" => "Достъп отказан: нямате право да одобрявате предложения",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
"Permission denied you cannot rename this page" => "Достъп отказан: нямате право да преименувате тази страница",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
"Cannot rename page maybe new page already exists" => "Невъзможност за преименуване на страница. Може би новата страница вече съществува",
"No repository given" => "Не е посочено хранилище",
// "created from notepad" => "created from notepad",
"No name indicated for wiki page" => "Не е посочено име за уики страницата",
"Page already exists" => "Страницата вече съществува",
"Click here to delete this category" => "Кликнете тук за да изтриете тази категория",
"You can not create a category with a name already existing at this level" => "Не можете да създадете категория с име, което вече съществува на това ниво.",
"Category can`t be parent of itself" => "Категорията не може сама да си бъде родителска",
"No forumId specified" => "Не е посочен номер на форум",
"Tiki RSS feed for forum: " => "Тики RSS емисия за форум: ",
"Message sent to" => "Съобщението изпратено на",
"You are not logged in and no user indicated" => "Не сте влезли в системата и не е посочен потребител",
"The user has chosen to make his information private" => "Потребителят е избрал да си направи информацията частна",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
"Your PHP installation does not have zlib enabled." => "Вашата PHP инсталация не разполага със zlib",
"empty" => "празен",
"No trackerId specified" => "Не е посочен номер на тракър",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
// "Cannot get messages" => "Cannot get messages",
"No result indicated" => "Не е посочен резултат",
"Missing title or body when trying to post a comment" => "Липсва заглавие или тяло при опита за публикация на коментар",
"You cannot take this quiz twice" => "Нямате право да решите този тест два пъти",
"Quiz time limit exceeded quiz cannot be computed" => "Времевият лимит за решаване на теста е просрочен. Резултатът ви не може да бъде изчислен",
"Invalid request to edit an image" => "Невалидна заявка за редакция на изображение",
"Permission denied you cannot edit images" => "Достъпът отказан: нямате право да редактирате съобщения",
"Permission denied you can edit images but not in this gallery" => "Достъп отказан: имате право да редактирате изображения, но не и в тази директория",
"Failed to edit the image" => "Провал при опита за редакция на изображение",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
"Invalid password.  Your current password is required to change administrative information" => "Невалидна парола. Трябва да предоставите сегашната си парола за да промените административната информация",
"Email is set to %s" => "И-мейл адресът е както следва: %s",
"The passwords did not match" => "Паролата в двете полета не съвпадна",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
"Sorry, you can't use this feature." => "Съжалявам, не можете да използвате тази функция",
"No question indicated" => "Не е посочен въпрос",
"You cannot take this survey twice" => "Не можете да участвате в проучването два пъти",
"ERROR: you must include a subject or a message at least" => "ГРЕШКА: трябва да въведете тема или съобщение",
// "Your email address has been removed from the list of addresses monitoring this tracker" => "Your email address has been removed from the list of addresses monitoring this tracker",
// "Your email address has been added to the list of addresses monitoring this tracker" => "Your email address has been added to the list of addresses monitoring this tracker",
"Tiki RSS feed for the file gallery: " => "RSS емисия за файловата галерия: ",
"No blogId specified" => "Не е посочен номер на блог",
"Tiki RSS feed for blog: " => "Тики RSS емисия за блог: ",
"moved %d images, %d errors occured." => "%d изображения преместени, възникнаха %d грешки.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
"Non-existent gallery" => "Несъществуваща галерия",
"Permission denied you cannot remove files from this gallery" => "Достъп отказан: нямате право да премахвате файлове от тази галерия",
"Permission denied you can't upload files so you can't edit them" => "Достъп отказан: нямате права за качване на файлове, следователно нямате права и да ги редактирате",
"Permission denied you cannot edit this file" => "Достъпът отказан: нямате право да редактирате този файл",
// "Algeria" => "Algeria",
// "American_Samoa" => "American_Samoa",
// "Angola" => "Angola",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Bermuda" => "Bermuda",
// "Bolivia" => "Bolivia",
// "Brazil" => "Brazil",
// "Brunei" => "Brunei",
// "Canada" => "Canada",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Colombia" => "Colombia",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El_Salvador" => "El_Salvador",
// "Estonia" => "Estonia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French_Polynesia" => "French_Polynesia",
// "Germany" => "Germany",
// "Greece" => "Greece",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Haiti" => "Haiti",
// "Honduras" => "Honduras",
// "Hungary" => "Hungary",
// "Chile" => "Chile",
// "China" => "China",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Malta" => "Malta",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mexico" => "Mexico",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "None" => "None",
// "Norway" => "Norway",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
"Bulgaria" => "България",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Finnish" => "Finnish",
// "French" => "French",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
"###end###"=>"###end###");
?>