__doc__='''Logger Initialization
$Id: __init__.py,v 1.3 2002/04/22 04:28:34 zen Exp $'''
__version__='$Revision: 1.3 $'[11:-2]

import os,os.path,stat
import Logger
from HelpSys.HelpTopic import STXTopic
from DateTime import DateTime

def initialize(context):
    help_path = os.path.join(os.path.dirname(__file__),'README.txt')

    help = context.getProductHelp()
    try:
        if help.lastRegistered is not None and \
            help.lastRegistered >= DateTime(os.stat(help_path)[stat.ST_MTIME]):
                return
    except AttributeError:
        pass

    try:
        help._delObject('Logger')
    except AttributeError:
        pass

    help.lastRegistered = DateTime()
    context.registerHelpTopic('Logger',
        STXTopic('Logger','dtml-log tag',help_path,
            categories=('DTML Programmer Information')))

