/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.PLSchemaException;
import ca.sqlpower.util.Version;
import ca.sqlpower.util.VersionFormatException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DefaultParameters {
    private Map params;

    public DefaultParameters(Connection con) throws SQLException, PLSchemaException {
        this(con, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultParameters(Connection con, String plCatalog, String plSchema) throws SQLException, PLSchemaException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        if (plCatalog != null) {
            sql.append(plCatalog).append(".");
        }
        if (plSchema != null) {
            sql.append(plSchema).append(".");
        }
        sql.append("DEF_PARAM");
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql.toString());
            if (!rs.next()) {
                throw new PLSchemaException("There are no rows in DEF_PARAM?!");
            }
            this.params = new HashMap();
            ResultSetMetaData rsmd = rs.getMetaData();
            int ncols = rsmd.getColumnCount();
            for (int col = 1; col <= ncols; ++col) {
                this.params.put(rsmd.getColumnName(col).toLowerCase(), rs.getString(col));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String get(String paramName) {
        String lcParamName = paramName.toLowerCase();
        if (!this.params.containsKey(lcParamName)) {
            throw new IllegalArgumentException("DEF_PARAM version " + this.params.get("SCHEMA_VERSION") + " doesn't have the parameter " + paramName);
        }
        return (String)this.params.get(paramName.toLowerCase());
    }

    public String getEmailReturnAddress() {
        return this.get("email_notification_return_adrs");
    }

    public String getEmailServerName() {
        return this.get("mail_server_name");
    }

    public Version getPLSchemaVersion() throws VersionFormatException {
        Version v = new Version();
        v.setVersion(this.get("schema_version"));
        return v;
    }
}

