/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util.table;

import ca.sqlpower.util.table.CleanupTableModel;
import ca.sqlpower.util.table.TableTextConverter;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class EditableJTable
extends JTable
implements TableTextConverter {
    private static final Logger logger = Logger.getLogger(EditableJTable.class);

    public EditableJTable() {
        this(null);
    }

    public EditableJTable(TableModel model) {
        super(model);
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.setTableHeader(this.createDefaultTableHeader());
    }

    public void removeNotify() {
        super.removeNotify();
        logger.debug((Object)"Table removed from hierarchy.  Cleaning up model...");
        if (this.getModel() instanceof CleanupTableModel) {
            ((CleanupTableModel)((Object)this.getModel())).cleanup();
        }
    }

    public void columnMarginChanged(ChangeEvent pE) {
        if (this.getEditingColumn() != -1 || this.getEditingRow() != -1) {
            this.editCellAt(0, 0);
        }
        super.columnMarginChanged(pE);
    }

    public String getTextForCell(int row, int col) {
        Object o = this.getValueAt(row, col);
        if (o != null) {
            return o.toString();
        }
        return "N/A";
    }

    public int modelIndex(int viewIndex) {
        return viewIndex;
    }

    public void setModel(TableModel dataModel) {
        logger.debug((Object)("Table Model change for EditableJTable " + this + ". Old model: " + this.getModel() + " new model: " + dataModel));
        super.setModel(dataModel);
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        logger.debug((Object)("Table Selection Model change for EditableJTable " + this + ". Old model: " + this.getSelectionModel() + " new model: " + newModel));
        super.setSelectionModel(newModel);
    }

    public TableCellEditor getCellEditor() {
        TableCellEditor editor = super.getCellEditor();
        logger.debug((Object)("EditableJTable.getCellEditor(): returning " + editor));
        return editor;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor returnVal = super.getCellEditor(row, column);
        logger.debug((Object)("EditableJTable.getCellEditor(" + row + "," + column + "): returning " + returnVal + " (tableColumn.getCellEditor()=" + tableColumn.getCellEditor() + ")"));
        return returnVal;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private int preferredHeight;
            {
                this.preferredHeight = -1;
            }

            private Component getHeaderRenderer(int columnIndex) {
                TableColumn aColumn = this.getColumnModel().getColumn(columnIndex);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    renderer = this.getDefaultRenderer();
                }
                return renderer.getTableCellRendererComponent(this.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
            }

            private int getPreferredHeight() {
                if (this.preferredHeight == -1) {
                    this.preferredHeight = 0;
                    TableColumnModel columnModel = this.getColumnModel();
                    for (int column = 0; column < columnModel.getColumnCount(); ++column) {
                        Component comp = this.getHeaderRenderer(column);
                        int rendererHeight = comp.getPreferredSize().height;
                        this.preferredHeight = Math.max(this.preferredHeight, rendererHeight);
                    }
                }
                return this.preferredHeight;
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, this.getPreferredHeight());
            }

            public void columnAdded(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnAdded(e);
            }

            public void columnRemoved(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnRemoved(e);
            }
        };
    }
}

