/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AboutPanel
extends JPanel
implements ArchitectPanel {
    public JLabel content;

    public AboutPanel() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("About", this.initAboutTab());
        tabs.add("System Properties", new JScrollPane(this.initSysPropsTab()));
        tabs.setSelectedIndex(0);
        this.add(tabs);
    }

    private JComponent initAboutTab() {
        JPanel pan = new JPanel();
        pan.setLayout(new FlowLayout());
        String realPath = "/icons/architect128.png";
        URL imgURL = ASUtils.class.getResource(realPath);
        if (imgURL != null) {
            ImageIcon imageIcon = new ImageIcon(imgURL, "Architect Logo");
            pan.add(new JLabel(imageIcon));
        }
        this.content = new JLabel("<html>Power*Architect 1.0.0<br><br>Copyright 2003-2006 SQL Power Group Inc.<br></html>");
        pan.add(this.content);
        return pan;
    }

    private JComponent initSysPropsTab() {
        JTable table = new JTable(new SystemPropertiesTableModel());
        table.getColumnModel().getColumn(0).setMinWidth(200);
        table.getColumnModel().getColumn(1).setMinWidth(2000);
        table.setSize(table.getPreferredSize());
        return table;
    }

    public boolean applyChanges() {
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this;
    }

    private class SystemPropertiesTableModel
    extends AbstractTableModel {
        private Properties props = System.getProperties();
        private String[] keys = this.props.keySet().toArray(new String[0]);

        SystemPropertiesTableModel() {
            Arrays.sort(this.keys);
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.keys[row];
                }
                case 1: {
                    return this.props.get(this.keys[row]);
                }
            }
            throw new IllegalArgumentException("Column count");
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IllegalArgumentException("Column count");
        }
    }
}

