/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractTableTargetedAction;
import org.apache.log4j.Logger;

public class InsertColumnAction
extends AbstractTableTargetedAction {
    private static final Logger logger = Logger.getLogger(InsertColumnAction.class);

    public InsertColumnAction() {
        super("New Column", ASUtils.createIcon("NewColumn", "New Column", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "New Column");
        this.putValue("ActionCommandKey", "PlayPen");
        this.setEnabled(false);
    }

    void processSQLObject(SQLObject so) throws ArchitectException {
        SQLTable st = null;
        int idx = 0;
        if (so instanceof SQLTable) {
            logger.debug((Object)"user clicked on table, so we shall try to add a column to the end of the table.");
            st = (SQLTable)so;
            idx = st.getColumnsFolder().getChildCount();
            logger.debug((Object)("SQLTable click -- idx set to: " + idx));
        } else if (so instanceof SQLColumn) {
            logger.debug((Object)"trying to determine insertion index for table.");
            SQLColumn sc = (SQLColumn)so;
            st = sc.getParentTable();
            idx = st.getColumnIndex(sc);
            if (idx == -1) {
                logger.debug((Object)"did not find column, inserting at start of table.");
                idx = 0;
            }
        } else {
            idx = 0;
        }
        st.addColumn(idx, new SQLColumn());
    }

    void processTablePane(TablePane tp) throws ArchitectException {
        int idx = tp.getSelectedColumnIndex();
        if (idx < 0) {
            idx = tp.getModel().getColumnsFolder().getChildCount();
        }
        tp.getModel().addColumn(idx, new SQLColumn());
    }

    public void disableAction() {
        this.setEnabled(false);
        logger.debug((Object)"Disabling Insert Column Action");
        this.putValue("ShortDescription", "Insert Column");
    }
}

