/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.classify;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugProperty;
import edu.umd.cs.findbugs.config.UserPreferences;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class AccuracyClassificationPulldownAction
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu menu;
    private MenuItem isBugItem;
    private MenuItem notBugItem;
    private IMarker marker;
    private BugInstance bugInstance;

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.fillMenu();
        }
        return this.menu;
    }

    private void fillMenu() {
        this.isBugItem = new MenuItem(this.menu, 16);
        this.isBugItem.setText("Bug");
        this.notBugItem = new MenuItem(this.menu, 16);
        this.notBugItem.setText("Not Bug");
        this.isBugItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AccuracyClassificationPulldownAction.this.bugInstance != null) {
                    AccuracyClassificationPulldownAction.this.classifyWarning(AccuracyClassificationPulldownAction.this.bugInstance, true);
                }
            }
        });
        this.notBugItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AccuracyClassificationPulldownAction.this.bugInstance != null) {
                    AccuracyClassificationPulldownAction.this.classifyWarning(AccuracyClassificationPulldownAction.this.bugInstance, false);
                }
            }
        });
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                System.out.println("Synchronizing menu!");
                AccuracyClassificationPulldownAction.this.syncMenu();
            }
        });
    }

    private void classifyWarning(BugInstance warning, boolean isBug) {
        BugProperty isBugProp = warning.lookupProperty("isBug");
        if (isBugProp != null && isBugProp.getValueAsBoolean() == isBug) {
            return;
        }
        warning.setProperty("isBug", isBug ? "true" : "false");
        try {
            FindbugsPlugin.markBugCollectionDirty(this.marker.getResource().getProject(), true);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not mark bug collection dirty");
        }
        if (!isBug) {
            IProject project = this.marker.getResource().getProject();
            try {
                UserPreferences userPrefs = FindbugsPlugin.getUserPreferences(project);
                if (!MarkerUtil.displayWarning(warning, userPrefs.getFilterSettings())) {
                    System.out.println("Deleting marker for false warning!");
                    this.marker.delete();
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get FindBugs preferences for project");
            }
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        System.out.println("Selection is " + selection.getClass().getName());
        this.bugInstance = null;
        this.marker = MarkerUtil.getMarkerFromSelection(selection);
        if (this.marker == null) {
            return;
        }
        System.out.println("Found a marker!");
        this.bugInstance = MarkerUtil.findBugInstanceForMarker(this.marker);
        if (this.bugInstance != null) {
            System.out.println("Found BugInstance for FindBugs warning marker!");
        }
    }

    private void syncMenu() {
        if (this.bugInstance != null) {
            this.isBugItem.setEnabled(true);
            this.notBugItem.setEnabled(true);
            BugProperty isBugProperty = this.bugInstance.lookupProperty("isBug");
            if (isBugProperty == null) {
                this.isBugItem.setSelection(false);
                this.notBugItem.setSelection(false);
            } else {
                boolean isBug = isBugProperty.getValueAsBoolean();
                this.isBugItem.setSelection(isBug);
                this.notBugItem.setSelection(!isBug);
            }
        } else {
            this.isBugItem.setEnabled(false);
            this.notBugItem.setEnabled(false);
            this.isBugItem.setSelection(false);
            this.notBugItem.setSelection(false);
        }
    }
}

