/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe2;

public class NullnessValue {
    static final int DEFINITELY_NULL = 0;
    static final int DEFINITELY_NOT_NULL = 1;
    static final int CHECKED = 2;
    static final int NO_KABOOM = 3;
    static final int FLAGS_MAX = 4;
    private static final NullnessValue[] instanceList = new NullnessValue[16];
    private final int flags;

    private NullnessValue(int flags) {
        this.flags = flags;
    }

    int getFlags() {
        return this.flags;
    }

    public boolean isDefinitelyNull() {
        return this.isFlagSet(0);
    }

    public boolean isDefinitelyNotNull() {
        return this.isFlagSet(1);
    }

    public boolean isChecked() {
        return this.isFlagSet(2);
    }

    public boolean isNoKaboom() {
        return this.isFlagSet(3);
    }

    public NullnessValue toCheckedValue() {
        return instanceList[this.flags | 4];
    }

    public NullnessValue toNoKaboomValue() {
        return instanceList[this.flags | 8];
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & 1 << flag) != 0;
    }

    static NullnessValue fromFlags(int flags) {
        return instanceList[flags];
    }

    public static NullnessValue definitelyNullValue() {
        return NullnessValue.fromFlags(1);
    }

    public static NullnessValue definitelyNotNullValue() {
        return NullnessValue.fromFlags(2);
    }

    public static NullnessValue unknownValue() {
        return NullnessValue.fromFlags(0);
    }

    public String toString() {
        String pfx = "";
        if (this.isChecked()) {
            pfx = pfx + "c";
        }
        if (this.isNoKaboom()) {
            pfx = pfx + "k";
        }
        String val = this.isDefinitelyNull() ? "n" : (this.isDefinitelyNotNull() ? "N" : "-");
        return pfx + val;
    }

    static {
        for (int i = 0; i < instanceList.length; ++i) {
            NullnessValue.instanceList[i] = new NullnessValue(i);
        }
    }
}

