/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IDatabaseFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionDatabaseFactory<E>
implements IDatabaseFactory<E> {
    private Class<E> databaseClass;

    public ReflectionDatabaseFactory(Class<E> databaseClass) {
        this.databaseClass = databaseClass;
    }

    @Override
    public E createDatabase() throws CheckedAnalysisException {
        E database = this.createUsingStaticCreateMethod();
        if (database != null) {
            return database;
        }
        database = this.createUsingConstructor();
        if (database != null) {
            return database;
        }
        throw new CheckedAnalysisException(new StringBuffer().append("Could not find a way to create database ").append(this.databaseClass.getName()).toString());
    }

    private E createUsingStaticCreateMethod() throws CheckedAnalysisException {
        Method createMethod;
        try {
            createMethod = this.databaseClass.getMethod("create", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(createMethod.getModifiers())) {
            return null;
        }
        if (createMethod.getReturnType() != this.databaseClass) {
            return null;
        }
        try {
            return (E)createMethod.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new CheckedAnalysisException(new StringBuffer().append("Could not create ").append(this.databaseClass.getName()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new CheckedAnalysisException(new StringBuffer().append("Could not create ").append(this.databaseClass.getName()).toString(), e);
        }
    }

    private E createUsingConstructor() throws CheckedAnalysisException {
        Constructor<E> constructor;
        try {
            constructor = this.databaseClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new CheckedAnalysisException(new StringBuffer().append("Could not create ").append(this.databaseClass.getName()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new CheckedAnalysisException(new StringBuffer().append("Could not create ").append(this.databaseClass.getName()).toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new CheckedAnalysisException(new StringBuffer().append("Could not create ").append(this.databaseClass.getName()).toString(), e);
        }
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerDatabaseFactory(this.databaseClass, this);
    }
}

