/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class UseObjectEquals
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack = new OpcodeStack();

    public UseObjectEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 182 && this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item1 = this.stack.getStackItem(1);
            try {
                JavaClass cls = item1.getJavaClass();
                if (cls != null && cls.isFinal()) {
                    if (item1.getSignature().equals("Ljava/lang/Class;")) {
                        return;
                    }
                    String methodClassName = this.getClassConstantOperand();
                    if (methodClassName.equals("java/lang/Object")) {
                        if (!AnalysisContext.currentAnalysisContext().isApplicationClass(cls)) {
                            return;
                        }
                        this.bugReporter.reportBug(new BugInstance("UOE_USE_OBJECT_EQUALS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

