/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.file;

import fr.jayasoft.ivy.repository.AbstractRepository;
import fr.jayasoft.ivy.repository.RepositoryCopyProgressListener;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.file.FileResource;
import fr.jayasoft.ivy.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener _progress = new RepositoryCopyProgressListener(this);
    private File _baseDir;
    private boolean _local = true;

    public FileRepository() {
        this._baseDir = null;
    }

    public FileRepository(File basedir) {
        this._baseDir = basedir;
    }

    public Resource getResource(String source) throws IOException {
        return new FileResource(this, this.getFile(source));
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        this.copy(this.getFile(source), destination, true);
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        this.copy(source, this.getFile(destination), overwrite);
    }

    private void copy(File src, File destination, boolean overwrite) throws IOException {
        try {
            this._progress.setTotalLength(new Long(src.length()));
            FileUtil.copy(src, destination, this._progress, overwrite);
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this._progress.setTotalLength(null);
        }
    }

    public List list(String parent) throws IOException {
        String[] names;
        File dir = this.getFile(parent);
        if (dir.exists() && dir.isDirectory() && (names = dir.list()) != null) {
            ArrayList<String> ret = new ArrayList<String>(names.length);
            for (int i = 0; i < names.length; ++i) {
                ret.add(parent + this.getFileSeparator() + names[i]);
            }
            return ret;
        }
        return null;
    }

    private File getFile(String source) {
        if (this._baseDir != null) {
            return new File(this._baseDir, source);
        }
        return new File(source);
    }

    public boolean isLocal() {
        return this._local;
    }

    public void setLocal(boolean local) {
        this._local = local;
    }
}

