/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletTaskProvider;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDoxletAnnotationUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.osgi.framework.Bundle;

public class XDocletWebAntProjectBuilder
extends XDocletAntProjectBuilder {
    String contextRoot = "";

    public XDocletWebAntProjectBuilder() {
        this.templateUrl = Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb.annotations.xdoclet").getEntry("/templates/builder/xdocletweb.xml");
    }

    protected String getTaskName() {
        return "webdoclet";
    }

    protected HashMap createTemplates(String beanPath) {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("@servlets@", beanPath);
        templates.put("@webDoclet@", this.createDocletTasks());
        return templates;
    }

    private String createDocletTasks() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.webdocletTaskProvider").getExtensions();
        StringBuffer tasks = new StringBuffer(512);
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                try {
                    String pluginDescriptor = elements[0].getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                    Class c = bundle.loadClass(elements[0].getAttribute("class"));
                    if (c != null) {
                        XDocletTaskProvider docletTaskProvider = (XDocletTaskProvider)c.newInstance();
                        docletTaskProvider.setClientProject(null);
                        docletTaskProvider.setPreferenceStore(this.preferenceStore);
                        docletTaskProvider.setExtension(extension);
                        docletTaskProvider.setProperties(this.getProperties());
                        docletTaskProvider.setProject(this.getProject());
                        if (this.preferenceStore.getBooleanProperty(String.valueOf(elements[0].getAttribute("id")) + ".defaultSelection")) {
                            tasks.append("\n");
                            tasks.append(docletTaskProvider.getTask());
                            tasks.append("\n");
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++i;
        }
        return tasks.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties createAntBuildProperties(IResource resource, IJavaProject javaProject, IPackageFragmentRoot packageFragmentRoot, String beanPath) {
        WebArtifactEdit webEdit;
        Properties properties;
        block7: {
            properties = new Properties();
            StructureEdit moduleCore = null;
            webEdit = null;
            try {
                try {
                    moduleCore = StructureEdit.getStructureEditForRead((IProject)javaProject.getProject());
                    WorkbenchComponent wbModule = moduleCore.getComponent();
                    IProject proj = javaProject.getProject();
                    webEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)proj);
                    if (webEdit != null && (this.contextRoot = webEdit.getServerContextRoot()) == null) {
                        this.contextRoot = "";
                    }
                    String projectDir = resource.getProject().getLocation().toString();
                    IPath webInf = this.getWebInfFolder(wbModule);
                    properties.put("web.module.webinf", String.valueOf(projectDir) + "/" + webInf.toString());
                    properties.put("web", this.contextRoot);
                    properties.put("web.project.dir", projectDir);
                    properties.put("web.project.classpath", this.asClassPath(javaProject));
                    properties.put("web.module.src", packageFragmentRoot.getResource().getLocation().toString());
                    properties.put("web.module.gen", packageFragmentRoot.getResource().getLocation().toString());
                    properties.put("web.bin.dir", this.getJavaProjectOutputContainer(javaProject).toString());
                    properties.put("xdoclet.home", this.getPreferenceStore().getProperty("XDOCLETHOME"));
                    properties.put("xdoclet.merge.dir", String.valueOf(projectDir) + "/" + webInf.toString());
                    URL url = Platform.getBundle((String)"org.apache.ant").getEntry("/");
                    url = FileLocator.toFileURL((URL)url);
                    File file = new File(url.getFile());
                    properties.put("ant.home", file.getAbsolutePath());
                    String servletLevel = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)proj);
                    properties.put("servlet.spec.version", servletLevel);
                    properties.put("java.class.path", "");
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                if (webEdit == null) throw throwable;
                webEdit.dispose();
                throw throwable;
            }
            {
                Object var15_18 = null;
                if (moduleCore == null) break block7;
            }
            moduleCore.dispose();
        }
        if (webEdit == null) return properties;
        webEdit.dispose();
        return properties;
    }

    protected String constructAnnotatedClassList(IPackageFragmentRoot root, IResource changedBean) {
        ArrayList webClasses = new ArrayList();
        this.getAllAnnotatedWebClasses((IParent)root, webClasses);
        String beans = "";
        try {
            Iterator iterator = webClasses.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                IResource bean = cu.getCorrespondingResource();
                IPath path = bean.getProjectRelativePath();
                path = this.makeRelativeTo(path, root);
                beans = String.valueOf(beans) + "\t<include name=\"" + path.toString() + "\" />\n";
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return beans;
    }

    private void getAllAnnotatedWebClasses(IParent root, List list) {
        IJavaElement[] elements = null;
        try {
            elements = root.getChildren();
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                if (XDoxletAnnotationUtil.isXDocletAnnotatedWebClass(element)) {
                    list.add(element);
                } else if (element.getElementType() == 4) {
                    this.getAllAnnotatedWebClasses((IParent)((IPackageFragment)element), list);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
    }

    protected void refreshProjects(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project != null) {
            project.refreshLocal(2, monitor);
        }
    }

    protected IPath getWebInfFolder(WorkbenchComponent webModule) {
        ComponentResource[] webXML = webModule.findResourcesByRuntimePath((IPath)new Path("/WEB-INF"));
        int i = 0;
        while (i < webXML.length) {
            ComponentResource resource = webXML[i];
            if (resource.getRuntimePath().toString().equals("/WEB-INF")) {
                return resource.getSourcePath();
            }
            ++i;
        }
        if (webXML.length > 0) {
            return webXML[0].getSourcePath();
        }
        return null;
    }
}

