/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLCommonElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDNamedComponent;

public class WSDLOperationElement
extends WSDLCommonElement {
    public static final int OPERATION_TYPE_SOAP = 0;
    public static final int OPERATION_TYPE_HTTP_GET = 1;
    public static final int OPERATION_TYPE_HTTP_POST = 2;
    private int operationType_;
    private Operation operation_;
    private WSDLPartsToXSDTypeMapper wsdlPartsToXsdTypeMapper_;
    private XSDToFragmentController fragController_;
    private boolean isDocumentStyle_;
    private boolean isUseLiteral_;
    private String soapAction_;
    private String encodingStyle_;
    private String encodingNamespace_;

    private final void gatherSoapInformation(WSDLBindingElement bindingElement, SOAPBinding soapBinding) {
        this.isDocumentStyle_ = true;
        this.soapAction_ = "";
        this.isUseLiteral_ = true;
        this.encodingStyle_ = null;
        this.encodingNamespace_ = null;
        if (soapBinding != null) {
            this.isDocumentStyle_ = "document".equals(soapBinding.getStyle());
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingElement);
        SOAPOperation soapOperation = null;
        Iterator i = bindingOperation.getExtensibilityElements().iterator();
        while (i.hasNext()) {
            ExtensibilityElement e = (ExtensibilityElement)i.next();
            if (!(e instanceof SOAPOperation)) continue;
            soapOperation = (SOAPOperation)e;
            this.soapAction_ = soapOperation.getSoapActionURI();
            String style = soapOperation.getStyle();
            if (style == null) break;
            this.isDocumentStyle_ = style.equals("document");
            break;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        SOAPBody soapBody = null;
        Iterator i2 = bindingInput.getExtensibilityElements().iterator();
        while (i2.hasNext()) {
            ExtensibilityElement e = (ExtensibilityElement)i2.next();
            if (!(e instanceof SOAPBody)) continue;
            soapBody = (SOAPBody)e;
            this.isUseLiteral_ = "literal".equals(soapBody.getUse());
            if (this.isUseLiteral_) break;
            Iterator j = soapBody.getEncodingStyles().iterator();
            if (!j.hasNext()) break;
            this.encodingStyle_ = (String)j.next();
            this.encodingNamespace_ = soapBody.getNamespaceURI();
            break;
        }
    }

    public WSDLOperationElement(String name, WSDLBindingElement bindingElement, Operation operation) {
        super(name, bindingElement.getModel());
        this.setOperation(bindingElement, operation);
    }

    public void setOperation(WSDLBindingElement bindingElement, Operation operation) {
        this.operation_ = operation;
        this.setDocumentation(operation.getDocumentationElement());
        this.fragController_ = null;
        this.wsdlPartsToXsdTypeMapper_ = null;
        this.operationType_ = bindingElement.getBindingType();
        ExtensibilityElement bindingExtensibilityElement = bindingElement.getBindingExtensibilityElement();
        switch (this.operationType_) {
            case 0: {
                this.gatherSoapInformation(bindingElement, (SOAPBinding)bindingExtensibilityElement);
            }
        }
    }

    public Operation getOperation() {
        return this.operation_;
    }

    public BindingOperation getBindingOperation() {
        return this.getBindingOperation((WSDLBindingElement)this.getParentElement());
    }

    private BindingOperation getBindingOperation(WSDLBindingElement bindingElement) {
        BindingOperation bindingOperation;
        Binding binding = bindingElement.getBinding();
        String operationInputName = null;
        String operationOutputName = null;
        Input operationInput = this.operation_.getInput();
        Output operationOutput = this.operation_.getOutput();
        if (operationInput != null) {
            operationInputName = operationInput.getName();
        }
        if (operationOutput != null) {
            operationOutputName = operationOutput.getName();
        }
        if ((bindingOperation = binding.getBindingOperation(this.operation_.getName(), operationInputName, operationOutputName)) == null) {
            bindingOperation = binding.getBindingOperation(this.operation_.getName(), null, null);
        }
        return bindingOperation;
    }

    public List getOrderedBodyParts() {
        Vector parts = new Vector(this.operation_.getInput().getMessage().getOrderedParts(this.operation_.getParameterOrdering()));
        BindingOperation bindingOperation = this.getBindingOperation();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        Iterator it = bindingInput.getExtensibilityElements().iterator();
        while (it.hasNext()) {
            ExtensibilityElement e = (ExtensibilityElement)it.next();
            if (!(e instanceof SOAPBody)) continue;
            SOAPBody soapBody = (SOAPBody)e;
            List bodyParts = soapBody.getParts();
            if (bodyParts == null) break;
            int i = 0;
            while (i < parts.size()) {
                Part part = (Part)parts.get(i);
                if (!bodyParts.contains(part) && !bodyParts.contains(part.getName())) {
                    parts.remove(i);
                    --i;
                }
                ++i;
            }
            break block0;
        }
        return parts;
    }

    private XSDToFragmentController getXSDToFragmentController() {
        if (this.fragController_ == null) {
            this.fragController_ = new XSDToFragmentController();
            this.fragController_.setWSDLPartsToXSDTypeMapper(this.wsdlPartsToXsdTypeMapper_);
        }
        return this.fragController_;
    }

    private XSDNamedComponent getSchema(Part part, String id) {
        if (this.wsdlPartsToXsdTypeMapper_ == null) {
            this.wsdlPartsToXsdTypeMapper_ = new WSDLPartsToXSDTypeMapper();
            WSDLBindingElement bindingElement = (WSDLBindingElement)this.getParentElement();
            WSDLServiceElement serviceElement = (WSDLServiceElement)bindingElement.getParentElement();
            WSDLElement wsdlElement = (WSDLElement)serviceElement.getParentElement();
            this.wsdlPartsToXsdTypeMapper_.addSchemas(wsdlElement.getSchemaList());
        }
        return this.wsdlPartsToXsdTypeMapper_.getXSDType(part, id);
    }

    public IXSDFragment getFragment(Part part) {
        return this.getFragment(part, true);
    }

    public IXSDFragment getFragment(Part part, boolean isInput) {
        StringBuffer id = new StringBuffer();
        if (isInput) {
            id.append("::input");
        } else {
            id.append("::output");
        }
        String partName = part.getName();
        id.append(partName);
        XSDToFragmentConfiguration config = new XSDToFragmentConfiguration();
        config.setIsWSDLPart(true);
        config.setWSDLPartName(partName);
        config.setXSDComponent((XSDComponent)this.getSchema(part, id.toString()));
        if (this.isDocumentStyle()) {
            config.setStyle(0);
        } else {
            config.setStyle(1);
        }
        if (this.operationType_ == 0) {
            if (!this.isUseLiteral_) {
                config.setPartEncoding(1);
            }
        } else {
            config.setPartEncoding(2);
        }
        IXSDFragment fragment = this.getXSDToFragmentController().getFragment(config, id.toString(), part.getName());
        return fragment;
    }

    public IXSDFragment getFragmentByID(String id) {
        return this.getXSDToFragmentController().getCachedFragment(id);
    }

    public void removeAllFragment() {
        this.getXSDToFragmentController().emptyCache();
    }

    public boolean isDocumentStyle() {
        return this.isDocumentStyle_;
    }

    public String getSoapAction() {
        return this.soapAction_;
    }

    public boolean isUseLiteral() {
        return this.isUseLiteral_;
    }

    public String getEncodingStyle() {
        return this.encodingStyle_;
    }

    public String getEncodingNamespace() {
        return this.encodingNamespace_;
    }

    public int getOperationType() {
        return this.operationType_;
    }
}

