/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.jst.server.generic.internal.core.util.ExtensionPointUtil;
import org.eclipse.jst.server.generic.internal.xml.XMLUtils;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class ServerTypeDefinitionManager {
    private XMLUtils fXmlUtils = new XMLUtils();

    protected ServerTypeDefinitionManager(URL serverDefinitionURL) {
        ExtensionPointUtil.addRegistryListener(new RegistryChangeListener());
    }

    public ServerRuntime getServerRuntimeDefinition(String id, Map properties) {
        ServerRuntime definition = this.fXmlUtils.getServerTypeDefinition(id);
        if (definition != null) {
            definition.setPropertyValues(properties);
        }
        return definition;
    }

    public ServerRuntime[] getServerTypeDefinitions() {
        ArrayList definitionList = this.fXmlUtils.getServerTypeDefinitions();
        return definitionList.toArray(new ServerRuntime[definitionList.size()]);
    }

    private void handleServerDefinitionsChanged() {
        XMLUtils utils;
        this.fXmlUtils = utils = new XMLUtils();
    }

    private class RegistryChangeListener
    implements IRegistryChangeListener {
        private RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.jst.server.generic.core", "serverdefinition");
            if (deltas != null && deltas.length > 0) {
                ServerTypeDefinitionManager.this.handleServerDefinitionsChanged();
            }
        }
    }
}

