/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.List;
import java.util.Vector;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURLParser;

public class History {
    private Vector history = new Vector();
    private int navigationLocation = 0;

    public void updateHistory(String location) {
        if (!this.history.isEmpty() && this.isSameLocation(location)) {
            return;
        }
        this.doUpdateHistory(location);
    }

    public void updateHistory(AbstractIntroPage page) {
        if (!this.history.isEmpty() && this.isSameLocation(page)) {
            return;
        }
        this.doUpdateHistory(page);
    }

    private void doUpdateHistory(Object location) {
        if (this.navigationLocation == this.getHistoryEndPosition()) {
            this.pushToHistory(location);
        } else {
            this.trimHistory(location);
        }
    }

    private boolean isSameLocation(Object location) {
        HistoryObject currentLocation = this.getCurrentLocation();
        if (location instanceof String && currentLocation.isURL()) {
            return currentLocation.getUrl().equals(location);
        }
        if (location instanceof AbstractIntroPage && currentLocation.isIntroPage()) {
            AbstractIntroPage locationPage = (AbstractIntroPage)location;
            if (!currentLocation.getPageId().equals(locationPage.getId())) {
                return false;
            }
            if (currentLocation.isIFramePage() && locationPage.isIFramePage()) {
                return currentLocation.getIFrameUrl().equals(locationPage.getIFrameURL());
            }
            return true;
        }
        return false;
    }

    private void pushToHistory(Object location) {
        this.history.add(new HistoryObject(location));
        this.navigationLocation = this.getHistoryEndPosition();
    }

    public void removeLastHistory() {
        this.history.remove(this.getHistoryEndPosition());
        this.navigationLocation = this.getHistoryEndPosition();
    }

    private void trimHistory(Object location) {
        List newHistory = this.history.subList(0, this.navigationLocation + 1);
        this.history = new Vector(newHistory);
        this.history.add(new HistoryObject(location));
        this.navigationLocation = this.getHistoryEndPosition();
    }

    private int getHistoryEndPosition() {
        if (this.history.isEmpty()) {
            return 0;
        }
        return this.history.size() - 1;
    }

    public void navigateHistoryBackward() {
        if (this.badNavigationLocation(this.navigationLocation - 1)) {
            return;
        }
        --this.navigationLocation;
    }

    public void navigateHistoryForward() {
        if (this.badNavigationLocation(this.navigationLocation + 1)) {
            return;
        }
        ++this.navigationLocation;
    }

    private boolean badNavigationLocation(int navigationLocation) {
        return navigationLocation < 0 || navigationLocation >= this.history.size();
    }

    private HistoryObject getCurrentLocation() {
        return (HistoryObject)this.history.elementAt(this.navigationLocation);
    }

    public boolean canNavigateForward() {
        return this.navigationLocation != this.getHistoryEndPosition();
    }

    public boolean canNavigateBackward() {
        return this.navigationLocation != 0;
    }

    public boolean currentLocationIsUrl() {
        return this.getCurrentLocation().isURL();
    }

    public String getCurrentLocationAsUrl() {
        return this.getCurrentLocation().getUrl();
    }

    public AbstractIntroPage getCurrentLocationAsPage() {
        return this.getCurrentLocation().getPage();
    }

    public static boolean isURL(String aString) {
        IntroURLParser parser = new IntroURLParser(aString);
        return parser.hasProtocol();
    }

    public void clear() {
        this.history.clear();
        this.navigationLocation = 0;
    }

    class HistoryObject {
        AbstractIntroPage page;
        String iframeUrl;
        String url;

        HistoryObject(Object location) {
            if (location instanceof String) {
                this.url = (String)location;
            }
            if (location instanceof AbstractIntroPage) {
                this.page = (AbstractIntroPage)location;
                this.iframeUrl = this.page.getIFrameURL();
            }
        }

        AbstractIntroPage getPage() {
            if (this.page.isIFramePage()) {
                this.page.setIFrameURL(this.getIFrameUrl());
            }
            return this.page;
        }

        String getPageId() {
            return this.page.getId();
        }

        String getIFrameUrl() {
            return this.iframeUrl;
        }

        String getUrl() {
            return this.url;
        }

        boolean isURL() {
            return this.url != null;
        }

        boolean isIntroPage() {
            return this.page != null;
        }

        boolean isIFramePage() {
            return this.iframeUrl != null;
        }
    }
}

