/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.decorators.OverlayCache;

public class DecorationResult {
    private List prefixes;
    private List suffixes;
    private ImageDescriptor[] descriptors;
    private Color foregroundColor;
    private Color backgroundColor;
    private Font font;

    DecorationResult(List prefixList, List suffixList, ImageDescriptor[] imageDescriptors, Color resultForegroundColor, Color resultBackgroundColor, Font resultFont) {
        this.prefixes = prefixList;
        this.suffixes = suffixList;
        if (this.hasOverlays(imageDescriptors)) {
            this.descriptors = imageDescriptors;
        }
        this.foregroundColor = resultForegroundColor;
        this.backgroundColor = resultBackgroundColor;
        this.font = resultFont;
    }

    private boolean hasOverlays(ImageDescriptor[] imageDescriptors) {
        int i = 0;
        while (i < imageDescriptors.length) {
            if (imageDescriptors[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Image decorateWithOverlays(Image image, OverlayCache overlayCache) {
        if (image == null || this.descriptors == null) {
            return image;
        }
        return overlayCache.applyDescriptors(image, this.descriptors);
    }

    public String decorateWithText(String text) {
        if (this.prefixes.isEmpty() && this.suffixes.isEmpty()) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        ListIterator prefixIterator = this.prefixes.listIterator();
        while (prefixIterator.hasNext()) {
            result.append(prefixIterator.next());
        }
        result.append(text);
        ListIterator suffixIterator = this.suffixes.listIterator();
        while (suffixIterator.hasNext()) {
            result.append(suffixIterator.next());
        }
        return result.toString();
    }

    ImageDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    List getPrefixes() {
        return this.prefixes;
    }

    List getSuffixes() {
        return this.suffixes;
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Font getFont() {
        return this.font;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }
}

