/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class EnableWatchExpressionAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    protected boolean fEnable = true;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            for (IWatchExpression expression : (IStructuredSelection)this.fSelection) {
                expression.setEnabled(this.fEnable);
                this.fireWatchExpressionChanged(expression);
            }
        } else if (this.fSelection instanceof IWatchExpression) {
            IWatchExpression expression = (IWatchExpression)this.fSelection;
            expression.setEnabled(this.fEnable);
            this.fireWatchExpressionChanged(expression);
        }
    }

    private void fireWatchExpressionChanged(IWatchExpression expression) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)expression, 16)});
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof IStructuredSelection) {
            boolean enabled = false;
            for (IWatchExpression expression : (IStructuredSelection)selection) {
                if (expression.isEnabled() == this.fEnable) continue;
                enabled = true;
                break;
            }
            action.setEnabled(enabled);
        } else if (this.fSelection instanceof IWatchExpression) {
            action.setEnabled(((IWatchExpression)this.fSelection).isEnabled() ^ this.fEnable);
        } else {
            action.setEnabled(false);
        }
    }
}

