/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TableRenderingPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private BooleanFieldEditor fAutoLoadPref;
    private IntegerFieldEditor fPageSizePref;
    private Composite fBufferComposite;

    public TableRenderingPreferencePage(String title) {
        super(title);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".table_renderings_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.fAutoLoadPref = new BooleanFieldEditor("org.eclpise.debug.ui.memory.dynamicLoad", DebugUIMessages.TableRenderingPreferencePage_1, composite);
        this.fAutoLoadPref.setPreferenceStore(this.getPreferenceStore());
        this.fAutoLoadPref.load();
        this.fBufferComposite = new Composite(composite, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.fBufferComposite.setLayoutData((Object)data);
        this.fPageSizePref = new IntegerFieldEditor("org.eclispe.debug.ui.memory.pageSize", DebugUIMessages.TableRenderingPreferencePage_2, this.fBufferComposite);
        this.fPageSizePref.setPreferenceStore(this.getPreferenceStore());
        this.fPageSizePref.load();
        boolean autoLoad = this.getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (autoLoad) {
            this.fPageSizePref.setEnabled(false, this.fBufferComposite);
        } else {
            this.fPageSizePref.setEnabled(true, this.fBufferComposite);
        }
        this.fAutoLoadPref.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPageSizePref.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPageSizePref.setValidRange(1, Integer.MAX_VALUE);
        return composite;
    }

    public boolean performOk() {
        this.fAutoLoadPref.store();
        this.fPageSizePref.store();
        return super.performOk();
    }

    protected void performDefaults() {
        this.fAutoLoadPref.loadDefault();
        this.fPageSizePref.loadDefault();
        this.updatePageSizePref();
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.fAutoLoadPref)) {
            this.updatePageSizePref();
            this.validatePageSize();
        }
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.fPageSizePref)) {
            this.validatePageSize();
        }
    }

    private void updatePageSizePref() {
        boolean autoLoad = this.fAutoLoadPref.getBooleanValue();
        if (autoLoad) {
            this.fPageSizePref.setEnabled(false, this.fBufferComposite);
        } else {
            this.fPageSizePref.setEnabled(true, this.fBufferComposite);
        }
    }

    private void validatePageSize() {
        block4: {
            boolean autoLoad = this.fAutoLoadPref.getBooleanValue();
            try {
                int bufferSize = this.fPageSizePref.getIntValue();
                if (!autoLoad && bufferSize < 1) {
                    this.setValid(false);
                    this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_3);
                } else {
                    this.setValid(true);
                    this.setErrorMessage(null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (autoLoad) break block4;
                this.setValid(false);
                this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_4);
            }
        }
    }

    public void dispose() {
        this.fAutoLoadPref.setPropertyChangeListener(null);
        this.fPageSizePref.setPropertyChangeListener(null);
        super.dispose();
    }
}

