/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;

public abstract class TextEditBasedChange
extends Change {
    static final TextEditBasedChangeGroup[] ALL_EDITS = new TextEditBasedChangeGroup[0];
    private List fChangeGroups;
    private GroupCategorySet fCombiedGroupCategories;
    private String fName;
    private String fTextType;
    private boolean fTrackEdits;

    protected TextEditBasedChange(String name) {
        Assert.isNotNull((Object)name, (String)"Name must not be null");
        this.fChangeGroups = new ArrayList(5);
        this.fName = name;
        this.fTextType = "txt";
    }

    public void addChangeGroup(TextEditBasedChangeGroup group) {
        Assert.isTrue((group != null ? 1 : 0) != 0);
        this.fChangeGroups.add(group);
        if (this.fCombiedGroupCategories != null) {
            this.fCombiedGroupCategories = GroupCategorySet.union(this.fCombiedGroupCategories, group.getGroupCategorySet());
        }
    }

    public void addTextEditGroup(TextEditGroup group) {
        this.addChangeGroup(new TextEditBasedChangeGroup(this, group));
    }

    public boolean hasOneGroupCategory(List groupCategories) {
        if (this.fCombiedGroupCategories == null) {
            this.fCombiedGroupCategories = GroupCategorySet.NONE;
            for (TextEditBasedChangeGroup group : this.fChangeGroups) {
                this.fCombiedGroupCategories = GroupCategorySet.union(this.fCombiedGroupCategories, group.getGroupCategorySet());
            }
        }
        return this.fCombiedGroupCategories.containsOneCategory(groupCategories);
    }

    public final TextEditBasedChangeGroup[] getChangeGroups() {
        return this.fChangeGroups.toArray(new TextEditBasedChangeGroup[this.fChangeGroups.size()]);
    }

    String getContent(IDocument document, IRegion region, boolean expandRegionToFullLine, int surroundingLines) throws CoreException {
        try {
            if (expandRegionToFullLine) {
                int startLine = Math.max(document.getLineOfOffset(region.getOffset()) - surroundingLines, 0);
                int endLine = region.getLength() == 0 ? Math.min(document.getLineOfOffset(region.getOffset()) + surroundingLines, document.getNumberOfLines() - 1) : Math.min(document.getLineOfOffset(region.getOffset() + region.getLength() - 1) + surroundingLines, document.getNumberOfLines() - 1);
                int offset = document.getLineInformation(startLine).getOffset();
                IRegion endLineRegion = document.getLineInformation(endLine);
                int length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                return document.get(offset, length);
            }
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }

    public abstract String getCurrentContent(IProgressMonitor var1) throws CoreException;

    public abstract String getCurrentContent(IRegion var1, boolean var2, int var3, IProgressMonitor var4) throws CoreException;

    public boolean getKeepPreviewEdits() {
        return this.fTrackEdits;
    }

    public String getName() {
        return this.fName;
    }

    public abstract String getPreviewContent(TextEditBasedChangeGroup[] var1, IRegion var2, boolean var3, int var4, IProgressMonitor var5) throws CoreException;

    public abstract String getPreviewContent(IProgressMonitor var1) throws CoreException;

    public String getTextType() {
        return this.fTextType;
    }

    TextEdit[] mapEdits(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(edits.length);
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = copier.getCopy(edits[i]);
            if (edit != null) {
                result.add(edit);
            }
            ++i;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (TextEditBasedChangeGroup element : this.fChangeGroups) {
            element.setEnabled(enabled);
        }
    }

    public void setKeepPreviewEdits(boolean keep) {
        this.fTrackEdits = keep;
    }

    public void setTextType(String type) {
        if (type == null) {
            type = "txt";
        }
        this.fTextType = type;
    }

    static final class LocalTextEditProcessor
    extends TextEditProcessor {
        public static final int EXCLUDE = 1;
        public static final int INCLUDE = 2;
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        protected LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setIncludes(TextEdit[] includes) {
            Assert.isNotNull((Object)includes);
            Assert.isTrue((this.fExcludes == null ? 1 : 0) != 0);
            this.fIncludes = this.flatten(includes);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull((Object)excludes);
            Assert.isTrue((this.fIncludes == null ? 1 : 0) != 0);
            this.fExcludes = this.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                int i = 0;
                while (i < this.fExcludes.length) {
                    if (edit.equals((Object)this.fExcludes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (this.fIncludes != null) {
                int i = 0;
                while (i < this.fIncludes.length) {
                    if (edit.equals((Object)this.fIncludes[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList result = new ArrayList(5);
            int i = 0;
            while (i < edits.length) {
                this.flatten(result, edits[i]);
                ++i;
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List result, TextEdit edit) {
            result.add(edit);
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                this.flatten(result, children[i]);
                ++i;
            }
        }
    }

    static final class PreviewAndRegion {
        public IDocument document;
        public IRegion region;

        public PreviewAndRegion(IDocument d, IRegion r) {
            this.document = d;
            this.region = r;
        }
    }
}

