/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.factories;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.StringTokenizer;
import org.eclipse.jface.internal.databinding.internal.observable.NestedObservableList;
import org.eclipse.jface.internal.databinding.internal.observable.NestedObservableValue;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.description.NestedProperty;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.factories.IObservableFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;

public class NestedObservableFactory
implements IObservableFactory {
    private final DataBindingContext dataBindingContext;

    public NestedObservableFactory(DataBindingContext dataBindingContext) {
        this.dataBindingContext = dataBindingContext;
    }

    public IObservable createObservable(Object description) {
        Property propertyDescription;
        Object o;
        if (description instanceof NestedProperty) {
            return this.createNestedObservable((NestedProperty)description, this.dataBindingContext);
        }
        if (description instanceof Property && (o = (propertyDescription = (Property)description).getObject()) instanceof IObservableValue) {
            IObservableValue observableValue = (IObservableValue)o;
            Class propertyType = propertyDescription.getPropertyType();
            if (propertyType == null) {
                throw new BindingException("Missing required property type for binding to a property of an IObservableValue.");
            }
            Boolean isCollectionProperty = propertyDescription.isCollectionProperty();
            if (isCollectionProperty == null) {
                throw new BindingException("Missing required property collection information for binding to a property of an IObservableValue.");
            }
            Object propertyID = propertyDescription.getPropertyID();
            if (isCollectionProperty.booleanValue()) {
                return new NestedObservableList(this.dataBindingContext, observableValue, propertyID, propertyType);
            }
            return new NestedObservableValue(this.dataBindingContext, observableValue, propertyID, propertyType);
        }
        return null;
    }

    private IObservable createNestedObservable(NestedProperty nestedProperty, DataBindingContext bindingContext) {
        IObservable lastChildObservable = null;
        Object targetObject = nestedProperty.getObject();
        if (nestedProperty.getPrototypeClass() != null) {
            Class targetClazz = nestedProperty.getPrototypeClass();
            StringTokenizer tokenizer = new StringTokenizer((String)nestedProperty.getPropertyID(), ".");
            while (tokenizer.hasMoreElements()) {
                String nextDesc;
                block10: {
                    nextDesc = (String)tokenizer.nextElement();
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(targetClazz);
                        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                        Class<?> discoveredClazz = null;
                        int i = 0;
                        while (i < propertyDescriptors.length) {
                            PropertyDescriptor descriptor = propertyDescriptors[i];
                            if (descriptor.getName().equals(nextDesc)) {
                                discoveredClazz = descriptor.getPropertyType();
                                break;
                            }
                            ++i;
                        }
                        if (discoveredClazz != null) {
                            targetClazz = discoveredClazz;
                            break block10;
                        }
                        throw new BindingException("Error using prototype class to determine binding types.");
                    }
                    catch (BindingException be) {
                        throw be;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BindingException("Exeception using prototype class to determine binding types.", e);
                    }
                }
                lastChildObservable = bindingContext.createObservable(new Property(targetObject, nextDesc, targetClazz, new Boolean(false)));
                targetObject = lastChildObservable;
            }
        } else {
            String[] properties = (String[])nestedProperty.getPropertyID();
            int i = 0;
            while (i < properties.length) {
                String nextDesc = properties[i];
                Class clazz = nestedProperty.getTypes()[i];
                lastChildObservable = bindingContext.createObservable(new Property(targetObject, nextDesc, clazz, new Boolean(false)));
                targetObject = lastChildObservable;
                ++i;
            }
        }
        return lastChildObservable;
    }
}

