/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerType;
import org.eclipse.ui.views.tasklist.MarkerTypesModel;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TasksFilter;

class FiltersDialog
extends TrayDialog {
    static final int RESET_ID = 1024;
    static final int SELECT_ID = 1025;
    private EnumType severityType;
    private EnumType priorityType;
    private EnumType completionType;
    private TasksFilter filter;
    MarkerTypesModel markerTypesModel = new MarkerTypesModel();
    private MarkerType[] markerTypes;
    private CheckboxTreeViewer typesViewer;
    Button anyResourceButton;
    Button anyResourceInSameProjectButton;
    Button selectedResourceButton;
    Button selectedResourceAndChildrenButton;
    private WorkingSetGroup workingSetGroup;
    private LabelComboTextGroup descriptionGroup;
    private CheckboxEnumGroup severityGroup;
    private CheckboxEnumGroup priorityGroup;
    private CheckboxEnumGroup completionGroup;
    private Button filterOnMarkerLimit;
    private Text markerLimit;
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FiltersDialog.this.widgetSelected(e);
        }
    };
    private ICheckStateListener checkStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            FiltersDialog.this.checkStateChanged(event);
        }
    };

    public FiltersDialog(Shell parentShell) {
        super(parentShell);
        this.initTypes();
    }

    protected void buttonPressed(int buttonId) {
        if (1024 == buttonId) {
            this.resetPressed();
        } else if (1025 == buttonId) {
            this.workingSetGroup.selectPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        MarkerType type = (MarkerType)event.getElement();
        this.typesViewer.setSubtreeChecked((Object)type, event.getChecked());
        MarkerType[] allSupertypes = type.getAllSupertypes();
        int i = 0;
        while (i < allSupertypes.length) {
            this.typesViewer.setChecked((Object)allSupertypes[i], false);
            ++i;
        }
        this.updateEnabledState();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TaskListMessages.TaskList_filter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.task_filters_dialog_context");
    }

    void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        String[] filters = new String[]{TaskListMessages.TaskList_contains, TaskListMessages.TaskList_doesNotContain};
        this.descriptionGroup = new LabelComboTextGroup(composite, TaskListMessages.TaskList_whereDescription, filters, "", 200);
        this.severityGroup = new CheckboxEnumGroup(composite, TaskListMessages.TaskList_severity_label, this.severityType);
        this.priorityGroup = new CheckboxEnumGroup(composite, TaskListMessages.TaskList_priority_label, this.priorityType);
        this.completionGroup = new CheckboxEnumGroup(composite, TaskListMessages.TaskList_status_label, this.completionType);
    }

    void createResetArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(128));
        Button reset = new Button(composite, 8);
        reset.setText(TaskListMessages.TaskList_resetText);
        reset.setData((Object)new Integer(1024));
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FiltersDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        reset.setFont(composite.getFont());
        this.setButtonLayoutData(reset);
    }

    Button createCheckbox(Composite parent, String text, boolean grabRow) {
        Button button = new Button(parent, 32);
        if (grabRow) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(text);
        button.addSelectionListener(this.selectionListener);
        button.setFont(parent.getFont());
        return button;
    }

    Combo createCombo(Composite parent, String[] items, int selectionIndex) {
        Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(parent.getFont());
        combo.setItems(items);
        combo.select(selectionIndex);
        combo.addSelectionListener(this.selectionListener);
        return combo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMarkerLimitArea(composite);
        this.createTypesArea(composite);
        this.createResourceArea(composite);
        this.createAttributesArea(composite);
        this.createResetArea(composite);
        this.createSeparatorLine(composite);
        this.updateUIFromFilter(this.getFilter());
        return composite;
    }

    void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setFont(parent.getFont());
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    void createResourceArea(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        group.setFont(parent.getFont());
        this.anyResourceButton = this.createRadioButton(group, TaskListMessages.TaskList_anyResource);
        this.anyResourceInSameProjectButton = this.createRadioButton(group, TaskListMessages.TaskList_anyResourceInSameProject);
        this.selectedResourceButton = this.createRadioButton(group, TaskListMessages.TaskList_selectedResource);
        this.selectedResourceAndChildrenButton = this.createRadioButton(group, TaskListMessages.TaskList_selectedAndChildren);
        this.workingSetGroup = new WorkingSetGroup(group);
    }

    void createTypesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(TaskListMessages.TaskList_showItemsOfType);
        this.typesViewer = new CheckboxTreeViewer(composite);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.typesViewer.setComparator(this.getViewerComparator());
        this.typesViewer.setAutoExpandLevel(-1);
        this.typesViewer.addCheckStateListener(this.checkStateListener);
        this.typesViewer.setInput((Object)this.getMarkerTypes());
    }

    ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{FiltersDialog.this.markerTypesModel.getType("org.eclipse.core.resources.problemmarker"), FiltersDialog.this.markerTypesModel.getType("org.eclipse.core.resources.taskmarker")};
            }

            public Object[] getChildren(Object parentElement) {
                MarkerType type = (MarkerType)parentElement;
                return type.getSubtypes();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }
        };
    }

    void createMarkerLimitArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.filterOnMarkerLimit = this.createCheckbox(composite, TaskListMessages.TaskList_limitVisibleTasksTo, false);
        this.filterOnMarkerLimit.setLayoutData((Object)new GridData());
        this.markerLimit = new Text(composite, 2052);
        this.markerLimit.setTextLimit(6);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.markerLimit.setLayoutData((Object)gridData);
        this.markerLimit.setFont(font);
    }

    public TasksFilter getFilter() {
        if (this.filter == null) {
            this.filter = new TasksFilter();
        }
        return this.filter;
    }

    ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                MarkerType type = (MarkerType)element;
                return type.getLabel();
            }
        };
    }

    MarkerType[] getMarkerTypes() {
        if (this.markerTypes == null) {
            ArrayList<MarkerType> typesList = new ArrayList<MarkerType>();
            MarkerType[] types = this.markerTypesModel.getTypes();
            int i = 0;
            while (i < types.length) {
                MarkerType type = types[i];
                if (type.getLabel().length() > 0 && (type.isSubtypeOf(this.markerTypesModel.getType("org.eclipse.core.resources.problemmarker")) || type.isSubtypeOf(this.markerTypesModel.getType("org.eclipse.core.resources.taskmarker")))) {
                    typesList.add(type);
                }
                ++i;
            }
            Collections.sort(typesList, new Comparator(){
                Collator collator = Collator.getInstance();

                public int compare(Object o1, Object o2) {
                    return this.collator.compare(((MarkerType)o1).getLabel(), ((MarkerType)o2).getLabel());
                }
            });
            this.markerTypes = new MarkerType[typesList.size()];
            typesList.toArray(this.markerTypes);
        }
        return this.markerTypes;
    }

    String[] getSelectedTypes() {
        Object[] checked = this.typesViewer.getCheckedElements();
        ArrayList<MarkerType> list = new ArrayList<MarkerType>();
        int i = 0;
        while (i < checked.length) {
            MarkerType type = (MarkerType)checked[i];
            boolean found = false;
            int j = list.size();
            while (--j >= 0) {
                if (!type.isSubtypeOf((MarkerType)list.get(j))) continue;
                found = true;
                break;
            }
            if (!found) {
                list.add(type);
            }
            ++i;
        }
        String[] types = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            types[i2] = ((MarkerType)list.get(i2)).getId();
            ++i2;
        }
        return types;
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                MarkerType t1 = (MarkerType)e1;
                MarkerType t2 = (MarkerType)e2;
                return this.getComparator().compare(t1.getLabel(), t2.getLabel());
            }
        };
    }

    String getTypeId(int typeIndex) {
        return this.getMarkerTypes()[typeIndex].getId();
    }

    int getTypeIndex(String markerType) {
        MarkerType[] types = this.getMarkerTypes();
        int i = 0;
        while (i < types.length) {
            String id = types[i].getId();
            if (id == null ? markerType == null : id.equals(markerType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void initTypes() {
        this.severityType = new EnumType(new EnumValue[]{new EnumValue(2, TaskListMessages.TaskList_severity_error, MarkerUtil.getImage("error")), new EnumValue(1, TaskListMessages.TaskList_severity_warning, MarkerUtil.getImage("warn")), new EnumValue(0, TaskListMessages.TaskList_severity_info, MarkerUtil.getImage("info"))});
        this.priorityType = new EnumType(new EnumValue[]{new EnumValue(2, TaskListMessages.TaskList_priority_high, MarkerUtil.getImage("hprio")), new EnumValue(1, TaskListMessages.TaskList_priority_normal, null), new EnumValue(0, TaskListMessages.TaskList_priority_low, MarkerUtil.getImage("lprio"))});
        this.completionType = new EnumType(new EnumValue[]{new EnumValue(1, TaskListMessages.TaskList_status_completed, null), new EnumValue(0, TaskListMessages.TaskList_status_notCompleted, null)});
    }

    protected void okPressed() {
        block3: {
            try {
                int parseResult = Integer.parseInt(this.markerLimit.getText());
                if (parseResult < 1) {
                    throw new NumberFormatException();
                }
                this.updateFilterFromUI(this.getFilter());
                super.okPressed();
            }
            catch (NumberFormatException numberFormatException) {
                MessageBox messageBox = new MessageBox(this.getShell(), 65569);
                messageBox.setText(TaskListMessages.TaskList_titleMarkerLimitInvalid);
                messageBox.setMessage(TaskListMessages.TaskList_messageMarkerLimitInvalid);
                messageBox.open();
                if (!this.markerLimit.forceFocus()) break block3;
                this.markerLimit.setSelection(0, this.markerLimit.getCharCount());
                this.markerLimit.showSelection();
            }
        }
    }

    void resetPressed() {
        this.updateUIFromFilter(new TasksFilter());
    }

    boolean selectionIncludesSubtypeOf(String type) {
        MarkerType superType = this.markerTypesModel.getType(type);
        if (superType == null) {
            return false;
        }
        Object[] checked = this.typesViewer.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            if (((MarkerType)checked[i]).isSubtypeOf(superType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFilter(TasksFilter filter) {
        this.filter = filter;
    }

    void setSelectedTypes(String[] typeIds) {
        this.typesViewer.setCheckedElements((Object[])new MarkerType[0]);
        int i = 0;
        while (i < typeIds.length) {
            MarkerType type = this.markerTypesModel.getType(typeIds[i]);
            if (type != null) {
                this.typesViewer.setSubtreeChecked((Object)type, true);
            }
            ++i;
        }
    }

    void updateEnabledState() {
        this.markerLimit.setEnabled(this.filterOnMarkerLimit.getSelection());
        boolean isProblemSelected = this.selectionIncludesSubtypeOf("org.eclipse.core.resources.problemmarker");
        boolean isTaskSelected = this.selectionIncludesSubtypeOf("org.eclipse.core.resources.taskmarker");
        this.severityGroup.setEnabled(isProblemSelected);
        this.priorityGroup.setEnabled(isTaskSelected);
        this.completionGroup.setEnabled(isTaskSelected);
    }

    void updateFilterFromUI(TasksFilter tasksFilter) {
        tasksFilter.types = this.getSelectedTypes();
        tasksFilter.onResource = this.selectedResourceButton.getSelection() ? 1 : (this.selectedResourceAndChildrenButton.getSelection() ? 2 : (this.anyResourceInSameProjectButton.getSelection() ? 3 : (this.workingSetGroup.getSelection() ? 4 : 0)));
        tasksFilter.workingSet = this.workingSetGroup.getWorkingSet();
        tasksFilter.descriptionFilterKind = this.descriptionGroup.combo.getSelectionIndex();
        tasksFilter.descriptionFilter = this.descriptionGroup.text.getText();
        tasksFilter.filterOnDescription = !tasksFilter.descriptionFilter.equals("");
        tasksFilter.filterOnSeverity = this.severityGroup.getSelection();
        tasksFilter.severityFilter = this.severityGroup.getValueMask();
        tasksFilter.filterOnPriority = this.priorityGroup.getSelection();
        tasksFilter.priorityFilter = this.priorityGroup.getValueMask();
        tasksFilter.filterOnCompletion = this.completionGroup.getSelection();
        tasksFilter.completionFilter = this.completionGroup.getValueMask();
        int limit = 2000;
        try {
            limit = Integer.parseInt(this.markerLimit.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        tasksFilter.setMarkerLimit(limit);
        tasksFilter.setFilterOnMarkerLimit(this.filterOnMarkerLimit.getSelection());
    }

    void updateUIFromFilter(TasksFilter tasksFilter) {
        this.setSelectedTypes(tasksFilter.types);
        int on = tasksFilter.onResource;
        this.anyResourceButton.setSelection(on == 0);
        this.anyResourceInSameProjectButton.setSelection(on == 3);
        this.selectedResourceButton.setSelection(on == 1);
        this.selectedResourceAndChildrenButton.setSelection(on == 2);
        this.workingSetGroup.setSelection(on == 4);
        this.workingSetGroup.setWorkingSet(tasksFilter.workingSet);
        this.descriptionGroup.combo.select(tasksFilter.descriptionFilterKind);
        this.descriptionGroup.text.setText(tasksFilter.descriptionFilter);
        this.severityGroup.setSelection(tasksFilter.filterOnSeverity);
        this.severityGroup.setValueMask(tasksFilter.severityFilter);
        this.priorityGroup.setSelection(tasksFilter.filterOnPriority);
        this.priorityGroup.setValueMask(tasksFilter.priorityFilter);
        this.completionGroup.setSelection(tasksFilter.filterOnCompletion);
        this.completionGroup.setValueMask(tasksFilter.completionFilter);
        this.markerLimit.setText("" + tasksFilter.getMarkerLimit());
        this.filterOnMarkerLimit.setSelection(tasksFilter.getFilterOnMarkerLimit());
        this.updateEnabledState();
    }

    void widgetSelected(SelectionEvent e) {
        this.updateEnabledState();
    }

    private static class EnumValue {
        private int value;
        private String text;
        private Image image;

        EnumValue(int value, String text, Image image) {
            this.value = value;
            this.text = text;
            this.image = image;
        }

        int getValue() {
            return this.value;
        }

        String getText() {
            return this.text;
        }

        Image getImage() {
            return this.image;
        }
    }

    private static class EnumType {
        private EnumValue[] values;

        EnumType(EnumValue[] values) {
            this.values = values;
        }

        EnumValue[] getValues() {
            return this.values;
        }
    }

    private class CheckboxEnumGroup {
        private EnumType type;
        private Button enableButton;
        private Button[] valueButtons;

        CheckboxEnumGroup(Composite parent, String text, EnumType type) {
            this.type = type;
            Composite enableComposite = new Composite(parent, 0);
            enableComposite.setLayoutData((Object)new GridData(768));
            enableComposite.setLayout((Layout)new FillLayout());
            this.enableButton = new Button(enableComposite, 32);
            this.enableButton.addSelectionListener(FiltersDialog.this.selectionListener);
            this.enableButton.setText(text);
            Composite valueComposite = new Composite(parent, 0);
            valueComposite.setLayoutData((Object)new GridData(768));
            valueComposite.setLayout((Layout)new FillLayout());
            EnumValue[] values = type.getValues();
            this.valueButtons = new Button[values.length];
            int i = 0;
            while (i < values.length) {
                Button valueButton = new Button(valueComposite, 32);
                valueButton.setText(values[i].getText());
                this.valueButtons[i] = valueButton;
                ++i;
            }
        }

        boolean getEnabled() {
            return this.enableButton.getEnabled();
        }

        void setEnabled(boolean enabled) {
            this.enableButton.setEnabled(enabled);
            this.updateEnabledState();
        }

        boolean getSelection() {
            return this.enableButton.getSelection();
        }

        void setSelection(boolean selected) {
            this.enableButton.setSelection(selected);
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean enabled = this.enableButton.isEnabled() && this.enableButton.getSelection();
            int i = 0;
            while (i < this.valueButtons.length) {
                this.valueButtons[i].setEnabled(enabled);
                ++i;
            }
        }

        int getValueMask() {
            int mask = 0;
            EnumValue[] values = this.type.getValues();
            int i = 0;
            while (i < this.valueButtons.length) {
                if (this.valueButtons[i].getSelection()) {
                    mask |= 1 << values[i].getValue();
                }
                ++i;
            }
            return mask;
        }

        void setValueMask(int mask) {
            EnumValue[] values = this.type.getValues();
            int i = 0;
            while (i < values.length) {
                this.valueButtons[i].setSelection((mask & 1 << values[i].getValue()) != 0);
                ++i;
            }
        }
    }

    private class LabelComboTextGroup {
        Label label;
        Combo combo;
        Text text;

        LabelComboTextGroup(Composite parent, String labelText, String[] comboStrings, String initialText, int widthHint) {
            Font font = parent.getFont();
            Composite group = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setFont(font);
            this.label = new Label(group, 0);
            this.label.setText(labelText);
            this.label.setFont(font);
            this.combo = FiltersDialog.this.createCombo(group, comboStrings, 0);
            this.text = new Text(parent, 2052);
            GridData gridData = new GridData(768);
            gridData.widthHint = widthHint;
            this.text.setLayoutData((Object)gridData);
            this.text.setFont(font);
            this.text.setText(initialText);
        }
    }

    private class WorkingSetGroup {
        private Button button;

        WorkingSetGroup(Composite parent) {
            this.button = FiltersDialog.this.createRadioButton(parent, TaskListMessages.TaskList_noWorkingSet);
            GridData data = new GridData(768);
            this.button.setLayoutData((Object)data);
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            Button radio = new Button(parent, 16);
            layout.marginWidth = radio.computeSize((int)-1, (int)-1).x;
            layout.marginHeight = 0;
            radio.dispose();
            composite.setLayout((Layout)layout);
            FiltersDialog.this.createButton(composite, 1025, TaskListMessages.TaskList_workingSetSelect, false);
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean selected) {
            this.button.setSelection(selected);
            if (selected) {
                FiltersDialog.this.anyResourceButton.setSelection(false);
                FiltersDialog.this.anyResourceInSameProjectButton.setSelection(false);
                FiltersDialog.this.selectedResourceButton.setSelection(false);
                FiltersDialog.this.selectedResourceAndChildrenButton.setSelection(false);
            }
        }

        void selectPressed() {
            IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(FiltersDialog.this.getShell(), false);
            IWorkingSet workingSet = this.getWorkingSet();
            if (workingSet != null) {
                dialog.setSelection(new IWorkingSet[]{workingSet});
            }
            if (dialog.open() == 0) {
                IWorkingSet[] result = dialog.getSelection();
                if (result != null && result.length > 0) {
                    this.setWorkingSet(result[0]);
                } else {
                    this.setWorkingSet(null);
                }
                if (!this.getSelection()) {
                    this.setSelection(true);
                }
            }
        }

        void setWorkingSet(IWorkingSet workingSet) {
            this.button.setData((Object)workingSet);
            if (workingSet != null) {
                this.button.setText(NLS.bind((String)TaskListMessages.TaskList_workingSet, (Object)workingSet.getLabel()));
            } else {
                this.button.setText(TaskListMessages.TaskList_noWorkingSet);
            }
        }
    }
}

