/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

public final class Token {
    String termText;
    int startOffset;
    int endOffset;
    String type = "word";
    private int positionIncrement = 1;

    public Token(String text, int start, int end) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(String text, int start, int end, String typ) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public final String termText() {
        return this.termText;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public final String type() {
        return this.type;
    }
}

