/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    long handle;
    long parentType;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    Hashtable children = new Hashtable(9);
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final long ATK_ACTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkAction", true));
    static final long ATK_COMPONENT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkComponent", true));
    static final long ATK_HYPERTEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkHypertext", true));
    static final long ATK_SELECTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkSelection", true));
    static final long ATK_TEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkText", true));
    static final boolean DEBUG = Display.DEBUG;

    AccessibleObject(long type, long widget, Accessible accessible, long parentType, boolean isLightweight) {
        this.handle = ATK.g_object_new(type, 0L);
        this.parentType = parentType;
        ATK.atk_object_initialize(this.handle, widget);
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            System.out.println("new AccessibleObject: " + this.handle);
        }
    }

    void addChild(AccessibleObject child) {
        this.children.put(new LONG(child.handle), child);
        child.setParent(this);
    }

    static long atkAction_get_keybinding(long atkObject, long index) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkAction_get_keybinding");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_ACTION_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(object.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove(actionIface, superType);
            if (actionIface.get_keybinding != 0L) {
                parentResult = ATK.call(actionIface.get_keybinding, object.handle, index);
            }
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0L) {
            int length = OS.strlen(parentResult);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, parentResult, (long)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getKeyboardShortcut(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (keybindingPtr != -1L) {
            OS.g_free(keybindingPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        keybindingPtr = OS.g_malloc(name.length);
        OS.memmove(keybindingPtr, name, (long)name.length);
        return keybindingPtr;
    }

    static long atkAction_get_name(long atkObject, long index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkAction_get_name");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_ACTION_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(object.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove(actionIface, superType);
            if (actionIface.get_name != 0L) {
                parentResult = ATK.call(actionIface.get_name, object.handle, index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        if (parentResult != 0L) {
            int length = OS.strlen(parentResult);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, parentResult, (long)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getDefaultAction(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (actionNamePtr != -1L) {
            OS.g_free(actionNamePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        actionNamePtr = OS.g_malloc(name.length);
        OS.memmove(actionNamePtr, name, (long)name.length);
        return actionNamePtr;
    }

    static long atkComponent_get_extents(long atkObject, long x, long y, long width, long height, long coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        long window;
        long topLevel;
        GtkAccessible gtkAccessible;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        OS.memmove(x, new int[1], 4L);
        OS.memmove(y, new int[1], 4L);
        OS.memmove(width, new int[1], 4L);
        OS.memmove(height, new int[1], 4L);
        if (ATK.g_type_is_a(object.parentType, ATK_COMPONENT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove(componentIface, superType);
            if (componentIface.get_extents != 0L) {
                ATK.call(componentIface.get_extents, object.handle, x, y, width, height, coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove(parentX, x, 4L);
        OS.memmove(parentY, y, 4L);
        OS.memmove(parentWidth, width, 4L);
        OS.memmove(parentHeight, height, 4L);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = parentX[0];
        event.y = parentY[0];
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        if (coord_type == 1L) {
            long gtkAccessibleHandle = ATK.GTK_ACCESSIBLE(object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW(topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin(window, topWindowX, topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        if (coord_type == 1L) {
            long gtkAccessibleHandle = ATK.GTK_ACCESSIBLE(object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW(topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin(window, topWindowX, topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove(x, new int[]{event.x}, 4L);
        OS.memmove(y, new int[]{event.y}, 4L);
        OS.memmove(width, new int[]{event.width}, 4L);
        OS.memmove(height, new int[]{event.height}, 4L);
        return 0L;
    }

    static long atkComponent_get_position(long atkObject, long x, long y, long coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        long window;
        long topLevel;
        GtkAccessible gtkAccessible;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_position, object: " + atkObject + " x: " + x + " y: " + y + " coord: " + coord_type);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        OS.memmove(x, new int[1], 4L);
        OS.memmove(y, new int[1], 4L);
        if (ATK.g_type_is_a(object.parentType, ATK_COMPONENT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove(componentIface, superType);
            if (componentIface.get_extents != 0L) {
                ATK.call(componentIface.get_position, object.handle, x, y, coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        OS.memmove(parentX, x, 4L);
        OS.memmove(parentY, y, 4L);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = parentX[0];
        event.y = parentY[0];
        if (coord_type == 1L) {
            long gtkAccessibleHandle = ATK.GTK_ACCESSIBLE(object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW(topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin(window, topWindowX, topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        if (coord_type == 1L) {
            long gtkAccessibleHandle = ATK.GTK_ACCESSIBLE(object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW(topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin(window, topWindowX, topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove(x, new int[]{event.x}, 4L);
        OS.memmove(y, new int[]{event.y}, 4L);
        return 0L;
    }

    static long atkComponent_get_size(long atkObject, long width, long height, long coord_type) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_size");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        OS.memmove(width, new int[1], 4L);
        OS.memmove(height, new int[1], 4L);
        if (ATK.g_type_is_a(object.parentType, ATK_COMPONENT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove(componentIface, superType);
            if (componentIface.get_extents != 0L) {
                ATK.call(componentIface.get_size, object.handle, width, height, coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0L;
        }
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove(parentWidth, width, 4L);
        OS.memmove(parentHeight, height, 4L);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        OS.memmove(width, new int[]{event.width}, 4L);
        OS.memmove(height, new int[]{event.height}, 4L);
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long atkObject, long x, long y, long coord_type) {
        AccessibleObject accObj;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_ref_accessible_at_point");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_COMPONENT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove(componentIface, superType);
            if (componentIface.ref_accessible_at_point != 0L) {
                parentResult = ATK.call(componentIface.ref_accessible_at_point, object.handle, x, y, coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = (int)x;
        event.y = (int)y;
        if (coord_type == 1L) {
            long gtkAccessibleHandle = ATK.GTK_ACCESSIBLE(object.handle);
            GtkAccessible gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, gtkAccessibleHandle);
            long topLevel = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            long window = OS.GTK_WIDGET_WINDOW(topLevel);
            int[] topWindowX = new int[1];
            int[] topWindowY = new int[1];
            OS.gdk_window_get_origin(window, topWindowX, topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildAtPoint(event);
            ++i;
        }
        if (event.childID == object.id) {
            event.childID = -1;
        }
        if ((accObj = object.getChildByID(event.childID)) != null) {
            if (parentResult > 0L) {
                OS.g_object_unref(parentResult);
            }
            OS.g_object_ref(accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    static long atkHypertext_get_link(long atkObject, long link_index) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link");
        }
        return 0L;
    }

    static long atkHypertext_get_n_links(long atkObject) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_n_links");
        }
        return 0L;
    }

    static long atkHypertext_get_link_index(long atkObject, long char_index) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link_index");
        }
        return 0L;
    }

    static long atkObject_get_description(long atkObject) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_description");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_description != 0L) {
            parentResult = ATK.call(objectClass.get_description, object.handle);
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0L) {
            int length = OS.strlen(parentResult);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, parentResult, (long)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getDescription(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (descriptionPtr != -1L) {
            OS.g_free(descriptionPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        descriptionPtr = OS.g_malloc(name.length);
        OS.memmove(descriptionPtr, name, (long)name.length);
        return descriptionPtr;
    }

    static long atkObject_get_name(long atkObject) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_name: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_name != 0L) {
            parentResult = ATK.call(objectClass.get_name, object.handle);
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0L) {
            int length = OS.strlen(parentResult);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, parentResult, (long)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getName(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (namePtr != -1L) {
            OS.g_free(namePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        namePtr = OS.g_malloc(name.length);
        OS.memmove(namePtr, name, (long)name.length);
        return namePtr;
    }

    static long atkObject_get_n_children(long atkObject) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_n_children: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_n_children != 0L) {
            parentResult = ATK.call(objectClass.get_n_children, object.handle);
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.detail = (int)parentResult;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildCount(event);
            ++i;
        }
        return event.detail;
    }

    static long atkObject_get_index_in_parent(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObjectCB_get_index_in_parent.  ");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        if (object.index != -1) {
            return object.index;
        }
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_index_in_parent == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.get_index_in_parent, object.handle);
    }

    static long atkObject_get_parent(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_parent: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        if (object.parent != null) {
            return object.parent.handle;
        }
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_parent == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.get_parent, object.handle);
    }

    static long atkObject_get_role(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_role: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        if (object.getAccessibleListeners().length != 0) {
            AccessibleControlListener[] listeners = object.getControlListeners();
            AccessibleControlEvent event = new AccessibleControlEvent(object);
            event.childID = object.id;
            event.detail = -1;
            int i = 0;
            while (i < listeners.length) {
                listeners[i].getRole(event);
                ++i;
            }
            if (event.detail != -1) {
                switch (event.detail) {
                    case 44: {
                        return 7L;
                    }
                    case 10: {
                        return 18L;
                    }
                    case 46: {
                        return 11L;
                    }
                    case 18: {
                        return 16L;
                    }
                    case 41: {
                        return 28L;
                    }
                    case 30: {
                        return 60L;
                    }
                    case 33: {
                        return 30L;
                    }
                    case 34: {
                        return 31L;
                    }
                    case 11: {
                        return 32L;
                    }
                    case 2: {
                        return 33L;
                    }
                    case 12: {
                        return 34L;
                    }
                    case 48: {
                        return 41L;
                    }
                    case 43: {
                        return 42L;
                    }
                    case 3: {
                        return 47L;
                    }
                    case 21: {
                        return 49L;
                    }
                    case 51: {
                        return 50L;
                    }
                    case 24: {
                        return 54L;
                    }
                    case 29: {
                        return 55L;
                    }
                    case 25: {
                        return 56L;
                    }
                    case 26: {
                        return 57L;
                    }
                    case 60: {
                        return 37L;
                    }
                    case 37: {
                        return 36L;
                    }
                    case 42: {
                        return 60L;
                    }
                    case 22: {
                        return 62L;
                    }
                    case 13: {
                        return 63L;
                    }
                    case 35: {
                        return 64L;
                    }
                    case 36: {
                        return 31L;
                    }
                    case 45: {
                        return 43L;
                    }
                    case 9: {
                        return 68L;
                    }
                }
            }
        }
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.get_role == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.get_role, object.handle);
    }

    static long atkObject_ref_child(long atkObject, long index) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_child: " + index + " of: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        object.updateChildren();
        AccessibleObject accObject = object.getChildByIndex((int)index);
        if (accObject != null) {
            OS.g_object_ref(accObject.handle);
            return accObject.handle;
        }
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.ref_child == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.ref_child, object.handle, index);
    }

    static long atkObject_ref_state_set(long atkObject) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_state_set");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        long superType = ATK.g_type_class_peek(object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, superType);
        if (objectClass.ref_state_set != 0L) {
            parentResult = ATK.call(objectClass.ref_state_set, object.handle);
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        long set = parentResult;
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.detail = -1;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getState(event);
            ++i;
        }
        if (event.detail != -1) {
            int state = event.detail;
            if ((state & 0x800) != 0) {
                ATK.atk_state_set_add_state(set, 3);
            }
            if ((state & 0x10) != 0) {
                ATK.atk_state_set_add_state(set, 4);
            }
            if ((state & 0x200) != 0) {
                ATK.atk_state_set_add_state(set, 9);
            }
            if ((state & 0x100000) != 0) {
                ATK.atk_state_set_add_state(set, 10);
            }
            if ((state & 4) != 0) {
                ATK.atk_state_set_add_state(set, 11);
            }
            if ((state & 0x80) != 0) {
                ATK.atk_state_set_add_state(set, 2);
            }
            if ((state & 0x8000) == 0) {
                ATK.atk_state_set_add_state(set, 28);
            }
            if ((state & 0x1000000) != 0) {
                ATK.atk_state_set_add_state(set, 16);
            }
            if ((state & 0x10000) == 0) {
                ATK.atk_state_set_add_state(set, 23);
            }
            if ((state & 8) != 0) {
                ATK.atk_state_set_add_state(set, 18);
            }
            if ((state & 0x40) == 0) {
                ATK.atk_state_set_add_state(set, 6);
            }
            if ((state & 0x200000) != 0) {
                ATK.atk_state_set_add_state(set, 20);
            }
            if ((state & 2) != 0) {
                ATK.atk_state_set_add_state(set, 21);
            }
            if ((state & 0x20000) != 0) {
                ATK.atk_state_set_add_state(set, 19);
            }
        }
        return set;
    }

    static long atkSelection_is_child_selected(long atkObject, long index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkSelection_is_child_selected");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_SELECTION_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(object.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove(selectionIface, superType);
            if (selectionIface.is_child_selected != 0L) {
                parentResult = ATK.call(selectionIface.is_child_selected, object.handle, index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelection(event);
            ++i;
        }
        AccessibleObject accessibleObject = object.getChildByID(event.childID);
        if (accessibleObject != null) {
            return (long)accessibleObject.index == index ? 1 : 0;
        }
        return parentResult;
    }

    static long atkSelection_ref_selection(long atkObject, long index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkSelection_ref_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_SELECTION_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(object.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove(selectionIface, superType);
            if (selectionIface.ref_selection != 0L) {
                parentResult = ATK.call(selectionIface.ref_selection, object.handle, index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelection(event);
            ++i;
        }
        AccessibleObject accObj = object.getChildByID(event.childID);
        if (accObj != null) {
            if (parentResult > 0L) {
                OS.g_object_unref(parentResult);
            }
            OS.g_object_ref(accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    static long atkText_get_caret_offset(long atkObject) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_caret_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            if (textIface.get_caret_offset != 0L) {
                parentResult = ATK.call(textIface.get_caret_offset, object.handle);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return parentResult;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        event.offset = (int)parentResult;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getCaretOffset(event);
            ++i;
        }
        return event.offset;
    }

    static long atkText_get_character_at_offset(long atkObject, long offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_at_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        String text = object.getText();
        if (text != null) {
            return text.charAt((int)offset);
        }
        if (ATK.g_type_is_a(object.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_class_peek(object.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            if (textIface.get_character_at_offset != 0L) {
                return ATK.call(textIface.get_character_at_offset, object.handle, offset);
            }
        }
        return 0L;
    }

    static long atkText_get_character_count(long atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_count");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        String text = object.getText();
        if (text != null) {
            return text.length();
        }
        if (ATK.g_type_is_a(object.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_class_peek(object.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            if (textIface.get_character_count != 0L) {
                return ATK.call(textIface.get_character_count, object.handle);
            }
        }
        return 0L;
    }

    static long atkText_get_n_selections(long atkObject) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_n_selections");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        long parentResult = 0L;
        if (ATK.g_type_is_a(object.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            if (textIface.get_n_selections != 0L) {
                parentResult = ATK.call(textIface.get_n_selections, object.handle);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return parentResult;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelectionRange(event);
            ++i;
        }
        return event.length == 0 ? parentResult : 1L;
    }

    static long atkText_get_selection(long atkObject, long selection_num, long start_offset, long end_offset) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        OS.memmove(start_offset, new int[1], 4L);
        OS.memmove(end_offset, new int[1], 4L);
        if (ATK.g_type_is_a(object.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            if (textIface.get_selection != 0L) {
                ATK.call(textIface.get_selection, object.handle, selection_num, start_offset, end_offset);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return 0L;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        int[] parentStart = new int[1];
        int[] parentEnd = new int[1];
        OS.memmove(parentStart, start_offset, 4L);
        OS.memmove(parentEnd, end_offset, 4L);
        event.offset = parentStart[0];
        event.length = parentEnd[0] - parentStart[0];
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelectionRange(event);
            ++i;
        }
        OS.memmove(start_offset, new int[]{event.offset}, 4L);
        OS.memmove(end_offset, new int[]{event.offset + event.length}, 4L);
        return 0L;
    }

    static long atkText_get_text(long atkObject, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text: " + start_offset + "," + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        String text = object.getText();
        if (text.length() > 0) {
            end_offset = end_offset == -1L ? (long)text.length() : Math.min(end_offset, (long)text.length());
            start_offset = Math.min(start_offset, end_offset);
            text = text.substring((int)start_offset, (int)end_offset);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            long result = OS.g_malloc(bytes.length);
            OS.memmove(result, bytes, (long)bytes.length);
            return result;
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_after_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        int offset = (int)offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch ((int)boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int previousWordEnd = AccessibleObject.previousIndexOfNotChar(text, " \n", offset);
                    if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                        offset = AccessibleObject.nextIndexOfNotChar(text, " \n", offset);
                    }
                    if (offset == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    int wordEnd1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordEnd1;
                    int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", wordEnd1);
                    if (wordEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int previousSentenceEnd = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    int previousText = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                    int sentenceStart1 = 0;
                    if (previousSentenceEnd >= previousText) {
                        sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", offset);
                    } else {
                        sentenceStart1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                    }
                    if (sentenceStart1 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceStart1;
                    int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceEnd1;
                    int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                    if (sentenceEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    int lineStart1 = text.indexOf(10, offset - 1);
                    if (lineStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((lineStart1 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineStart1;
                    int lineStart2 = text.indexOf(10, lineStart1);
                    if (lineStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = lineStart2 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart2);
                    break;
                }
                case 6: {
                    int lineEnd2;
                    int lineEnd1 = AccessibleObject.nextIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineEnd1;
                    endBounds = startBounds == length ? length : ((lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1)) == -1 ? length : lineEnd2);
                }
            }
            OS.memmove(start_offset, new int[]{startBounds}, 4L);
            OS.memmove(end_offset, new int[]{++endBounds}, 4L);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            long result = OS.g_malloc(bytes.length);
            OS.memmove(result, bytes, (long)bytes.length);
            return result;
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_at_offset: " + offset_value + " start: " + start_offset + " end: " + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        int offset = (int)offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch ((int)boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                    wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd1);
                    wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordEnd1 + 1;
                    int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                    if (wordEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int sentenceStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                    startBounds = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceStart1);
                    int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", startBounds);
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                    sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd1);
                    sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                    if (sentenceEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", offset) + 1;
                    int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", startBounds);
                    if (lineEnd2 < length) {
                        ++lineEnd2;
                    }
                    endBounds = lineEnd2;
                    break;
                }
                case 6: {
                    int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = lineEnd1;
                    endBounds = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                }
            }
            OS.memmove(start_offset, new int[]{startBounds}, 4L);
            OS.memmove(end_offset, new int[]{++endBounds}, 4L);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            long result = OS.g_malloc(bytes.length);
            OS.memmove(result, bytes, (long)bytes.length);
            return result;
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_before_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0L;
        }
        int offset = (int)offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch ((int)boundary_type) {
                case 0: {
                    if (length < offset || offset <= 0) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int wordStart2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                    break;
                }
                case 2: {
                    int wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordEnd1 + 1;
                    int wordEnd2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", endBounds);
                    if ((wordEnd2 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                    break;
                }
                case 3: {
                    int sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int sentenceStart2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", endBounds);
                    if ((sentenceEnd2 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                    break;
                }
                case 5: {
                    int lineStart1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineStart1) + 1;
                    break;
                }
                case 6: {
                    int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineEnd1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineEnd1);
                    if (startBounds != -1) break;
                    startBounds = 0;
                }
            }
            OS.memmove(start_offset, new int[]{--startBounds}, 4L);
            OS.memmove(end_offset, new int[]{endBounds}, 4L);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            long result = OS.g_malloc(bytes.length);
            OS.memmove(result, bytes, (long)bytes.length);
            return result;
        }
        return 0L;
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessible == null) {
            return new AccessibleListener[0];
        }
        AccessibleListener[] result = this.accessible.getAccessibleListeners();
        return result != null ? result : new AccessibleListener[]{};
    }

    static AccessibleObject getAccessibleObject(long atkObject) {
        return (AccessibleObject)AccessibleObjects.get(new LONG(atkObject));
    }

    AccessibleObject getChildByHandle(long handle) {
        return (AccessibleObject)this.children.get(new LONG(handle));
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.id != childId) continue;
            return object;
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.index != childIndex) continue;
            return object;
        }
        return null;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.accessible == null) {
            return new AccessibleControlListener[0];
        }
        AccessibleControlListener[] result = this.accessible.getControlListeners();
        return result != null ? result : new AccessibleControlListener[]{};
    }

    String getText() {
        AccessibleControlListener[] controlListeners;
        long parentResult = 0L;
        String parentText = "";
        if (ATK.g_type_is_a(this.parentType, ATK_TEXT_TYPE)) {
            long superType = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(this.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove(textIface, superType);
            long characterCount = 0L;
            if (textIface.get_character_count != 0L) {
                characterCount = ATK.call(textIface.get_character_count, this.handle);
            }
            if (characterCount > 0L && textIface.get_text != 0L && (parentResult = ATK.call(textIface.get_text, this.handle, 0L, characterCount)) != 0L) {
                int length = OS.strlen(parentResult);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, parentResult, (long)length);
                parentText = new String(Converter.mbcsToWcs(null, buffer));
            }
        }
        if ((controlListeners = this.getControlListeners()).length == 0) {
            return parentText;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.result = parentText;
        int i = 0;
        while (i < controlListeners.length) {
            controlListeners[i].getValue(event);
            ++i;
        }
        return event.result;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.accessible == null) {
            return new AccessibleTextListener[0];
        }
        AccessibleTextListener[] result = this.accessible.getTextListeners();
        return result != null ? result : new AccessibleTextListener[]{};
    }

    static long gObjectClass_finalize(long atkObject) {
        long superType = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(atkObject));
        long gObjectClass = ATK.G_OBJECT_CLASS(superType);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove(objectClassStruct, gObjectClass);
        ATK.call(objectClassStruct.finalize, atkObject);
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            AccessibleObjects.remove(new LONG(atkObject));
            object.release();
        }
        return 0L;
    }

    static int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index != -1) {
                result = Math.min(result, index);
            }
            ++i;
        }
        return result;
    }

    static int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        int length = string.length();
        int index = startIndex;
        while (index < length) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            ++index;
        }
        return index;
    }

    static int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index != -1) {
                result = Math.max(result, index);
            }
            ++i;
        }
        return result;
    }

    static int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int index = startIndex - 1;
        while (index >= 0) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            --index;
        }
        return index;
    }

    void release() {
        if (DEBUG) {
            System.out.println("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject child = (AccessibleObject)elements.nextElement();
            if (!child.isLightweight) continue;
            OS.g_object_unref(child.handle);
        }
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
    }

    void removeChild(AccessibleObject child, boolean unref) {
        this.children.remove(new LONG(child.handle));
        if (unref && child.isLightweight) {
            OS.g_object_unref(child.handle);
        }
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void setFocus(int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            ATK.atk_focus_tracker_notify(accObject.handle);
        }
    }

    void setParent(AccessibleObject parent) {
        this.parent = parent;
    }

    void textCaretMoved(int index) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, index);
    }

    void textChanged(int type, int startIndex, int length) {
        if (type == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, startIndex, length);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, startIndex, length);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        AccessibleControlListener[] listeners = this.getControlListeners();
        if (listeners.length == 0) {
            return;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildren(event);
            ++i;
        }
        if (event.children != null && event.children.length > 0) {
            Vector<LONG> idsToKeep = new Vector<LONG>(this.children.size());
            if (event.children[0] instanceof Integer) {
                long parentType = AccessibleFactory.getDefaultParentType();
                int i2 = 0;
                while (i2 < event.children.length) {
                    AccessibleObject object = this.getChildByIndex(i2);
                    if (object == null) {
                        long childType = AccessibleFactory.getChildType(this.accessible, i2);
                        object = new AccessibleObject(childType, 0L, this.accessible, parentType, true);
                        AccessibleObjects.put(new LONG(object.handle), object);
                        this.addChild(object);
                        object.index = i2;
                    }
                    try {
                        object.id = (Integer)event.children[i2];
                    }
                    catch (ClassCastException classCastException) {}
                    idsToKeep.addElement(new LONG(object.handle));
                    ++i2;
                }
            } else {
                int childIndex = 0;
                int i3 = 0;
                while (i3 < event.children.length) {
                    AccessibleObject object = null;
                    try {
                        object = ((Accessible)event.children[i3]).accessibleObject;
                    }
                    catch (ClassCastException classCastException) {}
                    if (object != null) {
                        object.index = childIndex++;
                        idsToKeep.addElement(new LONG(object.handle));
                    }
                    ++i3;
                }
            }
            Enumeration ids = this.children.keys();
            while (ids.hasMoreElements()) {
                LONG id = (LONG)ids.nextElement();
                if (idsToKeep.contains(id)) continue;
                AccessibleObject object = (AccessibleObject)this.children.get(id);
                this.removeChild(object, true);
            }
        }
    }
}

